/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.session.ApplicationConnection;
import com.sap.engine.frame.cluster.session.ClientConnection;
import com.sap.engine.frame.cluster.session.CommunicationSessionProcessor;
import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.frame.cluster.session.ConnectionMonitor;
import com.sap.engine.frame.cluster.session.Data;
import com.sap.engine.frame.cluster.session.HttpClientConnection;
import com.sap.engine.lib.lang.ObjectPool;
import com.sap.engine.services.httpserver.CommunicationConstants;
import com.sap.engine.services.httpserver.dispatcher.ConnectionInfo;
import com.sap.engine.services.httpserver.dispatcher.Constants;
import com.sap.engine.services.httpserver.dispatcher.HttpDispatcherFrame;
import com.sap.engine.services.httpserver.dispatcher.HttpMonitoring;
import com.sap.engine.services.httpserver.dispatcher.HttpProperties;
import com.sap.engine.services.httpserver.dispatcher.Utils;
import com.sap.engine.services.httpserver.dispatcher.icm.ExtraLayer;
import com.sap.engine.services.httpserver.dispatcher.loadbalance.HttpLoadbalance;
import com.sap.engine.services.httpserver.exceptions.HttpIOException;
import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.interfaces.client.RequestLine;
import com.sap.engine.services.httpserver.lib.Responses;
import com.sap.engine.services.httpserver.lib.protocol.HeaderValues;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.CharArrayUtils;
import com.sap.engine.services.httpserver.lib.util.HexPrinter;
import com.sap.engine.services.ssl.factory.SSLSocket;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;

public class Processor
implements CommunicationSessionProcessor,
Constants {
    private HttpProperties httpProperties = null;
    private HttpDispatcherFrame frame = null;
    private HttpLoadbalance loadbalance = null;
    private ObjectPool connectionInfoPool = null;
    private HttpMonitoring httpMonitoring = null;
    private ExtraLayer[] layers = new ExtraLayer[0];
    private ApplicationConnection application = null;
    private boolean acceptClientCertNoSSL = false;
    private Location req_resp_location = Location.getLocation((String)"com.sap.engine.services.httpserver.dispatcher.Processor");
    static /* synthetic */ Class class$com$sap$engine$services$httpserver$dispatcher$ConnectionInfo;

    public Processor(HttpProperties httpProperties, HttpDispatcherFrame frame, HttpMonitoring httpMonitoring, ExtraLayer[] layers) {
        this.httpProperties = httpProperties;
        this.frame = frame;
        this.connectionInfoPool = new ObjectPool(100, 5000, 200, class$com$sap$engine$services$httpserver$dispatcher$ConnectionInfo == null ? (class$com$sap$engine$services$httpserver$dispatcher$ConnectionInfo = Processor.class$("com.sap.engine.services.httpserver.dispatcher.ConnectionInfo")) : class$com$sap$engine$services$httpserver$dispatcher$ConnectionInfo);
        this.httpMonitoring = httpMonitoring;
        this.layers = layers;
    }

    public void setLayers(ExtraLayer[] layers) {
        if (layers != null) {
            this.layers = layers;
        }
    }

    public void setAcceptClientCertNoSSL(boolean acceptClientCertNoSSL) {
        this.acceptClientCertNoSSL = acceptClientCertNoSSL;
    }

    public void setLoadBalance(HttpLoadbalance loadbalance) {
        this.loadbalance = loadbalance;
    }

    public void initialize(Connection cc, ConnectionMonitor monitor) {
        ConnectionInfo ci = (ConnectionInfo)this.connectionInfoPool.getObject();
        ci.reset();
        ci.setInetaddress(monitor.getSocket().getInetAddress().getAddress());
        ci.setPort(monitor.getSocket().getLocalPort());
        cc.setPrivateData((Object)ci);
        ci.setConnection(cc);
        cc.setDestinationId(-1);
        this.frame.registerConnection(cc);
        this.httpMonitoring.onConnectionOpen(ci);
        ci.setKeepAlive(true);
        cc.startClientRequestReader();
        try {
            monitor.getSocket().setTcpNoDelay(this.httpProperties.getTcpNoDelay());
        }
        catch (Exception e) {
            this.frame.logError("Cannot set socket properties!", e);
        }
        this.frame.logDebug("New socket accepted [" + cc.getConnectionId() + "].");
    }

    public void parseRequest(Connection cc, ApplicationConnection application, ClientConnection client) {
        this.application = application;
        ConnectionInfo ci = (ConnectionInfo)cc.getPrivateData();
        try {
            if (this.httpProperties.getHttpTraceTime()) {
                ci.startResponseTimer();
            }
            ci.setKeepAlive(false);
            ci.setConnection(cc);
            this.httpMonitoring.onRequestBeginCheck(ci);
            if (this.frame.noServersInCluster() && !this.loadbalance.hasSuspendedServer()) {
                ci.setKeepAlive(true);
                this.sendErrorNoServer(cc, client);
                return;
            }
            Data clientData = cc.getRequestData();
            if (1 == this.httpProperties.getHttpTraceInt()) {
                this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + (ci.isInternalRequest() ? ", NEXT PIPELINED REQUEST: \r\n{" : ", REQUEST: \r\n{") + new String(clientData.getBytes(), clientData.getOffset(), clientData.getLength()) + "}");
            } else if (3 == this.httpProperties.getHttpTraceInt()) {
                this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + (ci.isInternalRequest() ? ", NEXT PIPELINED REQUEST: \r\n{" : ", REQUEST: \r\n{") + HexPrinter.toString(clientData.getBytes(), clientData.getOffset(), clientData.getLength()) + "}");
            }
            if (ci.getExtraLayerCode() == -1 && this.checkOldRequest(cc, ci)) {
                this.frame.logDebug("checkOldRequest [" + cc.getConnectionId() + "].");
                this.nextRequest(cc, client, ci.getNextRequest());
                return;
            }
            if (this.unpackExtraLayer(cc)) {
                this.trace(ci.getExtraLayerCode(), ci, "Waiting for more Data.\r\nThe length of the block of data is longer than the received bytes.", false);
                ci.setKeepAlive(true);
                return;
            }
            if (ci.getExtraLayerCode() != -1 && this.checkOldRequest(cc, ci)) {
                this.frame.logDebug("checkOldRequest for ICM request [" + cc.getConnectionId() + "].");
                this.nextRequest(cc, client, ci.getNextRequest());
                return;
            }
            if (ci.getErrorMessage() != null) {
                this.trace(ci.getExtraLayerCode(), ci, "Sending Error in the Layer message.\r\nIncorrect Headers of the Layer of Request.", true);
                client.send(cc, ci.getErrorMessage(), 0, ci.getErrorMessage().length);
                cc.closeConnection();
                this.frame.logDebug("ICM error returned [" + new String(ci.getErrorMessage()) + "] [" + cc.getConnectionId() + "].");
                return;
            }
            if (ci.getOffset() != -1) {
                int i = 0;
                while (i < this.layers.length) {
                    if (this.layers[i].retrieveClientCert(cc, ci)) {
                        int len;
                        int reqLen = cc.getRequestData().getOffset() + cc.getRequestData().getLength();
                        if (reqLen > (len = ci.getOffset() + ci.getLength())) {
                            byte[] nextData = new byte[reqLen - len];
                            System.arraycopy(cc.getRequestData().getBytes(), len, nextData, 0, nextData.length);
                            cc.dataProcessed();
                            cc.getRequestData().addBytes(nextData);
                        } else {
                            cc.dataProcessed();
                        }
                        ci.clear();
                        if (reqLen > len) {
                            ci.setInternalRequest(true);
                            this.parseRequest(cc, application, client);
                        }
                        this.frame.logDebug("retrieveClientCert for ICM request [" + cc.getConnectionId() + "].");
                        return;
                    }
                    ++i;
                }
            }
            byte[] tempBytes = cc.getRequestData().getBytes();
            if (ci.getOffset() != -1) {
                byte[] tmp = new byte[ci.getLength()];
                System.arraycopy(cc.getRequestData().getBytes(), ci.getOffset(), tmp, 0, tmp.length);
                tempBytes = tmp;
            }
            if (!Utils.containsRN(cc.getRequestData().getBytes(), cc.getRequestData().getOffset() + cc.getRequestData().getLength())) {
                this.trace(ci.getExtraLayerCode(), ci, "Waiting for end of HTTP Headers.\r\nTwo new lines not found.", false);
                if (this.httpProperties.getMaxHeadersLength() >= 0 && cc.getRequestData().getOffset() + cc.getRequestData().getLength() >= this.httpProperties.getMaxHeadersLength()) {
                    if (HttpDispatcherFrame.getHttpProperties().getUseServerHeader()) {
                        this.sendError(cc, client, 413, Constants.errorHeaders413, ("The request entity must be less than " + this.httpProperties.getMaxHeadersLength() + "The request entity must be less than ").getBytes());
                    } else {
                        this.sendError(cc, client, 413, Constants.errorHeaders413NoServerHeader, ("The request entity must be less than " + this.httpProperties.getMaxHeadersLength() + "The request entity must be less than ").getBytes());
                    }
                }
                ci.setKeepAlive(true);
                this.frame.logDebug("RNRN not found [" + cc.getConnectionId() + "].");
                return;
            }
            if (2 == this.httpProperties.getHttpTraceInt()) {
                int headLength = Utils.getHeadLength(tempBytes, tempBytes.length);
                this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + (ci.isInternalRequest() ? ", NEXT PIPELINED REQUEST: \r\n{" : ", REQUEST: \r\n{") + new String(tempBytes, 0, headLength) + "}");
            } else if (4 == this.httpProperties.getHttpTraceInt()) {
                int headLength = Utils.getHeadLength(tempBytes, tempBytes.length);
                this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + (ci.isInternalRequest() ? ", NEXT PIPELINED REQUEST: \r\n{" : ", REQUEST: \r\n{") + HexPrinter.toString(tempBytes, 0, headLength) + "}");
            }
            if (ci.getOffset() == -1) {
                if (this.answerDebugRequest(tempBytes, 0, tempBytes.length, cc, client)) {
                    return;
                }
                this.frame.logDebug("answerDebugRequest [" + cc.getConnectionId() + "].");
            } else {
                if (this.answerDebugRequest(tempBytes, 0, tempBytes.length, cc, client)) {
                    return;
                }
                this.frame.logDebug("answerDebugRequest for ICM request [" + cc.getConnectionId() + "].");
            }
            ci.startRequest();
            this.parseBodyCommand(cc, application, client, tempBytes);
            ci.setOffset(-1);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                this.frame.logWarning("Error in processing request. The request is:\r\n" + new String(cc.getRequestData().getBytes(), cc.getRequestData().getOffset(), cc.getRequestData().getLength()), e);
            }
            catch (OutOfMemoryError ex) {
                throw ex;
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable ex) {
                this.frame.logWarning("Error in processing request.", e);
            }
            cc.closeConnection();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseReply(Connection cc, ApplicationConnection appConnection, ClientConnection client) {
        try {
            Data serverData = null;
            byte flag = 0;
            HttpClientConnection httpClient = (HttpClientConnection)client;
            httpClient.setApplicationConnection(appConnection);
            httpClient.setCallbackSize(this.httpProperties.getServletsLongDataTransferCallbackSize());
            while (true) {
                if ((serverData = cc.getReplyData()) == null) {
                    return;
                }
                ConnectionInfo ci = (ConnectionInfo)cc.getPrivateData();
                if (1 == this.httpProperties.getHttpTraceInt()) {
                    this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + ", REPLY: \r\n{" + new String(serverData.getBytes(), serverData.getOffset(), serverData.getLength()) + "}");
                } else if (2 == this.httpProperties.getHttpTraceInt()) {
                    if (!ci.isHeaderPassed()) {
                        int headerLength = Utils.getHeadLength(serverData.getBytes(), serverData.getOffset(), serverData.getLength());
                        if (headerLength >= 0) {
                            ci.setHeaderPassed(true);
                        }
                        this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + ", REPLY: \r\n{" + new String(serverData.getBytes(), serverData.getOffset(), headerLength) + "}");
                    }
                } else if (3 == this.httpProperties.getHttpTraceInt()) {
                    this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + ", REPLY: \r\n{" + HexPrinter.toString(serverData.getBytes(), serverData.getOffset(), serverData.getLength()) + "}");
                } else if (4 == this.httpProperties.getHttpTraceInt() && !ci.isHeaderPassed()) {
                    int headerLength = Utils.getHeadLength(serverData.getBytes(), serverData.getOffset(), serverData.getLength());
                    if (headerLength >= 0) {
                        ci.setHeaderPassed(true);
                    }
                    this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + ", REPLY: \r\n{" + HexPrinter.toString(serverData.getBytes(), serverData.getOffset(), headerLength) + "}");
                }
                flag = serverData.getFlag();
                this.frame.logDebug("parseReply flag: [" + flag + "]. [" + cc.getConnectionId() + "].");
                if ((flag & 0x10) == 16) {
                    if (!ci.isChunkedFinished() && ci.isDoingRequest()) {
                        Object headerLength = ci.ldtRequestSynchObject;
                        synchronized (headerLength) {
                            cc.startClientRequestReader();
                        }
                    }
                } else if ((flag & 1) == 1) {
                    this.httpMonitoring.onResponseBeginCheck(ci);
                    byte[] packedResponse = null;
                    packedResponse = this.packExtraLayer(cc, serverData.getBytes(), serverData.getOffset(), serverData.getLength(), true);
                    if (ci.getExtraLayerCode() == -1) {
                        block44: {
                            if (serverData.getLength() > 0) {
                                client.send(cc, serverData.getBytes(), serverData.getOffset(), serverData.getLength());
                            }
                            if (this.httpProperties.getHttpTraceTime()) {
                                this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + ", RESPONSE TIME: " + ci.stopResponseTimer());
                            }
                            ci.endResponse(false);
                            ci.setClosed();
                            try {
                                block43: {
                                    try {
                                        int available = ((ConnectionMonitor)cc).getInputStream().available();
                                        if (available <= 0) break block43;
                                        ((ConnectionMonitor)cc).getInputStream().skip(available);
                                    }
                                    catch (IOException e) {
                                        this.frame.logDebug("Error in skipping client input stream when closing the socket. " + e);
                                        Object var11_22 = null;
                                        cc.closeConnection();
                                        break block44;
                                    }
                                }
                                Object var11_21 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_23 = null;
                                cc.closeConnection();
                                throw throwable;
                            }
                            cc.closeConnection();
                        }
                        this.httpMonitoring.onResponseEndCheck(ci);
                        return;
                    }
                    this.httpMonitoring.onResponseEndCheck(ci);
                    if (this.httpProperties.getHttpTraceTime()) {
                        this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + ", RESPONSE TIME: " + ci.stopResponseTimer());
                    }
                    ci.endResponse(true);
                    if (packedResponse != null) {
                        client.send(cc, packedResponse, 0, packedResponse.length);
                    }
                } else if ((flag & 2) == 2) {
                    this.httpMonitoring.onResponseBeginCheck(ci);
                    byte[] packedResponse = this.packExtraLayer(cc, serverData.getBytes(), serverData.getOffset(), serverData.getLength(), true);
                    if (packedResponse == null) {
                        client.send(cc, serverData.getBytes(), serverData.getOffset(), serverData.getLength());
                    } else {
                        client.send(cc, packedResponse, 0, packedResponse.length);
                    }
                    byte[] nextRequest = ci.getNextRequest();
                    this.httpMonitoring.onResponseEndCheck(ci);
                    if (this.httpProperties.getHttpTraceTime()) {
                        this.req_resp_location.debugT("CLIENT: " + cc.getConnectionId() + ", RESPONSE TIME: " + ci.stopResponseTimer());
                    }
                    ci.endResponse(true);
                    if (ci.getExtraLayerCode() == -1) {
                        ci.setKeepAlive(true);
                    }
                    this.nextRequest(cc, client, nextRequest);
                } else {
                    this.httpMonitoring.onResponseBeginCheck(ci);
                    if (serverData.getLength() > 0) {
                        byte[] packedResponse = this.packExtraLayer(cc, serverData.getBytes(), serverData.getOffset(), serverData.getLength(), false);
                        if (packedResponse == null) {
                            client.send(cc, serverData.getBytes(), serverData.getOffset(), serverData.getLength());
                        } else {
                            client.send(cc, packedResponse, 0, packedResponse.length);
                        }
                    }
                }
                if (!serverData.isLongData()) continue;
                try {
                    appConnection.longDataRequest(cc);
                }
                catch (ClusterException ce) {
                    this.req_resp_location.traceThrowableT(400, "Connection [" + cc.getConnectionId() + "] could not send long data request to the server [" + cc.getDestinationId() + "]", (Throwable)ce);
                    this.frame.logWarning("Connection [" + cc.getConnectionId() + "] could not send long data request to the server [" + cc.getDestinationId() + "]", ce);
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.frame.logWarning("Error in processing reply!", e);
        }
    }

    public void fail(Connection connection, ConnectionMonitor monitor) {
        try {
            ConnectionInfo ci = (ConnectionInfo)connection.getPrivateData();
            this.frame.connectionClosed(connection);
            this.httpMonitoring.onConnectionClose(ci);
            this.frame.logDebug("fail [" + connection.getConnectionId() + "].");
            if (ci != null && this.application != null && connection.getDestinationId() != -1 && !ci.getClosed() && !ci.isClear() && this.frame.serversVector.contains(connection.getDestinationId()) && connection.getRequestData() != null && connection.getRequestData().getBytes() != null) {
                connection.dataProcessed();
                byte[] connectionClosedMsg = new byte[9];
                connectionClosedMsg[0] = 3;
                try {
                    this.application.send(connection, connectionClosedMsg, 0, connectionClosedMsg.length);
                }
                catch (ClusterException e) {
                    this.frame.logWarning("Error sending notification for a failed connection.", e);
                }
            }
            connection.closeConnection();
            connection.setPrivateData(null);
            if (ci != null) {
                ci.setKeepAlive(false);
                ci.reset();
                this.connectionInfoPool.returnInPool((Object)ci);
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.frame.logWarning("Error while finalizing a failed connection.", e);
        }
    }

    public boolean memoryWarning(Connection cc, ApplicationConnection application, ClientConnection client, boolean forced) {
        return false;
    }

    private void nextRequest(Connection cc, ClientConnection client, byte[] nextRequest) throws IOException {
        if (nextRequest == null) {
            return;
        }
        try {
            cc.getRequestData().addBytes(nextRequest);
        }
        catch (Exception e) {
            throw new HttpIOException("http_0005", e);
        }
        ConnectionInfo ci = (ConnectionInfo)cc.getPrivateData();
        ci.setInternalRequest(true);
        this.parseRequest(cc, this.application, client);
    }

    private boolean checkOldRequest(Connection cc, ConnectionInfo ci) throws IOException {
        if (ci.joinRequest()) {
            if (ci.getTotalPutLength() <= 0L) {
                byte[] req;
                boolean chunkEndFound = true;
                try {
                    chunkEndFound = Utils.searchEndOfChunk(cc.getRequestData().getBytes(), 0, cc.getRequestData().getOffset() + cc.getRequestData().getLength(), ci);
                }
                catch (ParseException e) {
                    this.frame.logWarning("Can't parse a chunked request body.", (Throwable)((Object)e));
                }
                if (!(ci.skipRequestBody() || this.httpProperties.getMaxContentLength() >= 0L && ci.getChunkedRequestBodyRead() >= this.httpProperties.getMaxContentLength())) {
                    try {
                        req = null;
                        byte[] nextRequest = null;
                        if (ci.getNextRequestOffset() > -1) {
                            int nextRequestLength = cc.getRequestData().getOffset() + cc.getRequestData().getLength() - ci.getNextRequestOffset();
                            req = new byte[ci.getNextRequestOffset()];
                            System.arraycopy(cc.getRequestData().getBytes(), 0, req, 0, req.length);
                            nextRequest = new byte[nextRequestLength];
                            System.arraycopy(cc.getRequestData().getBytes(), req.length, nextRequest, 0, nextRequestLength);
                            cc.dataProcessed();
                            try {
                                cc.getRequestData().addBytes(req);
                            }
                            catch (Exception e) {
                                throw new IOException(e.toString());
                            }
                        }
                        this.addBytesToRequest(cc, CommunicationConstants.REQUEST_TYPE_BODY_PART_, Constants.bnull, true);
                        Object nextRequestLength = ci.ldtRequestSynchObject;
                        synchronized (nextRequestLength) {
                            int streamStatus = this.application.sendInQueue(cc, this.httpProperties.getServerReadRequestBodyChunkTimeoutMillis());
                            if (streamStatus == 2) {
                                this.frame.logDebug("Processor.checkOldRequest stopClientRequestReader " + cc.getConnectionId());
                                cc.stopClientRequestReader();
                            }
                        }
                        ci.setNextRequest(nextRequest);
                    }
                    catch (ClusterException e) {
                        this.frame.logWarning("Error sending request body to the server " + cc.getDestinationId() + ". The part of the body is: " + new String(cc.getRequestData().getBytes(), 0, cc.getRequestData().getOffset() + cc.getRequestData().getLength()), e);
                    }
                } else if (!ci.skipRequestBody() && this.httpProperties.getMaxContentLength() >= 0L) {
                    cc.dataProcessed();
                    this.frame.logWarning("Chunked body is longer than the maximum allowed value " + this.httpProperties.getMaxContentLength() + ". The rest of the body will be ignored.");
                } else if (!chunkEndFound && ci.skipRequestBody()) {
                    ci.setKeepAlive(true);
                    cc.dataProcessed();
                }
                if (chunkEndFound) {
                    req = null;
                    if (ci.getNextRequestOffset() > -1 && cc.getRequestData().getOffset() + cc.getRequestData().getLength() - ci.getNextRequestOffset() > 0) {
                        req = new byte[cc.getRequestData().getOffset() + cc.getRequestData().getLength() - ci.getNextRequestOffset()];
                        System.arraycopy(cc.getRequestData().getBytes(), ci.getNextRequestOffset(), req, 0, req.length);
                    }
                    ci.setChunkedFinished(true);
                    this.httpMonitoring.onRequestEndCheck(ci);
                    ci.endRequest();
                    cc.dataProcessed();
                    ci.setNextRequest(req);
                }
                this.frame.logDebug("checkOldRequest chunked request. chunkEndFound: [" + chunkEndFound + "]. [" + cc.getConnectionId() + "].");
                return true;
            }
            boolean skippingRequestBody = ci.skipRequestBody();
            long currentPutLength = ci.getCurrentPutLength();
            if (ci.getExtraLayerCode() == -1) {
                ci.setCurrentPutLength(currentPutLength + (long)cc.getRequestData().getOffset() + (long)cc.getRequestData().getLength());
            } else {
                ci.setCurrentPutLength(currentPutLength + (long)ci.getLength());
            }
            if (ci.getTotalPutLength() <= ci.getCurrentPutLength()) {
                cc.setPackSize(0);
                this.httpMonitoring.onRequestEndCheck(ci);
                ci.endRequest();
            } else if (ci.getTotalPutLength() - ci.getCurrentPutLength() < (long)this.httpProperties.getReadBufferSize()) {
                if (ci.getExtraLayerCode() == -1) {
                    cc.setPackSize((int)(ci.getTotalPutLength() - ci.getCurrentPutLength()));
                }
            } else if (ci.getExtraLayerCode() < 0) {
                cc.setPackSize(this.httpProperties.getReadBufferSize());
            }
            this.frame.logDebug("checkOldRequest remain: [" + (ci.getTotalPutLength() - ci.getCurrentPutLength()) + "]. [" + cc.getConnectionId() + "].");
            byte[] nextRequest = null;
            if (ci.getOffset() != -1) {
                if (ci.getOffset() + ci.getLength() < cc.getRequestData().getOffset() + cc.getRequestData().getLength()) {
                    byte[] req = new byte[ci.getOffset() + ci.getLength()];
                    System.arraycopy(cc.getRequestData().getBytes(), 0, req, 0, req.length);
                    nextRequest = new byte[cc.getRequestData().getOffset() + cc.getRequestData().getLength() - req.length];
                    System.arraycopy(cc.getRequestData().getBytes(), req.length, nextRequest, 0, nextRequest.length);
                    cc.dataProcessed();
                    try {
                        cc.getRequestData().addBytes(req);
                    }
                    catch (Exception e) {
                        throw new IOException(e.toString());
                    }
                }
            } else if (ci.getTotalPutLength() < ci.getCurrentPutLength()) {
                long nextRequestLength = ci.getCurrentPutLength() - ci.getTotalPutLength();
                ci.setCurrentPutLength(ci.getTotalPutLength());
                byte[] req = new byte[cc.getRequestData().getOffset() + cc.getRequestData().getLength() - (int)nextRequestLength];
                System.arraycopy(cc.getRequestData().getBytes(), 0, req, 0, req.length);
                nextRequest = new byte[(int)nextRequestLength];
                System.arraycopy(cc.getRequestData().getBytes(), req.length, nextRequest, 0, (int)nextRequestLength);
                cc.dataProcessed();
                try {
                    cc.getRequestData().addBytes(req);
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
            ci.setNextRequest(nextRequest);
            this.addBytesToRequest(cc, CommunicationConstants.REQUEST_TYPE_BODY_PART_, Constants.bnull, true);
            this.trace(ci.getExtraLayerCode(), ci, "Next part of the Put data received.\r\nSending data to the servers.", false);
            if (!skippingRequestBody) {
                if (ci.getOffset() != -1) {
                    byte[] putBytes = new byte[ci.getLength()];
                    System.arraycopy(cc.getRequestData().getBytes(), ci.getOffset(), putBytes, 0, putBytes.length);
                    try {
                        Object e = ci.ldtRequestSynchObject;
                        synchronized (e) {
                            int streamStatus = this.application.sendInQueue(cc, putBytes, 0, putBytes.length, this.httpProperties.getServerReadRequestBodyChunkTimeoutMillis());
                            if (streamStatus == 2) {
                                this.frame.logDebug("Processor.checkOldRequest stopClientRequestReader " + cc.getConnectionId());
                                cc.stopClientRequestReader();
                            }
                        }
                    }
                    catch (ClusterException e) {
                        this.frame.logWarning("Error sending request body to the server " + cc.getDestinationId() + ". The part of the body is: " + new String(putBytes), e);
                    }
                } else {
                    try {
                        Object putBytes = ci.ldtRequestSynchObject;
                        synchronized (putBytes) {
                            int streamStatus = this.application.sendInQueue(cc, this.httpProperties.getServerReadRequestBodyChunkTimeoutMillis());
                            if (streamStatus == 2) {
                                this.frame.logDebug("Processor.checkOldRequest stopClientRequestReader " + cc.getConnectionId());
                                cc.stopClientRequestReader();
                            }
                        }
                    }
                    catch (ClusterException e) {
                        this.frame.logWarning("Error sending request body to the server " + cc.getDestinationId() + ". The part of the body is: " + new String(cc.getRequestData().getBytes(), 0, cc.getRequestData().getOffset() + cc.getRequestData().getLength()), e);
                    }
                }
            } else {
                ci.setKeepAlive(true);
            }
            cc.dataProcessed();
            ci.setOffset(-1);
            return true;
        }
        return false;
    }

    private void parse(Connection cc, ApplicationConnection application, ClientConnection client, ConnectionInfo ci) throws IOException {
        this.frame.logDebug("parse [" + cc.getConnectionId() + "].");
        if (!this.setServerId(cc, client, ci)) {
            return;
        }
        int lengthInSocket = cc.getRequestData().getOffset() + cc.getRequestData().getLength();
        int headLength = Utils.getHeadLength(cc.getRequestData().getBytes(), lengthInSocket);
        byte[] nextRequest = null;
        if (lengthInSocket > headLength) {
            byte[] req = new byte[headLength];
            System.arraycopy(cc.getRequestData().getBytes(), 0, req, 0, req.length);
            nextRequest = new byte[lengthInSocket - headLength];
            System.arraycopy(cc.getRequestData().getBytes(), req.length, nextRequest, 0, nextRequest.length);
            cc.dataProcessed();
            try {
                cc.getRequestData().addBytes(req);
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        ci.setNextRequest(nextRequest);
        this.addBytesToRequest(cc, CommunicationConstants.REQUEST_TYPE_NEW_REQUEST_NO_BODY_, ci.getInetaddress(), false);
        if (ci.getOffset() != -1) {
            this.trace(ci.getExtraLayerCode(), ci, "Sending request to server.", false);
            byte[] newbyte = new byte[ci.getLength()];
            System.arraycopy(cc.getRequestData().getBytes(), ci.getOffset(), newbyte, 0, newbyte.length);
            try {
                application.send(cc, newbyte, 0, newbyte.length);
            }
            catch (ClusterException e) {
                this.frame.logWarning("Error sending request to the server " + cc.getDestinationId() + ". The request is: " + new String(newbyte), e);
            }
            cc.dataProcessed();
        } else {
            try {
                application.send(cc);
            }
            catch (ClusterException e) {
                this.frame.logWarning("Error sending request to the server " + cc.getDestinationId() + ". The request is: " + new String(cc.getRequestData().getBytes(), 0, cc.getRequestData().getOffset() + cc.getRequestData().getLength()), e);
            }
        }
        cc.dataProcessed();
        ci.setOffset(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyCommand(Connection cc, ApplicationConnection application, ClientConnection client, byte[] tempBytes) throws IOException {
        int headLength;
        long length;
        this.frame.logDebug("parseBodyCommand [" + cc.getConnectionId() + "].");
        ConnectionInfo ci = (ConnectionInfo)cc.getPrivateData();
        if (!this.setServerId(cc, client, ci)) {
            return;
        }
        int tempBytesLength = tempBytes.length;
        if (ci.getOffset() == -1) {
            tempBytesLength = cc.getRequestData().getOffset() + cc.getRequestData().getLength();
        }
        if ((length = Utils.getContentLengthLong(tempBytes, headLength = Utils.getHeadLength(tempBytes, tempBytesLength))) > 0L && this.httpProperties.getMaxContentLength() >= 0L && length > this.httpProperties.getMaxContentLength()) {
            if (length > 0L) {
                if (HttpDispatcherFrame.getHttpProperties().getUseServerHeader()) {
                    this.sendError(cc, client, 413, Constants.errorHeaders413, ("Content length must be less than " + this.httpProperties.getMaxContentLength() + " bytes.").getBytes());
                    return;
                }
            }
            this.sendError(cc, client, 413, Constants.errorHeaders413NoServerHeader, ("Content length must be less than " + this.httpProperties.getMaxContentLength() + " bytes.").getBytes());
            return;
        }
        boolean isChunked = false;
        if ((long)(cc.getRequestData().getOffset() + cc.getRequestData().getLength()) < (long)headLength + length) {
            this.trace(ci.getExtraLayerCode(), ci, "Waiting for the end of HTTP Post Data.\r\nRecieved Post data is shorter then the length found in the HTTP headers.", false);
            ci.setTotalPutLength(length);
            ci.setCurrentPutLength(cc.getRequestData().getOffset() + cc.getRequestData().getLength() - headLength);
            ci.setDoingBody(true);
            if (ci.getTotalPutLength() - ci.getCurrentPutLength() > (long)this.httpProperties.getReadBufferSize()) {
                if (ci.getExtraLayerCode() < 0) {
                    cc.setPackSize(this.httpProperties.getReadBufferSize());
                }
            } else if (ci.getExtraLayerCode() == -1) {
                cc.setPackSize((int)(ci.getTotalPutLength() - ci.getCurrentPutLength()));
            }
            this.frame.logDebug("Processor.parseBodyCommand stopClientRequestReader " + cc.getConnectionId());
            cc.stopClientRequestReader();
            this.frame.logDebug("parseBodyCommand body is not full. Remain [" + (ci.getTotalPutLength() - ci.getCurrentPutLength()) + "] bytes. [" + cc.getConnectionId() + "].");
        } else {
            byte[] transferEncoding = Utils.getTransferEncoding(tempBytes, tempBytesLength);
            if (transferEncoding != null && ByteArrayUtils.equalsBytes(transferEncoding, HeaderValues.chunked_)) {
                isChunked = true;
                boolean isAll = true;
                try {
                    isAll = Utils.searchEndOfChunk(tempBytes, headLength, tempBytesLength, ci);
                }
                catch (ParseException e) {
                    this.frame.logWarning("Can't parse a chunked request body.", (Throwable)((Object)e));
                }
                if (isAll) {
                    this.httpMonitoring.onRequestEndCheck(ci);
                    ci.endRequest();
                    ci.setChunkedFinished(true);
                    this.frame.logDebug("parseBodyCommand entire chunked request is read [" + cc.getConnectionId() + "].");
                } else {
                    ci.setDoingBody(true);
                    this.frame.logDebug("Processor.parseBodyCommand stopClientRequestReader " + cc.getConnectionId());
                    cc.stopClientRequestReader();
                    this.frame.logDebug("parseBodyCommand chunked request. Body is not full [" + cc.getConnectionId() + "].");
                }
            } else {
                this.frame.logDebug("parseBodyCommand entire request is read [" + cc.getConnectionId() + "].");
                this.httpMonitoring.onRequestEndCheck(ci);
                ci.endRequest();
            }
        }
        byte[] nextRequest = null;
        if (ci.getOffset() != -1) {
            if (ci.getOffset() + ci.getLength() < cc.getRequestData().getOffset() + cc.getRequestData().getLength()) {
                byte[] req = new byte[ci.getOffset() + ci.getLength()];
                System.arraycopy(cc.getRequestData().getBytes(), 0, req, 0, req.length);
                nextRequest = new byte[cc.getRequestData().getOffset() + cc.getRequestData().getLength() - req.length];
                System.arraycopy(cc.getRequestData().getBytes(), req.length, nextRequest, 0, nextRequest.length);
                cc.dataProcessed();
                try {
                    cc.getRequestData().addBytes(req);
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
        } else if (length <= 0L) {
            if (!isChunked && tempBytesLength > headLength) {
                byte[] req = new byte[headLength];
                System.arraycopy(cc.getRequestData().getBytes(), 0, req, 0, req.length);
                nextRequest = new byte[tempBytesLength - headLength];
                System.arraycopy(cc.getRequestData().getBytes(), req.length, nextRequest, 0, nextRequest.length);
                cc.dataProcessed();
                try {
                    cc.getRequestData().addBytes(req);
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
        } else if ((long)tempBytesLength > (long)headLength + length) {
            byte[] req = new byte[headLength + (int)length];
            System.arraycopy(cc.getRequestData().getBytes(), 0, req, 0, req.length);
            nextRequest = new byte[tempBytesLength - headLength - (int)length];
            System.arraycopy(cc.getRequestData().getBytes(), req.length, nextRequest, 0, nextRequest.length);
            cc.dataProcessed();
            try {
                cc.getRequestData().addBytes(req);
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        ci.setNextRequest(nextRequest);
        this.addBytesToRequest(cc, CommunicationConstants.REQUEST_TYPE_NEW_REQUEST_, ci.getInetaddress(), false);
        if (!isChunked || this.httpProperties.getMaxContentLength() < 0L || ci.getChunkedRequestBodyRead() < this.httpProperties.getMaxContentLength()) {
            if (ci.getOffset() != -1) {
                this.trace(ci.getExtraLayerCode(), ci, "Sending request to server.", false);
                byte[] newbyte = new byte[ci.getLength()];
                System.arraycopy(cc.getRequestData().getBytes(), ci.getOffset(), newbyte, 0, newbyte.length);
                try {
                    application.send(cc, newbyte, 0, newbyte.length);
                }
                catch (ClusterException e) {
                    this.frame.logWarning("Error sending request to the server " + cc.getDestinationId() + ". The request is: " + new String(newbyte), e);
                }
            } else {
                try {
                    application.send(cc);
                }
                catch (ClusterException e) {
                    this.frame.logWarning("Error sending request to the server " + cc.getDestinationId() + ". The request is: " + new String(cc.getRequestData().getBytes(), 0, cc.getRequestData().getOffset() + cc.getRequestData().getLength()), e);
                }
            }
        } else if (isChunked && this.httpProperties.getMaxContentLength() >= 0L) {
            if (HttpDispatcherFrame.getHttpProperties().getUseServerHeader()) {
                this.sendError(cc, client, 413, Constants.errorHeaders413, ("Content length must be less than " + this.httpProperties.getMaxContentLength() + " bytes.").getBytes());
                return;
            }
            this.sendError(cc, client, 413, Constants.errorHeaders413NoServerHeader, ("Content length must be less than " + this.httpProperties.getMaxContentLength() + " bytes.").getBytes());
            return;
        }
        cc.dataProcessed();
        ci.setOffset(-1);
    }

    private boolean setServerId(Connection cc, ClientConnection client, ConnectionInfo ci) {
        boolean hasSuspended = this.loadbalance.hasSuspendedServer();
        if (cc.getDestinationId() == -1 && this.frame.serversVector.size() == 1 && !hasSuspended) {
            int[] servArray = this.frame.serversVector.toArray();
            if (servArray.length == 0) {
                cc.setDestinationId(-1);
            } else {
                cc.setDestinationId(this.frame.serversVector.toArray()[0]);
            }
            this.frame.logDebug("setServerId [" + cc.getDestinationId() + "]. [" + cc.getConnectionId() + "].");
            this.frame.registerConnection(cc);
        } else if (this.frame.serversVector.size() != 1 || hasSuspended) {
            int newId = -1;
            int oldId = -1;
            if (this.httpProperties.isHeterogeneousLoadBalancing()) {
                try {
                    newId = this.loadbalance.getServerIdFromRequest(cc.getRequestData().getBytes());
                }
                catch (ParseException e) {
                    this.frame.logWarning("Error in parsing the http request for load balancing. The request is:\r\n<" + new String(cc.getRequestData().getBytes(), 0, cc.getRequestData().getLength()) + ">.", (Throwable)((Object)e));
                    newId = this.loadbalance.getLeastBusyServerId();
                }
            } else if (ci.getOffset() != -1) {
                boolean isUrlSessionTracking = Utils.getUrlSessionTracking(cc.getRequestData().getBytes(), ci.getOffset() + ci.getLength());
                newId = Utils.getCookieId(cc.getRequestData().getBytes(), ci.getOffset() + ci.getLength(), !isUrlSessionTracking);
            } else {
                boolean isUrlSessionTracking = Utils.getUrlSessionTracking(cc.getRequestData().getBytes(), cc.getRequestData().getOffset() + cc.getRequestData().getLength());
                newId = Utils.getCookieId(cc.getRequestData().getBytes(), cc.getRequestData().getOffset() + cc.getRequestData().getLength(), !isUrlSessionTracking);
            }
            if (newId != -1) {
                if (!this.httpProperties.isHeterogeneousLoadBalancing()) {
                    oldId = newId;
                    if ((newId = this.frame.getMappedServer(newId)) != -1) {
                        this.trace(ci.getExtraLayerCode(), ci, "HTTP Session Cookies detected.\r\nWill proceed the request on the same server where the session is established.", false);
                    } else {
                        try {
                            newId = this.loadbalance.getServerId(cc.getRequestData().getBytes());
                        }
                        catch (ParseException e) {
                            this.frame.logWarning("Error in parsing the http request for load balancing. The request is:\r\n<" + new String(cc.getRequestData().getBytes(), 0, cc.getRequestData().getLength()) + ">.", (Throwable)((Object)e));
                            newId = this.loadbalance.getLeastBusyServerId();
                        }
                        this.frame.putMappedServer(oldId, newId);
                    }
                }
                cc.setDestinationId(newId);
            } else if (this.httpProperties.isHeterogeneousLoadBalancing()) {
                try {
                    cc.setDestinationId(this.loadbalance.getServerId(cc.getRequestData().getBytes()));
                }
                catch (ParseException e) {
                    this.frame.logWarning("Error in parsing the http request for load balancing. The request is:\r\n<" + new String(cc.getRequestData().getBytes(), 0, cc.getRequestData().getLength()) + ">.", (Throwable)((Object)e));
                    newId = this.loadbalance.getLeastBusyServerId();
                }
            } else {
                cc.setDestinationId(this.loadbalance.getLeastBusyServerId());
            }
            this.frame.registerConnection(cc);
        }
        this.frame.logDebug("setServerId [" + cc.getDestinationId() + "]. [" + cc.getConnectionId() + "].");
        if (cc.getDestinationId() == -1) {
            this.sendErrorNoServer(cc, client);
            return false;
        }
        return true;
    }

    private void sendError(Connection cc, ClientConnection clientConnection, int code, byte[] headers, byte[] error) {
        byte[] errorBody = Responses.getErrorResponse(HttpDispatcherFrame.getVersion(), code, error);
        error = new byte[errorBody.length + headers.length];
        System.arraycopy(headers, 0, error, 0, headers.length);
        System.arraycopy(errorBody, 0, error, headers.length, errorBody.length);
        byte[] newError = this.packExtraLayerError(cc, error);
        ConnectionInfo ci = (ConnectionInfo)cc.getPrivateData();
        if (ci.getExtraLayerCode() != -1) {
            this.trace(ci.getExtraLayerCode(), ci, "Dispatcher Running But No Server Connected.", true);
            clientConnection.send(cc, newError, 0, newError.length);
            cc.startClientRequestReader();
            return;
        }
        clientConnection.send(cc, newError, 0, newError.length);
        cc.closeConnection();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendCustomizedError(Connection cc, ClientConnection clientConnection, byte[] headers) {
        filePath = HttpDispatcherFrame.getHttpProperties().getServiceUnavailableResponse();
        radomAccessFile = null;
        try {
            radomAccessFile = new RandomAccessFile(new File(filePath), "r");
            radomAccessFile.seek(0L);
            fileLength = (int)radomAccessFile.length();
            fileContent = new byte[fileLength + headers.length];
            System.arraycopy(headers, 0, fileContent, 0, headers.length);
            readed = 0;
            offset = headers.length;
            while (true) {
                block11: {
                    if (readed != -1 && offset < fileLength + headers.length) break block11;
                    newError = this.packExtraLayerError(cc, fileContent);
                    ci = (ConnectionInfo)cc.getPrivateData();
                    if (ci.getExtraLayerCode() == -1) break;
                    this.trace(ci.getExtraLayerCode(), ci, "Dispatcher Running But No Server Connected.", true);
                    clientConnection.send(cc, newError, 0, newError.length);
                    cc.startClientRequestReader();
                    var13_13 = null;
                    ** GOTO lbl51
                }
                readed = radomAccessFile.read(fileContent, offset, fileLength - offset + headers.length);
                offset += readed;
            }
            clientConnection.send(cc, newError, 0, newError.length);
            cc.closeConnection();
            ** GOTO lbl57
        }
        catch (Exception ioe) {
            this.frame.logError("Cannot send customized error page " + filePath, ioe);
            this.sendError(cc, clientConnection, 503, headers, Constants.errorMessageNoServer);
            var13_15 = null;
            try {
                radomAccessFile.close();
                return;
            }
            catch (Exception e) {
                this.frame.logWarning("Cannot close file " + filePath + ".", e);
                return;
            }
        }
        {
            catch (Throwable var12_21) {
                var13_16 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 272->280)] { 
lbl46:
                // 1 sources

                radomAccessFile.close();
                throw var12_21;
lbl48:
                // 1 sources

                catch (Exception e) {
                    this.frame.logWarning("Cannot close file " + filePath + ".", e);
                }
                throw var12_21;
            }
lbl51:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 272->280)] { 
lbl52:
            // 1 sources

            radomAccessFile.close();
            return;
lbl54:
            // 1 sources

            catch (Exception e) {
                this.frame.logWarning("Cannot close file " + filePath + ".", e);
            }
            return;
lbl57:
            // 1 sources

            var13_14 = null;
            try {}
            catch (Exception e) {}
            this.frame.logWarning("Cannot close file " + filePath + ".", e);
            return;
            radomAccessFile.close();
            return;
        }
    }

    private void sendErrorNoServer(Connection cc, ClientConnection client) {
        this.frame.logDebug("sendErrorNoServer [" + cc.getConnectionId() + "].");
        if (HttpDispatcherFrame.getHttpProperties().getServiceUnavailableResponse() != null) {
            if (HttpDispatcherFrame.getHttpProperties().getUseServerHeader()) {
                this.sendCustomizedError(cc, client, Constants.errorHeaders503);
            } else {
                this.sendCustomizedError(cc, client, Constants.errorHeaders503NoServerHeader);
            }
        } else if (HttpDispatcherFrame.getHttpProperties().getUseServerHeader()) {
            this.sendError(cc, client, 503, Constants.errorHeaders503, Constants.errorMessageNoServer);
        } else {
            this.sendError(cc, client, 503, Constants.errorHeaders503NoServerHeader, Constants.errorMessageNoServer);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addBytesToRequest(Connection c, byte[] b1, byte[] b2, boolean put) throws IOException {
        ci = (ConnectionInfo)c.getPrivateData();
        try {
            c.getRequestData().addBytes(b1);
            c.getRequestData().addBytes(b2);
            c.getRequestData().addBytes(ci.getPort());
        }
        catch (Exception e) {
            throw new HttpIOException("http_0006", e);
        }
        if (ci.getLength() > -1) {
            ci.setLength(ci.getLength() + b1.length + b2.length + ci.getPort().length);
        }
        if (ci.getCertFromICM() != null && (this.acceptClientCertNoSSL || ((ConnectionMonitor)c).getSocket() instanceof SSLSocket)) {
            origRequest = c.getRequestData().getBytes();
            offset = ci.getOffset();
            len = ci.getLength();
            if (offset == -1) {
                offset = 0;
                len = c.getRequestData().getOffset() + c.getRequestData().getLength();
            }
            newRequest = new byte[len + 5];
            System.arraycopy(origRequest, offset, newRequest, 0, newRequest.length);
            newRequest[newRequest.length - 5] = b1[0];
            newRequest[newRequest.length - 4] = b2[0];
            newRequest[newRequest.length - 3] = b2[1];
            newRequest[newRequest.length - 2] = b2[2];
            newRequest[newRequest.length - 1] = b2[3];
            ci.setOriginalRequest(newRequest);
            try {
                cert = this.readClientCert(c, false);
                if (ci.getLength() > -1) {
                    ci.setLength(ci.getLength() + cert.length);
                }
                c.getRequestData().addBytes(cert);
            }
            catch (Exception e) {
                throw new HttpIOException("http_0006", e);
            }
        }
        if (ci.isSSL()) {
            try {
                c.getRequestData().addBytes(CommunicationConstants.REQUEST_SSL_);
                if (ci.getLength() <= -1) ** GOTO lbl68
                ci.setLength(ci.getLength() + CommunicationConstants.REQUEST_SSL_.length);
            }
            catch (Exception e) {
                throw new HttpIOException("http_0006", e);
            }
        } else {
            if (((ConnectionMonitor)c).getSocket() instanceof SSLSocket && ci.getOffset() == -1) {
                origRequest = c.getRequestData().getBytes();
                newRequest = new byte[origRequest.length + 5];
                System.arraycopy(origRequest, 0, newRequest, 0, origRequest.length);
                newRequest[newRequest.length - 5] = b1[0];
                newRequest[newRequest.length - 4] = b2[0];
                newRequest[newRequest.length - 3] = b2[1];
                newRequest[newRequest.length - 2] = b2[2];
                newRequest[newRequest.length - 1] = b2[3];
                ci.setOriginalRequest(newRequest);
                try {
                    c.getRequestData().addBytes(this.readClientCert(c, false));
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new HttpIOException("http_0006", e);
                }
            }
            try {
                c.getRequestData().addBytes(CommunicationConstants.REQUEST_NO_SSL_);
                if (ci.getLength() > -1) {
                    ci.setLength(ci.getLength() + CommunicationConstants.REQUEST_NO_SSL_.length);
                }
            }
            catch (Exception e) {
                throw new HttpIOException("http_0006", e);
            }
        }
lbl68:
        // 5 sources

        if (ci.getExtraLayerCode() != -1) {
            if (((ConnectionMonitor)c).getSocket() instanceof SSLSocket) {
                origRequest = c.getRequestData().getBytes();
                newRequest = new byte[origRequest.length + 5];
                System.arraycopy(origRequest, 0, newRequest, 0, origRequest.length);
                newRequest[newRequest.length - 5] = b1[0];
                newRequest[newRequest.length - 4] = b2[0];
                newRequest[newRequest.length - 3] = b2[1];
                newRequest[newRequest.length - 2] = b2[2];
                newRequest[newRequest.length - 1] = b2[3];
                ci.setOriginalRequest(newRequest);
                try {
                    c.getRequestData().addBytes(this.readClientCert(c, true));
                }
                catch (Exception e) {
                    throw new HttpIOException("http_0006", e);
                }
                ci.setICM((byte)2);
            } else {
                ci.setICM((byte)1);
            }
        } else {
            ci.setICM((byte)-1);
        }
        try {
            c.getRequestData().addBytes(ci.getICM());
            if (ci.getLength() > -1) {
                ci.setLength(ci.getLength() + ci.getICM().length);
            }
        }
        catch (Exception e) {
            throw new HttpIOException("http_0006", e);
        }
    }

    private byte[] readClientCert(Connection cc, boolean fromSocket) {
        Socket sslSocket = ((ConnectionMonitor)cc).getSocket();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int connectionInfo = 3;
        try {
            if (!fromSocket && ((ConnectionInfo)cc.getPrivateData()).getCertFromICM() != null) {
                connectionInfo = 3;
                byte[] cert = ((ConnectionInfo)cc.getPrivateData()).getCertFromICM();
                baos.write(cert, 0, cert.length);
                baos.write(Utils.intToBytes(cert.length), 0, 2);
                baos.write(Utils.intToBytes(1), 0, 2);
                baos.write(Utils.intToBytes(0), 0, 2);
            } else if (sslSocket instanceof SSLSocket) {
                String cipherSuite;
                SSLSocket socket = (SSLSocket)sslSocket;
                socket.setNeedClientAuth(true);
                socket.startHandshake();
                X509Certificate[] certificates = (X509Certificate[])socket.getClientCertificate();
                int certLength = 0;
                if (certificates != null) {
                    certLength = certificates.length;
                    int c = 0;
                    while (c < certLength) {
                        byte[] certBytes = certificates[c].getEncoded();
                        baos.write(certBytes, 0, certBytes.length);
                        baos.write(Utils.intToBytes(certBytes.length), 0, 2);
                        ++c;
                    }
                }
                baos.write(Utils.intToBytes(certLength), 0, 2);
                SSLSession session = socket.getSession();
                String string = cipherSuite = session == null ? "" : session.getCipherSuite();
                if (cipherSuite == null) {
                    cipherSuite = "";
                }
                int size = cipherSuite.length();
                baos.write(cipherSuite.getBytes(), 0, size);
                baos.write(Utils.intToBytes(size), 0, 2);
            } else {
                connectionInfo = 2;
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.frame.logWarning("Can't read client certificate. ", e);
            baos.reset();
            baos.write(ConnectionInfo.EMPTY_CERT, 0, ConnectionInfo.EMPTY_CERT.length);
        }
        baos.write(connectionInfo);
        return baos.toByteArray();
    }

    /*
     * Unable to fully structure code
     */
    private boolean answerDebugRequest(byte[] tempBytes, int off, int length, Connection cc, ClientConnection clientConnection) {
        block22: {
            block21: {
                block20: {
                    if (!this.loadbalance.hasDebugServer()) {
                        return false;
                    }
                    scheme = null;
                    host = null;
                    url = null;
                    suspendId = null;
                    ind = off;
                    endInd = off + length;
                    while (ind < endInd && tempBytes[ind] != 32) {
                        ++ind;
                    }
                    if (ind == endInd) {
                        return false;
                    }
                    if (tempBytes[++ind] != 47) break block20;
                    ++ind;
                    ** GOTO lbl45
                }
                if (!ByteArrayUtils.startsWith(tempBytes, ind, endInd - ind, RequestLine.scheme_http_)) break block21;
                ind += RequestLine.scheme_http_.length;
                scheme = RequestLine.scheme_http_;
                while (ind < endInd && tempBytes[ind] == 47) {
                    ++ind;
                }
                hostOffset = ind;
                while (ind < endInd && tempBytes[ind] != 47 && tempBytes[ind] != 32) {
                    ++ind;
                }
                host = new byte[ind - hostOffset];
                System.arraycopy(tempBytes, hostOffset, host, 0, host.length);
                ** GOTO lbl45
            }
            if (!ByteArrayUtils.startsWith(tempBytes, ind, endInd - ind, RequestLine.scheme_https_)) break block22;
            scheme = RequestLine.scheme_https_;
            hostOffset = ind += RequestLine.scheme_https_.length;
            while (ind < endInd && tempBytes[ind] != 47 && tempBytes[ind] != 32) {
                ++ind;
            }
            host = new byte[ind - hostOffset];
            System.arraycopy(tempBytes, hostOffset, host, 0, host.length);
            if (true) ** GOTO lbl45
        }
        return false;
        do {
            ++ind;
lbl45:
            // 4 sources

        } while (ind < endInd && tempBytes[ind] == 47);
        if (!ByteArrayUtils.startsWith(tempBytes, ind, endInd - ind, Constants.DEBUG_STR)) {
            return false;
        }
        ind += Constants.DEBUG_STR.length;
        if (scheme == null) {
            scheme = ((ConnectionMonitor)cc).getSocket() instanceof SSLSocket != false ? RequestLine.scheme_https_ : RequestLine.scheme_http_;
        }
        if ((indexOfHost = ByteArrayUtils.indexOfIgnoreCase(tempBytes, ind, endInd - ind, Constants.host_header_beg)) != -1) {
            indexOfHost += ind;
            indexOfHost += Constants.host_header_beg.length;
        } else {
            indexOfHost = ByteArrayUtils.indexOfIgnoreCase(tempBytes, ind, endInd - ind, Constants.host_header_beg_sp);
            if (indexOfHost != -1) {
                indexOfHost += ind;
                indexOfHost += Constants.host_header_beg_sp.length;
            }
        }
        if (indexOfHost > -1) {
            hostHeaderEnd = ByteArrayUtils.indexOf(tempBytes, indexOfHost, endInd - indexOfHost, new byte[]{10});
            if (tempBytes[(hostHeaderEnd += indexOfHost) - 1] == 13) {
                --hostHeaderEnd;
            }
            host = new byte[hostHeaderEnd - indexOfHost];
            System.arraycopy(tempBytes, indexOfHost, host, 0, host.length);
            host = ByteArrayUtils.trim(host);
        }
        reqLineEndInd = ByteArrayUtils.indexOf(tempBytes, ind, endInd - ind, new byte[]{10});
        spInd = ByteArrayUtils.indexOf(tempBytes, ind, (reqLineEndInd += ind) - ind, new byte[]{32});
        if (spInd == -1) {
            return false;
        }
        spInd += ind;
        if (tempBytes[ind] == 47 || tempBytes[ind] == 32) {
            suspendId = ("" + this.loadbalance.getDebuged()).getBytes();
            url = new byte[spInd - ind];
            System.arraycopy(tempBytes, ind, url, 0, url.length);
        } else {
            slashInd = ByteArrayUtils.indexOf(tempBytes, ind, spInd - ind, new byte[]{47});
            slashInd = slashInd == -1 ? spInd : (slashInd += ind);
            suspendId = new byte[slashInd - ind];
            System.arraycopy(tempBytes, ind, suspendId, 0, suspendId.length);
            ind += slashInd - ind;
            if (slashInd == spInd) {
                url = new byte[]{};
            } else {
                url = new byte[spInd - ind];
                System.arraycopy(tempBytes, ind, url, 0, url.length);
            }
        }
        this.removeDebuggedSession(cc.getRequestData().getBytes(), cc.getRequestData().getOffset(), cc.getRequestData().getLength());
        urlOffset = 0;
        while (url.length > urlOffset && (url[urlOffset] == 47 || url[urlOffset] == 92)) {
            ++urlOffset;
        }
        requestedApplication = this.loadbalance.findAlias(url, urlOffset, url.length - urlOffset);
        this.returnSetCookieMessage(cc, clientConnection, scheme, host, url, requestedApplication, suspendId);
        return true;
    }

    private void removeDebuggedSession(byte[] requets, int off, int len) {
        byte[] cookie = Utils.getSessionCookie(requets, off + len);
        if (cookie == null || cookie.length == 0) {
            return;
        }
        int[] allServers = this.frame.serversVector.toArray();
        int i = 0;
        while (i < allServers.length) {
            try {
                this.frame.getMessageContext().sendAndWaitForAnswer(allServers[i], 523, cookie, 0, cookie.length, this.httpProperties.getServerReadRequestBodyChunkTimeoutMillis());
            }
            catch (ClusterException e) {
                this.frame.logWarning("Cannot send message to server [" + allServers[i] + "] to remove debugged session [" + cookie + "].", e);
            }
            ++i;
        }
    }

    private void returnSetCookieMessage(Connection cc, ClientConnection clientConnection, byte[] scheme, byte[] host, byte[] url, String requestedApplication, byte[] suspendId) {
        String suspendIdName = new String(suspendId);
        String cookieDomain = this.getCookieDomain(new String(host));
        String cookieHeaderEnd = "; Version=1" + (cookieDomain == null ? "" : "; Domain=" + cookieDomain) + "; Discard; Path=/\r\n";
        String rewriting = ";" + this.httpProperties.getLoadBalancingCookiePrefix() + "*=(" + this.frame.getInstanceId() + ")" + suspendIdName;
        String statusLine = "HTTP/1.1 302 Found\r\n";
        String server = "Server: SAP J2EE Engine/" + new String(HttpDispatcherFrame.getVersion()) + "\r\n";
        String applicationCookieHeader = "Set-Cookie: " + this.httpProperties.getLoadBalancingCookiePrefix() + "*=(" + this.frame.getInstanceId() + ")" + suspendIdName + cookieHeaderEnd;
        String connection = "Connection: close\r\n";
        String location = "Location: ";
        String end = "\r\n";
        if (requestedApplication != null && requestedApplication.length() != 0) {
            applicationCookieHeader = applicationCookieHeader + "Set-Cookie: " + this.httpProperties.getLoadBalancingCookiePrefix() + "*" + "=(" + this.frame.getInstanceId() + ")" + suspendIdName + "; Version=1; Discard; Path=/" + requestedApplication + "/" + end;
        }
        if (host != null) {
            location = location + new String(scheme);
            location = location + new String(host);
        }
        String urlString = new String(url);
        if (url.length == 0 || url[0] != 47) {
            urlString = "/";
        }
        String query = "";
        int qInd = urlString.indexOf(63);
        if (qInd > -1) {
            query = urlString.substring(qInd);
            urlString = urlString.substring(0, qInd);
        }
        if ((qInd = urlString.indexOf(59)) != -1) {
            String urlRewriting = urlString.substring(qInd);
            urlString = urlString.substring(0, qInd);
            urlRewriting = urlRewriting.startsWith(";jsessionid=") ? ((qInd = urlRewriting.indexOf(59, ";jsessionid=".length())) == -1 ? urlRewriting + rewriting : urlRewriting.substring(0, qInd) + rewriting + urlRewriting.substring(qInd)) : rewriting + urlRewriting;
            urlString = urlString + urlRewriting;
        } else {
            urlString = urlString + rewriting;
        }
        location = location + urlString + query;
        location = location + end;
        byte[] message = null;
        message = HttpDispatcherFrame.getHttpProperties().getUseServerHeader() ? this.packExtraLayerError(cc, (statusLine + server + connection + applicationCookieHeader + location + end).getBytes()) : this.packExtraLayerError(cc, (statusLine + connection + applicationCookieHeader + location + end).getBytes());
        if (((ConnectionInfo)cc.getPrivateData()).getExtraLayerCode() != -1) {
            this.trace(((ConnectionInfo)cc.getPrivateData()).getExtraLayerCode(), (ConnectionInfo)cc.getPrivateData(), "Dispatcher Running But No Server Connected.", true);
            clientConnection.send(cc, message, 0, message.length);
            cc.startClientRequestReader();
            return;
        }
        clientConnection.send(cc, message, 0, message.length);
        cc.closeConnection();
    }

    private String getCookieDomain(String hostName) {
        boolean isIP = true;
        int points = 0;
        boolean domainHasPort = false;
        char[] domain = hostName.toCharArray();
        int ind = CharArrayUtils.indexOf(domain, ':');
        if (ind > 0) {
            domainHasPort = true;
            char[] tmpDomain = new char[ind];
            System.arraycopy(domain, 0, tmpDomain, 0, ind);
            domain = tmpDomain;
        }
        int i = 0;
        while (i < domain.length) {
            if (domain[i] == '.') {
                ++points;
            } else if (!Character.isDigit(domain[i])) {
                isIP = false;
                break;
            }
            ++i;
        }
        if (isIP && points == 3) {
            if (domainHasPort) {
                return new String(domain);
            }
            return hostName;
        }
        int dotInd = CharArrayUtils.indexOf(domain, '.');
        if (dotInd >= 0 && CharArrayUtils.indexOf(domain, '.', dotInd) >= 0) {
            return new String(domain, dotInd, domain.length - dotInd);
        }
        return null;
    }

    private byte[] packExtraLayer(Connection cc, byte[] serverData, int offset, int length, boolean eod) {
        byte[] result = null;
        int i = 0;
        while (i < this.layers.length) {
            result = this.layers[i].packExtraLayer(cc, serverData, offset, length, eod);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    private boolean unpackExtraLayer(Connection cc) {
        if (((ConnectionInfo)cc.getPrivateData()).getProtocol()) {
            int i = 0;
            while (i < this.layers.length) {
                if (this.layers[i].unpackExtraLayer(cc)) {
                    return ((ConnectionInfo)cc.getPrivateData()).getWaiting();
                }
                ++i;
            }
        }
        return false;
    }

    private byte[] packExtraLayerError(Connection cc, byte[] error) {
        byte[] result = null;
        int i = 0;
        while (i < this.layers.length) {
            result = this.layers[i].packError(cc, error);
            if (result != null) break;
            ++i;
        }
        if (result == null) {
            return error;
        }
        return result;
    }

    private void trace(int layerCode, ConnectionInfo ci, String message, boolean isError) {
        int i = 0;
        while (i < this.layers.length) {
            if (this.layers[i].getLayerCode() == layerCode) {
                this.layers[i].trace(ci, message, isError);
                break;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

