/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher;

import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.services.httpserver.dispatcher.HttpDispatcherFrame;
import com.sap.engine.services.httpserver.dispatcher.PortProperties;
import com.sap.engine.services.httpserver.lib.CookieParser;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class HttpProperties {
    private static final String proxy_mappings_key = "ProxyMappings";
    private static final String ports_key = "Ports";
    private static final String port_key = "Port";
    private static final String type_key = "Type";
    private static final String type_http = "http";
    private static final String type_ssl = "ssl";
    private static final String socket_queue_key = "SocketQueue";
    private static final String accepting_threads_count_key = "AcceptingThreadsCount";
    private static final String keep_alive_timeout_key = "KeepAliveTimeout";
    private static final String max_request_headers_length_key = "MaxRequestHeadersLength";
    private static final String bind_address_key = "BindAddress";
    private static final String heterogeneous_load_balancing_key = "HeterogeneousLoadBalancing";
    private static final String http_trace_key = "HttpTrace";
    private static final String HTTP_TRACE_TIME_KEY = "HttpTraceTime";
    private static final String USE_SERVER_HEADER = "UseServerHeader";
    private static final String SERVICE_UNAVAILABLE_RESPONSE = "ServiceUnavailableResponse";
    private static final String READ_BUFFER_SIZE_KEY = "ReadBufferSize";
    private static final String MAX_REQUEST_CONTENT_LENGTH = "MaxRequestContentLength";
    private static final String SOCKET_TCP_NO_DELAY = "SocketTcpNoDelay";
    private static final String LOAD_BALANCING_COOKIE_PREFIX = "LoadBalancingCookiePrefix";
    private static final String HTTP_MONITORING_CACHE_TIMEOUT_MILLIS = "HttpMonitoringCacheTimeoutMillis";
    private static final String SERVER_READ_REQUEST_BODY_CHUNK_TIMEOUT_MILLIS = "ServerReadRequestBodyChunkTimeoutMillis";
    private static final String SERVLETS_LONG_DATA_TRANSFER_CALLBACK_SIZE = "ServletsLongDataTransferCallbackSize";
    private static final int SERVLETS_LONG_DATA_TRANSFER_CALLBACK_SIZE_MIN_VALUE = 1024;
    private static final int SERVLETS_LONG_DATA_TRANSFER_CALLBACK_SIZE_DEFAULT_VALUE = -1;
    private static final long defaultKeepaliveTimeout = 15000L;
    private static final String disableHttpTrace = "disable";
    private static final String enableHttpTrace = "enable";
    private static final String enableHeadersHttpTrace = "enableHeaders";
    private static final String enableHexHttpTrace = "enableHex";
    private static final String enableHexHeadersHttpTrace = "enableHexHeaders";
    public static final int DISABLE_HTTP_TRACE_INT = 0;
    public static final int ENABLE_HTTP_TRACE_INT = 1;
    public static final int ENABLE_HEADERS_HTTP_TRACE_INT = 2;
    public static final int ENABLE_HEX_HTTP_TRACE_INT = 3;
    public static final int ENABLE_HEX_HEADERS_HTTP_TRACE_INT = 4;
    private ConcurrentHashMapIntObject port = new ConcurrentHashMapIntObject();
    private int max_headers_length = 4096;
    private long max_content_length = 0x8000000L;
    private long keepaliveTimeout = 15000L;
    private boolean keepaliveTimeoutModified = true;
    private boolean isHeterogeneous = true;
    private String httpTrace = "disable";
    private int httpTraceInt = 0;
    private String proxyMappings = "";
    private boolean useServerHeader = true;
    private String serviceUnavailableResponse = null;
    private int readBufferSize = 32768;
    private boolean tcpNoDelay = true;
    private String loadBalancingCookiePrefix = "saplb_";
    private boolean httpTraceTime = false;
    private long httpMonitoringCacheTimeoutMillis = 1500L;
    private long serverReadRequestBodyChunkTimeoutMillis = 600000L;
    private static final long MIN_SERVER_READ_REQUEST_BODY_CHUNK_TIMEOUT_MILLIS = 100L;
    private int servletsLongDataTransferCallbackSize = -1;
    private HttpDispatcherFrame frame = null;

    public HttpProperties(HttpDispatcherFrame frame) {
        this.frame = frame;
    }

    public ConcurrentHashMapIntObject getPorts() {
        return this.port;
    }

    public String getProxyMappings() {
        return this.proxyMappings;
    }

    public int getMaxHeadersLength() {
        return this.max_headers_length;
    }

    public long getMaxContentLength() {
        return this.max_content_length;
    }

    public long getKeepaliveTimeout() {
        return this.keepaliveTimeout;
    }

    public boolean keepaliveTimeoutModified() {
        return this.keepaliveTimeoutModified;
    }

    public boolean isHeterogeneousLoadBalancing() {
        return this.isHeterogeneous;
    }

    public String getHttpTrace() {
        return this.httpTrace;
    }

    public int getHttpTraceInt() {
        return this.httpTraceInt;
    }

    public boolean getUseServerHeader() {
        return this.useServerHeader;
    }

    public String getServiceUnavailableResponse() {
        return this.serviceUnavailableResponse;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public String getLoadBalancingCookiePrefix() {
        return this.loadBalancingCookiePrefix;
    }

    public boolean getHttpTraceTime() {
        return this.httpTraceTime;
    }

    public long getHttpMonitoringCacheTimeoutMillis() {
        return this.httpMonitoringCacheTimeoutMillis;
    }

    public long getServerReadRequestBodyChunkTimeoutMillis() {
        return this.serverReadRequestBodyChunkTimeoutMillis;
    }

    public int getServletsLongDataTransferCallbackSize() {
        return this.servletsLongDataTransferCallbackSize;
    }

    public void setProperties(Properties sp) {
        Enumeration en = ((Hashtable)sp).keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.setProperty(key, sp.getProperty(key));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String name, String value) {
        if (ports_key.equals(name)) {
            try {
                this.port = this.getPortsProperties(value);
                return;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logError("Incompatible value of the property Ports.", e);
                return;
            }
        }
        if (proxy_mappings_key.equals(name)) {
            try {
                this.proxyMappings = value.trim();
                return;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logError("Incompatible value of the property ProxyMappings.", e);
                return;
            }
        }
        if (heterogeneous_load_balancing_key.equals(name)) {
            this.isHeterogeneous = Boolean.valueOf(value);
            return;
        }
        if (max_request_headers_length_key.equals(name)) {
            try {
                this.max_headers_length = new Integer(value);
                return;
            }
            catch (Exception e) {
                this.logError("Incompatible value of the property MaxRequestHeadersLength. Will use the default value.", e);
            }
            return;
        }
        if (MAX_REQUEST_CONTENT_LENGTH.equals(name)) {
            try {
                this.max_content_length = new Long(value) * 1024L;
                return;
            }
            catch (Exception e) {
                this.max_content_length = 0x8000000L;
                this.logError("Incompatible value of the property MaxRequestContentLength. Will use the default value.", e);
            }
            return;
        }
        if (keep_alive_timeout_key.equals(name)) {
            long newkeepaliveTimeout = -1L;
            try {
                newkeepaliveTimeout = Long.valueOf(value) * 1000L;
                if (newkeepaliveTimeout <= 0L) {
                    newkeepaliveTimeout = -1L;
                }
                this.keepaliveTimeoutModified = this.keepaliveTimeout != newkeepaliveTimeout;
                this.keepaliveTimeout = newkeepaliveTimeout;
                return;
            }
            catch (NumberFormatException t) {
                this.logError("Incompatible value of the property KeepAliveTimeout. Keep-Alive connections will not be closed.", t);
                this.keepaliveTimeoutModified = this.keepaliveTimeout != 15000L;
                this.keepaliveTimeout = 15000L;
            }
            return;
        }
        if (HTTP_MONITORING_CACHE_TIMEOUT_MILLIS.equals(name)) {
            try {
                this.httpMonitoringCacheTimeoutMillis = Long.parseLong(value);
                if (this.httpMonitoringCacheTimeoutMillis >= 0L) return;
                this.httpMonitoringCacheTimeoutMillis = 0L;
                return;
            }
            catch (NumberFormatException e) {
                this.logError("Incompatible value of the property HttpMonitoringCacheTimeoutMillis. Using the default value of " + this.httpMonitoringCacheTimeoutMillis + ".", e);
            }
            return;
        }
        if (SERVER_READ_REQUEST_BODY_CHUNK_TIMEOUT_MILLIS.equals(name)) {
            try {
                this.serverReadRequestBodyChunkTimeoutMillis = Long.parseLong(value);
                if (this.serverReadRequestBodyChunkTimeoutMillis >= 100L) return;
                this.frame.logError("Incompatible value of the property ServerReadRequestBodyChunkTimeoutMillis==(" + this.serverReadRequestBodyChunkTimeoutMillis + "). Using the minimum allowed value of " + 100L + ".");
                this.serverReadRequestBodyChunkTimeoutMillis = 100L;
                return;
            }
            catch (NumberFormatException e) {
                this.logError("Incompatible value of the property ServerReadRequestBodyChunkTimeoutMillis. Using the default value of " + this.serverReadRequestBodyChunkTimeoutMillis + ".", e);
            }
            return;
        }
        if (http_trace_key.equals(name)) {
            try {
                this.setHttpTrace(value.trim());
                return;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logError("Error while setting property \"HttpTrace\" to value \"" + value.trim() + "\".", e);
                return;
            }
        }
        if (HTTP_TRACE_TIME_KEY.equals(name)) {
            this.httpTraceTime = "true".equalsIgnoreCase(value.trim());
            return;
        }
        if (USE_SERVER_HEADER.equals(name)) {
            this.useServerHeader = Boolean.valueOf(value);
            return;
        }
        if (SERVICE_UNAVAILABLE_RESPONSE.equals(name)) {
            try {
                this.serviceUnavailableResponse = value;
                if (new File(this.serviceUnavailableResponse).exists() && new File(this.serviceUnavailableResponse).isFile()) return;
                this.serviceUnavailableResponse = null;
                return;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logError("Incompatible value of the ServiceUnavailableResponse property. The default value will be used.", e);
                this.serviceUnavailableResponse = null;
                return;
            }
        }
        if (READ_BUFFER_SIZE_KEY.equals(name)) {
            try {
                this.readBufferSize = Integer.valueOf(value);
                if (this.readBufferSize >= 0) return;
                this.readBufferSize = 0;
                return;
            }
            catch (NumberFormatException t) {
                this.logError("Incompatible value of the property " + name + ". The default value 32768 will be used.", t);
                this.readBufferSize = 32768;
            }
            return;
        }
        if (SOCKET_TCP_NO_DELAY.equals(name)) {
            this.tcpNoDelay = new Boolean(value);
            return;
        }
        if (LOAD_BALANCING_COOKIE_PREFIX.equals(name)) {
            CookieParser.app_cookie_prefix = this.loadBalancingCookiePrefix = value.trim();
            CookieParser.app_cookie_prefix_ = CookieParser.app_cookie_prefix.getBytes();
            return;
        }
        if (!SERVLETS_LONG_DATA_TRANSFER_CALLBACK_SIZE.equals(name)) return;
        try {
            this.servletsLongDataTransferCallbackSize = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            this.logError("Incompatible value " + value + " of the property " + name + ". The default value " + -1 + " will be set.", nfe);
            this.servletsLongDataTransferCallbackSize = -1;
        }
        if (this.servletsLongDataTransferCallbackSize <= 0) {
            this.servletsLongDataTransferCallbackSize = -1;
            return;
        } else {
            if (this.servletsLongDataTransferCallbackSize >= 1024) return;
            this.logError("Incompatible value " + value + " of the property " + name + ". The default value " + -1 + " will be set.", null);
            this.servletsLongDataTransferCallbackSize = -1;
        }
    }

    private void logError(String errorMsg, Throwable t) {
        this.frame.logError(errorMsg, t);
    }

    private ConcurrentHashMapIntObject getPortsProperties(String value) {
        int b = -1;
        int e = -1;
        String s = null;
        String v = null;
        PortProperties pp = null;
        ConcurrentHashMapIntObject result = new ConcurrentHashMapIntObject();
        boolean defaultHttp = false;
        boolean defaultSsl = false;
        while ((b = value.indexOf(40, e + 1)) > -1 && (e = value.indexOf(41, b + 1)) > -1) {
            s = value.substring(b + 1, e);
            pp = new PortProperties();
            v = this.getValue(s, bind_address_key);
            if (v != null) {
                pp.setBindAddress(v.trim());
            } else {
                pp.setBindAddress(null);
            }
            v = this.getValue(s, type_key);
            if (v != null) {
                pp.setType(v.trim().equals(type_ssl) ? 2 : 1);
            } else {
                pp.setType(1);
            }
            v = this.getValue(s, port_key);
            if (v != null) {
                try {
                    pp.setPort(new Integer(v));
                }
                catch (OutOfMemoryError ex) {
                    throw ex;
                }
                catch (ThreadDeath ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    pp.setPort(-1);
                    this.logError("Incompatible value of the property Port. Will use the default values (http:80, ssl:443).", ex);
                }
            } else {
                pp.setPort(-1);
            }
            v = this.getValue(s, socket_queue_key);
            if (v != null) {
                try {
                    pp.setSocketQueue(new Integer(v));
                }
                catch (OutOfMemoryError ex) {
                    throw ex;
                }
                catch (ThreadDeath ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    pp.setSocketQueue(200);
                    this.logError("Incompatible value of the property SocketQueue. ", ex);
                }
            } else {
                pp.setSocketQueue(200);
            }
            v = this.getValue(s, accepting_threads_count_key);
            if (v != null) {
                try {
                    pp.setAcceptingThreadsCount(new Integer(v));
                }
                catch (OutOfMemoryError ex) {
                    throw ex;
                }
                catch (ThreadDeath ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    pp.setAcceptingThreadsCount(10);
                    this.logError("Incompatible value of the property AcceptingThreadsCount.", ex);
                }
            } else {
                pp.setAcceptingThreadsCount(10);
            }
            if (pp.getPort() == -1) continue;
            if (!defaultHttp && pp.getType() == 1) {
                defaultHttp = true;
                pp.setDefault(true);
            } else if (!defaultSsl && pp.getType() == 2) {
                defaultSsl = true;
                pp.setDefault(true);
            }
            result.put(pp.getPort(), (Object)pp);
        }
        return result;
    }

    private String getValue(String data, String key) {
        int i = 0;
        int j = 0;
        while ((i = data.indexOf(key + ":", j)) > -1) {
            if (i == 0 || Character.isWhitespace(data.charAt(i - 1)) || data.charAt(i - 1) == ',') break;
            j += key.length() + 1;
        }
        if (i > -1) {
            j = data.indexOf(44, i += key.length() + 1);
            if (j == -1) {
                j = data.length();
            }
            return data.substring(i, j);
        }
        return null;
    }

    private void setHttpTrace(String value) {
        int oldValue = this.httpTraceInt;
        if (disableHttpTrace.equals(value)) {
            this.httpTraceInt = 0;
            this.frame.logDebug("DEBUG: HttpTrace disabled(" + this.httpTraceInt + "), was (" + oldValue + ").");
        } else if (enableHttpTrace.equals(value)) {
            this.httpTraceInt = 1;
            this.frame.logDebug("DEBUG: HttpTrace enabled(" + this.httpTraceInt + "), was (" + oldValue + ").");
        } else if (enableHeadersHttpTrace.equals(value)) {
            this.httpTraceInt = 2;
            this.frame.logDebug("DEBUG: HttpTrace enabled(" + this.httpTraceInt + ") - headers only, was (" + oldValue + ").");
        } else if (enableHexHttpTrace.equals(value)) {
            this.httpTraceInt = 3;
            this.frame.logDebug("DEBUG: HttpTrace enabled(" + this.httpTraceInt + ") - hex formatting, was (" + oldValue + ").");
        } else if (enableHexHeadersHttpTrace.equals(value)) {
            this.httpTraceInt = 4;
            this.frame.logDebug("DEBUG: HttpTrace enabled(" + this.httpTraceInt + ") - headers only, hex formatting, was (" + oldValue + ").");
        } else {
            this.httpTraceInt = 0;
            this.frame.logError("ERROR: Unknown value \"" + value + "\" for the property \"" + http_trace_key + "\". Assuming value \"" + disableHttpTrace + "\".");
        }
        boolean httpTraceDisabled = this.httpTraceInt == 0;
        this.frame.setLogConfiguratorHttpTraceSeverity(httpTraceDisabled);
    }
}

