/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher;

import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.lib.util.Set;
import com.sap.engine.services.httpserver.DispatcherMonitoring;
import com.sap.engine.services.httpserver.dispatcher.ConnectionInfo;
import com.sap.engine.services.httpserver.dispatcher.ConnectionsHolder;
import java.util.Enumeration;

public class HttpMonitoring
implements DispatcherMonitoring {
    private boolean enabled = false;
    private Object accountingLock = new Object();
    private long cacheTimeoutMillis;
    private long cacheTime = -1L;
    private int currentOpenConnectionsReadingRequest = 0;
    private int currentOpenConnectionsReadingResponse = 0;
    private int currentOpenConnectionsSkippingRequest = 0;
    private int currentOpenConnectionsKeepAlive = 0;
    private long totalConnectionsClosedByClient = 0L;
    private long totalConnectionsClosedByServerConnectionClose = 0L;
    private long totalConnectionsClosedByServerTimeout = 0L;
    private long totalRequests = 0L;
    private long totalRequestResponseTime = 0L;
    private ConnectionsHolder connectionsHolder = null;

    HttpMonitoring(ConnectionsHolder connectionsHolder, long cacheTimeoutMillis) {
        this.connectionsHolder = connectionsHolder;
        this.cacheTimeoutMillis = cacheTimeoutMillis;
        if (cacheTimeoutMillis < 0L) {
            cacheTimeoutMillis = 0L;
        }
        this.resetAllCounters();
    }

    void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            Object object = this.accountingLock;
            synchronized (object) {
                this.resetAllCounters();
            }
        }
        this.enabled = enabled;
    }

    public int getCurrentOpenConnections() {
        Object object = this.accountingLock;
        synchronized (object) {
            if (!this.isFreshCache()) {
                this.refreshCache();
            }
            int n = this.currentOpenConnectionsReadingRequest + this.currentOpenConnectionsReadingResponse + this.currentOpenConnectionsSkippingRequest + this.currentOpenConnectionsKeepAlive;
            return n;
        }
    }

    public int getCurrentOpenConnectionsReadingRequest() {
        Object object = this.accountingLock;
        synchronized (object) {
            if (!this.isFreshCache()) {
                this.refreshCache();
            }
            int n = this.currentOpenConnectionsReadingRequest;
            return n;
        }
    }

    public int getCurrentOpenConnectionsReadingResponse() {
        Object object = this.accountingLock;
        synchronized (object) {
            if (!this.isFreshCache()) {
                this.refreshCache();
            }
            int n = this.currentOpenConnectionsReadingResponse;
            return n;
        }
    }

    public int getCurrentOpenConnectionsSkippingRequest() {
        Object object = this.accountingLock;
        synchronized (object) {
            if (!this.isFreshCache()) {
                this.refreshCache();
            }
            int n = this.currentOpenConnectionsSkippingRequest;
            return n;
        }
    }

    public int getCurrentOpenConnectionsKeepAlive() {
        Object object = this.accountingLock;
        synchronized (object) {
            if (!this.isFreshCache()) {
                this.refreshCache();
            }
            int n = this.currentOpenConnectionsKeepAlive;
            return n;
        }
    }

    public long getTotalConnections() {
        Object object = this.accountingLock;
        synchronized (object) {
            long l = (long)this.getCurrentOpenConnections() + this.totalConnectionsClosedByClient + this.getTotalConnectionsClosedByServer();
            return l;
        }
    }

    public long getTotalConnectionsClosedByClient() {
        Object object = this.accountingLock;
        synchronized (object) {
            long l = this.totalConnectionsClosedByClient;
            return l;
        }
    }

    public long getTotalConnectionsClosedByServer() {
        Object object = this.accountingLock;
        synchronized (object) {
            long l = this.totalConnectionsClosedByServerConnectionClose + this.totalConnectionsClosedByServerTimeout;
            return l;
        }
    }

    public long getTotalConnectionsClosedByServerConnectionClose() {
        Object object = this.accountingLock;
        synchronized (object) {
            long l = this.totalConnectionsClosedByServerConnectionClose;
            return l;
        }
    }

    public long getTotalConnectionsClosedByServerTimeout() {
        Object object = this.accountingLock;
        synchronized (object) {
            long l = this.totalConnectionsClosedByServerTimeout;
            return l;
        }
    }

    public long getTotalRequests() {
        Object object = this.accountingLock;
        synchronized (object) {
            long l = this.totalRequests;
            return l;
        }
    }

    public long getTotalRequestResponseTime() {
        Object object = this.accountingLock;
        synchronized (object) {
            long l = this.totalRequestResponseTime;
            return l;
        }
    }

    public int getTotalRequestsPerTotalConnectionsRatio() {
        Object object = this.accountingLock;
        synchronized (object) {
            long totalConnections = this.getTotalConnections();
            if (this.totalRequests == 0L || totalConnections == 0L) {
                int n = 0;
                return n;
            }
            int n = (int)(this.totalRequests / totalConnections);
            return n;
        }
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    void onConnectionOpen(ConnectionInfo connection) {
        if (this.enabled) {
            connection.markConnectionOpen();
        }
    }

    void onConnectionClose(ConnectionInfo connection) {
        if (connection != null && this.enabled && !connection.isConnectionClosed()) {
            connection.markConnectionClosed();
            Object object = this.accountingLock;
            synchronized (object) {
                if (!connection.getClosed()) {
                    ++this.totalConnectionsClosedByClient;
                } else if (connection.isKeepAlive()) {
                    ++this.totalConnectionsClosedByServerTimeout;
                } else {
                    ++this.totalConnectionsClosedByServerConnectionClose;
                }
            }
        }
    }

    void onRequestBeginCheck(ConnectionInfo connection) {
        if (this.enabled) {
            connection.markRequestBegin();
            if (!connection.isRequestAccounted()) {
                connection.markRequestAccounted();
                Object object = this.accountingLock;
                synchronized (object) {
                    ++this.totalRequests;
                }
            }
        }
    }

    void onRequestEndCheck(ConnectionInfo connection) {
        if (this.enabled) {
            connection.markRequestEnd();
        }
    }

    void onResponseBeginCheck(ConnectionInfo connection) {
        if (this.enabled) {
            connection.markResponseBegin();
        }
    }

    void onResponseEndCheck(ConnectionInfo connection) {
        if (this.enabled) {
            connection.markResponseEnd();
            Object object = this.accountingLock;
            synchronized (object) {
                this.totalRequestResponseTime += connection.getRequestResponseDurationTime();
            }
        }
    }

    private static boolean isReadingRequest(ConnectionInfo connection) {
        return connection.isAfterRequestBegin() && !connection.isAfterRequestEnd() && !connection.isAfterResponseBegin();
    }

    private static boolean isReadingResponse(ConnectionInfo connection) {
        return !connection.isAfterResponseEnd() && (connection.isAfterRequestEnd() || connection.isAfterResponseBegin());
    }

    private static boolean isSkippingRequest(ConnectionInfo connection) {
        return connection.isAfterResponseEnd() && !connection.isAfterRequestEnd();
    }

    private static boolean isWaitingInKeepAlive(ConnectionInfo connection) {
        return connection.isKeepAlive() && connection.isConnectionOpen() && !connection.isConnectionClosed() && !connection.isAfterRequestBegin();
    }

    private boolean isFreshCache() {
        return System.currentTimeMillis() - this.cacheTime < this.cacheTimeoutMillis;
    }

    private void refreshCache() {
        Object object = this.accountingLock;
        synchronized (object) {
            this.resetCacheCounters();
            Set currentOpenConnections = this.connectionsHolder.getAllConnections();
            Enumeration en = currentOpenConnections.elements();
            while (en.hasMoreElements()) {
                Connection clientConnection = (Connection)en.nextElement();
                ConnectionInfo connection = (ConnectionInfo)clientConnection.getPrivateData();
                if (HttpMonitoring.isReadingRequest(connection)) {
                    ++this.currentOpenConnectionsReadingRequest;
                    continue;
                }
                if (HttpMonitoring.isReadingResponse(connection)) {
                    ++this.currentOpenConnectionsReadingResponse;
                    continue;
                }
                if (HttpMonitoring.isWaitingInKeepAlive(connection)) {
                    ++this.currentOpenConnectionsKeepAlive;
                    continue;
                }
                if (!HttpMonitoring.isSkippingRequest(connection)) continue;
                ++this.currentOpenConnectionsSkippingRequest;
            }
        }
        this.cacheTime = System.currentTimeMillis();
    }

    private void resetAllCounters() {
        this.resetCacheCounters();
        this.totalConnectionsClosedByClient = 0L;
        this.totalConnectionsClosedByServerConnectionClose = 0L;
        this.totalConnectionsClosedByServerTimeout = 0L;
        this.totalRequests = 0L;
        this.totalRequestResponseTime = 0L;
    }

    private void resetCacheCounters() {
        this.cacheTime = -1L;
        this.currentOpenConnectionsReadingRequest = 0;
        this.currentOpenConnectionsReadingResponse = 0;
        this.currentOpenConnectionsSkippingRequest = 0;
        this.currentOpenConnectionsKeepAlive = 0;
    }
}

