/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.session.CommunicationSessionProcessor;
import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.util.ConcurrentHashMapIntInt;
import com.sap.engine.lib.util.ConcurrentHashMapIntLong;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.lib.util.ConcurrentSetInt;
import com.sap.engine.services.httpserver.dispatcher.ConnectionsHolder;
import com.sap.engine.services.httpserver.dispatcher.Constants;
import com.sap.engine.services.httpserver.dispatcher.HttpMonitoring;
import com.sap.engine.services.httpserver.dispatcher.HttpProperties;
import com.sap.engine.services.httpserver.dispatcher.PortProperties;
import com.sap.engine.services.httpserver.dispatcher.Processor;
import com.sap.engine.services.httpserver.dispatcher.icm.ExtraLayer;
import com.sap.engine.services.httpserver.dispatcher.icm.ICMExtraLayerV1;
import com.sap.engine.services.httpserver.dispatcher.loadbalance.HttpLoadbalance;
import com.sap.engine.services.httpserver.dispatcher.shellcommands.ListLoadBalancing;
import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import com.sap.engine.services.r3startup.R3Notifier;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;

public class HttpDispatcherFrame
implements Constants,
CommunicationServiceFrame,
ServiceEventListener,
ContainerEventListener,
MessageListener,
ClusterEventListener {
    private static HttpProperties httpProperties = null;
    private CommunicationServiceContext sdc;
    private ShellInterface shell = null;
    public ConcurrentSetInt serversVector = new ConcurrentSetInt();
    private ConcurrentHashMapIntInt servers = new ConcurrentHashMapIntInt();
    private static ConcurrentHashMapObjectObject urlSessionTrackingApps = new ConcurrentHashMapObjectObject();
    private Location location = Location.getLocation((String)"com.sap.engine.services.httpserver.dispatcher");
    private ConcurrentHashMapIntLong invalidateByETag = new ConcurrentHashMapIntLong();
    private R3Notifier r3startup = null;
    private int invalidateTimeout = 60000;
    public static String INSTANCE_NAME = null;
    private int commandId = -1;
    private ConnectionsHolder connectionsHolder = null;
    private Processor httpProcessor = null;
    private HttpMonitoring httpMonitoring = null;
    private HttpLoadbalance loadbalance = null;
    private ConvertTools convert = new ConvertTools(false);
    private static byte[] version = null;
    private boolean startInit;
    private final int ALL_SERVERS = -1;
    private ConcurrentHashMapIntObject openedPorts = new ConcurrentHashMapIntObject();
    private int groupId = -1;
    private ConcurrentSetInt webDispLoadbalanceServers = new ConcurrentSetInt();

    public void start(CommunicationServiceContext sdc) throws ServiceException {
        this.sdc = sdc;
        this.groupId = sdc.getClusterContext().getClusterMonitor().getCurrentParticipant().getGroupId();
        version = sdc.getCoreContext().getCoreMonitor().getCoreMajorVersion().getBytes();
        httpProperties = new HttpProperties(this);
        httpProperties.setProperties(sdc.getServiceState().getProperties());
        ICMExtraLayerV1 layer = new ICMExtraLayerV1();
        layer.setLocation(this.location);
        ExtraLayer[] layers = new ExtraLayer[]{layer};
        this.connectionsHolder = new ConnectionsHolder();
        this.httpMonitoring = new HttpMonitoring(this.connectionsHolder, httpProperties.getHttpMonitoringCacheTimeoutMillis());
        sdc.getServiceState().registerManagementInterface((ManagementInterface)this.httpMonitoring);
        this.httpProcessor = new Processor(httpProperties, this, this.httpMonitoring, layers);
        try {
            sdc.getClusterContext().getCommunicationSessionContext().registerProcessor((CommunicationSessionProcessor)this.httpProcessor);
        }
        catch (ListenerAlreadyRegisteredException e) {
            this.logError("Can't register http service for session processor.", e);
        }
        this.loadbalance = new HttpLoadbalance(sdc.getClusterContext().getLoadbalanceContext(), sdc);
        this.httpProcessor.setLoadBalance(this.loadbalance);
        this.startInit = true;
        this.setProperties(true);
        this.startInit = false;
        sdc.getContainerContext().getObjectRegistry().registerInterface((Object)this);
        String sapstart = SystemProperties.getProperty((String)"SAPSTART");
        if (sapstart != null && sapstart.equals("1")) {
            INSTANCE_NAME = SystemProperties.getProperty((String)"SAPMYNAME");
            if (INSTANCE_NAME != null && INSTANCE_NAME.equalsIgnoreCase("null")) {
                INSTANCE_NAME = null;
            }
        } else {
            int id = sdc.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            INSTANCE_NAME = id != -1 ? "J2EE" + id : null;
        }
        int mask = 84;
        HashSet<String> names = new HashSet<String>(3);
        names.add("shell");
        names.add("ssl");
        names.add("monitor");
        sdc.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        try {
            sdc.getClusterContext().getMessageContext().registerListener((MessageListener)this);
        }
        catch (Exception e) {
            this.logError("Can't register http service for message listener.", e);
        }
        try {
            sdc.getServiceState().registerClusterEventListener((ClusterEventListener)this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            this.logError("Can't register http service for cluster events listener.", e);
        }
        if (sdc.getContainerContext().getSystemMonitor().getService("monitor") != null && sdc.getContainerContext().getSystemMonitor().getService("monitor").getStatus() == 5) {
            this.httpMonitoring.setEnabled(true);
        }
        sdc.getServiceState().registerServiceEventListener((ServiceEventListener)this);
        ClusterElement[] ci = sdc.getClusterContext().getClusterMonitor().getServiceNodes();
        int i = 0;
        while (i < ci.length) {
            this.serviceStarted(ci[i]);
            ++i;
        }
    }

    public MessageContext getMessageContext() {
        return this.sdc.getClusterContext().getMessageContext();
    }

    public static byte[] getVersion() {
        return version;
    }

    public static HttpProperties getHttpProperties() {
        return httpProperties;
    }

    public String getInstanceId() {
        return INSTANCE_NAME;
    }

    public int getMappedServer(int oldServerId) {
        try {
            return this.servers.get(oldServerId);
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    public void putMappedServer(int oldServerId, int newServerId) {
        this.servers.put(oldServerId, newServerId);
    }

    public boolean noServersInCluster() {
        return this.serversVector.size() == 0;
    }

    public void connectionClosed(Connection connection) {
        this.connectionsHolder.connectionClosed(connection);
    }

    public void registerConnection(Connection connection) {
        this.connectionsHolder.registerConnection(connection, connection.getDestinationId());
    }

    private R3Notifier getR3Notifier() {
        if (this.r3startup == null) {
            Object obj = this.sdc.getContainerContext().getObjectRegistry().getServiceInterface("r3startup");
            this.r3startup = (R3Notifier)obj;
        }
        return this.r3startup;
    }

    public static int isUrlSessionTracking(String url, int sepInd) {
        Boolean res = null;
        res = sepInd == -1 ? (Boolean)urlSessionTrackingApps.get((Object)url) : (Boolean)urlSessionTrackingApps.get((Object)url.substring(0, sepInd));
        if (res == null) {
            if (sepInd == -1) {
                return -1;
            }
            int nextSepInd = url.indexOf("/", sepInd + 1);
            if (nextSepInd > -1) {
                return HttpDispatcherFrame.isUrlSessionTracking(url, nextSepInd);
            }
            return HttpDispatcherFrame.isUrlSessionTracking(url, -1);
        }
        if (res.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public synchronized void receive(int clusterId, int msgType, byte[] msg, int off, int length) {
        switch (msgType) {
            case 1: {
                if (this.getR3Notifier() == null) break;
                String alias = new String(msg, off, length);
                try {
                    if (this.invalidateByETag.containsKey(alias.hashCode()) && System.currentTimeMillis() - this.invalidateByETag.get(alias.hashCode()) < (long)this.invalidateTimeout) {
                        return;
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                this.invalidateByETag.put(alias.hashCode(), System.currentTimeMillis());
                this.getR3Notifier().invalidateEtag(alias);
                break;
            }
            case 3: {
                int appNameLen = this.convert.arrToInt(msg, off);
                byte[] appName = new byte[appNameLen];
                System.arraycopy(msg, off += 4, appName, 0, appNameLen);
                int numOfWebs = this.convert.arrToInt(msg, off += appNameLen);
                off += 4;
                byte[][] webs = new byte[numOfWebs][];
                int i = 0;
                while (i < numOfWebs) {
                    int len = this.convert.arrToInt(msg, off);
                    webs[i] = new byte[len];
                    System.arraycopy(msg, off += 4, webs[i], 0, len);
                    off += len;
                    ++i;
                }
                try {
                    this.loadbalance.register(clusterId, appName, webs);
                }
                catch (ParseException e) {
                    this.logError("Error in processing message \"APPLICATION_STARTED\" from server " + clusterId + ".", (Throwable)((Object)e));
                }
                break;
            }
            case 4: {
                byte[] appName = new byte[length];
                System.arraycopy(msg, off, appName, 0, length);
                try {
                    this.loadbalance.unregister(clusterId, appName);
                }
                catch (ParseException e) {
                    this.logError("Error in processing message \"APPLICATION_STOPPED\" from server " + clusterId + ".", (Throwable)((Object)e));
                }
                break;
            }
            case 5: {
                try {
                    this.loadbalance.unregisterServer(clusterId);
                }
                catch (ParseException e) {
                    this.logError("Error in processing message \"ALL_APPLICATIONS_STOPPED\" from server " + clusterId + ".", (Throwable)((Object)e));
                }
                break;
            }
            case 6: {
                if (msg[0] > 0) {
                    this.httpProcessor.setAcceptClientCertNoSSL(true);
                    break;
                }
                this.httpProcessor.setAcceptClientCertNoSSL(false);
                break;
            }
            case 7: {
                int appNameLen = this.convert.arrToInt(msg, off);
                byte[] appName = new byte[appNameLen];
                System.arraycopy(msg, off += 4, appName, 0, appNameLen);
                boolean urlSessionTracking = false;
                if (msg[off += appNameLen] > 0) {
                    urlSessionTracking = true;
                }
                this.loadbalance.urlSessionTracking(appName, urlSessionTracking);
                urlSessionTrackingApps.put((Object)new String(appName), (Object)new Boolean(urlSessionTracking));
                break;
            }
            case 8: {
                ClusterElement el = this.sdc.getClusterContext().getClusterMonitor().getParticipant(clusterId);
                if (el == null || el.getGroupId() != this.groupId) {
                    return;
                }
                if ((el.getModifiers() & 1) != 0) break;
                if (!this.webDispLoadbalanceServers.contains(clusterId)) {
                    this.webDispLoadbalanceServers.add(clusterId);
                }
                this.LogonInfo(this.openedPorts);
                break;
            }
            case 9: {
                byte[] groupSeparator = null;
                if (length > 0) {
                    groupSeparator = new byte[length];
                    System.arraycopy(msg, off, groupSeparator, 0, length);
                }
                this.loadbalance.setZoneSeparator(groupSeparator);
                break;
            }
        }
    }

    public MessageAnswer receiveWait(int clusterId, int msgType, byte[] msg, int off, int length) {
        return null;
    }

    private void setProperties(boolean initial) {
        this.sendProxyMappingsToServer(-1);
        if (initial) {
            this.openSocket(httpProperties.getPorts());
        }
    }

    public void stop() {
        this.loadbalance.unregisterLBListener();
        this.sdc.getClusterContext().getCommunicationSessionContext().unregisterProcessor();
        if (this.shell != null) {
            this.shell.unregisterCommands(this.commandId);
        }
        if (!this.startInit) {
            this.sdc.getClusterContext().getMessageContext().unregisterListener();
            this.sdc.getServiceState().unregisterServiceEventListener();
            this.sdc.getServiceState().unregisterContainerEventListener();
            this.sdc.getContainerContext().getObjectRegistry().unregisterInterface();
            this.closeSocket(this.openedPorts);
        }
    }

    public void serviceStarted(ClusterElement newElement) {
        this.serverNodeInitialized(newElement.getClusterId());
    }

    public void serviceStopped(ClusterElement oldElement) {
        if (oldElement.getType() == 2) {
            this.connectionsHolder.clear(oldElement.getClusterId());
            try {
                this.loadbalance.unregisterServer(oldElement.getClusterId());
            }
            catch (ParseException e) {
                this.logError("Error in notifying http loadbalancing that the http service is not available on server " + oldElement.getClusterId() + ".", (Throwable)((Object)e));
            }
        }
        int tempId = -1;
        try {
            tempId = this.servers.get(oldElement.getClusterId());
        }
        catch (NoSuchElementException e) {
            tempId = -1;
        }
        this.webDispLoadbalanceServers.remove(oldElement.getClusterId());
        this.serversVector.remove(oldElement.getClusterId());
        if (tempId != -1) {
            int newId = this.loadbalance.getLeastBusyServerId();
            if (newId == -1) {
                this.servers.clear();
            } else {
                this.servers.put(oldElement.getClusterId(), newId);
                int[] keys = this.servers.getAllKeys();
                int i = 0;
                while (i < keys.length) {
                    try {
                        if (this.servers.get(keys[i]) == oldElement.getClusterId()) {
                            this.servers.put(keys[i], this.loadbalance.getLeastBusyServerId());
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        Object[] p = this.openedPorts.getAllValues();
        int i = 0;
        while (i < p.length) {
            this.putLogonInfo((PortProperties)p[i], this.webDispLoadbalanceServers.size());
            ++i;
        }
    }

    private void serverNodeInitialized(int clusterId) {
        ClusterElement ce = this.sdc.getClusterContext().getClusterMonitor().getParticipant(clusterId);
        if (ce == null) {
            return;
        }
        this.connectionsHolder.alementJoin(clusterId);
        if (this.groupId == ce.getGroupId() && ce.getState() != 7) {
            if (this.serversVector.contains(clusterId)) {
                return;
            }
            this.servers.put(clusterId, clusterId);
            this.serversVector.add(clusterId);
        }
        this.sendProxyMappingsToServer(clusterId);
    }

    private void setCommands(ShellInterface shellInterface) {
        this.shell = shellInterface;
        Command[] cmds = new Command[]{new ListLoadBalancing(this.loadbalance)};
        this.commandId = shellInterface.registerCommands(cmds);
    }

    public void logDebug(String msg) {
        this.location.debugT(msg);
    }

    public void log(String msg) {
        this.location.infoT(msg);
    }

    public void logWarning(String msg) {
        this.location.warningT(msg);
    }

    public void logWarning(String msg, Throwable ex) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(ostr));
        this.location.warningT(msg + "\r\n" + ostr);
    }

    public void logError(String msg) {
        this.location.errorT(msg);
    }

    public void logError(String msg, Throwable ex) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(ostr));
        this.location.errorT(msg + "\r\n" + ostr);
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if (serviceName.equals("ssl")) {
            if (this.openedPorts.size() != httpProperties.getPorts().size()) {
                this.openSocket(this.getSslPorts());
            }
        } else if (serviceName.equals("monitor")) {
            this.httpMonitoring.setEnabled(true);
        }
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
        if (serviceName.equals("ssl")) {
            this.closeSocket(this.getSslPorts());
        } else if (serviceName.equals("monitor")) {
            this.httpMonitoring.setEnabled(false);
        }
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.setCommands((ShellInterface)interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void markForShutdown(long timeout) {
    }

    public boolean setServiceProperty(String key, String value) {
        ConcurrentHashMapIntObject oldPorts = (ConcurrentHashMapIntObject)httpProperties.getPorts().clone();
        httpProperties.setProperty(key, value);
        this.initChangedPorts(oldPorts, (ConcurrentHashMapIntObject)httpProperties.getPorts().clone());
        this.setProperties(false);
        return true;
    }

    public boolean setServiceProperties(Properties properties) {
        ConcurrentHashMapIntObject oldPorts = (ConcurrentHashMapIntObject)httpProperties.getPorts().clone();
        httpProperties.setProperties(properties);
        this.initChangedPorts(oldPorts, (ConcurrentHashMapIntObject)httpProperties.getPorts().clone());
        this.setProperties(false);
        return true;
    }

    public void containerStarted() {
    }

    public void elementJoin(ClusterElement element) {
    }

    public void elementLoss(ClusterElement element) {
        if (element.getType() != 2) {
            return;
        }
        try {
            this.webDispLoadbalanceServers.remove(element.getClusterId());
            Object[] p = this.openedPorts.getAllValues();
            int i = 0;
            while (i < p.length) {
                this.putLogonInfo((PortProperties)p[i], this.webDispLoadbalanceServers.size());
                ++i;
            }
        }
        catch (Exception e) {
            this.logError("Cannot update load balancing info on message server after server element [" + element.getClusterId() + "] lost.", e);
        }
        this.loadbalance.elementLoss(element);
        this.connectionsHolder.clear(element.getClusterId());
        try {
            this.loadbalance.unregisterServer(element.getClusterId());
        }
        catch (ParseException e) {
            this.logError("Error in notifying http loadbalancing that the http service is not available on server " + element.getClusterId() + ".", (Throwable)((Object)e));
        }
        int tempId = -1;
        try {
            tempId = this.servers.get(element.getClusterId());
        }
        catch (NoSuchElementException e) {
            tempId = -1;
        }
        this.serversVector.remove(element.getClusterId());
        if (tempId != -1) {
            int newId = this.loadbalance.getLeastBusyServerId();
            if (newId == -1) {
                this.servers.clear();
            } else {
                this.servers.put(element.getClusterId(), newId);
                int[] keys = this.servers.getAllKeys();
                int i = 0;
                while (i < keys.length) {
                    try {
                        if (this.servers.get(keys[i]) == element.getClusterId()) {
                            this.servers.put(keys[i], this.loadbalance.getLeastBusyServerId());
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
        this.loadbalance.elementStateChanged(element, oldState);
        if (element.getState() == 7) {
            this.serversVector.remove(element.getClusterId());
        } else if (element.getState() == 5) {
            this.elementLoss(element);
        }
    }

    public void beginContainerStop() {
    }

    /*
     * Unable to fully structure code
     */
    private void openSocket(ConcurrentHashMapIntObject portsToOpen) {
        flag = this.openedPorts.size();
        if (this.openedPorts == portsToOpen) {
            portsToOpen = (ConcurrentHashMapIntObject)portsToOpen.clone();
        }
        ep = portsToOpen.elements();
        p = null;
        sslState = -1;
        try {
            sslState = this.sdc.getContainerContext().getSystemMonitor().getService("ssl").getStatus();
            ** GOTO lbl16
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.logError("Can't get a Runtime Monitor of service ssl.", e);
lbl16:
            // 5 sources

            ** while (ep.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            p = (PortProperties)ep.nextElement();
            if (p.getType() == 2 && sslState != 5) continue;
            try {
                if (p.getBindAddress() == null || p.getBindAddress().equals("")) {
                    this.sdc.getClusterContext().getCommunicationSessionContext().openServerSocket(p.getPort(), p.getType() == 2 ? "ssl" : "", p.getSocketQueue(), p.getAcceptingThreadsCount());
                } else {
                    this.sdc.getClusterContext().getCommunicationSessionContext().openServerSocket(p.getBindAddress(), p.getPort(), p.getType() == 2 ? "ssl" : "", p.getSocketQueue(), p.getAcceptingThreadsCount());
                }
                this.openedPorts.put(p.getPort(), (Object)p);
                this.log(p.getType() == 2 ? "SSL" : "HTTP server socket opened on " + p.getPort());
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logError("Can't open " + (p.getType() == 2 ? "SSL" : "HTTP") + " server socket on " + p.getPort() + ".", e);
            }
            continue;
        }
lbl37:
        // 1 sources

        if (flag != this.openedPorts.size()) {
            this.LogonInfo(this.openedPorts);
        }
    }

    private void closeSocket(ConcurrentHashMapIntObject portsToClose) {
        int flag = this.openedPorts.size();
        if (this.openedPorts == portsToClose) {
            portsToClose = (ConcurrentHashMapIntObject)portsToClose.clone();
        }
        Enumeration ep = portsToClose.elements();
        PortProperties p = null;
        while (ep.hasMoreElements()) {
            p = (PortProperties)ep.nextElement();
            if (!this.openedPorts.containsKey(p.getPort())) continue;
            this.openedPorts.remove(p.getPort());
            try {
                this.sdc.getClusterContext().getCommunicationSessionContext().closeServerSocket(p.getPort());
                this.log(p.getType() == 2 ? "SSL" : "HTTP server socket closed on " + p.getPort() + ".");
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logError("Can't close " + (p.getType() == 2 ? "SSL" : "HTTP") + " server socket on " + p.getPort() + ".", e);
            }
            this.sdc.getClusterContext().getCommunicationSessionContext().closeClientConnections(p.getPort());
            this.putLogonInfo(p, 0);
        }
        if (flag != this.openedPorts.size()) {
            this.LogonInfo(this.openedPorts);
        }
    }

    private ConcurrentHashMapIntObject getSslPorts() {
        ConcurrentHashMapIntObject sslPorts = new ConcurrentHashMapIntObject();
        Enumeration ep = httpProperties.getPorts().elements();
        PortProperties p = null;
        while (ep.hasMoreElements()) {
            p = (PortProperties)ep.nextElement();
            if (p.getType() != 2) continue;
            sslPorts.put(p.getPort(), (Object)p);
        }
        return sslPorts;
    }

    private void initChangedPorts(ConcurrentHashMapIntObject oldPorts, ConcurrentHashMapIntObject newPorts) {
        ConcurrentHashMapIntObject portsToOpen = new ConcurrentHashMapIntObject();
        ConcurrentHashMapIntObject portsToClose = new ConcurrentHashMapIntObject();
        int[] oldPort = oldPorts.getAllKeys();
        int[] newPort = newPorts.getAllKeys();
        int i = 0;
        while (i < oldPort.length) {
            if (newPorts.containsKey(oldPort[i])) {
                if (!((PortProperties)newPorts.get(oldPort[i])).equals((PortProperties)oldPorts.get(oldPort[i]))) {
                    portsToClose.put(oldPort[i], oldPorts.get(oldPort[i]));
                    portsToOpen.put(oldPort[i], oldPorts.get(oldPort[i]));
                }
            } else {
                portsToClose.put(oldPort[i], oldPorts.get(oldPort[i]));
            }
            ++i;
        }
        i = 0;
        while (i < newPort.length) {
            if (!oldPorts.containsKey(newPort[i])) {
                portsToOpen.put(newPort[i], newPorts.get(newPort[i]));
            }
            ++i;
        }
        this.closeSocket(portsToClose);
        this.openSocket(portsToOpen);
        this.LogonInfo(this.openedPorts);
    }

    private void putLogonInfo(PortProperties p, int serversCount) {
        if (p.isDefault()) {
            try {
                if (p.getType() == 2) {
                    this.sdc.getClusterContext().getCommunicationSessionContext().putLogonInfo(2, p.getPort(), serversCount);
                } else {
                    this.sdc.getClusterContext().getCommunicationSessionContext().putLogonInfo(1, p.getPort(), serversCount);
                }
            }
            catch (ClusterException e) {
                this.logError("Cannot update http logon information for the message server.", e);
            }
        }
    }

    private void LogonInfo(ConcurrentHashMapIntObject portsToSend) {
        Object[] p = null;
        if (!portsToSend.isEmpty()) {
            p = portsToSend.getAllValues();
            int i = 0;
            while (i < p.length) {
                this.putLogonInfo((PortProperties)p[i], this.webDispLoadbalanceServers.size());
                ++i;
            }
        }
    }

    private void sendProxyMappingsToServer(int serverId) {
        byte[] msg = this.getProxyMappings().getBytes();
        try {
            if (serverId == -1) {
                this.sdc.getClusterContext().getMessageContext().send(-1, (byte)2, 512, msg, 0, msg.length);
            } else {
                ClusterElement clusterElement = this.sdc.getClusterContext().getClusterMonitor().getParticipant(serverId);
                if (clusterElement == null || clusterElement.getState() == 7) {
                    return;
                }
                this.sdc.getClusterContext().getMessageContext().send(serverId, 512, msg, 0, msg.length);
            }
        }
        catch (ClusterException e) {
            this.logError("Can't send ProxyMappings to server.", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getProxyMappings() {
        String port;
        String proxyMappings = httpProperties.getProxyMappings();
        Object[] p = httpProperties.getPorts().getAllValues();
        int i = 0;
        while (i < p.length) {
            int k;
            port = ((PortProperties)p[i]).getPort() + "";
            int j = 0;
            while ((k = proxyMappings.indexOf(port + "=", j)) > -1) {
                void var3_5;
                if (var3_5 == false || Character.isWhitespace(proxyMappings.charAt((int)(var3_5 - true))) || proxyMappings.charAt((int)(var3_5 - true)) == ',') break;
                j += proxyMappings.length() + 1;
            }
            if (k == -1) {
                port = port + "=(Host:" + this.sdc.getClusterContext().getClusterMonitor().getCurrentParticipant().getAddress().getHostName() + ",Port:" + port + ",Scheme:" + (((PortProperties)p[i]).getType() == 2 ? "https" : "http") + ")";
                proxyMappings = proxyMappings.length() > 0 ? proxyMappings + "," + port : proxyMappings + port;
            }
            ++i;
        }
        i = 0;
        while (i < p.length) {
            port = String.valueOf(((PortProperties)p[i]).getPort());
            port = port + "=(Host:" + this.sdc.getClusterContext().getClusterMonitor().getCurrentParticipant().getAddress().getHostName() + ",Port:" + port + ",Scheme:" + (((PortProperties)p[i]).getType() == 2 ? "https" : "http") + ",Override:default)";
            proxyMappings = proxyMappings.length() > 0 ? proxyMappings + "," + port : proxyMappings + port;
            ++i;
        }
        return proxyMappings;
    }

    void setLogConfiguratorHttpTraceSeverity(boolean disabled) {
        try {
            Object si = this.sdc.getContainerContext().getObjectRegistry().getServiceInterface("log_configurator");
            LogConfiguratorManagementInterface logConfigurator = (LogConfiguratorManagementInterface)si;
            LogConfiguration lc = new LogConfiguration();
            LogControllerDescriptor lcd = new LogControllerDescriptor();
            lcd.setName("com.sap.engine.services.httpserver.dispatcher.Processor");
            lcd.setEffectiveSeverity(disabled ? 500 : 0);
            lc.addLogController(lcd);
            logConfigurator.applyAndStoreConfiguration(lc);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.logError("Error while changing trace severity level for HttpTrace.", e);
        }
    }
}

