/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher;

import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.lib.util.ConcurrentReadHashMapIntObj;
import com.sap.engine.lib.util.ConcurrentSet;
import com.sap.engine.lib.util.Set;
import java.util.Enumeration;

public class ConnectionsHolder {
    private ConcurrentReadHashMapIntObj serverToConnections = new ConcurrentReadHashMapIntObj();
    private ConcurrentSet noServerConnections = null;

    ConnectionsHolder() {
        this.alementJoin(-1);
        this.noServerConnections = (ConcurrentSet)this.serverToConnections.get(-1);
    }

    public Set getAllConnections() {
        Set res = new Set();
        Enumeration en = this.serverToConnections.elements();
        while (en.hasMoreElements()) {
            ConcurrentSet serverConnections = (ConcurrentSet)en.nextElement();
            if (serverConnections == null) continue;
            res.addAll(serverConnections.toArray());
        }
        return res;
    }

    public void registerConnection(Connection cc, int serverId) {
        ConcurrentSet connections = (ConcurrentSet)this.serverToConnections.get(serverId);
        if (connections != null) {
            if (serverId != -1) {
                while (this.noServerConnections.remove((Object)cc)) {
                }
            }
            if (!connections.contains((Object)cc)) {
                connections.add((Object)cc);
            }
        }
    }

    public void connectionClosed(Connection cc) {
        Enumeration en = this.serverToConnections.elements();
        while (en.hasMoreElements()) {
            ConcurrentSet next = (ConcurrentSet)en.nextElement();
            while (next.remove((Object)cc)) {
            }
        }
    }

    public void alementJoin(int serverId) {
        this.serverToConnections.put(serverId, (Object)new ConcurrentSet());
    }

    public void clear(int serverId) {
        ConcurrentSet toClose = (ConcurrentSet)this.serverToConnections.get(serverId);
        if (toClose != null) {
            Object[] en = toClose.toArray();
            int i = 0;
            while (i < en.length) {
                ((Connection)en[i]).closeConnection();
                ++i;
            }
        }
    }
}

