/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher;

import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.services.httpserver.dispatcher.HttpDispatcherFrame;
import com.sap.engine.services.httpserver.dispatcher.HttpProperties;
import com.sap.engine.services.httpserver.exceptions.HttpIOException;
import java.io.IOException;

public class ConnectionInfo {
    private static final long UNSET_VALUE_LONG = -1L;
    private static final int TIME_OUT = 60000;
    protected static final byte[] EMPTY_CERT = new byte[]{0, 0, 0, 0};
    protected Object ldtRequestSynchObject = new Object();
    private HttpProperties httpProperties = null;
    private boolean doingBody = false;
    private byte[] inetaddress = null;
    private boolean closed = false;
    private byte[] guid = null;
    private byte[] errorMessage = null;
    private int offset = -1;
    private int extraLayerCode = -1;
    private boolean waiting = false;
    private Connection cc = null;
    private byte[] originalRequest = null;
    private int traceLevel = -1;
    private boolean protocolFound = true;
    private long totalPutLength = 0L;
    private long currentPutLength = 0L;
    private boolean doingRequest = false;
    private boolean clear = true;
    private boolean responseDone = false;
    private byte[] certFromICM = null;
    private int icmBlockLength = -1;
    private boolean isSSL = false;
    private boolean isChunkedFinished = false;
    private byte[] buffer = null;
    private int chunkBytesWaiting = -1;
    private byte[] nextRequest = null;
    private byte[] port = new byte[2];
    private byte[] isICM = new byte[]{-1};
    private long chunkedRequestBodyRead = 0L;
    private int nextRequestOffset = -1;
    private boolean headerPassed = false;
    private long responseTime = -1L;
    private boolean internalRequest = false;
    private boolean connectionOpen = false;
    private boolean connectionClosed = false;
    private boolean keepAlive = false;
    private boolean requestAccounted = false;
    private long requestBeginTime = -1L;
    private boolean requestEnd = false;
    private boolean responseBegin = false;
    private long responseEndTime = -1L;

    public ConnectionInfo() {
        this.httpProperties = HttpDispatcherFrame.getHttpProperties();
    }

    public void startRequest() {
        this.clear = false;
        this.doingRequest = true;
    }

    public void endRequest() {
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            if (this.cc == null) {
                return;
            }
            this.doingRequest = false;
            if (this.responseDone) {
                this.clear();
                this.notifyAll();
            } else {
                this.cc.stopClientRequestReader();
            }
        }
    }

    public boolean isDoingRequest() {
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            boolean bl = this.doingRequest;
            return bl;
        }
    }

    public boolean joinRequest() throws IOException {
        if (this.clear) {
            return false;
        }
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            if (this.doingRequest) {
                boolean bl = true;
                return bl;
            }
            long startTime = System.currentTimeMillis();
            long delta = 0L;
            while (!this.clear && delta < 60000L) {
                try {
                    this.wait(60000L);
                }
                catch (Exception t) {
                    throw new HttpIOException("http_0067", new Object[]{"60000"});
                }
                delta = System.currentTimeMillis() - startTime;
            }
        }
        return false;
    }

    public boolean skipRequestBody() {
        return this.doingRequest && this.responseDone;
    }

    public void endResponse(boolean startRead) {
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            if (this.cc == null) {
                return;
            }
            this.responseDone = true;
            if (!this.doingRequest) {
                this.clear();
                this.notifyAll();
            }
            if (startRead) {
                this.cc.startClientRequestReader();
            }
        }
    }

    public void setDoingBody(boolean doingBody) {
        this.doingBody = doingBody;
    }

    public boolean getDoingBody() {
        return this.doingBody;
    }

    public void setInetaddress(byte[] inetaddress) {
        this.inetaddress = inetaddress;
    }

    public byte[] getInetaddress() {
        return this.inetaddress;
    }

    public void setClosed() {
        this.closed = true;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public void setConnectionGuid(byte[] guid) {
        this.guid = guid;
    }

    public byte[] getConnectionGuid() {
        return this.guid;
    }

    public void setErrorMessage(byte[] errorMessage) {
        this.errorMessage = errorMessage;
    }

    public byte[] getErrorMessage() {
        return this.errorMessage;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLength(int len) {
        this.icmBlockLength = len;
    }

    public int getLength() {
        return this.icmBlockLength;
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    public boolean getWaiting() {
        return this.waiting;
    }

    public void setProtocol(boolean protocolFound) {
        this.protocolFound = protocolFound;
    }

    public boolean getProtocol() {
        return this.protocolFound;
    }

    public void setExtraLayerCode(int extraLayerCode) {
        this.extraLayerCode = extraLayerCode;
    }

    public int getExtraLayerCode() {
        return this.extraLayerCode;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public void setConnection(Connection cc) {
        this.cc = cc;
    }

    public void setOriginalRequest(byte[] originalRequest) {
        this.originalRequest = originalRequest;
    }

    public byte[] getOriginalRequest() {
        return this.originalRequest;
    }

    boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean towait) {
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            this.keepAlive = towait;
            if (towait) {
                if (this.closed) {
                    return;
                }
                if (this.httpProperties.getKeepaliveTimeout() > 0L) {
                    this.cc.markForClose((int)this.httpProperties.getKeepaliveTimeout());
                }
            } else {
                this.cc.markForClose(-1);
            }
        }
    }

    public void setCurrentPutLength(long currentPutLength) {
        this.currentPutLength = currentPutLength;
        if (this.totalPutLength == currentPutLength) {
            this.doingRequest = false;
        }
    }

    public long getCurrentPutLength() {
        return this.currentPutLength;
    }

    public void setTotalPutLength(long totalPutLength) {
        this.totalPutLength = totalPutLength;
    }

    public long getTotalPutLength() {
        return this.totalPutLength;
    }

    public void setCertFromICM(byte[] cert) {
        this.certFromICM = cert;
    }

    public byte[] getCertFromICM() {
        return this.certFromICM;
    }

    public void setSSL(boolean flag) {
        this.isSSL = flag;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setChunkedFinished(boolean chunked) {
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            if (!this.clear) {
                this.isChunkedFinished = chunked;
            }
        }
    }

    public boolean isChunkedFinished() {
        return this.isChunkedFinished;
    }

    public void setBuffer(byte[] buff, int off, int len) {
        this.buffer = new byte[len];
        System.arraycopy(buff, off, this.buffer, 0, len);
    }

    public void clearBuffer() {
        this.buffer = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setChunkBytesWaiting(int chunkBytesWaiting) {
        this.chunkBytesWaiting = chunkBytesWaiting;
    }

    public int getChunkBytesWaiting() {
        return this.chunkBytesWaiting;
    }

    public void setNextRequest(byte[] nextRequest) {
        this.nextRequest = nextRequest;
    }

    public byte[] getNextRequest() {
        return this.nextRequest;
    }

    public boolean isClear() {
        return this.clear;
    }

    public void setPort(int portInt) {
        this.port[0] = (byte)(portInt & 0xFF);
        this.port[1] = (byte)(portInt >> 8 & 0xFF);
    }

    public byte[] getPort() {
        return this.port;
    }

    public void setICM(byte icm) {
        this.isICM[0] = icm;
    }

    public byte[] getICM() {
        return this.isICM;
    }

    public void chenkedBodyRead(long read) {
        this.chunkedRequestBodyRead += read;
    }

    public long getChunkedRequestBodyRead() {
        return this.chunkedRequestBodyRead;
    }

    public int getNextRequestOffset() {
        return this.nextRequestOffset;
    }

    public void setNextRequestOffset(int offset) {
        this.nextRequestOffset = offset;
    }

    public void setHeaderPassed(boolean headerPassed) {
        this.headerPassed = headerPassed;
    }

    public boolean isHeaderPassed() {
        return this.headerPassed;
    }

    public void startResponseTimer() {
        if (this.responseTime == -1L) {
            this.responseTime = System.currentTimeMillis();
        }
    }

    public long stopResponseTimer() {
        return System.currentTimeMillis() - this.responseTime;
    }

    public void setInternalRequest(boolean internalRequest) {
        this.internalRequest = internalRequest;
    }

    public boolean isInternalRequest() {
        return this.internalRequest;
    }

    public boolean isRequestAccounted() {
        return this.requestAccounted;
    }

    public void markRequestAccounted() {
        this.requestAccounted = true;
    }

    void markConnectionOpen() {
        this.connectionOpen = true;
    }

    boolean isConnectionOpen() {
        return this.connectionOpen;
    }

    void markConnectionClosed() {
        this.connectionClosed = true;
        this.markConnectionOpen();
    }

    boolean isConnectionClosed() {
        return this.connectionClosed;
    }

    long getRequestBeginTime() {
        return this.requestBeginTime;
    }

    void markRequestBegin() {
        if (this.requestBeginTime == -1L) {
            this.requestBeginTime = System.currentTimeMillis();
            this.markConnectionOpen();
        }
    }

    boolean isAfterRequestBegin() {
        return this.requestBeginTime != -1L;
    }

    void markRequestEnd() {
        this.requestEnd = true;
        this.markRequestBegin();
    }

    boolean isAfterRequestEnd() {
        return this.requestEnd;
    }

    void markResponseBegin() {
        this.responseBegin = true;
        this.markRequestBegin();
    }

    boolean isAfterResponseBegin() {
        return this.responseBegin;
    }

    long getResponseEndTime() {
        return this.responseEndTime;
    }

    void markResponseEnd() {
        if (this.responseEndTime == -1L) {
            this.responseEndTime = System.currentTimeMillis();
            this.markResponseBegin();
        }
    }

    boolean isAfterResponseEnd() {
        return this.responseEndTime != -1L;
    }

    long getRequestResponseDurationTime() {
        if (!this.isAfterRequestBegin() || !this.isAfterResponseEnd()) {
            return 0L;
        }
        return this.responseEndTime - this.requestBeginTime;
    }

    public synchronized void reset() {
        this.cc = null;
        this.inetaddress = null;
        this.certFromICM = null;
        this.port[0] = 0;
        this.port[1] = 0;
        this.connectionOpen = false;
        this.connectionClosed = false;
        this.keepAlive = false;
        this.clear();
        this.notifyAll();
    }

    public synchronized void clear() {
        this.closed = false;
        this.guid = null;
        this.errorMessage = null;
        this.offset = -1;
        this.extraLayerCode = -1;
        this.waiting = false;
        this.originalRequest = null;
        this.traceLevel = -1;
        this.protocolFound = true;
        this.totalPutLength = 0L;
        this.currentPutLength = 0L;
        this.doingBody = false;
        this.doingRequest = false;
        this.clear = true;
        this.responseDone = false;
        this.isSSL = false;
        this.icmBlockLength = -1;
        this.isChunkedFinished = false;
        this.buffer = null;
        this.chunkBytesWaiting = -1;
        this.nextRequest = null;
        this.isICM[0] = -1;
        this.nextRequestOffset = -1;
        this.chunkedRequestBodyRead = 0L;
        this.headerPassed = false;
        this.responseTime = -1L;
        this.internalRequest = false;
        this.requestAccounted = false;
        this.requestBeginTime = -1L;
        this.requestEnd = false;
        this.responseBegin = false;
        this.responseEndTime = -1L;
    }
}

