/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.semiauto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.GRectangle;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Rectangle;

final class VerticesLayouter {
    private Optioner myOptioner;
    private LinesManager myLinesManager;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;

    public VerticesLayouter(Optioner optioner, LinesManager linesManager) {
        this.myOptioner = optioner;
        this.myLinesManager = linesManager;
    }

    public void doLayout(Vertex[] vertices, Edge[] edges) {
        Vertex v;
        this.myVertices = vertices;
        this.myEdges = edges;
        int count = 0;
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v2 = this.myVertices[i_Vertex];
            if (v2.isSelected() && v2.getContainingNode() == null) {
                ++count;
            }
            ++i_Vertex;
        }
        if (count == 0) {
            return;
        }
        Vertex[] selected = new Vertex[count];
        int index = 0;
        int i_Vertex2 = 0;
        while (i_Vertex2 < this.myVertices.length) {
            Vertex v3 = this.myVertices[i_Vertex2];
            if (v3.isSelected() && v3.getContainingNode() == null) {
                selected[index++] = v3;
            }
            ++i_Vertex2;
        }
        int i = 0;
        while (i < selected.length) {
            int j = i + 1;
            while (j < selected.length) {
                Vertex v2 = selected[j];
                Vertex v1 = selected[i];
                if (this.earlierThan(v2, v1)) {
                    selected[i] = v2;
                    selected[j] = v1;
                }
                ++j;
            }
            v = selected[i];
            int oldX = v.getX();
            int oldY = v.getY();
            this.layout(v);
            v.process();
            int dx = v.getX() - oldX;
            int dy = v.getY() - oldY;
            int i_Vertex3 = 0;
            while (i_Vertex3 < this.myVertices.length) {
                Vertex v1 = this.myVertices[i_Vertex3];
                if (v1.getContainingNode() == v) {
                    v1.shift(dx, dy);
                }
                ++i_Vertex3;
            }
            ++i;
        }
        int i_Vertex4 = 0;
        while (i_Vertex4 < this.myVertices.length) {
            v = this.myVertices[i_Vertex4];
            if (v.getContainingNode() != null) {
                this.myLinesManager.add(v);
                v.process();
            }
            ++i_Vertex4;
        }
    }

    private boolean earlierThan(Vertex v1, Vertex v2) {
        int nLinks1 = v1.myLinks.length;
        int nLinks2 = v2.myLinks.length;
        if (nLinks1 == 0) {
            return false;
        }
        if (nLinks2 == 0) {
            return true;
        }
        Link[] links1 = v1.myLinks;
        int nNotProcessedLinks1 = 0;
        int i_Link = 0;
        while (i_Link < links1.length) {
            if (!links1[i_Link].myVertex.isProcessed()) {
                ++nNotProcessedLinks1;
            }
            ++i_Link;
        }
        Link[] links2 = v2.myLinks;
        int nNotProcessedLinks2 = 0;
        int i_Link2 = 0;
        while (i_Link2 < links2.length) {
            if (!links2[i_Link2].myVertex.isProcessed()) {
                ++nNotProcessedLinks2;
            }
            ++i_Link2;
        }
        if (nNotProcessedLinks1 > nNotProcessedLinks2) {
            return true;
        }
        if (nNotProcessedLinks2 > nNotProcessedLinks1) {
            return false;
        }
        return nLinks1 > nLinks2;
    }

    private void layout(Vertex v) {
        int centerX = this.myOptioner.userFocusX;
        int centerY = this.myOptioner.userFocusY;
        int step = this.myOptioner.semiautoNodeLayoutStep;
        int border = this.myOptioner.semiautoNodeLayoutMinLinkedDistance;
        Link[] links = v.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            links[i_Link].myVertex.tempFlag = false;
            ++i_Link;
        }
        int i_Link2 = 0;
        while (i_Link2 < links.length) {
            Vertex v1 = links[i_Link2].myVertex;
            if (v1.isProcessed() && !v1.tempFlag) {
                Rectangle badRect = new Rectangle(v1.getLeft() - border, v1.getTop() - border, v1.getWidth() + 2 * border, v1.getHeight() + 2 * border, v1);
                this.myLinesManager.add(badRect);
                v1.tempFlag = true;
            }
            ++i_Link2;
        }
        int maxDist = Integer.MAX_VALUE;
        int bestValue = Integer.MAX_VALUE;
        int bestDist = 0;
        int dist = 0;
        while (dist < maxDist) {
            int value = this.layout(v, centerX, centerY, dist);
            if (value != Integer.MAX_VALUE) {
                if (maxDist == Integer.MAX_VALUE) {
                    maxDist = dist + step * 10;
                }
                if (value < bestValue) {
                    bestValue = value;
                    bestDist = dist;
                }
            }
            dist += step;
        }
        this.layout(v, centerX, centerY, bestDist);
        this.myLinesManager.add(v);
        int i_Link3 = 0;
        while (i_Link3 < links.length) {
            Vertex v1 = links[i_Link3].myVertex;
            if (v1.isProcessed() && v1.tempFlag) {
                Rectangle badRect = new Rectangle(v1.getLeft() - border, v1.getTop() - border, v1.getWidth() + 2 * border, v1.getHeight() + 2 * border, v1);
                this.myLinesManager.remove(badRect);
                v1.tempFlag = false;
            }
            ++i_Link3;
        }
    }

    private int layout(Vertex v, int centerX, int centerY, int dist) {
        int value;
        int step = this.myOptioner.semiautoNodeLayoutStep;
        int bestX = 0;
        int bestY = 0;
        int bestValue = Integer.MAX_VALUE;
        int y = centerY - dist;
        int x = centerX - dist;
        while (x <= centerX + dist) {
            value = this.place(v, x, y);
            if (value == 0) {
                return 0;
            }
            if (bestValue > value) {
                bestValue = value;
                bestX = x;
                bestY = y;
            }
            x += step;
        }
        y = centerY + dist;
        x = centerX - dist;
        while (x <= centerX + dist) {
            value = this.place(v, x, y);
            if (value == 0) {
                return 0;
            }
            if (bestValue > value) {
                bestValue = value;
                bestX = x;
                bestY = y;
            }
            x += step;
        }
        x = centerX - dist;
        y = centerY - dist;
        while (y <= centerY + dist) {
            value = this.place(v, x, y);
            if (value == 0) {
                return 0;
            }
            if (bestValue > value) {
                bestValue = value;
                bestX = x;
                bestY = y;
            }
            y += step;
        }
        x = centerX + dist;
        y = centerY - dist;
        while (y <= centerY + dist) {
            value = this.place(v, x, y);
            if (value == 0) {
                return 0;
            }
            if (bestValue > value) {
                bestValue = value;
                bestX = x;
                bestY = y;
            }
            y += step;
        }
        if (bestValue != Integer.MAX_VALUE) {
            this.place(v, bestX, bestY);
        }
        return bestValue;
    }

    private int place(Vertex v, int x, int y) {
        int left = x - v.getWidth() / 2;
        if (left < 0) {
            return Integer.MAX_VALUE;
        }
        int top = y - v.getWidth() / 2;
        if (top < 0) {
            return Integer.MAX_VALUE;
        }
        v.setX(left);
        v.setY(top);
        if (!this.myLinesManager.isCorrect(v)) {
            Element reason = this.myLinesManager.getReason();
            if (reason instanceof Rectangle) {
                return Integer.MAX_VALUE;
            }
            if (reason instanceof Line) {
                return 100;
            }
            if (reason instanceof GRectangle) {
                return 50;
            }
        }
        return 0;
    }
}

