/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.semiauto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.semiauto.LinksLayouter;
import com.tssap.selena.layout.impl.semiauto.OrthogonalLinksLayouter;
import com.tssap.selena.layout.impl.semiauto.Straightener;

final class StraightLinksLayouter
extends LinksLayouter {
    private Straightener myStraightener;
    private OrthogonalLinksLayouter myOrthogonalLinksLayouter;

    public StraightLinksLayouter(Optioner optioner, LinesManager linesManager, boolean transponate) {
        super(optioner, linesManager, transponate);
        this.myStraightener = new Straightener(this.myOptioner, this.myLinesManager);
        this.myOrthogonalLinksLayouter = new OrthogonalLinksLayouter(this.myOptioner, this.myLinesManager, transponate);
    }

    public void doLayout(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.removeCycles();
        this.myInjectionsAssigner.start(this.myVertices, this.myEdges);
        this.myInjectionsAssigner.setStrongMode();
        this.myInjectionsAssigner.assignInjections();
        this.makeInjections();
        if (this.removeCycles()) {
            this.myInjectionsAssigner.setWeakMode();
            this.myInjectionsAssigner.assignInjections();
            this.makeInjections();
        }
        this.removeCycles();
        this.addToLinesManager();
        this.myStraightener.straighten(this.myEdges);
    }

    public void layoutEdgeWithSelectedPoint(Edge edge, Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        if (edge.vertex1 == edge.vertex2) {
            this.myOrthogonalLinksLayouter.layoutEdgeWithSelectedPoint(edge, this.myVertices, this.myEdges);
            return;
        }
        this.myInjectionsAssigner.start(this.myVertices, this.myEdges);
        Point p = (Point)edge.getSelectedPoint();
        int n = edge.getPointCount();
        int index = 0;
        while (index < n) {
            if (edge.getPointAt(index) == p) break;
            ++index;
        }
        if (index == n) {
            throw new RuntimeException("SSTLL001");
        }
        Vertex v1 = edge.vertex1;
        Vertex v2 = edge.vertex2;
        if (index == 1) {
            edge.srcChange = true;
        }
        if (index == n - 2) {
            edge.dstChange = true;
        }
        this.myInjectionsAssigner.setStrongMode();
        this.myInjectionsAssigner.assignInjections();
        this.makeInjections(edge);
        if (this.removeCycles()) {
            this.myInjectionsAssigner.setWeakMode();
            this.myInjectionsAssigner.assignInjections();
            this.makeInjections(edge);
        }
    }

    protected void changeInjections(Edge e) {
        int n = e.getPointCount();
        Point p1 = e.srcInject != -1 ? e.getSrcInjectionPoint() : e.getPointAt(0);
        Point p2 = e.dstInject != -1 ? e.getDstInjectionPoint() : e.getPointAt(n - 1);
        if (n == 0) {
            e.addPoint(p1);
            e.addPoint(p2);
        } else {
            e.setPointAt(0, p1);
            e.setPointAt(n - 1, p2);
        }
    }
}

