/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.semiauto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Service;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.semiauto.LinksLayouter;
import java.util.Vector;

final class OrthogonalLinksLayouter
extends LinksLayouter {
    private Vector dummyVertices = new Vector();
    private Vector dummyEdges = new Vector();
    private Vertex[] myOldVertices = null;
    private Edge[] myOldEdges = null;

    public OrthogonalLinksLayouter(Optioner optioner, LinesManager linesManager, boolean transponate) {
        super(optioner, linesManager, transponate);
    }

    public void doLayout(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.removeUselessPoints();
        this.createDummies();
        this.myInjectionsAssigner.start(this.myVertices, this.myEdges);
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.isSelected()) {
                this.setOldInjectionKind(edge, true);
                this.setOldInjectionKind(edge, false);
            }
            ++i_Edge;
        }
        this.cutSegments();
        this.myInjectionsAssigner.setStrongMode();
        this.myInjectionsAssigner.assignInjections();
        this.makeInjections();
        this.removeDummies();
        this.removeCycles();
        this.removeUselessPoints();
        this.addToLinesManager();
    }

    private void cutSegments() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.isSelected() && edge.vertex1 != edge.vertex2 && !edge.isYLink()) {
                if (edge.srcChange) {
                    this.cutSegments(edge, true);
                }
                if (edge.dstChange) {
                    this.cutSegments(edge, false);
                }
            }
            ++i_Edge;
        }
    }

    private void cutSegments(Edge edge, boolean srcFlag) {
        int n = edge.getPointCount();
        if (n <= 2) {
            edge.resetPoints();
        } else {
            boolean cut = false;
            Point p1 = edge.getPointAt(srcFlag ? 0 : n - 1);
            Point p2 = edge.getPointAt(srcFlag ? 1 : n - 2);
            Vertex v = srcFlag ? edge.vertex1 : edge.vertex2;
            int dx = p1.x - p2.x;
            int dy = p1.y - p2.y;
            if (dx == 0) {
                cut = dy > 0 ? v.getTop() < p2.y + this.myOptioner.nRectanglesSpace : v.getBottom() > p2.y - this.myOptioner.nRectanglesSpace;
            } else if (dy == 0) {
                if (dx > 0) {
                    cut = v.getLeft() < p2.x + this.myOptioner.nRectanglesSpace;
                } else {
                    boolean bl = cut = v.getRight() > p2.x - this.myOptioner.nRectanglesSpace;
                }
            }
            if (cut) {
                edge.deletePointAt(srcFlag ? 0 : n - 1);
                this.cutSegments(edge, srcFlag);
            }
        }
    }

    protected void changeInjections(Edge edge) {
        int n = edge.getPointCount();
        Point p1 = edge.srcInject != -1 ? edge.getSrcInjectionPoint() : edge.getPointAt(0);
        Point p2 = edge.dstInject != -1 ? edge.getDstInjectionPoint() : edge.getPointAt(n - 1);
        if (n <= 2) {
            boolean vertical2;
            edge.resetPoints();
            int inject1 = edge.srcInject;
            int inject2 = edge.dstInject;
            boolean vertical1 = inject1 == 3 || inject1 == 4;
            boolean bl = vertical2 = inject2 == 3 || inject2 == 4;
            if (vertical1) {
                if (vertical2) {
                    if (p1.x == p2.x) {
                        edge.addPoint(p1);
                        edge.addPoint(p2);
                    } else {
                        int y = (p1.y + p2.y) / 2;
                        edge.addPoint(p1);
                        edge.addPoint(new Point(p1.x, y, edge));
                        edge.addPoint(new Point(p2.x, y, edge));
                        edge.addPoint(p2);
                    }
                } else {
                    edge.addPoint(p1);
                    edge.addPoint(new Point(p1.x, p2.y, edge));
                    edge.addPoint(p2);
                }
            } else if (!vertical2) {
                if (p1.y == p2.y) {
                    edge.addPoint(p1);
                    edge.addPoint(p2);
                } else {
                    int x = (p1.x + p2.x) / 2;
                    edge.addPoint(p1);
                    edge.addPoint(new Point(x, p1.y, edge));
                    edge.addPoint(new Point(x, p2.y, edge));
                    edge.addPoint(p2);
                }
            } else {
                edge.addPoint(p1);
                edge.addPoint(new Point(p2.x, p1.y, edge));
                edge.addPoint(p2);
            }
        } else {
            this.changeInjection(edge, true);
            this.changeInjection(edge, false);
        }
    }

    private void changeInjection(Edge edge, boolean srcFlag) {
        int n = edge.getPointCount();
        Point inj = edge.getInjectionPoint(srcFlag);
        int inject = srcFlag ? edge.srcInject : edge.dstInject;
        boolean vertical = inject == 3 || inject == 4;
        Point p = edge.getPointAt(srcFlag ? 1 : n - 2);
        edge.setPointAt(srcFlag ? 0 : n - 1, inj);
        if (vertical) {
            p.x = inj.x;
        } else {
            p.y = inj.y;
        }
    }

    private boolean removeUselessPoints() {
        boolean changes = false;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.isSelected() && this.removeUselessPoints(this.myEdges[i_Edge])) {
                changes = true;
            }
            ++i_Edge;
        }
        return changes;
    }

    private boolean removeUselessPoints(Edge edge) {
        boolean changes = false;
        int i = 1;
        while (i < edge.getPointCount() - 1) {
            Point p = edge.getPointAt(i);
            if (edge.getSelectedPoint() != p) {
                Point prev = edge.getPointAt(i - 1);
                Point next = edge.getPointAt(i + 1);
                if (!(prev.x == p.x ? p.x != next.x : prev.y != p.y || p.y != next.y)) {
                    edge.deletePointAt(i);
                    --i;
                    changes = true;
                }
            }
            ++i;
        }
        return changes;
    }

    private void setOldInjectionKind(Edge edge, boolean srcFlag) {
        int kind;
        int n = edge.getPointCount();
        if (n < 2) {
            return;
        }
        Point p1 = edge.getPointAt(srcFlag ? 0 : n - 1);
        Point p2 = edge.getPointAt(srcFlag ? 1 : n - 2);
        int n2 = kind = p1.x == p2.x ? 1 : 2;
        if (srcFlag) {
            edge.srcWas = kind;
        } else {
            edge.dstWas = kind;
        }
    }

    private void createDummies() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            edge.myGroup = null;
            ++i_Edge;
        }
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            Service.createEdgesGroups(v, -1);
            ++i_Vertex;
        }
        boolean groupExists = false;
        int i_Edge2 = 0;
        while (i_Edge2 < this.myEdges.length) {
            EdgesGroup group = this.myEdges[i_Edge2].myGroup;
            if (group != null) {
                Edge[] edges = group.myEdges;
                int i = 0;
                while (i < edges.length) {
                    if (edges[i].isSelected()) break;
                    ++i;
                }
                if (i != edges.length) {
                    group.tempFlag = false;
                    groupExists = true;
                } else {
                    group.tempFlag = true;
                }
            }
            ++i_Edge2;
        }
        this.dummyVertices.clear();
        this.dummyEdges.clear();
        if (groupExists) {
            int i_Edge3 = 0;
            while (i_Edge3 < this.myEdges.length) {
                EdgesGroup group = this.myEdges[i_Edge3].myGroup;
                if (group != null && !group.tempFlag) {
                    this.createDummy(group);
                    group.tempFlag = true;
                }
                ++i_Edge3;
            }
            this.setMyVertices();
            this.setMyEdges();
            this.updateLinks();
            int i_Edge4 = 0;
            while (i_Edge4 < this.myEdges.length) {
                this.myEdges[i_Edge4].myGroup = null;
                ++i_Edge4;
            }
        }
    }

    private void removeDummies() {
        if (this.dummyVertices.size() == 0) {
            return;
        }
        this.myVertices = this.myOldVertices;
        this.myEdges = this.myOldEdges;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.vertex2.isDummy) {
                Edge edge1 = edge.vertex2.tempEdge;
                edge.vertex2 = edge.vertex2.tempVertex;
                int i_Point = 0;
                while (i_Point < edge1.getPointCount()) {
                    edge.addPoint((Point)edge1.getPointAt(i_Point).clone());
                    ++i_Point;
                }
                edge.setSelected(true);
            }
            ++i_Edge;
        }
        this.updateLinks();
    }

    private void createDummy(EdgesGroup group) {
        Edge[] edges = group.myEdges;
        Vertex v2 = group.vertex2;
        Vertex dummyV = new Vertex();
        Edge dummyE = new Edge();
        dummyV.isDummy = true;
        dummyV.tempVertex = v2;
        dummyV.tempEdge = dummyE;
        dummyV.setX(-536870911);
        dummyV.setWidth(0x3FFFFFFF);
        dummyV.setHeight(0);
        dummyE.vertex1 = dummyV;
        dummyE.vertex2 = v2;
        int commonY = Integer.MAX_VALUE;
        int bestD = Integer.MAX_VALUE;
        int i = 0;
        while (i < edges.length) {
            Edge edge = edges[i];
            int n = edge.getPointCount();
            if (n > 2) {
                int y = edge.getPointAt((int)(n - 2)).y;
                if (edge.isSelected() && !edge.vertex1.isReshaped() && !edge.vertex2.isReshaped()) {
                    commonY = y;
                    break;
                }
                int d = Integer.MAX_VALUE;
                if (y > v2.getBottom()) {
                    d = y - v2.getBottom();
                } else if (y < v2.getTop()) {
                    d = v2.getTop() - y;
                }
                if (d < bestD) {
                    bestD = d;
                    commonY = y;
                }
            }
            ++i;
        }
        if (commonY == Integer.MAX_VALUE) {
            commonY = v2.getBottom() + 30;
        }
        dummyV.setY(commonY);
        int injx = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < edges.length) {
            Edge edge = edges[i2];
            int n = edge.getPointCount();
            if (n != 0) {
                Point p = edge.getPointAt(n - 1);
                if (p.y == v2.getTop() || p.y == v2.getBottom()) {
                    injx = p.x;
                    if (edge.isSelected() && !edge.vertex1.isReshaped() && !edge.vertex2.isReshaped()) break;
                }
            }
            ++i2;
        }
        if (injx != Integer.MAX_VALUE) {
            Point p1 = new Point(injx, commonY, dummyE);
            Point p2 = new Point(injx, v2.getBottom(), dummyE);
            dummyE.addPoint(p1);
            dummyE.addPoint(p2);
            if (v2.isReshaped()) {
                dummyE.setSelected(true);
            }
        } else {
            dummyE.setSelected(true);
        }
        int i3 = 0;
        while (i3 < edges.length) {
            Edge edge = edges[i3];
            if (edge.isProcessed()) {
                edge.removeFromLinesManager(this.myLinesManager);
                edge.unprocess();
            }
            edge.vertex2 = dummyV;
            int n = edge.getPointCount();
            if (n != 0) {
                Point p1 = edge.getPointAt(n - 1);
                Point p2 = edge.getPointAt(n - 2);
                if (p1.x == p2.x) {
                    edge.deletePointAt(n - 1);
                    edge.deletePointAt(n - 2);
                    if (n == 3) {
                        edge.deletePointAt(0);
                    } else if (n > 3) {
                        edge.getPointAt((int)(n - 3)).y = commonY;
                    }
                } else {
                    edge.deletePointAt(n - 1);
                    if (n == 2) {
                        edge.deletePointAt(0);
                    } else {
                        edge.getPointAt((int)(n - 2)).y = commonY;
                    }
                }
                if (edge.getPointCount() == 0) {
                    edge.setSelected(true);
                }
            }
            ++i3;
        }
        this.dummyVertices.add(dummyV);
        this.dummyEdges.add(dummyE);
    }

    private void setMyVertices() {
        Vertex[] newVertices = new Vertex[this.myVertices.length + this.dummyVertices.size()];
        int i = 0;
        while (i < this.myVertices.length) {
            newVertices[i] = this.myVertices[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.dummyVertices.size()) {
            newVertices[this.myVertices.length + i2] = (Vertex)this.dummyVertices.get(i2);
            ++i2;
        }
        this.myOldVertices = this.myVertices;
        this.myVertices = newVertices;
    }

    private void setMyEdges() {
        Edge[] newEdges = new Edge[this.myEdges.length + this.dummyEdges.size()];
        int i = 0;
        while (i < this.myEdges.length) {
            newEdges[i] = this.myEdges[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.dummyEdges.size()) {
            newEdges[this.myEdges.length + i2] = (Edge)this.dummyEdges.get(i2);
            ++i2;
        }
        this.myOldEdges = this.myEdges;
        this.myEdges = newEdges;
    }

    private void updateLinks() {
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            v.myNumberOfLinks = 0;
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            ++v1.myNumberOfLinks;
            if (v1 != v2) {
                ++v2.myNumberOfLinks;
            }
            ++i_Edge;
        }
        int i_Vertex2 = 0;
        while (i_Vertex2 < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex2];
            v.myLinks = new Link[v.myNumberOfLinks];
            v.index = 0;
            ++i_Vertex2;
        }
        int i_Edge2 = 0;
        while (i_Edge2 < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge2];
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            if (v1.myLinks != null) {
                v1.myLinks[v1.index++] = new Link(v2, edge, v1 != v2 ? 1 : 0);
            }
            if (v1 != v2 && v2.myLinks != null) {
                v2.myLinks[v2.index++] = new Link(v1, edge, -1);
            }
            ++i_Edge2;
        }
    }

    public void layoutEdgeWithSelectedPoint(Edge edge, Vertex[] vertices, Edge[] edges) {
        boolean verticalDst;
        boolean verticalSrc;
        this.myVertices = vertices;
        this.myEdges = edges;
        Point p = (Point)edge.getSelectedPoint();
        int n = edge.getPointCount();
        int index = 0;
        while (index < n) {
            if (edge.getPointAt(index) == p) break;
            ++index;
        }
        if (index == n) {
            throw new RuntimeException("SORLL001");
        }
        Vertex v1 = edge.vertex1;
        Vertex v2 = edge.vertex2;
        this.myInjectionsAssigner.start(this.myVertices, this.myEdges);
        this.myInjectionsAssigner.setWeakMode();
        this.myInjectionsAssigner.prepareInjections();
        if (index == 0) {
            throw new RuntimeException("SORLL002");
        }
        if (index == 1) {
            int oldInject = edge.srcInject;
            verticalSrc = oldInject == 3 || oldInject == 4;
        } else {
            Point prev = edge.getPointAt(index - 1);
            Point pprev = edge.getPointAt(index - 2);
            boolean bl = verticalSrc = prev.y == pprev.y;
        }
        if (index == n - 1) {
            throw new RuntimeException("SORLL003");
        }
        if (index == n - 2) {
            int oldInject = edge.dstInject;
            verticalDst = oldInject == 3 || oldInject == 4;
        } else {
            Point next = edge.getPointAt(index + 1);
            Point nnext = edge.getPointAt(index + 2);
            verticalDst = next.y == nnext.y;
        }
        this.processLinkForSelectedPoint(edge, index, -1, verticalSrc);
        if (verticalSrc != verticalDst || edge.vertex1 == edge.vertex2) {
            this.processLinkForSelectedPoint(edge, index, 1, verticalDst);
        } else {
            Point next = edge.getPointAt(index + 1);
            Point newPoint = verticalDst ? new Point(next.x, p.y) : new Point(p.x, next.y);
            edge.insertPointAt(index + 1, newPoint);
        }
        this.myInjectionsAssigner.assignInjections(false);
        if (edge.getSelectedPoint() == edge.getPointAt(1)) {
            this.changeInjection(edge, true, verticalSrc);
        }
        if (edge.getSelectedPoint() == edge.getPointAt(edge.getPointCount() - 2)) {
            this.changeInjection(edge, false, verticalDst);
        }
        this.removeCycles();
    }

    private void processLinkForSelectedPoint(Edge edge, int index, int direction, boolean vertical) {
        Point p = edge.getPointAt(index);
        int n = edge.getPointCount();
        if (index != (direction == -1 ? 1 : n - 2)) {
            Point prev = edge.getPointAt(index + direction);
            if (vertical) {
                prev.x = p.x;
            } else {
                prev.y = p.y;
            }
        } else {
            Vertex v = direction == -1 ? edge.vertex1 : edge.vertex2;
            int left = v.getLeft();
            int right = v.getRight();
            int top = v.getTop();
            int bottom = v.getBottom();
            int x = p.x;
            int y = p.y;
            int dx = 0;
            if (x < left) {
                dx = -1;
            } else if (x > right) {
                dx = 1;
            }
            int dy = 0;
            if (y < top) {
                dy = -1;
            } else if (y > bottom) {
                dy = 1;
            }
            int inject = -1;
            int offset = -1;
            if (vertical) {
                if (dx < 0) {
                    inject = 1;
                } else if (dx > 0) {
                    inject = 2;
                } else {
                    inject = dy < 0 ? 3 : 4;
                    offset = x - left;
                }
            } else if (dy < 0) {
                inject = 3;
            } else if (dy > 0) {
                inject = 4;
            } else {
                inject = dx < 0 ? 1 : 2;
                offset = y - top;
            }
            if (direction == -1) {
                edge.srcInject = inject;
                edge.srcOffset = offset;
            } else {
                edge.dstInject = inject;
                edge.dstOffset = offset;
            }
        }
    }

    private void changeInjection(Edge edge, boolean srcFlag, boolean wasVertical) {
        int n = edge.getPointCount();
        Point inj = edge.getInjectionPoint(srcFlag);
        int inject = srcFlag ? edge.srcInject : edge.dstInject;
        boolean vertical = inject == 3 || inject == 4;
        Point p = edge.getPointAt(srcFlag ? 1 : n - 2);
        edge.setPointAt(srcFlag ? 0 : n - 1, inj);
        if (vertical) {
            if (!wasVertical) {
                edge.insertPointAt(srcFlag ? 1 : n - 1, new Point(inj.x, p.y));
            }
        } else if (wasVertical) {
            edge.insertPointAt(srcFlag ? 1 : n - 1, new Point(p.x, inj.y));
        }
    }
}

