/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.semiauto;

import com.tssap.selena.layout.GraphLink;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.semiauto.InjectionsAssigner;

abstract class LinksLayouter {
    protected Optioner myOptioner;
    protected LinesManager myLinesManager;
    protected boolean myTransponateFlag;
    protected InjectionsAssigner myInjectionsAssigner;
    protected Vertex[] myVertices = null;
    protected Edge[] myEdges = null;

    public LinksLayouter(Optioner optioner, LinesManager linesManager, boolean transponate) {
        this.myOptioner = optioner;
        this.myLinesManager = linesManager;
        this.myTransponateFlag = transponate;
        this.myInjectionsAssigner = new InjectionsAssigner(this.myOptioner, this.myTransponateFlag);
    }

    public abstract void doLayout(Vertex[] var1, Edge[] var2);

    public abstract void layoutEdgeWithSelectedPoint(Edge var1, Vertex[] var2, Edge[] var3);

    protected final void addToLinesManager() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (!edge.isProcessed()) {
                edge.addToLinesManager(this.myLinesManager);
                edge.process();
                if (edge.isSelected()) {
                    int i_Icon = 0;
                    while (i_Icon < edge.getIconCount()) {
                        Icon icon = edge.getIconAt(i_Icon);
                        if (icon.isProcessed()) {
                            this.myLinesManager.remove(icon);
                            icon.unprocess();
                            icon.setSelected(true);
                        }
                        ++i_Icon;
                    }
                }
            }
            ++i_Edge;
        }
    }

    protected final void makeInjections() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.isSelected()) {
                this.makeInjections(edge);
                edge.srcChange = false;
                edge.dstChange = false;
            }
            ++i_Edge;
        }
    }

    protected final void makeInjections(Edge edge) {
        if (!edge.srcChange && !edge.dstChange) {
            return;
        }
        if (edge.vertex1 == edge.vertex2) {
            this.rerouteSelfConnect(edge);
        } else {
            this.changeInjections(edge);
        }
    }

    protected final void rerouteSelfConnect(Edge e) {
        if (e.isYLink()) {
            this.rerouteSelfConnectYLink(e);
            return;
        }
        if (this.keepSelfLinkCustomSize(e)) {
            return;
        }
        Point p1 = e.getSrcInjectionPoint();
        Point p2 = e.getDstInjectionPoint();
        int x = 2 * p2.x - p1.x + this.myOptioner.nRectanglesSpace;
        int y = 2 * p1.y - p2.y + this.myOptioner.nRectanglesSpace;
        Point p = new Point(x, y);
        Point p3 = new Point(p1.x, y);
        Point p4 = new Point(x, p2.y);
        e.resetPoints();
        e.addPoint(p1);
        e.addPoint(p3);
        e.addPoint(p);
        e.addPoint(p4);
        e.addPoint(p2);
    }

    protected final void rerouteSelfConnectYLink(Edge e) {
        Point p1 = e.getSrcInjectionPoint();
        Point p2 = e.getDstInjectionPoint();
        Point p3 = (Point)p1.clone();
        Point p4 = (Point)p2.clone();
        if (!this.myTransponateFlag) {
            p3.x += this.myOptioner.selfConnectYLinkSize;
            p4.x += this.myOptioner.selfConnectYLinkSize;
        } else {
            p3.y += this.myOptioner.selfConnectYLinkSize;
            p4.y += this.myOptioner.selfConnectYLinkSize;
        }
        e.resetPoints();
        e.addPoint(p1);
        e.addPoint(p3);
        e.addPoint(p4);
        e.addPoint(p2);
    }

    protected abstract void changeInjections(Edge var1);

    protected final boolean removeCycles() {
        boolean changes1 = false;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge e = this.myEdges[i_Edge];
            if (e.isSelected()) {
                Vertex v1 = e.vertex1;
                Vertex v2 = e.vertex2;
                boolean changes = true;
                while (changes) {
                    changes = false;
                    int n = e.getPointCount();
                    int i_Point = 1;
                    while (i_Point < n) {
                        Point p = e.getPointAt(i_Point);
                        Point prev = e.getPointAt(i_Point - 1);
                        Point cross = Geometer.calculateCrossPoint(prev, p, v2);
                        if (!(cross == null || i_Point == n - 1 && cross.x == p.x && cross.y == p.y || i_Point == 1 && cross.x == prev.x && cross.y == prev.y || v2.myLongSideOnly && (cross.x == v2.getLeft() || cross.x == v2.getRight() || cross.y == v2.getTop() || cross.y == v2.getBottom()))) {
                            int i;
                            if (e.getSelectedPoint() != null) {
                                i = i_Point;
                                while (i < n) {
                                    if (e.getPointAt(i) != e.getSelectedPoint()) {
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                i = i_Point + 1;
                                while (i < n) {
                                    e.deletePointAt(i_Point + 1);
                                    ++i;
                                }
                                e.setPointAt(i_Point, cross);
                                e.dstChange = true;
                                changes = true;
                                break;
                            }
                        }
                        ++i_Point;
                    }
                    n = e.getPointCount();
                    int i_Point2 = n - 2;
                    while (i_Point2 >= 0) {
                        Point p = e.getPointAt(i_Point2);
                        Point prev = e.getPointAt(i_Point2 + 1);
                        Point cross = Geometer.calculateCrossPoint(prev, p, v1);
                        if (!(cross == null || i_Point2 == 0 && cross.x == p.x && cross.y == p.y || i_Point2 == n - 2 && cross.x == prev.x && cross.y == prev.y || v1.myLongSideOnly && (cross.x == v1.getLeft() || cross.x == v1.getRight() || cross.y == v1.getTop() || cross.y == v1.getBottom()))) {
                            int i;
                            if (e.getSelectedPoint() != null) {
                                i = 0;
                                while (i <= i_Point2) {
                                    if (e.getPointAt(i) != e.getSelectedPoint()) {
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                i = 0;
                                while (i < i_Point2) {
                                    e.deletePointAt(0);
                                    ++i;
                                }
                                e.setPointAt(0, cross);
                                e.srcChange = true;
                                changes = true;
                                break;
                            }
                        }
                        --i_Point2;
                    }
                    n = e.getPointCount();
                    int i = 0;
                    block8: while (i < n - 3) {
                        int j = i + 2;
                        block9: while (j < n - 1) {
                            Point p1 = e.getPointAt(i);
                            Point p2 = e.getPointAt(i + 1);
                            Point p3 = e.getPointAt(j);
                            Point p4 = e.getPointAt(j + 1);
                            Point p = Geometer.calculateCrossPoint(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
                            if (p != null) {
                                int k;
                                if (e.getSelectedPoint() != null) {
                                    k = i + 1;
                                    while (k <= j) {
                                        if (e.getPointAt(k) == e.getSelectedPoint()) break block9;
                                        ++k;
                                    }
                                }
                                k = i + 1;
                                while (k <= j) {
                                    e.deletePointAt(i + 1);
                                    ++k;
                                }
                                e.insertPointAt(i + 1, p);
                                changes = true;
                                break block8;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (!changes) continue;
                    changes1 = true;
                }
            }
            ++i_Edge;
        }
        return changes1;
    }

    protected boolean keepSelfLinkCustomSize(Edge e) {
        boolean result = false;
        try {
            Point shiftPoint;
            Point[] newPoints;
            GraphLink graph;
            Object userObj = e.getUserObject();
            if (userObj != null && userObj instanceof GraphLink && this.analyzeSelfLink(graph = (GraphLink)userObj) && this.assignPointsToSelfLink(e, newPoints = this.createPointsForSelfLink(graph, (shiftPoint = this.calcShiftsForSelfLink(e)).getX(), shiftPoint.getY()))) {
                result = true;
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    protected boolean analyzeSelfLink(GraphLink link) {
        boolean result;
        block1: {
            result = false;
            java.awt.Point[] points = link.getPointsArray();
            int numPoints = points.length;
            if (numPoints < 3) break block1;
            java.awt.Point srcPnt = points[0];
            java.awt.Point dstPnt = points[numPoints - 1];
            if (srcPnt.getX() < dstPnt.getX() && srcPnt.getY() > dstPnt.getY()) {
                result = true;
            }
        }
        return result;
    }

    protected Point calcShiftsForSelfLink(Edge e) {
        GraphLink link = (GraphLink)e.getUserObject();
        java.awt.Point[] points = link.getPointsArray();
        int numPoints = points.length;
        java.awt.Point srcPnt = points[0];
        java.awt.Point dstPnt = points[numPoints - 1];
        Vertex node = e.getFrom();
        int cornerX = node.getRight();
        int cornerY = node.getBottom();
        int shiftX = cornerX - (int)Math.round(dstPnt.getX());
        int shiftY = cornerY - (int)Math.round(srcPnt.getY());
        return new Point(shiftX, shiftY);
    }

    protected Point[] createPointsForSelfLink(GraphLink link, int shiftX, int shiftY) {
        java.awt.Point[] points = link.getPointsArray();
        int numPoints = points.length;
        Point[] result = new Point[numPoints];
        int i = 0;
        while (i < numPoints) {
            int x = (int)Math.round(points[i].getX());
            int y = (int)Math.round(points[i].getY());
            result[i] = new Point(x += shiftX, y += shiftY);
            ++i;
        }
        return result;
    }

    protected boolean assignPointsToSelfLink(Edge e, Point[] points) {
        boolean result;
        block1: {
            result = false;
            int numPoints = points.length;
            Vertex node = e.getFrom();
            if (points[0].getX() < node.getLeft() || points[numPoints - 1].getY() < node.getTop()) break block1;
            e.resetPoints();
            int i = 0;
            while (i < numPoints) {
                e.addPoint(points[i]);
                ++i;
            }
            result = true;
        }
        return result;
    }
}

