/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.semiauto;

import com.tssap.selena.layout.impl.AbstractLayouter;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.StandardIgnorer;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.semiauto.IconsLayouter;
import com.tssap.selena.layout.impl.semiauto.InjectionsAssigner;
import com.tssap.selena.layout.impl.semiauto.LinksLayouter;
import com.tssap.selena.layout.impl.semiauto.OrthogonalLinksLayouter;
import com.tssap.selena.layout.impl.semiauto.StraightLinksLayouter;
import com.tssap.selena.layout.impl.semiauto.VerticesLayouter;
import java.util.Vector;

public final class Layouter
extends AbstractLayouter {
    private Optioner myOptioner;
    private Vector myVerticesArray = null;
    private Vector myEdgesArray = null;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private VerticesLayouter myVerticesLayouter;
    private LinksLayouter myLinksLayouter;
    private IconsLayouter myIconsLayouter;
    private LinesManager myLinesManager;
    private boolean transponate;

    public Layouter(Optioner optioner) {
        this.myOptioner = optioner;
        this.myLinesManager = new LinesManager(this.myOptioner);
        this.myLinesManager.setConflictIgnorerBefore(new StandardIgnorer());
        int orientation = this.myOptioner.orientation;
        this.transponate = orientation != 2 && orientation != 1;
        this.myVerticesLayouter = new VerticesLayouter(this.myOptioner, this.myLinesManager);
        this.myLinksLayouter = this.myOptioner.bOrthogonalMode ? new OrthogonalLinksLayouter(this.myOptioner, this.myLinesManager, this.transponate) : new StraightLinksLayouter(this.myOptioner, this.myLinesManager, this.transponate);
        this.myIconsLayouter = new IconsLayouter(this.myOptioner, this.myLinesManager, this.transponate);
    }

    public void doLayout(Vector verticesArray, Vector edgesArray) {
        this.myVerticesArray = verticesArray;
        this.myEdgesArray = edgesArray;
        this.autoEnlargeContainerWithLinks();
        int i_Edge = 0;
        while (i_Edge < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge);
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            int n = edge.getPointCount();
            if (v1 == null || v2 == null) {
                return;
            }
            if (n >= 2) {
                int inject1 = InjectionsAssigner.getInjectionSide(edge, true);
                int inject2 = InjectionsAssigner.getInjectionSide(edge, false);
                if (inject1 == -1) {
                    edge.setSelected(true);
                    v1.setReshaped(true);
                }
                if (inject2 == -1) {
                    edge.setSelected(true);
                    v2.setReshaped(true);
                }
            }
            if (!edge.isYLink()) {
                if (n == 0) {
                    edge.setSelected(true);
                } else if (n == 1) {
                    edge.resetPoints();
                    edge.setSelected(true);
                }
            } else {
                if (edge.vertex1 != edge.vertex2) {
                    if (n != 2) {
                        edge.setSelected(true);
                    }
                } else if (n != 4) {
                    edge.setSelected(true);
                }
                if (edge.isSelected()) {
                    Point p1 = edge.getPointAt(0);
                    if (n == 1) {
                        edge.addPoint((Point)p1.clone());
                        n = 2;
                    }
                    Point p2 = edge.getPointAt(n - 1);
                    edge.resetPoints();
                    edge.addPoint(p1);
                    edge.addPoint(p2);
                }
            }
            if (v1.isSelected() || v2.isSelected()) {
                edge.setSelected(true);
            }
            if (v1.isSelected()) {
                v1.setReshaped(true);
            }
            if (v2.isSelected()) {
                v2.setReshaped(true);
            }
            if (edge.isSelected()) {
                int i_Icon = 0;
                while (i_Icon < edge.getIconCount()) {
                    edge.getIconAt(i_Icon).setSelected(true);
                    ++i_Icon;
                }
            }
            ++i_Edge;
        }
        this.makeVerticesAndEdges();
        this.myLinesManager.clear();
        Point selectedPoint = null;
        Edge edgeWithSelectedPoint = null;
        int selectedEdgeCount = 0;
        if (this.myEdges != null) {
            int i_Edge2 = 0;
            while (i_Edge2 < this.myEdges.length) {
                Edge edge = this.myEdges[i_Edge2];
                if (edge.isSelected()) {
                    ++selectedEdgeCount;
                    if (edge.getSelectedPoint() != null) {
                        if (selectedPoint == null) {
                            selectedPoint = (Point)edge.getSelectedPoint();
                            edgeWithSelectedPoint = edge;
                        } else {
                            throw new RuntimeException("SLAYTR001");
                        }
                    }
                }
                ++i_Edge2;
            }
        }
        int selectedPointX = 0;
        int selectedPointY = 0;
        if (selectedPoint != null) {
            if (selectedEdgeCount != 1) {
                return;
            }
            selectedPointX = selectedPoint.x;
            selectedPointY = selectedPoint.y;
            this.myLinksLayouter.layoutEdgeWithSelectedPoint(edgeWithSelectedPoint, this.myVertices, this.myEdges);
            if (edgeWithSelectedPoint.getSelectedPoint() != selectedPoint) {
                throw new RuntimeException("SLAYTR002");
            }
            int n = edgeWithSelectedPoint.getPointCount();
            int i_Point = 0;
            while (i_Point < n) {
                if (edgeWithSelectedPoint.getPointAt(i_Point) == selectedPoint) break;
                ++i_Point;
            }
            if (i_Point == n) {
                throw new RuntimeException("SLAYTR003");
            }
            if (selectedPoint.x != selectedPointX || selectedPoint.y != selectedPointY) {
                throw new RuntimeException("SLAYTR004");
            }
            return;
        }
        if (this.transponate) {
            this.transponate();
        }
        int i_Vertex = 0;
        while (i_Vertex < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i_Vertex);
            if (!v.isSelected() && v.getContainingNode() == null) {
                this.myLinesManager.add(v);
                v.process();
            } else {
                v.unprocess();
            }
            ++i_Vertex;
        }
        int i_Edge3 = 0;
        while (i_Edge3 < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge3);
            if (!edge.isSelected()) {
                edge.addToLinesManager(this.myLinesManager);
                edge.process();
            } else {
                edge.unprocess();
            }
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                Icon icon = edge.getIconAt(i_Icon);
                if (!icon.isSelected() && icon.getSin() == 0.0f && icon.getCos() == 0.0f) {
                    icon.setSelected(true);
                }
                if (!icon.isSelected()) {
                    this.myLinesManager.add(icon);
                    icon.process();
                } else {
                    icon.unprocess();
                }
                ++i_Icon;
            }
            ++i_Edge3;
        }
        if (this.myVertices != null) {
            this.myVerticesLayouter.doLayout(this.myVertices, this.myEdges);
        }
        if (this.myEdges != null) {
            this.myLinksLayouter.doLayout(this.myVertices, this.myEdges);
        }
        this.myIconsLayouter.doLayout(this.myEdgesArray);
        if (this.transponate) {
            this.transponate();
        }
    }

    private void makeVerticesAndEdges() {
        this.myVertices = null;
        this.myEdges = null;
        int i_Vertex = 0;
        while (i_Vertex < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i_Vertex);
            v.index = -1;
            v.myNumberOfLinks = 0;
            v.myLinks = null;
            ++i_Vertex;
        }
        int verticeCount = 0;
        int i_Vertex2 = 0;
        while (i_Vertex2 < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i_Vertex2);
            if (v.isSelected()) {
                v.index = verticeCount++;
            }
            ++i_Vertex2;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge);
            if (edge.isSelected()) {
                Vertex v1 = edge.vertex1;
                Vertex v2 = edge.vertex2;
                if (v1.index == -1) {
                    v1.index = verticeCount++;
                }
                if (v2.index == -1) {
                    v2.index = verticeCount++;
                }
            }
            ++i_Edge;
        }
        if (verticeCount == 0) {
            return;
        }
        int i_Edge2 = 0;
        while (i_Edge2 < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge2);
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            if (v1.index != -1) {
                if (v2.index == -1) {
                    v2.index = verticeCount++;
                }
            } else if (v2.index != -1) {
                v1.index = verticeCount++;
            }
            ++i_Edge2;
        }
        this.myVertices = new Vertex[verticeCount];
        int i_Edge3 = 0;
        while (i_Edge3 < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge3);
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            ++v1.myNumberOfLinks;
            if (v1 != v2) {
                ++v2.myNumberOfLinks;
            }
            ++i_Edge3;
        }
        int i_Vertex3 = 0;
        while (i_Vertex3 < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i_Vertex3);
            int index = v.index;
            if (index != -1) {
                this.myVertices[index] = v;
                v.myLinks = new Link[v.myNumberOfLinks];
                v.tempInt = 0;
            }
            ++i_Vertex3;
        }
        int edgeCount = 0;
        int i_Edge4 = 0;
        while (i_Edge4 < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge4);
            if (edge.vertex1.index != -1 || edge.vertex2.index != -1) {
                ++edgeCount;
            }
            ++i_Edge4;
        }
        this.myEdges = new Edge[edgeCount];
        int index = 0;
        int i_Edge5 = 0;
        while (i_Edge5 < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge5);
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            int fromIndex = v1.index;
            int toIndex = v2.index;
            if (fromIndex != -1 || toIndex != -1) {
                Link newLink;
                this.myEdges[index++] = edge;
                if (fromIndex != -1) {
                    newLink = new Link();
                    v1.myLinks[v1.tempInt++] = newLink;
                    newLink.myVertex = v2;
                    newLink.myEdge = edge;
                    int n = newLink.iDirected = v2 != v1 ? 1 : 0;
                }
                if (toIndex != -1 && v2 != v1) {
                    newLink = new Link();
                    v2.myLinks[v2.tempInt++] = newLink;
                    newLink.myVertex = v1;
                    newLink.myEdge = edge;
                    newLink.iDirected = -1;
                }
            }
            ++i_Edge5;
        }
    }

    private void transponate() {
        int i_Vertex = 0;
        while (i_Vertex < this.myVerticesArray.size()) {
            ((Vertex)this.myVerticesArray.get(i_Vertex)).transponate();
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdgesArray.size()) {
            Edge e = (Edge)this.myEdgesArray.get(i_Edge);
            int i_Point = 0;
            while (i_Point < e.getPointCount()) {
                e.getPointAt(i_Point).transponate();
                ++i_Point;
            }
            int i_Icon = 0;
            while (i_Icon < e.getIconCount()) {
                e.getIconAt(i_Icon).transponate();
                ++i_Icon;
            }
            ++i_Edge;
        }
    }

    private void autoEnlargeContainerWithLinks() {
        int i_Edge = 0;
        while (i_Edge < this.myEdgesArray.size()) {
            Edge e = (Edge)this.myEdgesArray.get(i_Edge);
            if (e.getPointCount() == 1) {
                Vertex v1 = e.vertex1;
                Vertex v2 = e.vertex2;
                if (v1 != null && v2 != null) {
                    if (v1.myContainingVertex == v2) {
                        this.checkContainerToEnlarge(v1, v2);
                    } else if (v2.myContainingVertex == v1) {
                        this.checkContainerToEnlarge(v2, v1);
                    }
                }
            }
            ++i_Edge;
        }
    }

    private void checkContainerToEnlarge(Vertex innerV, Vertex containerV) {
        int MIN_DISTANCE = 20;
        int[] distances = new int[]{Math.abs(containerV.getLeft() - innerV.getLeft()), Math.abs(containerV.getRight() - innerV.getRight()), Math.abs(containerV.getTop() - innerV.getTop()), Math.abs(containerV.getBottom() - innerV.getBottom())};
        int maxD = distances[1];
        if (maxD < 20) {
            int corD = Math.abs(20 - (containerV.getRight() - innerV.getRight()));
            int newW = containerV.getWidth() + corD;
            containerV.setWidth(newW);
            containerV.setShouldBeResized(true);
        }
    }
}

