/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.semiauto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.IconSpacing;
import com.tssap.selena.layout.impl.Injection;
import com.tssap.selena.layout.impl.InjectionsSolver;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Point;

final class InjectionsAssigner {
    private Optioner myOptioner;
    private boolean myTransponateFlag;
    private InjectionsSolver myInjectionsSolver;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private boolean strongMode = true;
    private int pass;
    private int selfConnCounter = 0;

    public InjectionsAssigner(Optioner optioner, boolean transponateFlag) {
        this.myOptioner = optioner;
        this.myTransponateFlag = transponateFlag;
        this.myInjectionsSolver = new InjectionsSolver(this.myOptioner);
    }

    public void setStrongMode() {
        this.strongMode = true;
    }

    public void setWeakMode() {
        this.strongMode = false;
    }

    public void start(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.isSelected()) {
                if (edge.getPointCount() == 0 || edge.isYLink()) {
                    edge.srcChange = true;
                    edge.dstChange = true;
                } else {
                    edge.srcChange = edge.vertex1.isReshaped();
                    edge.dstChange = edge.vertex2.isReshaped();
                }
                edge.srcWas = 0;
                edge.dstWas = 0;
            }
            ++i_Edge;
        }
    }

    public void assignInjections() {
        this.assignInjections(true);
    }

    public void assignInjections(boolean prepare) {
        if (prepare) {
            this.prepareInjections();
        }
        this.assignInjectionsSides();
        this.pass = 0;
        while (this.pass < 2) {
            int i_Vertex = 0;
            while (i_Vertex < this.myVertices.length) {
                Vertex v = this.myVertices[i_Vertex];
                this.assignInjections(v, 3);
                this.assignInjections(v, 4);
                this.assignInjections(v, 1);
                this.assignInjections(v, 2);
                ++i_Vertex;
            }
            ++this.pass;
        }
    }

    public void prepareInjections() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (this.strongMode && edge.isSelected()) {
                Vertex v1 = edge.vertex1;
                Vertex v2 = edge.vertex2;
                if (!edge.srcChange) {
                    edge.srcChange = this.needToChange(edge, true);
                }
                if (!edge.dstChange) {
                    edge.dstChange = this.needToChange(edge, false);
                }
            }
            if (!edge.isSelected() || !edge.srcChange) {
                edge.srcInject = InjectionsAssigner.getInjectionSide(edge, true);
                edge.srcOffset = InjectionsAssigner.getInjectionOffset(edge, true);
            } else {
                edge.srcInject = -1;
                edge.srcOffset = -1;
            }
            if (!edge.isSelected() || !edge.dstChange) {
                edge.dstInject = InjectionsAssigner.getInjectionSide(edge, false);
                edge.dstOffset = InjectionsAssigner.getInjectionOffset(edge, false);
            } else {
                edge.dstInject = -1;
                edge.dstOffset = -1;
            }
            ++i_Edge;
        }
    }

    private void assignInjections(Vertex v, int inject) {
        int size = inject == 3 || inject == 4 ? v.getWidth() : v.getHeight();
        this.myInjectionsSolver.setSize(size);
        int space = Math.min(v.getWidth(), v.getHeight()) * this.myOptioner.nOutermostSpacePercents / 100;
        this.myInjectionsSolver.setMaxOutermostSpace(space);
        this.myInjectionsSolver.resetInjections();
        this.selfConnCounter = 0;
        Link[] links = v.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            Edge edge = links[i_Link].myEdge;
            if (edge.vertex1 == v && edge.srcInject == inject) {
                this.addInjection(edge, true);
            }
            if (edge.vertex2 == v && edge.dstInject == inject) {
                this.addInjection(edge, false);
            }
            ++i_Link;
        }
        this.setBaries1();
        if (!v.isDummy) {
            this.myInjectionsSolver.solve();
        }
        this.setInjections();
    }

    private void addInjection(Edge edge, boolean srcFlag) {
        int offset;
        Vertex v = srcFlag ? edge.vertex1 : edge.vertex2;
        Vertex vertex = srcFlag ? edge.vertex2 : edge.vertex1;
        int n = edge.getPointCount();
        int inject = srcFlag ? edge.srcInject : edge.dstInject;
        boolean verticalFlag = inject == 3 || inject == 4;
        int left = verticalFlag ? v.getTop() : v.getLeft();
        int right = verticalFlag ? v.getBottom() : v.getRight();
        int top = verticalFlag ? v.getLeft() : v.getTop();
        int bottom = verticalFlag ? v.getRight() : v.getBottom();
        MyInjection inj = new MyInjection(edge, srcFlag);
        if (edge.isYLink()) {
            Point p = edge.getPointAt(srcFlag ? 0 : n - 1);
            inj.offset = this.myTransponateFlag ? p.x - top : p.y - top;
            this.myInjectionsSolver.addInjection(inj);
            return;
        }
        boolean change = srcFlag ? edge.srcChange : edge.dstChange;
        int n2 = offset = srcFlag ? edge.srcOffset : edge.dstOffset;
        if (change || offset == -1) {
            if (v != vertex) {
                int inject1;
                int x = 0;
                int y = 0;
                Point p = this.calculateAttractivePoint(edge, srcFlag, verticalFlag);
                if (p != null) {
                    if (verticalFlag) {
                        x = p.y;
                        y = p.x;
                    } else {
                        x = p.x;
                        y = p.y;
                    }
                    inj.bestOffset = y - top;
                }
                int left1 = verticalFlag ? vertex.getTop() : vertex.getLeft();
                int right1 = verticalFlag ? vertex.getBottom() : vertex.getRight();
                int top1 = verticalFlag ? vertex.getLeft() : vertex.getTop();
                int bottom1 = verticalFlag ? vertex.getRight() : vertex.getBottom();
                int n3 = inject1 = srcFlag ? edge.dstInject : edge.srcInject;
                if (verticalFlag && (inject1 == 3 || inject1 == 4) || !verticalFlag && (inject1 == 1 || inject1 == 2)) {
                    if (p == null) {
                        x = inject1 == 1 || inject1 == 3 ? left1 : right1;
                        y = (top1 + bottom1) / 2;
                    }
                    int minBound = Math.max(top1, top) - top;
                    int maxBound = Math.min(bottom1, bottom) - top;
                    if (this.pass == 0 && minBound <= maxBound) {
                        inj.minBound = minBound;
                        inj.maxBound = maxBound;
                    }
                } else if (p == null) {
                    x = (left1 + right1) / 2;
                    y = (top1 + bottom1) / 2;
                }
                if (!(verticalFlag || p == null && bottom1 >= top && top1 <= bottom)) {
                    inj.attractorFlag = true;
                    inj.attractorOffset = y - top;
                }
                if (!this.myOptioner.bOrthogonalMode) {
                    int centerx = (left + right) / 2;
                    int centery = (top + bottom) / 2;
                    if (x != centerx) {
                        int yy;
                        inj.bary2 = yy = (int)(1000.0f * Geometer.calculateIntersectionWithVertical((float)x, (float)y, (float)centerx, (float)centery, inject == 1 || inject == 3 ? (float)left : (float)right));
                    }
                } else {
                    inj.bary2 = y;
                }
                if (verticalFlag) {
                    inj.prevPointX = y;
                    inj.prevPointY = x;
                } else {
                    inj.prevPointX = x;
                    inj.prevPointY = y;
                }
            } else {
                inj.bary1 = inj.bary2 = Integer.MAX_VALUE - this.selfConnCounter++;
                inj.attractorOffset = inj.bary2;
                inj.attractorFlag = true;
            }
        } else {
            if (offset < 0) {
                throw new RuntimeException("SIJAS001");
            }
            inj.offset = offset;
            Point p = this.calculateAttractivePoint(edge, srcFlag, verticalFlag);
            if (p == null) {
                p = edge.getPointAt(srcFlag ? 1 : n - 2);
            }
            inj.prevPointX = p.x;
            inj.prevPointY = p.y;
        }
        inj.leftIconSpace = IconSpacing.calculateInjectionIconsSpace(edge, srcFlag, verticalFlag ? 3 : 1);
        inj.rightIconSpace = IconSpacing.calculateInjectionIconsSpace(edge, srcFlag, verticalFlag ? 4 : 2);
        if (v.isDummy) {
            int x = n > 2 ? edge.getPointAt((int)(srcFlag ? 1 : n - 2)).x : edge.getInjectionX(!srcFlag);
            inj.offset = x - top;
        }
        this.myInjectionsSolver.addInjection(inj);
    }

    private void setBaries1() {
        int i = 0;
        while (i < this.myInjectionsSolver.getInjectionCount()) {
            MyInjection inj = (MyInjection)this.myInjectionsSolver.getInjection(i);
            if (inj.offset != -1) {
                inj.bary1 = inj.offset;
            } else {
                Edge edge = inj.edge;
                if (edge.vertex1 != edge.vertex2) {
                    int y;
                    int x;
                    boolean verticalFlag;
                    boolean srcFlag = inj.srcFlag;
                    int inject = srcFlag ? edge.srcInject : edge.dstInject;
                    boolean bl = verticalFlag = inject == 3 || inject == 4;
                    if (verticalFlag) {
                        x = inj.prevPointY;
                        y = inj.prevPointX;
                    } else {
                        x = inj.prevPointX;
                        y = inj.prevPointY;
                    }
                    int maxOffset = -1;
                    int j = 0;
                    while (j < this.myInjectionsSolver.getInjectionCount()) {
                        MyInjection inj1 = (MyInjection)this.myInjectionsSolver.getInjection(j);
                        int offset = inj1.offset;
                        if (offset != -1 && offset > maxOffset) {
                            int yy;
                            int y1;
                            int x1;
                            int inj1y;
                            int inj1x;
                            Edge edge1 = inj1.edge;
                            boolean srcFlag1 = inj1.srcFlag;
                            if (verticalFlag) {
                                inj1x = edge1.getInjectionY(srcFlag1);
                                inj1y = edge1.getInjectionX(srcFlag1);
                                x1 = inj1.prevPointY;
                                y1 = inj1.prevPointX;
                            } else {
                                inj1x = edge1.getInjectionX(srcFlag1);
                                inj1y = edge1.getInjectionY(srcFlag1);
                                x1 = inj1.prevPointX;
                                y1 = inj1.prevPointY;
                            }
                            if (x1 != inj1x && y > (yy = Geometer.calculateIntersectionWithVertical(x1, y1, inj1x, inj1y, x))) {
                                maxOffset = offset;
                            }
                        }
                        ++j;
                    }
                    inj.bary1 = maxOffset + 1;
                }
            }
            ++i;
        }
    }

    private void setInjections() {
        int i = 0;
        while (i < this.myInjectionsSolver.getInjectionCount()) {
            MyInjection inj = (MyInjection)this.myInjectionsSolver.getInjection(i);
            Edge edge = inj.edge;
            if (inj.srcFlag) {
                edge.srcOffset = inj.offset;
            } else {
                edge.dstOffset = inj.offset;
            }
            ++i;
        }
    }

    private void assignInjectionsSides() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.isSelected()) {
                if (edge.srcInject == -1) {
                    edge.srcInject = this.chooseInjectionSide(edge, true);
                }
                if (edge.dstInject == -1) {
                    edge.dstInject = this.chooseInjectionSide(edge, false);
                }
            }
            ++i_Edge;
        }
    }

    private int chooseInjectionSide(Edge e, boolean srcFlag) {
        if (e.isYLink()) {
            return this.myTransponateFlag ? 4 : 2;
        }
        if (!this.myOptioner.bOrthogonalMode) {
            return this.chooseInjectionSideFree(e, srcFlag);
        }
        int n = e.getPointCount();
        if (n == 0) {
            return this.chooseInjectionSideFree(e, srcFlag);
        }
        Point p1 = e.getPointAt(srcFlag ? 0 : n - 1);
        Point p2 = e.getPointAt(srcFlag ? 1 : n - 2);
        boolean vertical = p1.x == p2.x;
        return this.chooseInjectionSideConstrained(e, srcFlag, vertical);
    }

    private int chooseInjectionSideConstrained(Edge e, boolean srcFlag, boolean vertical) {
        int x1;
        Vertex v1;
        Vertex v = srcFlag ? e.vertex1 : e.vertex2;
        Vertex vertex = v1 = srcFlag ? e.vertex2 : e.vertex1;
        if (vertical) {
            int y1;
            int y = (v.getTop() + v.getBottom()) / 2;
            return y > (y1 = (v1.getTop() + v1.getBottom()) / 2) ? 3 : 4;
        }
        int x = (v.getLeft() + v.getRight()) / 2;
        return x > (x1 = (v1.getLeft() + v1.getRight()) / 2) ? 1 : 2;
    }

    private int chooseInjectionSideFree(Edge e, boolean srcFlag) {
        int oldKind;
        Vertex v = srcFlag ? e.vertex1 : e.vertex2;
        Vertex vertex = srcFlag ? e.vertex2 : e.vertex1;
        int n = oldKind = srcFlag ? e.srcWas : e.dstWas;
        if (v == vertex) {
            return srcFlag ? 4 : 2;
        }
        Point p = this.calculateAttractivePoint(e, srcFlag, oldKind != 2);
        int y = (v.getTop() + v.getBottom()) / 2;
        int x = (v.getLeft() + v.getRight()) / 2;
        if (p != null) {
            int n2 = this.getSectorNumber(p, v);
            if (v.myLongSideOnly && (n2 == 2 || n2 == 3 || n2 == 4 || n2 == 1)) {
                if (v.getWidth() > v.getHeight()) {
                    return y > p.y ? 3 : 4;
                }
                return x > p.x ? 1 : 2;
            }
            switch (n2) {
                case -1: 
                case 1: {
                    return 3;
                }
                case -3: 
                case 3: {
                    return 4;
                }
                case -4: 
                case 4: {
                    return 1;
                }
                case -2: 
                case 2: {
                    return 2;
                }
            }
            Point p1 = this.getNodeNearestPoint(vertex, v);
            int m = this.getSectorNumber(p1, v);
            if (v.myLongSideOnly) {
                if (v.getWidth() > v.getHeight()) {
                    return y > p1.y ? 3 : 4;
                }
                return x > p1.x ? 1 : 2;
            }
            switch (n2) {
                case 5: {
                    switch (m) {
                        case 1: 
                        case 2: 
                        case 6: {
                            return 3;
                        }
                        case 3: 
                        case 4: 
                        case 8: {
                            return 1;
                        }
                    }
                    return 3;
                }
                case 6: {
                    switch (m) {
                        case 1: 
                        case 4: 
                        case 5: {
                            return 3;
                        }
                        case 2: 
                        case 3: 
                        case 7: {
                            return 2;
                        }
                    }
                    return 3;
                }
                case 8: {
                    switch (m) {
                        case 2: 
                        case 3: 
                        case 7: {
                            return 4;
                        }
                        case 1: 
                        case 4: 
                        case 5: {
                            return 1;
                        }
                    }
                    return 4;
                }
                case 7: {
                    switch (m) {
                        case 3: 
                        case 4: 
                        case 8: {
                            return 4;
                        }
                        case 1: 
                        case 2: 
                        case 6: {
                            return 2;
                        }
                    }
                    return 4;
                }
            }
            throw new RuntimeException("SIJAS002");
        }
        Point p1 = this.getNodeNearestPoint(vertex, v);
        if (v.myLongSideOnly) {
            if (v.getWidth() > v.getHeight()) {
                return y > p1.y ? 3 : 4;
            }
            return x > p1.x ? 1 : 2;
        }
        int n3 = this.getSectorNumber(p1, v);
        switch (n3) {
            case -1: 
            case 1: {
                return 3;
            }
            case -3: 
            case 3: {
                return 4;
            }
            case -4: 
            case 4: {
                return 1;
            }
            case -2: 
            case 2: {
                return 2;
            }
            case 5: {
                return oldKind == 2 ? 1 : 3;
            }
            case 6: {
                return oldKind == 2 ? 2 : 3;
            }
            case 7: {
                return oldKind == 2 ? 2 : 4;
            }
            case 8: {
                return oldKind == 2 ? 1 : 4;
            }
        }
        throw new RuntimeException("SIJAS003");
    }

    private int getSectorNumber(Point p, Vertex v) {
        int x = p.x;
        int y = p.y;
        int left = v.getLeft();
        int right = v.getRight();
        int top = v.getTop();
        int bottom = v.getBottom();
        int left1 = left - this.myOptioner.nInjectionChangeThreshold;
        int right1 = right + this.myOptioner.nInjectionChangeThreshold;
        int top1 = top - this.myOptioner.nInjectionChangeThreshold;
        int bottom1 = bottom + this.myOptioner.nInjectionChangeThreshold;
        if (y <= top1) {
            if (x <= left1) {
                return 5;
            }
            if (x >= right1) {
                return 6;
            }
            return 1;
        }
        if (y >= bottom1) {
            if (x <= left1) {
                return 8;
            }
            if (x >= right1) {
                return 7;
            }
            return 3;
        }
        if (x <= left1) {
            return 4;
        }
        if (x >= right1) {
            return 2;
        }
        if (y <= top) {
            if (x <= left) {
                return left - x > top - y ? 4 : 1;
            }
            if (x >= right) {
                return x - right > top - y ? 2 : 1;
            }
            return 1;
        }
        if (y >= bottom) {
            if (x <= left) {
                return left - x > y - bottom ? 4 : 3;
            }
            if (x >= right) {
                return x - right > y - bottom ? 2 : 3;
            }
            return 3;
        }
        if (x <= left) {
            return 4;
        }
        if (x >= right) {
            return 2;
        }
        int d1 = y - top;
        int d2 = right - x;
        int d3 = bottom - y;
        int d4 = x - left;
        int min = d1;
        int minn = 1;
        if (d2 < min) {
            min = d2;
            minn = 2;
        }
        if (d3 < min) {
            min = d3;
            minn = 3;
        }
        if (d4 < min) {
            min = d4;
            minn = 4;
        }
        return -minn;
    }

    private Point getNodeNearestPoint(Vertex v, Vertex from) {
        int b;
        int t;
        int r;
        int left = v.getLeft();
        int right = v.getRight();
        int top = v.getTop();
        int bottom = v.getBottom();
        int left1 = from.getLeft();
        int right1 = from.getRight();
        int top1 = from.getTop();
        int bottom1 = from.getBottom();
        int l = Math.max(left, left1);
        if (l <= (r = Math.min(right, right1)) && (t = Math.max(top, top1)) <= (b = Math.min(bottom, bottom1))) {
            int minn = this.detectNearestSide(v, from);
            switch (minn) {
                case 1: {
                    return new Point((left1 + right1) / 2, top1);
                }
                case 2: {
                    return new Point(right1, (top1 + bottom1) / 2);
                }
                case 3: {
                    return new Point((left1 + right1) / 2, bottom1);
                }
                case 4: {
                    return new Point(left1, (top1 + bottom1) / 2);
                }
            }
        }
        int x = (left1 + right1) / 2;
        x = Math.min(x, right);
        x = Math.max(x, left);
        int y = (top1 + bottom1) / 2;
        y = Math.min(y, bottom);
        y = Math.max(y, top);
        return new Point(x, y);
    }

    private int detectNearestSide(Vertex curV, Vertex fromV) {
        boolean bInnerNodes = curV.getContainingNode() == fromV || fromV.getContainingNode() == curV;
        int[] distances = new int[]{Math.abs(fromV.getTop() - curV.getTop()), Math.abs(fromV.getRight() - curV.getRight()), Math.abs(fromV.getBottom() - curV.getBottom()), Math.abs(fromV.getLeft() - curV.getLeft())};
        int minIndex = 0;
        int i = 0;
        while (i < 4) {
            if (distances[i] < distances[minIndex]) {
                minIndex = i;
            }
            ++i;
        }
        int MIN_DISTANCE = 15;
        if (bInnerNodes && distances[minIndex] < 15) {
            minIndex = -1;
            int i2 = 0;
            while (i2 < 4) {
                if (distances[i2] >= 15) {
                    if (minIndex < 0) {
                        minIndex = i2;
                    } else if (distances[i2] < distances[minIndex]) {
                        minIndex = i2;
                    }
                }
                ++i2;
            }
            if (minIndex < 0) {
                minIndex = 0;
            }
        }
        return minIndex + 1;
    }

    private Point calculateAttractivePoint(Edge edge, boolean srcFlag, boolean verticalFlag) {
        int inject;
        int n = edge.getPointCount();
        int offset = srcFlag ? edge.dstOffset : edge.srcOffset;
        int n2 = inject = srcFlag ? edge.dstInject : edge.srcInject;
        if (n <= 2) {
            if (offset == -1) {
                return null;
            }
            Point p = edge.getInjectionPoint(!srcFlag);
            if (verticalFlag) {
                if (inject == 3 || inject == 4) {
                    return p;
                }
                return null;
            }
            if (inject == 1 || inject == 2) {
                return p;
            }
            return null;
        }
        if (!this.strongMode || !this.myOptioner.bOrthogonalMode) {
            return edge.getPointAt(srcFlag ? 1 : n - 2);
        }
        Point p = null;
        int i = 1;
        while (i < n - 1) {
            p = edge.getPointAt(srcFlag ? i : n - 1 - i);
            if (p == edge.getSelectedPoint()) {
                return p;
            }
            Point next = edge.getPointAt(srcFlag ? i + 1 : n - 1 - i - 1);
            if (verticalFlag && p.x == next.x || !verticalFlag && p.y == next.y) break;
            ++i;
        }
        if (i == n - 1) {
            return null;
        }
        if (i == n - 2) {
            if (offset == -1) {
                return null;
            }
            if (verticalFlag) {
                if (inject == 3 || inject == 4) {
                    return new Point(edge.getInjectionX(!srcFlag), p.y);
                }
                return p;
            }
            if (inject == 1 || inject == 2) {
                return new Point(p.x, edge.getInjectionY(!srcFlag));
            }
            return p;
        }
        return p;
    }

    private boolean needToChange(Edge edge, boolean srcFlag) {
        boolean change;
        int n = edge.getPointCount();
        if (n == 0) {
            return true;
        }
        boolean bl = change = srcFlag ? edge.dstChange : edge.srcChange;
        if (!change) {
            return false;
        }
        if (!this.myOptioner.bOrthogonalMode) {
            return n <= 2;
        }
        return n <= 4;
    }

    static int getInjectionSide(Edge edge, boolean srcFlag) {
        Vertex v;
        Vertex vertex = v = srcFlag ? edge.vertex1 : edge.vertex2;
        if (v == null) {
            return -1;
        }
        int n = edge.getPointCount();
        if (n < 2) {
            throw new RuntimeException("SIJAS004");
        }
        Point p = edge.getPointAt(srcFlag ? 0 : n - 1);
        int x = p.x;
        int y = p.y;
        int left = v.getLeft();
        int right = v.getRight();
        int top = v.getTop();
        int bottom = v.getBottom();
        boolean bCorrect = v.myLongSideOnly;
        if (x == left && top < y && y < bottom) {
            return !bCorrect || v.getWidth() < v.getHeight() ? 1 : -1;
        }
        if (x == right && top < y && y < bottom) {
            return !bCorrect || v.getWidth() < v.getHeight() ? 2 : -1;
        }
        if (y == top && left < x && x < right) {
            return !bCorrect || v.getWidth() > v.getHeight() ? 3 : -1;
        }
        if (y == bottom && left < x && x < right) {
            return !bCorrect || v.getWidth() > v.getHeight() ? 4 : -1;
        }
        Point p1 = edge.getPointAt(srcFlag ? 1 : n - 2);
        int dx = Math.abs(p1.x - x);
        int dy = Math.abs(p1.y - y);
        if (x == left && y == top) {
            if (!bCorrect) {
                return dx > dy ? 1 : 3;
            }
            return v.getWidth() > v.getHeight() ? 3 : 1;
        }
        if (x == right && y == top) {
            if (!bCorrect) {
                return dx > dy ? 2 : 3;
            }
            return v.getWidth() > v.getHeight() ? 3 : 2;
        }
        if (x == left && y == bottom) {
            if (!bCorrect) {
                return dx > dy ? 1 : 4;
            }
            return v.getWidth() > v.getHeight() ? 4 : 1;
        }
        if (x == right && y == bottom) {
            if (!bCorrect) {
                return dx > dy ? 2 : 4;
            }
            return v.getWidth() > v.getHeight() ? 4 : 2;
        }
        return -1;
    }

    private static int getInjectionOffset(Edge edge, boolean srcFlag) {
        Vertex v;
        Vertex vertex = v = srcFlag ? edge.vertex1 : edge.vertex2;
        if (v == null) {
            return -1;
        }
        int n = edge.getPointCount();
        if (n < 2) {
            throw new RuntimeException("SIJAS005");
        }
        Point p = edge.getPointAt(srcFlag ? 0 : n - 1);
        int inject = srcFlag ? edge.srcInject : edge.dstInject;
        switch (inject) {
            case 3: 
            case 4: {
                return p.x - v.getLeft();
            }
            case 1: 
            case 2: {
                return p.y - v.getTop();
            }
        }
        return -1;
    }

    private static final class MyInjection
    extends Injection {
        Edge edge;
        boolean srcFlag;
        int prevPointX;
        int prevPointY;

        MyInjection(Edge edge, boolean srcFlag) {
            this.edge = edge;
            this.srcFlag = srcFlag;
        }
    }
}

