/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.increment;

import com.tssap.selena.layout.impl.AbstractComponentLayouter;
import com.tssap.selena.layout.impl.AbstractLayouter;
import com.tssap.selena.layout.impl.ComponentsManager;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.LonelyVerticesLayouter;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.RightBound;
import com.tssap.selena.layout.impl.Service;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.increment.ComponentLayouter;
import java.util.Vector;

public final class Layouter
extends AbstractLayouter {
    private Optioner myOptioner;
    private ComponentsManager myComponentsManager;
    private LonelyVerticesLayouter myLonelyVerticesLayouter;
    private com.tssap.selena.layout.impl.auto.ComponentLayouter myAutoComponentLayouter;
    private ComponentLayouter myComponentLayouter;
    private LinesManager myLinesManager;
    private Vector myVerticesArray = null;
    private Vector myEdgesArray = null;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;

    public Layouter(Optioner optioner) {
        this.myOptioner = optioner;
        this.myComponentsManager = new ComponentsManager(this.myOptioner);
        this.myLonelyVerticesLayouter = new LonelyVerticesLayouter(this.myOptioner);
        this.myAutoComponentLayouter = new com.tssap.selena.layout.impl.auto.ComponentLayouter(this.myOptioner);
        this.myComponentLayouter = new ComponentLayouter(this.myOptioner);
        this.myLinesManager = new LinesManager(this.myOptioner);
    }

    public void doLayout(Vector verticesArray, Vector edgesArray) {
        this.myVerticesArray = verticesArray;
        this.myEdgesArray = edgesArray;
        this.myComponentsManager.start(this.myVerticesArray, this.myEdgesArray);
        this.myComponentsManager.countAdjacentLinks();
        this.myComponentsManager.selectComponents();
        this.arrangeComponentsAndLonelyVertices();
        int orientation = this.myOptioner.orientation;
        boolean transponate = orientation != 2 && orientation != 1;
        this.myLinesManager.clear();
        RightBound startX = new RightBound(this.myOptioner, this.myOptioner.startX);
        int startY = this.myOptioner.startY;
        int i_Comp = 0;
        while (i_Comp < this.myComponentsManager.getComponentCount()) {
            this.myComponentsManager.chooseComponent(i_Comp);
            this.myVertices = this.myComponentsManager.getVertices();
            this.myEdges = this.myComponentsManager.getEdges();
            int selectedVerticeCount = 0;
            int totalNumber = 0;
            int i_Vertex = 0;
            while (i_Vertex < this.myVertices.length) {
                if (this.myVertices[i_Vertex].isSelected()) {
                    ++selectedVerticeCount;
                }
                ++totalNumber;
                ++i_Vertex;
            }
            if (selectedVerticeCount == 0) {
                if (!this.myComponentsManager.isCorrectWith(this.myLinesManager)) {
                    this.myComponentsManager.adjustComponent(startX, 1);
                }
            } else {
                AbstractComponentLayouter componentLayouter;
                this.myComponentsManager.buildLinksList();
                if (transponate) {
                    this.myComponentsManager.transponateComponent();
                }
                AbstractComponentLayouter abstractComponentLayouter = componentLayouter = totalNumber - selectedVerticeCount <= 1 ? this.myAutoComponentLayouter : this.myComponentLayouter;
                if (!transponate) {
                    componentLayouter.doLayout(this.myVertices, this.myEdges, startX, startY);
                } else {
                    componentLayouter.doLayout(this.myVertices, this.myEdges, new RightBound(this.myOptioner, startY), startX.getMaxX(0, Integer.MAX_VALUE));
                }
                if (transponate) {
                    this.myComponentsManager.transponateComponent();
                }
                if (this.myOptioner.adjustComponents) {
                    this.myComponentsManager.adjustComponent(startX, 0);
                }
            }
            Service.addToLinesManager(this.myLinesManager, this.myVertices, this.myEdges, true);
            this.myComponentsManager.calculateNewRightBound(startX);
            ++i_Comp;
        }
        this.myLonelyVerticesLayouter.layoutLonelyVerticesForIncremental(this.myVerticesArray, startX, this.myLinesManager);
    }

    private void arrangeComponentsAndLonelyVertices() {
        int verticeCount = this.myVerticesArray.size();
        int componentCount = this.myComponentsManager.getComponentCount();
        int[] baries = new int[componentCount];
        int[] counts = new int[componentCount];
        int i = 0;
        while (i < componentCount) {
            baries[i] = 0;
            counts[i] = 0;
            ++i;
        }
        int i_Vertex = 0;
        while (i_Vertex < verticeCount) {
            Vertex v = (Vertex)this.myVerticesArray.get(i_Vertex);
            if (v.myNumberOfLinks != 0 && !v.isSelected()) {
                int comp;
                int n = comp = v.myComponent;
                baries[n] = baries[n] + (v.getLeft() + v.getRight());
                int n2 = comp;
                counts[n2] = counts[n2] + 1;
            }
            ++i_Vertex;
        }
        int i2 = 0;
        while (i2 < componentCount) {
            baries[i2] = counts[i2] != 0 ? 100 * baries[i2] / counts[i2] : Integer.MAX_VALUE;
            ++i2;
        }
        int[] comps = new int[componentCount];
        int i3 = 0;
        while (i3 < comps.length) {
            comps[i3] = i3;
            ++i3;
        }
        int i4 = 0;
        while (i4 < baries.length - 1) {
            int j = i4 + 1;
            while (j < baries.length) {
                if (baries[j] < baries[i4]) {
                    int temp = baries[i4];
                    baries[i4] = baries[j];
                    baries[j] = temp;
                    temp = comps[i4];
                    comps[i4] = comps[j];
                    comps[j] = temp;
                }
                ++j;
            }
            ++i4;
        }
        int[] comps1 = new int[componentCount];
        int i5 = 0;
        while (i5 < comps.length) {
            comps1[comps[i5]] = i5;
            ++i5;
        }
        int i_Vertex2 = 0;
        while (i_Vertex2 < verticeCount) {
            Vertex v = (Vertex)this.myVerticesArray.get(i_Vertex2);
            if (v.myNumberOfLinks != 0) {
                v.myComponent = comps1[v.myComponent];
            }
            ++i_Vertex2;
        }
        int i6 = 0;
        while (i6 < verticeCount - 1) {
            int j = i6 + 1;
            while (j < verticeCount) {
                Vertex v1 = (Vertex)this.myVerticesArray.get(i6);
                if (v1.myNumberOfLinks == 0) {
                    Vertex v2 = (Vertex)this.myVerticesArray.get(j);
                    if (v2.myNumberOfLinks == 0) {
                        int y2;
                        int y1 = v1.isSelected() ? Integer.MAX_VALUE : v1.getLeft() + v1.getRight();
                        int n = y2 = v2.isSelected() ? Integer.MAX_VALUE : v2.getLeft() + v2.getRight();
                        if (y2 < y1) {
                            this.myVerticesArray.set(i6, v2);
                            this.myVerticesArray.set(j, v1);
                        }
                    }
                }
                ++j;
            }
            ++i6;
        }
    }
}

