/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.increment;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.DummyVerticesManager;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Point;

final class AbsPosAssigner {
    private Optioner myOptioner;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private int nLevels = -1;
    private Vertex[][] myLevels = null;
    private int[] levelsCenters = null;

    public AbsPosAssigner(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public void assignAbsPos(Vertex[] vertices, Edge[] edges, int n_Levels) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.nLevels = n_Levels;
        this.createLevels();
        this.calculateLevelsCenters();
        int i_Level = 0;
        while (i_Level < this.nLevels) {
            this.assignNotSelectedAbsPos(i_Level);
            ++i_Level;
        }
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            if (v.isSelected()) {
                this.assignSelectedAbsPos(v);
            }
            ++i_Vertex;
        }
    }

    public Vertex[][] getLevels() {
        return this.myLevels;
    }

    private void createLevels() {
        this.myLevels = new Vertex[this.nLevels][];
        int assigned = 0;
        int i_Level = 0;
        while (i_Level < this.myLevels.length) {
            int count = 0;
            int i_Vertex = 0;
            while (i_Vertex < this.myVertices.length) {
                if (this.myVertices[i_Vertex].level == i_Level) {
                    ++count;
                }
                ++i_Vertex;
            }
            Vertex[] nodes = new Vertex[count];
            int index = 0;
            int i_Vertex2 = 0;
            while (i_Vertex2 < this.myVertices.length) {
                Vertex v = this.myVertices[i_Vertex2];
                if (v.level == i_Level) {
                    nodes[index++] = v;
                    ++assigned;
                }
                ++i_Vertex2;
            }
            this.myLevels[i_Level] = nodes;
            ++i_Level;
        }
        if (assigned != this.myVertices.length) {
            throw new RuntimeException("IAPAS001");
        }
    }

    private void calculateLevelsCenters() {
        this.levelsCenters = new int[this.myLevels.length];
        int i_Level = 0;
        while (i_Level < this.myLevels.length) {
            int top = Integer.MAX_VALUE;
            int bottom = Integer.MIN_VALUE;
            Vertex[] nodes = this.myLevels[i_Level];
            int i = 0;
            while (i < nodes.length) {
                Vertex v = nodes[i];
                if (!v.isSelected() && !v.isDummy) {
                    top = Math.min(top, v.getTop());
                    bottom = Math.max(bottom, v.getBottom());
                }
                ++i;
            }
            this.levelsCenters[i_Level] = top != Integer.MAX_VALUE ? (top + bottom) / 2 : Integer.MIN_VALUE;
            ++i_Level;
        }
    }

    private void assignNotSelectedAbsPos(int i_Level) {
        Vertex[] nodes = this.myLevels[i_Level];
        int i = 0;
        while (i < nodes.length - 1) {
            int j = i + 1;
            while (j < nodes.length) {
                if (this.lessThan(nodes[j], nodes[i])) {
                    Vertex temp = nodes[i];
                    nodes[i] = nodes[j];
                    nodes[j] = temp;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < nodes.length) {
            Vertex v = nodes[i2];
            v.absPos = !v.isSelected() ? i2 : -1;
            ++i2;
        }
    }

    private boolean lessThan(Vertex v1, Vertex v2) {
        if (v1.isSelected()) {
            return false;
        }
        if (v2.isSelected()) {
            return true;
        }
        if (!v1.isDummy && !v2.isDummy) {
            return v1.getLeft() + v1.getRight() < v2.getLeft() + v2.getRight();
        }
        if (v1.isDummy && v2.isDummy) {
            int y = this.levelsCenters[v1.level];
            if (y == Integer.MIN_VALUE) {
                return false;
            }
            Edge edge1 = DummyVerticesManager.getOrigin(v1);
            Edge edge2 = DummyVerticesManager.getOrigin(v2);
            if (edge1.getPointCount() < 2 || edge2.getPointCount() < 2) {
                throw new RuntimeException("IAPAS002");
            }
            Point p1 = null;
            Point p2 = null;
            int i_Point = 0;
            while (i_Point < edge1.getPointCount() - 1) {
                p1 = edge1.getPointAt(i_Point);
                p2 = edge1.getPointAt(i_Point + 1);
                if (Math.min(p1.y, p2.y) <= y && y <= Math.max(p1.y, p2.y)) break;
                ++i_Point;
            }
            int x1 = 0;
            if (p1.y != p2.y) {
                x1 = Geometer.calculateIntersectionWithHorizontal(p1.x, p1.y, p2.x, p2.y, y);
            }
            i_Point = 0;
            while (i_Point < edge2.getPointCount() - 1) {
                p1 = edge2.getPointAt(i_Point);
                p2 = edge2.getPointAt(i_Point + 1);
                if (Math.min(p1.y, p2.y) <= y && y <= Math.max(p1.y, p2.y)) break;
                ++i_Point;
            }
            int x2 = 0;
            if (p1.y != p2.y) {
                x2 = Geometer.calculateIntersectionWithHorizontal(p1.x, p1.y, p2.x, p2.y, y);
            }
            return x1 < x2;
        }
        boolean inverse = false;
        if (v1.isDummy) {
            Vertex temp = v1;
            v1 = v2;
            v2 = temp;
            inverse = true;
        }
        int x = (v1.getLeft() + v1.getRight()) / 2;
        int y = (v1.getTop() + v1.getBottom()) / 2;
        Edge edge = DummyVerticesManager.getOrigin(v2);
        if (edge.getPointCount() < 2) {
            throw new RuntimeException("IAPAS003");
        }
        Point p1 = null;
        Point p2 = null;
        int i_Point = 0;
        while (i_Point < edge.getPointCount() - 1) {
            p1 = edge.getPointAt(i_Point);
            p2 = edge.getPointAt(i_Point + 1);
            if (Math.min(p1.y, p2.y) <= y && y <= Math.max(p1.y, p2.y)) break;
            ++i_Point;
        }
        int xx = 0;
        if (p1.y != p2.y) {
            xx = Geometer.calculateIntersectionWithHorizontal(p1.x, p1.y, p2.x, p2.y, y);
        }
        return inverse ? xx < x : xx > x;
    }

    private void assignSelectedAbsPos(Vertex v) {
        int level = v.level;
        Vertex[] nodes = this.myLevels[level];
        int bestValue = Integer.MAX_VALUE;
        int bestPos = -1;
        int i_Pos = 0;
        while (i_Pos == 0 || !nodes[i_Pos - 1].isSelected()) {
            int value = this.calculateValue(v, i_Pos, bestValue);
            if (value < bestValue) {
                bestValue = value;
                bestPos = i_Pos;
            }
            ++i_Pos;
        }
        this.setAbsPos(v, bestPos);
    }

    private int calculateValue(Vertex v, int pos, int bestValue) {
        int level = v.level;
        Vertex[] nodes = this.myLevels[level];
        Link[] links = v.myLinks;
        int value = 0;
        int i_Link = 0;
        while (i_Link < links.length) {
            Vertex v1 = links[i_Link].myVertex;
            if (v1.absPos >= 0 && v1 != v) {
                int level1 = v1.level;
                int pos1 = v1.absPos;
                if (level1 == level) {
                    int d;
                    if (pos1 >= pos) {
                        ++pos1;
                    }
                    value += (d = Math.abs(pos1 - pos)) == 1 ? 0 : d + 3;
                } else {
                    int i_Pos = 0;
                    while (!nodes[i_Pos].isSelected()) {
                        Vertex vertex = nodes[i_Pos];
                        Link[] links1 = vertex.myLinks;
                        int i_Link1 = 0;
                        while (i_Link1 < links1.length) {
                            Vertex vertex1 = links1[i_Link1].myVertex;
                            if (vertex1.level == level1 && (i_Pos < pos && vertex1.absPos > pos1 || i_Pos >= pos && vertex1.absPos < pos1)) {
                                value += 10;
                            }
                            ++i_Link1;
                        }
                        ++i_Pos;
                    }
                }
                if (value > bestValue) {
                    return value;
                }
            }
            ++i_Link;
        }
        if (pos > 0 && !nodes[pos].isSelected()) {
            int i_Pos = 0;
            while (i_Pos < pos) {
                Vertex vertex = nodes[i_Pos];
                links = vertex.myLinks;
                int i_Link2 = 0;
                while (i_Link2 < links.length) {
                    int d;
                    Vertex vertex1 = links[i_Link2].myVertex;
                    if (vertex1.level == level && (d = vertex1.absPos - pos) >= 0) {
                        value += d == 0 ? 4 : 1;
                    }
                    ++i_Link2;
                }
                ++i_Pos;
            }
        }
        return value;
    }

    private void setAbsPos(Vertex v, int pos) {
        int i_Level = v.level;
        Vertex[] nodes = this.myLevels[i_Level];
        int i = nodes.length - 1;
        while (nodes[i].isSelected()) {
            if (nodes[i] == v) break;
            --i;
        }
        if (nodes[i] != v) {
            throw new RuntimeException("IAPAS004");
        }
        int j = i;
        while (j > pos) {
            nodes[j] = nodes[j - 1];
            nodes[j].absPos = j;
            --j;
        }
        nodes[pos] = v;
        v.absPos = pos;
    }
}

