/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.geometry;

import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.geometry.AddAction;
import com.tssap.selena.layout.impl.geometry.CellAction;
import com.tssap.selena.layout.impl.geometry.CheckAction;
import com.tssap.selena.layout.impl.geometry.ConflictIgnorer;
import com.tssap.selena.layout.impl.geometry.CrossPermitter;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.ElementGroup;
import com.tssap.selena.layout.impl.geometry.GRectangle;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Lattice;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.geometry.Rectangle;
import com.tssap.selena.layout.impl.geometry.RemoveAction;

public final class LinesManager {
    private Optioner myOptioner;
    private Geometer myGeometer;
    private int nLinesSpace;
    private int nRectanglesSpace;
    private int nGRectanglesSpace;
    private Lattice myPointsKeeper;
    private Lattice myLinesKeeper;
    private Lattice myRectanglesKeeper;
    private Lattice myGRectanglesKeeper;
    private AddAction myAddAction = new AddAction();
    private RemoveAction myRemoveAction = new RemoveAction();
    private CheckAction myCheckAction = new CheckAction();
    private int currentMark = 0;
    private Element lastReason = null;
    private int myFlags = 0;
    public static final int IgnorePointsWithPoint = 1;
    public static final int IgnorePointsWithLine = 2;
    public static final int IgnorePointsWithRectangle = 4;
    public static final int IgnorePointsWithGRectangle = 8;
    public static final int IgnorePoints = 15;
    public static final int IgnoreLinesWithPoint = 16;
    public static final int IgnoreLinesWithLine = 32;
    public static final int IgnoreLinesWithRectangle = 64;
    public static final int IgnoreLinesWithGRectangle = 128;
    public static final int IgnoreLines = 240;
    public static final int IgnoreRectanglesWithPoint = 256;
    public static final int IgnoreRectanglesWithLine = 512;
    public static final int IgnoreRectanglesWithRectangle = 1024;
    public static final int IgnoreRectanglesWithGRectangle = 2048;
    public static final int IgnoreRectangles = 3840;
    public static final int IgnoreGRectanglesWithPoint = 4096;
    public static final int IgnoreGRectanglesWithLine = 8192;
    public static final int IgnoreGRectanglesWithRectangle = 16384;
    public static final int IgnoreGRectanglesWithGRectangle = 32768;
    public static final int IgnoreGRectangles = 61440;
    public static final int IgnoreAddRemovePoint = 65536;
    public static final int IgnoreAddRemoveLine = 131072;
    public static final int IgnoreAddRemoveRectangle = 262144;
    public static final int IgnoreAddRemoveGRectangle = 524288;

    public LinesManager(Optioner optioner) {
        this.myOptioner = optioner;
        this.nLinesSpace = this.myOptioner.nLinesSpace;
        this.nRectanglesSpace = this.myOptioner.nRectanglesSpace;
        this.nGRectanglesSpace = this.myOptioner.nIconsSpace;
        this.myGeometer = new Geometer(this.myOptioner);
        this.myPointsKeeper = new Lattice(this.myOptioner.pointsCellSize);
        this.myLinesKeeper = new Lattice(this.myOptioner.linesCellSize);
        this.myRectanglesKeeper = new Lattice(this.myOptioner.rectanglesCellSize);
        this.myGRectanglesKeeper = new Lattice(this.myOptioner.gRectanglesCellSize);
        if (this.myOptioner.pointsCellSize <= this.nLinesSpace) {
            throw new RuntimeException("LMGR001");
        }
        if (this.myOptioner.linesCellSize <= this.nLinesSpace) {
            throw new RuntimeException("LMGR002");
        }
        if (this.myOptioner.rectanglesCellSize <= this.nLinesSpace) {
            throw new RuntimeException("LMGR003");
        }
        if (this.myOptioner.gRectanglesCellSize <= this.nLinesSpace) {
            throw new RuntimeException("LMGR004");
        }
    }

    public void assignFlags(int flags) {
        this.myFlags = flags;
        this.lastReason = null;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public void setFlags(int flags) {
        this.myFlags |= flags;
        this.lastReason = null;
    }

    public void clearFlags(int flags) {
        this.myFlags &= ~flags;
        this.lastReason = null;
    }

    public void setCrossPermitter(CrossPermitter crossPermitter) {
        this.myGeometer.setCrossPermitter(crossPermitter);
    }

    public CrossPermitter getCrossPermitter() {
        return this.myGeometer.getCrossPermitter();
    }

    public void setConflictIgnorerBefore(ConflictIgnorer conflictIgnorer) {
        this.myGeometer.setConflictIgnorerBefore(conflictIgnorer);
    }

    public ConflictIgnorer getConflictIgnorerBefore() {
        return this.myGeometer.getConflictIgnorerBefore();
    }

    public void setConflictIgnorerAfter(ConflictIgnorer conflictIgnorer) {
        this.myGeometer.setConflictIgnorerAfter(conflictIgnorer);
    }

    public ConflictIgnorer getConflictIgnorerAfter() {
        return this.myGeometer.getConflictIgnorerAfter();
    }

    public void clear() {
        this.clearPoints();
        this.clearLines();
        this.clearRectangles();
        this.clearGRectangles();
    }

    public void clearPoints() {
        this.myPointsKeeper.clear();
        this.lastReason = null;
    }

    public void clearLines() {
        this.myLinesKeeper.clear();
        this.lastReason = null;
    }

    public void clearRectangles() {
        this.myRectanglesKeeper.clear();
        this.lastReason = null;
    }

    public void clearGRectangles() {
        this.myGRectanglesKeeper.clear();
        this.lastReason = null;
    }

    public void add(Point point) {
        if ((this.myFlags & 0x10000) == 0) {
            this.myAddAction.setLattice(this.myPointsKeeper);
            this.myAddAction.setElement(point);
            this.forEachCell(point, (CellAction)this.myAddAction, true);
            point.mark = this.currentMark;
            this.lastReason = null;
        }
    }

    public void add(Line line) {
        if ((this.myFlags & 0x20000) == 0) {
            this.myAddAction.setLattice(this.myLinesKeeper);
            this.myAddAction.setElement(line);
            this.forEachCell(line, this.myAddAction);
            line.mark = this.currentMark;
            this.lastReason = null;
        }
    }

    public void add(Rectangle rectangle) {
        if ((this.myFlags & 0x40000) == 0) {
            this.myAddAction.setLattice(this.myRectanglesKeeper);
            this.myAddAction.setElement(rectangle);
            this.forEachCell(rectangle, (CellAction)this.myAddAction, true);
            rectangle.mark = this.currentMark;
            this.lastReason = null;
        }
    }

    public void add(GRectangle grect) {
        if ((this.myFlags & 0x80000) == 0) {
            this.myAddAction.setLattice(this.myGRectanglesKeeper);
            this.myAddAction.setElement(grect);
            this.forEachCell(grect, (CellAction)this.myAddAction, true);
            grect.mark = this.currentMark;
            this.lastReason = null;
        }
    }

    public void remove(Point point) {
        if ((this.myFlags & 0x10000) == 0) {
            this.myRemoveAction.setLattice(this.myPointsKeeper);
            this.myRemoveAction.setElement(point);
            this.forEachCell(point, (CellAction)this.myRemoveAction, true);
            this.lastReason = null;
        }
    }

    public void remove(Line line) {
        if ((this.myFlags & 0x20000) == 0) {
            this.myRemoveAction.setLattice(this.myLinesKeeper);
            this.myRemoveAction.setElement(line);
            this.forEachCell(line, this.myRemoveAction);
            this.lastReason = null;
        }
    }

    public void remove(Rectangle rectangle) {
        if ((this.myFlags & 0x40000) == 0) {
            this.myRemoveAction.setLattice(this.myRectanglesKeeper);
            this.myRemoveAction.setElement(rectangle);
            this.forEachCell(rectangle, (CellAction)this.myRemoveAction, true);
            this.lastReason = null;
        }
    }

    public void remove(GRectangle grect) {
        if ((this.myFlags & 0x80000) == 0) {
            this.myRemoveAction.setLattice(this.myGRectanglesKeeper);
            this.myRemoveAction.setElement(grect);
            this.forEachCell(grect, (CellAction)this.myRemoveAction, true);
            this.lastReason = null;
        }
    }

    public boolean isCorrect(Element elem) {
        if (elem instanceof Point) {
            return this.isCorrect((Point)elem);
        }
        if (elem instanceof Line) {
            return this.isCorrect((Line)elem);
        }
        if (elem instanceof Rectangle) {
            return this.isCorrect((Rectangle)elem);
        }
        if (elem instanceof GRectangle) {
            return this.isCorrect((GRectangle)elem);
        }
        if (elem instanceof ElementGroup) {
            return this.isCorrect((ElementGroup)elem);
        }
        throw new RuntimeException("LMGR005");
    }

    public boolean isCorrect(Point point) {
        ++this.currentMark;
        if (this.lastReason != null) {
            if ((this.myFlags & 0x100) != 0 && this.lastReason instanceof Rectangle || (this.myFlags & 0x10) != 0 && this.lastReason instanceof Line || (this.myFlags & 1) != 0 && this.lastReason instanceof Point || (this.myFlags & 0x1000) != 0 && this.lastReason instanceof GRectangle) {
                this.lastReason = null;
            } else {
                if (!this.myGeometer.mayCombine((Element)point, this.lastReason)) {
                    return false;
                }
                this.lastReason.mark = this.currentMark;
                this.lastReason = null;
            }
        }
        this.myCheckAction.setCurrentMark(this.currentMark);
        this.myCheckAction.setGeometer(this.myGeometer);
        this.myCheckAction.setElement(point);
        if ((this.myFlags & 0x100) == 0 && !this.myRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(point, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x10) == 0 && !this.myLinesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myLinesKeeper);
            this.myCheckAction.start();
            this.forEachCell(point, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 1) == 0 && !this.myPointsKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myPointsKeeper);
            this.myCheckAction.start();
            this.forEachCell(point, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x1000) == 0 && !this.myGRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myGRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(point, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        return true;
    }

    public boolean isCorrect(Line line) {
        ++this.currentMark;
        if (this.lastReason != null) {
            if ((this.myFlags & 0x200) != 0 && this.lastReason instanceof Rectangle || (this.myFlags & 0x20) != 0 && this.lastReason instanceof Line || (this.myFlags & 2) != 0 && this.lastReason instanceof Point || (this.myFlags & 0x2000) != 0 && this.lastReason instanceof GRectangle) {
                this.lastReason = null;
            } else {
                if (!this.myGeometer.mayCombine((Element)line, this.lastReason)) {
                    return false;
                }
                this.lastReason.mark = this.currentMark;
                this.lastReason = null;
            }
        }
        this.myCheckAction.setCurrentMark(this.currentMark);
        this.myCheckAction.setGeometer(this.myGeometer);
        this.myCheckAction.setElement(line);
        if ((this.myFlags & 0x200) == 0 && !this.myRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(line, this.myCheckAction);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x20) == 0 && !this.myLinesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myLinesKeeper);
            this.myCheckAction.start();
            this.forEachCell(line, this.myCheckAction);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 2) == 0 && !this.myPointsKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myPointsKeeper);
            this.myCheckAction.start();
            this.forEachCell(line, this.myCheckAction);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x2000) == 0 && !this.myGRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myGRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(line, this.myCheckAction);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        return true;
    }

    public boolean isCorrect(Rectangle rectangle) {
        ++this.currentMark;
        if (this.lastReason != null) {
            if ((this.myFlags & 0x400) != 0 && this.lastReason instanceof Rectangle || (this.myFlags & 0x40) != 0 && this.lastReason instanceof Line || (this.myFlags & 4) != 0 && this.lastReason instanceof Point || (this.myFlags & 0x4000) != 0 && this.lastReason instanceof GRectangle) {
                this.lastReason = null;
            } else {
                if (!this.myGeometer.mayCombine((Element)rectangle, this.lastReason)) {
                    return false;
                }
                this.lastReason.mark = this.currentMark;
                this.lastReason = null;
            }
        }
        this.myCheckAction.setCurrentMark(this.currentMark);
        this.myCheckAction.setGeometer(this.myGeometer);
        this.myCheckAction.setElement(rectangle);
        if ((this.myFlags & 0x400) == 0 && !this.myRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(rectangle, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x40) == 0 && !this.myLinesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myLinesKeeper);
            this.myCheckAction.start();
            this.forEachCell(rectangle, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 4) == 0 && !this.myPointsKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myPointsKeeper);
            this.myCheckAction.start();
            this.forEachCell(rectangle, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x4000) == 0 && !this.myGRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myGRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(rectangle, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        return true;
    }

    public boolean isCorrect(GRectangle grect) {
        ++this.currentMark;
        if (this.lastReason != null) {
            if ((this.myFlags & 0x800) != 0 && this.lastReason instanceof Rectangle || (this.myFlags & 0x80) != 0 && this.lastReason instanceof Line || (this.myFlags & 8) != 0 && this.lastReason instanceof Point || (this.myFlags & 0x8000) != 0 && this.lastReason instanceof GRectangle) {
                this.lastReason = null;
            } else {
                if (!this.myGeometer.mayCombine((Element)grect, this.lastReason)) {
                    return false;
                }
                this.lastReason.mark = this.currentMark;
                this.lastReason = null;
            }
        }
        this.myCheckAction.setCurrentMark(this.currentMark);
        this.myCheckAction.setGeometer(this.myGeometer);
        this.myCheckAction.setElement(grect);
        if ((this.myFlags & 0x800) == 0 && !this.myRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(grect, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x80) == 0 && !this.myLinesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myLinesKeeper);
            this.myCheckAction.start();
            this.forEachCell(grect, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 8) == 0 && !this.myPointsKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myPointsKeeper);
            this.myCheckAction.start();
            this.forEachCell(grect, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        if ((this.myFlags & 0x8000) == 0 && !this.myGRectanglesKeeper.isEmpty()) {
            this.myCheckAction.setLattice(this.myGRectanglesKeeper);
            this.myCheckAction.start();
            this.forEachCell(grect, (CellAction)this.myCheckAction, false);
            if (!this.myCheckAction.getContinueFlag()) {
                this.lastReason = this.myCheckAction.getReason();
                return false;
            }
        }
        return true;
    }

    public boolean isCorrect(ElementGroup group) {
        int i = 0;
        while (i < group.getElementCount()) {
            if (!this.isCorrect(group.getElement(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Element getReason() {
        return this.lastReason;
    }

    private void forEachCell(Point point, CellAction action, boolean withArea) {
        Lattice lattice = action.getLattice();
        int row = lattice.calculateRow(point.y);
        int col = lattice.calculateCol(point.x);
        action.process(row, col);
        if (!action.getContinueFlag()) {
            return;
        }
        if (withArea) {
            int cellHeight;
            int cellWidth;
            int x = lattice.calculateInnerX(point.x);
            int y = lattice.calculateInnerY(point.y);
            if (x < this.nLinesSpace) {
                action.process(row, col - 1);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
            if ((cellWidth = lattice.getCellWidth()) - x <= this.nLinesSpace) {
                action.process(row, col + 1);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
            if (y < this.nLinesSpace) {
                action.process(row - 1, col);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
            if ((cellHeight = lattice.getCellHeight()) - y <= this.nLinesSpace) {
                action.process(row + 1, col);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
            if (x < this.nLinesSpace && y < this.nLinesSpace) {
                action.process(row - 1, col - 1);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
            if (cellWidth - x <= this.nLinesSpace && y < this.nLinesSpace) {
                action.process(row - 1, col + 1);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
            if (x < this.nLinesSpace && cellHeight - y <= this.nLinesSpace) {
                action.process(row + 1, col - 1);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
            if (cellWidth - x <= this.nLinesSpace && cellHeight - y <= this.nLinesSpace) {
                action.process(row + 1, col + 1);
                if (!action.getContinueFlag()) {
                    return;
                }
            }
        }
    }

    private void forEachCell(Line line, CellAction action) {
        Lattice lattice = action.getLattice();
        int row1 = lattice.calculateRow(line.y1);
        int col1 = lattice.calculateCol(line.x1);
        int row2 = lattice.calculateRow(line.y2);
        int col2 = lattice.calculateCol(line.x2);
        action.process(row1, col1);
        int dx = line.x2 - line.x1;
        int dy = line.y2 - line.y1;
        int cellWidth = lattice.getCellWidth();
        int cellHeight = lattice.getCellHeight();
        while (action.getContinueFlag() && (row1 != row2 || col1 != col2)) {
            int y;
            int x;
            int minX;
            int x2;
            int y2;
            int minY;
            if (dx > 0 && (minY = row1 * cellHeight) <= (y2 = line.calculateIntersectionWithVertical(x2 = (col1 + 1) * cellWidth)) && y2 < minY + cellHeight) {
                action.process(row1, ++col1);
                continue;
            }
            if (dx < 0 && (minY = row1 * cellHeight) <= (y2 = line.calculateIntersectionWithVertical(x2 = col1 * cellWidth - 1)) && y2 < minY + cellHeight) {
                action.process(row1, --col1);
                continue;
            }
            if (dy > 0 && (minX = col1 * cellWidth) <= (x = line.calculateIntersectionWithHorizontal(y = (row1 + 1) * cellHeight)) && x < minX + cellWidth) {
                action.process(++row1, col1);
                continue;
            }
            if (dy < 0 && (minX = col1 * cellWidth) <= (x = line.calculateIntersectionWithHorizontal(y = row1 * cellHeight - 1)) && x < minX + cellWidth) {
                action.process(--row1, col1);
                continue;
            }
            if (dx == 0 || dy == 0) {
                throw new RuntimeException("LMGR006");
            }
            action.process(row1 += dy > 0 ? 1 : -1, col1 += dx > 0 ? 1 : -1);
        }
    }

    private void forEachCell(Rectangle rectangle, CellAction action, boolean withArea) {
        int top = rectangle.getTop();
        int bottom = rectangle.getBottom();
        int left = rectangle.getLeft();
        int right = rectangle.getRight();
        if (withArea) {
            top -= this.nRectanglesSpace;
            bottom += this.nRectanglesSpace;
            left -= this.nRectanglesSpace;
            right += this.nRectanglesSpace;
        }
        Lattice lattice = action.getLattice();
        int row1 = lattice.calculateRow(top);
        int col1 = lattice.calculateCol(left);
        int row2 = lattice.calculateRow(bottom);
        int col2 = lattice.calculateCol(right);
        int row = row1;
        while (row <= row2) {
            int col = col1;
            while (col <= col2) {
                action.process(row, col);
                if (!action.getContinueFlag()) {
                    return;
                }
                ++col;
            }
            ++row;
        }
    }

    private void forEachCell(GRectangle grect, CellAction action, boolean withArea) {
        int top = grect.getTop();
        int bottom = grect.getBottom();
        int left = grect.getLeft();
        int right = grect.getRight();
        if (withArea) {
            top -= this.nGRectanglesSpace;
            bottom += this.nGRectanglesSpace;
            left -= this.nGRectanglesSpace;
            right += this.nGRectanglesSpace;
        }
        Lattice lattice = action.getLattice();
        int row1 = lattice.calculateRow(top);
        int col1 = lattice.calculateCol(left);
        int row2 = lattice.calculateRow(bottom);
        int col2 = lattice.calculateCol(right);
        int row = row1;
        while (row <= row2) {
            int col = col1;
            while (col <= col2) {
                action.process(row, col);
                if (!action.getContinueFlag()) {
                    return;
                }
                ++col;
            }
            ++row;
        }
    }
}

