/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.geometry;

import com.tssap.selena.layout.impl.geometry.Element;

public final class Line
extends Element {
    int x1;
    int y1;
    int x2;
    int y2;

    public Line(int x1, int y1, int x2, int y2) {
        super(null);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public Line(int x1, int y1, int x2, int y2, Object obj) {
        super(obj);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void set(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void set(int x1, int y1, int x2, int y2, Object obj) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.setObject(obj);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Line) {
            Line line = (Line)obj;
            return (this.x1 == line.x1 && this.x2 == line.x2 && this.y1 == line.y1 && this.y2 == line.y2 || this.x1 == line.x2 && this.x2 == line.x1 && this.y1 == line.y2 && this.y2 == line.y1) && this.myObject == line.myObject;
        }
        return false;
    }

    public void shift(int dx, int dy) {
        this.x1 += dx;
        this.x2 += dx;
        this.y1 += dy;
        this.y2 += dy;
    }

    public void transponate() {
        int tx1 = this.x1;
        this.x1 = this.y1;
        this.y1 = tx1;
        int tx2 = this.x2;
        this.x2 = this.y2;
        this.y2 = tx2;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public int getLeft() {
        return Math.min(this.x1, this.x2);
    }

    public int getRight() {
        return Math.max(this.x1, this.x2);
    }

    public int getTop() {
        return Math.min(this.y1, this.y2);
    }

    public int getBottom() {
        return Math.max(this.y1, this.y2);
    }

    public int calculateIntersectionWithVertical(int x) {
        return this.y1 + (x - this.x1) * (this.y1 - this.y2) / (this.x1 - this.x2);
    }

    public int calculateIntersectionWithHorizontal(int y) {
        return this.x1 + (y - this.y1) * (this.x1 - this.x2) / (this.y1 - this.y2);
    }

    public String toString() {
        return "Line(" + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + (this.getObject() != null ? "," + this.getObject() + ")" : ")");
    }
}

