/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.geometry;

import com.tssap.selena.layout.impl.geometry.Cell;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.Row;
import java.util.Vector;

final class Lattice {
    private int myCellSize;
    private Vector myUpRows = null;
    private Vector myDownRows = null;
    private int myFirstRow;

    public Lattice(int cellSize) {
        this.myCellSize = cellSize;
    }

    public int calculateCol(int x) {
        return x >= 0 ? x / this.myCellSize : -((-x - 1) / this.myCellSize) - 1;
    }

    public int calculateRow(int y) {
        return y >= 0 ? y / this.myCellSize : -((-y - 1) / this.myCellSize) - 1;
    }

    public int calculateInnerX(int x) {
        return x >= 0 ? x % this.myCellSize : this.myCellSize - 1 - (-x - 1) % this.myCellSize;
    }

    public int calculateInnerY(int y) {
        return y >= 0 ? y % this.myCellSize : this.myCellSize - 1 - (-y - 1) % this.myCellSize;
    }

    public int getCellWidth() {
        return this.myCellSize;
    }

    public int getCellHeight() {
        return this.myCellSize;
    }

    public void clear() {
        this.myUpRows = null;
        this.myDownRows = null;
    }

    public boolean isEmpty() {
        return this.myDownRows == null;
    }

    public void add(Element element, int row, int col) {
        if (this.myDownRows == null) {
            this.myDownRows = new Vector();
            this.myFirstRow = row;
        }
        if ((row -= this.myFirstRow) >= 0) {
            while (this.myDownRows.size() <= row) {
                this.myDownRows.add(null);
            }
            if (this.myDownRows.get(row) == null) {
                this.myDownRows.set(row, new Row());
            }
            ((Row)this.myDownRows.get(row)).add(element, col);
        } else {
            row = -row - 1;
            if (this.myUpRows == null) {
                this.myUpRows = new Vector();
            }
            while (this.myUpRows.size() <= row) {
                this.myUpRows.add(null);
            }
            if (this.myUpRows.get(row) == null) {
                this.myUpRows.set(row, new Row());
            }
            ((Row)this.myUpRows.get(row)).add(element, col);
        }
    }

    public void remove(Element element, int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            throw new RuntimeException("LATT001");
        }
        cell.remove(element);
    }

    public Cell getCell(int row, int col) {
        if (this.myDownRows == null) {
            return null;
        }
        if ((row -= this.myFirstRow) >= 0) {
            if (row >= this.myDownRows.size()) {
                return null;
            }
            Row r = (Row)this.myDownRows.get(row);
            if (r == null) {
                return null;
            }
            return r.getCell(col);
        }
        if (this.myUpRows == null) {
            return null;
        }
        if ((row = -row - 1) >= this.myUpRows.size()) {
            return null;
        }
        Row r = (Row)this.myUpRows.get(row);
        if (r == null) {
            return null;
        }
        return r.getCell(col);
    }
}

