/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.geometry;

import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.geometry.CannotShiftException;
import com.tssap.selena.layout.impl.geometry.ConflictIgnorer;
import com.tssap.selena.layout.impl.geometry.CrossPermitter;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.GRectangle;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.geometry.Rectangle;

public final class Geometer {
    public static final int UnknownDirection = 0;
    public static final int UpDirection = 1;
    public static final int DownDirection = 2;
    public static final int LeftDirection = 3;
    public static final int RightDirection = 4;
    private int nLinesSpace;
    private int nRectanglesSpace;
    private int nGRectanglesSpace;
    private CrossPermitter myCrossPermitter = null;
    private ConflictIgnorer myConflictIgnorerBefore = null;
    private ConflictIgnorer myConflictIgnorerAfter = null;
    private Point myPoint = new Point(0, 0, null);
    private Line myLine = new Line(0, 0, 0, 0, null);
    private Rectangle myRectangle = new Rectangle(0, 0, 0, 0, null);
    private GRectangle myGRectangle = new GRectangle(0, 0, 0, 0, 0.0f, 0.0f, null);

    public Geometer(Optioner optioner) {
        this.nLinesSpace = optioner.nLinesSpace;
        this.nRectanglesSpace = optioner.nRectanglesSpace;
        this.nGRectanglesSpace = optioner.nIconsSpace;
    }

    public void setCrossPermitter(CrossPermitter crossPermitter) {
        this.myCrossPermitter = crossPermitter;
    }

    public CrossPermitter getCrossPermitter() {
        return this.myCrossPermitter;
    }

    public void setConflictIgnorerBefore(ConflictIgnorer conflictIgnorer) {
        this.myConflictIgnorerBefore = conflictIgnorer;
    }

    public ConflictIgnorer getConflictIgnorerBefore() {
        return this.myConflictIgnorerBefore;
    }

    public void setConflictIgnorerAfter(ConflictIgnorer conflictIgnorer) {
        this.myConflictIgnorerAfter = conflictIgnorer;
    }

    public ConflictIgnorer getConflictIgnorerAfter() {
        return this.myConflictIgnorerAfter;
    }

    public void shiftOnePointForOK(Point p1, Point p2, Rectangle rect, int direction) throws CannotShiftException {
        int right;
        int left;
        int top;
        int y2;
        int x2;
        int y1;
        int x1;
        switch (direction) {
            case 1: {
                x1 = p1.x;
                y1 = p1.y;
                x2 = p2.x;
                y2 = p2.y;
                top = rect.getTop() - this.nRectanglesSpace;
                left = rect.getLeft() - this.nRectanglesSpace;
                right = rect.getRight() + this.nRectanglesSpace;
                break;
            }
            case 2: {
                x1 = p1.x;
                y1 = -p1.y;
                x2 = p2.x;
                y2 = -p2.y;
                top = -rect.getBottom() - this.nRectanglesSpace;
                left = rect.getLeft() - this.nRectanglesSpace;
                right = rect.getRight() + this.nRectanglesSpace;
                break;
            }
            case 3: {
                x1 = p1.y;
                y1 = p1.x;
                x2 = p2.y;
                y2 = p2.x;
                top = rect.getLeft() - this.nRectanglesSpace;
                left = rect.getTop() - this.nRectanglesSpace;
                right = rect.getBottom() + this.nRectanglesSpace;
                break;
            }
            case 4: {
                x1 = p1.y;
                y1 = -p1.x;
                x2 = p2.y;
                y2 = -p2.x;
                top = -rect.getRight() - this.nRectanglesSpace;
                left = rect.getTop() - this.nRectanglesSpace;
                right = rect.getBottom() + this.nRectanglesSpace;
                break;
            }
            default: {
                throw new RuntimeException("GEOM001");
            }
        }
        int y = x1 <= left ? (y2 <= top ? Geometer.calculateIntersectionWithVertical(x2, y2, left, top, x1) : Geometer.calculateIntersectionWithVertical(x2, y2, right, top, x1)) : (x1 >= right ? (y2 <= top ? Geometer.calculateIntersectionWithVertical(x2, y2, right, top, x1) : Geometer.calculateIntersectionWithVertical(x2, y2, left, top, x1)) : (y2 > top ? (x2 <= left ? Geometer.calculateIntersectionWithVertical(x2, y2, left, top, x1) : (x2 >= right ? Geometer.calculateIntersectionWithVertical(x2, y2, right, top, x1) : top)) : top));
        if (--y >= y1) {
            throw new CannotShiftException();
        }
        switch (direction) {
            case 1: {
                p1.y = y;
                break;
            }
            case 2: {
                p1.y = -y;
                break;
            }
            case 3: {
                p1.x = y;
                break;
            }
            case 4: {
                p1.x = -y;
            }
        }
    }

    public void shiftOnePointForOK(Point p1, Point p2, GRectangle grect, int direction) throws CannotShiftException {
        int space = this.nGRectanglesSpace - this.nRectanglesSpace;
        this.myRectangle.set(grect.getLeft() - space, grect.getTop() - space, grect.calculateMaxWidth() + 2 * space, grect.calculateMaxHeight() + 2 * space, null);
        this.shiftOnePointForOK(p1, p2, this.myRectangle, direction);
    }

    public void shiftOnePointForOK(Point p1, Point p2, Point p3, int direction) throws CannotShiftException {
        int space = this.nLinesSpace - this.nRectanglesSpace;
        this.myRectangle.set(p3.x - space, p3.y - space, 2 * space, 2 * space, null);
        this.shiftOnePointForOK(p1, p2, this.myRectangle, direction);
    }

    public void shiftPointForOK(Point p1, Point p2, int direction) {
        int y2;
        int x2;
        int y1;
        int x1;
        switch (direction) {
            case 1: {
                x1 = p1.x;
                y1 = p1.y;
                x2 = p2.x;
                y2 = p2.y;
                break;
            }
            case 2: {
                x1 = p1.x;
                y1 = -p1.y;
                x2 = p2.x;
                y2 = -p2.y;
                break;
            }
            case 3: {
                x1 = p1.y;
                y1 = p1.x;
                x2 = p2.y;
                y2 = p2.x;
                break;
            }
            case 4: {
                x1 = p1.y;
                y1 = -p1.x;
                x2 = p2.y;
                y2 = -p2.x;
                break;
            }
            default: {
                throw new RuntimeException("GEM002");
            }
        }
        int y = y2 - (int)Math.ceil(Math.sqrt(this.nLinesSpace * this.nLinesSpace - (x1 - x2) * (x1 - x2)));
        if (y >= y1) {
            throw new RuntimeException("GEOM003");
        }
        switch (direction) {
            case 1: {
                p1.y = y;
                break;
            }
            case 2: {
                p1.y = -y;
                break;
            }
            case 3: {
                p1.x = y;
                break;
            }
            case 4: {
                p1.x = -y;
            }
        }
    }

    public void shiftPointForOK(Point p, Line line, int direction) {
        int y;
        int y3;
        int x3;
        int y2;
        int x2;
        int y1;
        int x1;
        switch (direction) {
            case 1: {
                x1 = p.x;
                y1 = p.y;
                x2 = line.getX1();
                y2 = line.getY1();
                x3 = line.getX2();
                y3 = line.getY2();
                break;
            }
            case 2: {
                x1 = p.x;
                y1 = -p.y;
                x2 = line.getX1();
                y2 = -line.getY1();
                x3 = line.getX2();
                y3 = -line.getY2();
                break;
            }
            case 3: {
                x1 = p.y;
                y1 = p.x;
                x2 = line.getY1();
                y2 = line.getX1();
                x3 = line.getY2();
                y3 = line.getX2();
                break;
            }
            case 4: {
                x1 = p.y;
                y1 = -p.x;
                x2 = line.getY1();
                y2 = -line.getX1();
                x3 = line.getY2();
                y3 = -line.getX2();
                break;
            }
            default: {
                throw new RuntimeException("GEOM004");
            }
        }
        if (x2 == x3) {
            int upy = Math.min(y2, y3);
            y = upy - (int)Math.ceil(Math.sqrt(this.nLinesSpace * this.nLinesSpace - (x1 - x2) * (x1 - x2)));
        } else {
            int righty;
            int rightx;
            int lefty;
            int leftx;
            if (x2 < x3) {
                leftx = x2;
                lefty = y2;
                rightx = x3;
                righty = y3;
            } else {
                leftx = x3;
                lefty = y3;
                rightx = x2;
                righty = y2;
            }
            int dx = leftx - rightx;
            int dy = lefty - righty;
            double t = (double)this.nLinesSpace / Math.sqrt(dx * dx + dy * dy);
            int shiftx = -((int)Math.round(t * (double)dy));
            int shifty = (int)Math.floor(t * (double)dx);
            int leftx1 = leftx + shiftx;
            int lefty1 = lefty + shifty;
            int rightx1 = rightx + shiftx;
            int righty1 = righty + shifty;
            y = x1 < leftx1 ? lefty - (int)Math.ceil(Math.sqrt(this.nLinesSpace * this.nLinesSpace - (x1 - leftx) * (x1 - leftx))) : (x1 > rightx1 ? righty - (int)Math.ceil(Math.sqrt(this.nLinesSpace * this.nLinesSpace - (x1 - rightx) * (x1 - rightx))) : Geometer.calculateIntersectionWithVertical(leftx1, lefty1, rightx1, righty1, x1) - 1);
        }
        if (--y >= y1) {
            System.out.println("Cannot resolve shift: " + String.valueOf(y) + " " + String.valueOf(y1));
            y = y1 - 1;
        }
        switch (direction) {
            case 1: {
                p.y = y;
                break;
            }
            case 2: {
                p.y = -y;
                break;
            }
            case 3: {
                p.x = y;
                break;
            }
            case 4: {
                p.x = -y;
            }
        }
    }

    public void shiftPointForOK(Point p, GRectangle grect, int direction) {
        switch (direction) {
            case 1: {
                int y = grect.getTop() - this.nGRectanglesSpace;
                if (p.y <= y) {
                    throw new RuntimeException("GEOM005");
                }
                p.y = y;
                break;
            }
            case 2: {
                int y = grect.getBottom() + this.nGRectanglesSpace;
                if (p.y >= y) {
                    throw new RuntimeException("GEOM006");
                }
                p.y = y;
                break;
            }
            case 3: {
                int x = grect.getLeft() - this.nGRectanglesSpace;
                if (p.x <= x) {
                    throw new RuntimeException("GEOM007");
                }
                p.x = x;
                break;
            }
            case 4: {
                int x = grect.getRight() + this.nGRectanglesSpace;
                if (p.x >= x) {
                    throw new RuntimeException("GEOM008");
                }
                p.x = x;
                break;
            }
            default: {
                throw new RuntimeException("GEOM009");
            }
        }
    }

    public void shiftOnePointForNotCross(Point p1, Point p2, Line line, int direction) throws CannotShiftException {
        int y;
        int y4;
        int x4;
        int y3;
        int x3;
        int y2;
        int x2;
        int y1;
        int x1;
        switch (direction) {
            case 1: {
                x1 = p1.x;
                y1 = p1.y;
                x2 = p2.x;
                y2 = p2.y;
                x3 = line.getX1();
                y3 = line.getY1();
                x4 = line.getX2();
                y4 = line.getY2();
                break;
            }
            case 2: {
                x1 = p1.x;
                y1 = -p1.y;
                x2 = p2.x;
                y2 = -p2.y;
                x3 = line.getX1();
                y3 = -line.getY1();
                x4 = line.getX2();
                y4 = -line.getY2();
                break;
            }
            case 3: {
                x1 = p1.y;
                y1 = p1.x;
                x2 = p2.y;
                y2 = p2.x;
                x3 = line.getY1();
                y3 = line.getX1();
                x4 = line.getY2();
                y4 = line.getX2();
                break;
            }
            case 4: {
                x1 = p1.y;
                y1 = -p1.x;
                x2 = p2.y;
                y2 = -p2.x;
                x3 = line.getY1();
                y3 = -line.getX1();
                x4 = line.getY2();
                y4 = -line.getX2();
                break;
            }
            default: {
                throw new RuntimeException("GEOM010");
            }
        }
        if (x3 == x4) {
            int miny = Math.min(y3, y4);
            y = x1 == x2 ? miny : Geometer.calculateIntersectionWithVertical(x2, y2, x3, miny, x1);
        } else {
            int yy;
            int righty;
            int rightx;
            int lefty;
            int leftx;
            if (x3 < x4) {
                leftx = x3;
                lefty = y3;
                rightx = x4;
                righty = y4;
            } else {
                leftx = x4;
                lefty = y4;
                rightx = x3;
                righty = y3;
            }
            if (leftx <= x2 && x2 <= rightx && (yy = Geometer.calculateIntersectionWithVertical(x3, y3, x4, y4, x2)) <= y2) {
                throw new CannotShiftException();
            }
            y = Integer.MAX_VALUE;
            if (leftx <= x1 && x1 <= rightx) {
                y = Geometer.calculateIntersectionWithVertical(x3, y3, x4, y4, x1);
            }
            if (y > y1) {
                y = x1 < leftx && x2 <= rightx || x2 < leftx && x1 <= rightx ? Geometer.calculateIntersectionWithVertical(x2, y2, leftx, lefty, x1) : (x1 > rightx && x2 >= leftx || x2 > rightx && x1 >= leftx ? Geometer.calculateIntersectionWithVertical(x2, y2, rightx, righty, x1) : ((yy = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, x3)) >= y3 ? Geometer.calculateIntersectionWithVertical(x2, y2, x3, y3, x1) : Geometer.calculateIntersectionWithVertical(x2, y2, x4, y4, x1)));
            }
        }
        if (--y >= y1) {
            throw new CannotShiftException();
        }
        switch (direction) {
            case 1: {
                p1.y = y;
                break;
            }
            case 2: {
                p1.y = -y;
                break;
            }
            case 3: {
                p1.x = y;
                break;
            }
            case 4: {
                p1.x = -y;
            }
        }
    }

    public void shiftLineForOK(Line line, Point p, int direction) {
        int antiDir;
        switch (direction) {
            case 1: {
                antiDir = 2;
                break;
            }
            case 2: {
                antiDir = 1;
                break;
            }
            case 3: {
                antiDir = 4;
                break;
            }
            case 4: {
                antiDir = 3;
                break;
            }
            default: {
                throw new RuntimeException("GEOM011");
            }
        }
        this.myPoint.set(p.x, p.y, null);
        this.shiftPointForOK(this.myPoint, line, antiDir);
        int dx = this.myPoint.x - p.x;
        int dy = this.myPoint.y - p.y;
        line.shift(-dx, -dy);
    }

    public void shiftLineForNotCross(Line l1, Line l2, int direction) {
        int shift;
        int y4;
        int x4;
        int y3;
        int x3;
        int y2;
        int x2;
        int y1;
        int x1;
        switch (direction) {
            case 1: {
                x1 = l1.getX1();
                y1 = l1.getY1();
                x2 = l1.getX2();
                y2 = l1.getY2();
                x3 = l2.getX1();
                y3 = l2.getY1();
                x4 = l2.getX2();
                y4 = l2.getY2();
                break;
            }
            case 2: {
                x1 = l1.getX1();
                y1 = -l1.getY1();
                x2 = l1.getX2();
                y2 = -l1.getY2();
                x3 = l2.getX1();
                y3 = -l2.getY1();
                x4 = l2.getX2();
                y4 = -l2.getY2();
                break;
            }
            case 3: {
                x1 = l1.getY1();
                y1 = l1.getX1();
                x2 = l1.getY2();
                y2 = l1.getX2();
                x3 = l2.getY1();
                y3 = l2.getX1();
                x4 = l2.getY2();
                y4 = l2.getX2();
                break;
            }
            case 4: {
                x1 = l1.getY1();
                y1 = -l1.getX1();
                x2 = l1.getY2();
                y2 = -l1.getX2();
                x3 = l2.getY1();
                y3 = -l2.getX1();
                x4 = l2.getY2();
                y4 = -l2.getX2();
                break;
            }
            default: {
                throw new RuntimeException("GEOM012");
            }
        }
        if (x1 == x2) {
            if (x3 == x4) {
                shift = Math.max(y3, y4) - Math.min(y1, y2);
            } else {
                int y = Geometer.calculateIntersectionWithVertical(x3, y3, x4, y4, x1);
                shift = y - Math.min(y1, y2);
            }
        } else {
            int righty;
            int rightx;
            int lefty;
            int leftx;
            int yy;
            int xx;
            int d;
            int nx = y2 - y1;
            int ny = x1 - x2;
            if (ny > 0) {
                nx = -nx;
                ny = -ny;
            }
            if ((d = nx * (x4 - x3) + ny * (y4 - y3)) > 0) {
                xx = x4;
                yy = y4;
            } else if (d < 0) {
                xx = x3;
                yy = y3;
            } else {
                throw new RuntimeException("GEOM013");
            }
            if (x1 < x2) {
                leftx = x1;
                lefty = y1;
                rightx = x2;
                righty = y2;
            } else {
                leftx = x2;
                lefty = y2;
                rightx = x1;
                righty = y1;
            }
            shift = leftx <= xx ? (xx <= rightx ? yy - Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, xx) : Geometer.calculateIntersectionWithVertical(x3, y3, x4, y4, rightx) - righty) : Geometer.calculateIntersectionWithVertical(x3, y3, x4, y4, leftx) - lefty;
        }
        if (--shift >= 0) {
            throw new RuntimeException("GEOM014");
        }
        switch (direction) {
            case 1: {
                l1.shift(0, shift);
                break;
            }
            case 2: {
                l1.shift(0, -shift);
                break;
            }
            case 3: {
                l1.shift(shift, 0);
                break;
            }
            case 4: {
                l1.shift(-shift, 0);
            }
        }
    }

    public static int calculateIntersectionWithVertical(int x1, int y1, int x2, int y2, int x) {
        int desc = x1 - x2;
        if (desc == 0) {
            return y1 + 2;
        }
        return y1 + (x - x1) * (y1 - y2) / desc;
    }

    public static int calculateIntersectionWithHorizontal(int x1, int y1, int x2, int y2, int y) {
        int desc = y1 - y2;
        if (desc == 0) {
            return x1 + 2;
        }
        return x1 + (y - y1) * (x1 - x2) / desc;
    }

    public static float calculateIntersectionWithVertical(float x1, float y1, float x2, float y2, float x) {
        float desc = x1 - x2;
        if (desc == 0.0f) {
            return y1 + 2.0f;
        }
        return y1 + (x - x1) * (y1 - y2) / desc;
    }

    public static float calculateIntersectionWithHorizontal(float x1, float y1, float x2, float y2, float y) {
        float desc = y1 - y2;
        if (desc == 0.0f) {
            return x1 + 2.0f;
        }
        return x1 + (y - y1) * (x1 - x2) / desc;
    }

    public static boolean lineCrossLine(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int a1 = x1 - x2;
        int b1 = x4 - x3;
        int c1 = x4 - x2;
        int a2 = y1 - y2;
        int b2 = y4 - y3;
        int c2 = y4 - y2;
        int D = a1 * b2 - a2 * b1;
        if (D == 0) {
            return false;
        }
        double t1 = (double)(b2 * c1 - b1 * c2) / (double)D;
        if (t1 < 0.0 || t1 > 1.0) {
            return false;
        }
        double t2 = (double)(a1 * c2 - a2 * c1) / (double)D;
        return !(t2 < 0.0) && !(t2 > 1.0);
    }

    public static Point calculateCrossPoint(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int a1 = x1 - x2;
        int b1 = x4 - x3;
        int c1 = x4 - x2;
        int a2 = y1 - y2;
        int b2 = y4 - y3;
        int c2 = y4 - y2;
        int D = a1 * b2 - a2 * b1;
        if (D == 0) {
            return null;
        }
        double t1 = (double)(b2 * c1 - b1 * c2) / (double)D;
        if (t1 < 0.0 || t1 > 1.0) {
            return null;
        }
        double t2 = (double)(a1 * c2 - a2 * c1) / (double)D;
        if (t2 < 0.0 || t2 > 1.0) {
            return null;
        }
        return new Point((int)Math.round((double)x1 * t1 + (double)x2 * (1.0 - t1)), (int)Math.round((double)y1 * t1 + (double)y2 * (1.0 - t1)));
    }

    public static boolean lineCrossRectangle(Line l, Rectangle r) {
        return Geometer.lineCrossRectangle(l.getX1(), l.getY1(), l.getX2(), l.getY2(), r.getLeft(), r.getTop(), r.getRight(), r.getBottom());
    }

    public static boolean lineCrossRectangle(int x1, int y1, int x2, int y2, int left, int top, int right, int bottom) {
        int leftRight2;
        int upDown2;
        int leftRight1;
        int upDown1;
        int n = y1 <= top ? -1 : (upDown1 = y1 >= bottom ? 1 : 0);
        int n2 = x1 <= left ? -1 : (leftRight1 = x1 >= right ? 1 : 0);
        int n3 = y2 <= top ? -1 : (upDown2 = y2 >= bottom ? 1 : 0);
        int n4 = x2 <= left ? -1 : (leftRight2 = x2 >= right ? 1 : 0);
        if (upDown1 == 0 && leftRight1 == 0) {
            return upDown2 != 0 || leftRight2 != 0;
        }
        if (upDown2 == 0 && leftRight2 == 0) {
            return true;
        }
        if (upDown1 == upDown2) {
            if (upDown1 == 0 && leftRight1 != leftRight2) {
                return true;
            }
        } else if (leftRight1 == leftRight2) {
            if (leftRight1 == 0) {
                return true;
            }
        } else {
            int x;
            int y;
            if ((leftRight1 < 0 || leftRight2 < 0) && top < (y = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, left)) && y < bottom) {
                return true;
            }
            if ((leftRight1 > 0 || leftRight2 > 0) && top < (y = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, right)) && y < bottom) {
                return true;
            }
            if ((upDown1 < 0 || upDown2 < 0) && left < (x = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, top)) && x < right) {
                return true;
            }
            if ((upDown1 > 0 || upDown2 > 0) && left < (x = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, bottom)) && x < right) {
                return true;
            }
        }
        return false;
    }

    public static Point calculateCrossPoint(Point p1, Point p2, Rectangle rect) {
        int x;
        int y;
        boolean inside;
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        int l = rect.getLeft();
        int r = rect.getRight();
        int t = rect.getTop();
        int b = rect.getBottom();
        boolean bl = inside = l <= x1 && x1 <= r && t <= y1 && y1 <= b;
        if ((x1 < l && x2 >= l || inside && x2 < l) && t <= (y = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, l)) && y <= b) {
            return new Point(l, y);
        }
        if ((x1 > r && x2 <= r || inside && x2 > r) && t <= (y = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, r)) && y <= b) {
            return new Point(r, y);
        }
        if ((y1 < t && y2 >= t || inside && y2 < t) && l <= (x = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, t)) && x <= r) {
            return new Point(x, t);
        }
        if ((y1 > b && y2 <= b || inside && y2 > b) && l <= (x = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, b)) && x <= r) {
            return new Point(x, b);
        }
        return null;
    }

    public static boolean lineCrossGRectangle(Line l, GRectangle grect) {
        int y2;
        int x2;
        int y1;
        int x1;
        int x0 = grect.x;
        int y0 = grect.y;
        float sin = grect.sin;
        float cos = grect.cos;
        if (sin != 0.0f || cos != 1.0f) {
            int xx1 = l.x1 - x0;
            int yy1 = l.y1 - y0;
            int xx2 = l.x2 - x0;
            int yy2 = l.y2 - y0;
            x1 = Math.round((float)x0 + (float)xx1 * cos + (float)yy1 * sin);
            y1 = Math.round((float)y0 - (float)xx1 * sin + (float)yy1 * cos);
            x2 = Math.round((float)x0 + (float)xx2 * cos + (float)yy2 * sin);
            y2 = Math.round((float)y0 - (float)xx2 * sin + (float)yy2 * cos);
        } else {
            x1 = l.getX1();
            y1 = l.getY1();
            x2 = l.getX2();
            y2 = l.getY2();
        }
        return Geometer.lineCrossRectangle(x1, y1, x2, y2, x0, y0, x0 + grect.w, x0 + grect.h);
    }

    public boolean mayCombine(Element elem1, Element elem2) {
        if (this.myConflictIgnorerBefore != null && this.myConflictIgnorerBefore.ignoreConflict(elem1, elem2)) {
            return true;
        }
        boolean reply = true;
        if (elem1 instanceof Line) {
            if (elem2 instanceof Line) {
                reply = this.mayCombine((Line)elem1, (Line)elem2);
            } else if (elem2 instanceof Point) {
                reply = this.mayCombine((Line)elem1, (Point)elem2);
            } else if (elem2 instanceof Rectangle) {
                reply = this.mayCombine((Line)elem1, (Rectangle)elem2);
            } else if (elem2 instanceof GRectangle) {
                reply = this.mayCombine((Line)elem1, (GRectangle)elem2);
            }
        } else if (elem1 instanceof Point) {
            if (elem2 instanceof Line) {
                reply = this.mayCombine((Point)elem1, (Line)elem2);
            } else if (elem2 instanceof Point) {
                reply = this.mayCombine((Point)elem1, (Point)elem2);
            } else if (elem2 instanceof Rectangle) {
                reply = this.mayCombine((Point)elem1, (Rectangle)elem2);
            } else if (elem2 instanceof GRectangle) {
                reply = this.mayCombine((Point)elem1, (GRectangle)elem2);
            }
        } else if (elem1 instanceof Rectangle) {
            if (elem2 instanceof Line) {
                reply = this.mayCombine((Rectangle)elem1, (Line)elem2);
            } else if (elem2 instanceof Point) {
                reply = this.mayCombine((Rectangle)elem1, (Point)elem2);
            } else if (elem2 instanceof Rectangle) {
                reply = this.mayCombine((Rectangle)elem1, (Rectangle)elem2);
            } else if (elem2 instanceof GRectangle) {
                reply = this.mayCombine((Rectangle)elem1, (GRectangle)elem2);
            }
        } else if (elem1 instanceof GRectangle) {
            if (elem2 instanceof Line) {
                reply = this.mayCombine((GRectangle)elem1, (Line)elem2);
            } else if (elem2 instanceof Point) {
                reply = this.mayCombine((GRectangle)elem1, (Point)elem2);
            } else if (elem2 instanceof Rectangle) {
                reply = this.mayCombine((GRectangle)elem1, (Rectangle)elem2);
            } else if (elem2 instanceof GRectangle) {
                reply = this.mayCombine((GRectangle)elem1, (GRectangle)elem2);
            }
        } else {
            throw new RuntimeException("GEOM015");
        }
        if (!reply && this.myConflictIgnorerAfter != null && this.myConflictIgnorerAfter.ignoreConflict(elem1, elem2)) {
            return true;
        }
        return reply;
    }

    private boolean mayCombine(Point p1, Point p2) {
        int dx = p1.x - p2.x;
        if (Math.abs(dx) >= this.nLinesSpace) {
            return true;
        }
        int dy = p1.y - p2.y;
        if (Math.abs(dy) >= this.nLinesSpace) {
            return true;
        }
        return dx * dx + dy * dy >= this.nLinesSpace * this.nLinesSpace;
    }

    private boolean mayCombine(Point p, Line l) {
        int x;
        int x2 = l.x2;
        int x0 = p.x;
        int x1 = l.x1;
        int dx = x2 - x1;
        int y2 = l.y2;
        int y0 = p.y;
        int y1 = l.y1;
        int dy = y2 - y1;
        double t = (double)((x2 - x0) * dx + (y2 - y0) * dy) / (double)(dx * dx + dy * dy);
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        if (Math.abs(dx = (x = (int)Math.round((double)x1 * t + (double)x2 * (1.0 - t))) - x0) >= this.nLinesSpace) {
            return true;
        }
        int y = (int)Math.round((double)y1 * t + (double)y2 * (1.0 - t));
        dy = y - y0;
        if (Math.abs(dy) >= this.nLinesSpace) {
            return true;
        }
        return dx * dx + dy * dy >= this.nLinesSpace * this.nLinesSpace;
    }

    private boolean mayCombine(Line l, Point p) {
        return this.mayCombine(p, l);
    }

    private boolean mayCombine(Line l1, Line l2) {
        if (this.myCrossPermitter == null) {
            return true;
        }
        if (!Geometer.lineCrossLine(l1.x1, l1.y1, l1.x2, l1.y2, l2.x1, l2.y1, l2.x2, l2.y2)) {
            return true;
        }
        return this.myCrossPermitter.permitCrossing(l1, l2);
    }

    private boolean mayCombine(Point p, Rectangle r) {
        int x = p.x;
        int y = p.y;
        return r.getLeft() - this.nRectanglesSpace >= x || x >= r.getRight() + this.nRectanglesSpace || r.getTop() - this.nRectanglesSpace >= y || y >= r.getBottom() + this.nRectanglesSpace;
    }

    private boolean mayCombine(Rectangle r, Point p) {
        return this.mayCombine(p, r);
    }

    private boolean mayCombine(Line l, Rectangle r) {
        return !Geometer.lineCrossRectangle(l.getX1(), l.getY1(), l.getX2(), l.getY2(), r.getLeft() - this.nRectanglesSpace, r.getTop() - this.nRectanglesSpace, r.getRight() + this.nRectanglesSpace, r.getBottom() + this.nRectanglesSpace);
    }

    private boolean mayCombine(Rectangle r, Line l) {
        return this.mayCombine(l, r);
    }

    private boolean mayCombine(Rectangle r1, Rectangle r2) {
        if (r1.getLeft() - r2.getRight() >= this.nRectanglesSpace) {
            return true;
        }
        if (r2.getLeft() - r1.getRight() >= this.nRectanglesSpace) {
            return true;
        }
        if (r1.getTop() - r2.getBottom() >= this.nRectanglesSpace) {
            return true;
        }
        return r2.getTop() - r1.getBottom() >= this.nRectanglesSpace;
    }

    private boolean mayCombine(Point p, GRectangle grect) {
        int x0 = grect.x;
        int y0 = grect.y;
        float sin = grect.sin;
        float cos = grect.cos;
        if (sin != 0.0f || cos != 1.0f) {
            int xx = p.x - x0;
            int yy = p.y - y0;
            int x = Math.round((float)x0 + (float)xx * cos + (float)yy * sin);
            int y = Math.round((float)y0 - (float)xx * sin + (float)yy * cos);
            this.myPoint.set(x, y, p.getObject());
            p = this.myPoint;
        }
        int temp = this.nRectanglesSpace;
        this.nRectanglesSpace = this.nGRectanglesSpace;
        this.myRectangle.set(x0, y0, grect.w, grect.h, null);
        boolean reply = this.mayCombine(p, this.myRectangle);
        this.nRectanglesSpace = temp;
        return reply;
    }

    private boolean mayCombine(GRectangle grect, Point p) {
        return this.mayCombine(p, grect);
    }

    private boolean mayCombine(Line l, GRectangle grect) {
        this.myGRectangle.set(grect.getLeft() - this.nGRectanglesSpace, grect.getTop() - this.nGRectanglesSpace, grect.getWidth() + 2 * this.nGRectanglesSpace, grect.getHeight() + 2 * this.nGRectanglesSpace, grect.getSin(), grect.getCos(), grect.getObject());
        return !Geometer.lineCrossGRectangle(l, this.myGRectangle);
    }

    private boolean mayCombine(GRectangle grect, Line l) {
        return this.mayCombine(l, grect);
    }

    private boolean mayCombine(Rectangle r, GRectangle grect) {
        int space = Math.max(this.nRectanglesSpace, this.nGRectanglesSpace);
        if (grect.getLeft() - r.getRight() >= space) {
            return true;
        }
        if (r.getLeft() - grect.getRight() >= space) {
            return true;
        }
        if (grect.getTop() - r.getBottom() >= space) {
            return true;
        }
        if (r.getTop() - grect.getBottom() >= space) {
            return true;
        }
        if (grect.sin == 0.0f && grect.cos == 1.0f) {
            return false;
        }
        int temp = this.nLinesSpace;
        this.nLinesSpace = space;
        int x1 = grect.calculateX1();
        int y1 = grect.calculateY1();
        this.myPoint.set(x1, y1, null);
        if (!this.mayCombine(this.myPoint, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        int x2 = grect.calculateX2();
        int y2 = grect.calculateY2();
        this.myPoint.set(x2, y2, null);
        if (!this.mayCombine(this.myPoint, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        int x3 = grect.calculateX3();
        int y3 = grect.calculateY3();
        this.myPoint.set(x3, y3, null);
        if (!this.mayCombine(this.myPoint, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        int x4 = grect.calculateX4();
        int y4 = grect.calculateY4();
        this.myPoint.set(x4, y4, null);
        if (!this.mayCombine(this.myPoint, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        this.myLine.set(x1, y1, x2, y2, null);
        if (!this.mayCombine(this.myLine, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        this.myLine.set(x2, y2, x3, y3, null);
        if (!this.mayCombine(this.myLine, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        this.myLine.set(x3, y3, x4, y4, null);
        if (!this.mayCombine(this.myLine, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        this.myLine.set(x4, y4, x1, y1, null);
        if (!this.mayCombine(this.myLine, r)) {
            this.nLinesSpace = temp;
            return false;
        }
        this.nLinesSpace = temp;
        return true;
    }

    private boolean mayCombine(GRectangle grect, Rectangle r) {
        return this.mayCombine(r, grect);
    }

    private boolean mayCombine(GRectangle grect1, GRectangle grect2) {
        float sin1 = grect1.sin;
        float cos1 = grect1.cos;
        float sin2 = grect2.sin;
        float cos2 = grect2.cos;
        int x0 = grect1.x;
        int y0 = grect1.y;
        int xx = grect2.x - x0;
        int yy = grect2.y - y0;
        int x = Math.round((float)x0 + (float)xx * cos1 + (float)yy * sin1);
        int y = Math.round((float)y0 - (float)xx * sin1 + (float)yy * cos1);
        int temp = this.nRectanglesSpace;
        this.nRectanglesSpace = this.nGRectanglesSpace;
        this.myRectangle.set(x0, y0, grect1.w, grect1.h, null);
        this.myGRectangle.set(x, y, grect2.w, grect2.h, sin2 * cos1 - sin1 * cos2, cos1 * cos2 + sin1 * sin2);
        boolean reply = this.mayCombine(this.myRectangle, this.myGRectangle);
        this.nRectanglesSpace = temp;
        return reply;
    }
}

