/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.geometry;

import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Rectangle;

public class GRectangle
extends Element {
    int x;
    int y;
    int w;
    int h;
    float sin;
    float cos;

    public GRectangle(int x, int y, int w, int h, float sin, float cos) {
        super(null);
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.sin = sin;
        this.cos = cos;
    }

    public GRectangle(int x, int y, int w, int h, float sin, float cos, Object obj) {
        super(obj);
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.sin = sin;
        this.cos = cos;
    }

    public final void set(int x, int y, int w, int h, float sin, float cos) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.sin = sin;
        this.cos = cos;
    }

    public final void set(int x, int y, int w, int h, float sin, float cos, Object obj) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.sin = sin;
        this.cos = cos;
        this.setObject(obj);
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final void setWidth(int w) {
        this.w = w;
    }

    public final void setHeight(int h) {
        this.h = h;
    }

    public final void setSin(float sin) {
        this.sin = sin;
    }

    public final void setCos(float cos) {
        this.cos = cos;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    public final float getSin() {
        return this.sin;
    }

    public final float getCos() {
        return this.cos;
    }

    public void shift(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void transponate() {
        int tx = this.x;
        this.x = Math.round((float)this.y + (float)this.h * this.cos);
        this.y = Math.round((float)tx - (float)this.h * this.sin);
        float tsin = this.sin;
        this.sin = this.cos;
        this.cos = tsin;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GRectangle) {
            GRectangle grect = (GRectangle)obj;
            return this.x == grect.x && this.y == grect.y && this.w == grect.w && this.h == grect.h && this.sin == grect.sin && this.cos == grect.cos && this.myObject == grect.myObject;
        }
        return false;
    }

    public final void setLeftTopAt(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final void setLeftBottomAt(int x, int y) {
        this.x = x + Math.round((float)this.h * this.sin);
        this.y = y - Math.round((float)this.h * this.cos);
    }

    public final void setLeftCenterAt(int x, int y) {
        this.x = x + Math.round((float)this.h * this.sin / 2.0f);
        this.y = y - Math.round((float)this.h * this.cos / 2.0f);
    }

    public final void setRightTopAt(int x, int y) {
        this.x = x - Math.round((float)this.w * this.cos);
        this.y = y - Math.round((float)this.w * this.sin);
    }

    public final void setCenterTopAt(int x, int y) {
        this.x = x - Math.round((float)this.w * this.cos / 2.0f);
        this.y = y - Math.round((float)this.w * this.sin / 2.0f);
    }

    public final void setRightBottomAt(int x, int y) {
        this.x = x + Math.round((float)this.h * this.sin - (float)this.w * this.cos);
        this.y = y - Math.round((float)this.h * this.cos + (float)this.w * this.sin);
    }

    public final void setCenterAt(int x, int y) {
        this.x = x + Math.round(((float)this.h * this.sin - (float)this.w * this.cos) / 2.0f);
        this.y = y - Math.round(((float)this.h * this.cos + (float)this.w * this.sin) / 2.0f);
    }

    public final void setRightCenterAt(int x, int y) {
        this.x = x + Math.round((float)this.h * this.sin / 2.0f - (float)this.w * this.cos);
        this.y = y - Math.round((float)this.h * this.cos / 2.0f + (float)this.w * this.sin);
    }

    public final void setCenterBottomAt(int x, int y) {
        this.x = x + Math.round((float)this.h * this.sin - (float)this.w * this.cos / 2.0f);
        this.y = y - Math.round((float)this.h * this.cos + (float)this.w * this.sin / 2.0f);
    }

    public final void setLeftAt(int x1, int y1, int x2, int y2) {
        int d1 = this.calculateX1() - Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY1());
        int d2 = this.calculateX2() - Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY2());
        int d3 = this.calculateX3() - Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY3());
        int d4 = this.calculateX4() - Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY4());
        int d = Math.min(d1, Math.min(d2, Math.min(d3, d4)));
        this.x -= d;
    }

    public final void setRightAt(int x1, int y1, int x2, int y2) {
        int d1 = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY1()) - this.calculateX1();
        int d2 = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY2()) - this.calculateX2();
        int d3 = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY3()) - this.calculateX3();
        int d4 = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, this.calculateY4()) - this.calculateX4();
        int d = Math.min(d1, Math.min(d2, Math.min(d3, d4)));
        this.x += d;
    }

    public final void setTopAt(int x1, int y1, int x2, int y2) {
        int d1 = this.calculateY1() - Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX1());
        int d2 = this.calculateY2() - Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX2());
        int d3 = this.calculateY3() - Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX3());
        int d4 = this.calculateY4() - Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX4());
        int d = Math.min(d1, Math.min(d2, Math.min(d3, d4)));
        this.y -= d;
    }

    public final void setBottomAt(int x1, int y1, int x2, int y2) {
        int d1 = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX1()) - this.calculateY1();
        int d2 = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX2()) - this.calculateY2();
        int d3 = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX3()) - this.calculateY3();
        int d4 = Geometer.calculateIntersectionWithVertical(x1, y1, x2, y2, this.calculateX4()) - this.calculateY4();
        int d = Math.min(d1, Math.min(d2, Math.min(d3, d4)));
        this.y += d;
    }

    public final int getLeft() {
        int left = this.x;
        if (this.sin > 0.0f) {
            left -= Math.round((float)this.h * this.sin);
        }
        if (this.cos < 0.0f) {
            left += Math.round((float)this.w * this.cos);
        }
        return left;
    }

    public final int getRight() {
        int right = this.x;
        if (this.sin < 0.0f) {
            right -= Math.round((float)this.h * this.sin);
        }
        if (this.cos > 0.0f) {
            right += Math.round((float)this.w * this.cos);
        }
        return right;
    }

    public final int getTop() {
        int top = this.y;
        if (this.sin < 0.0f) {
            top += Math.round((float)this.w * this.sin);
        }
        if (this.cos < 0.0f) {
            top += Math.round((float)this.h * this.cos);
        }
        return top;
    }

    public final int getBottom() {
        int bottom = this.y;
        if (this.sin > 0.0f) {
            bottom += Math.round((float)this.w * this.sin);
        }
        if (this.cos > 0.0f) {
            bottom += Math.round((float)this.h * this.cos);
        }
        return bottom;
    }

    public final int calculateMaxWidth() {
        return Math.abs(Math.round((float)this.h * this.sin)) + Math.abs(Math.round((float)this.w * this.cos));
    }

    public final int calculateMaxHeight() {
        return Math.abs(Math.round((float)this.w * this.sin)) + Math.abs(Math.round((float)this.h * this.cos));
    }

    public final Rectangle calculateBoundingRectangle() {
        return new Rectangle(this.getLeft(), this.getTop(), this.calculateMaxWidth(), this.calculateMaxHeight());
    }

    public final int calculateX1() {
        return this.x;
    }

    public final int calculateY1() {
        return this.y;
    }

    public final int calculateX2() {
        return this.x + Math.round((float)this.w * this.cos);
    }

    public final int calculateY2() {
        return this.y + Math.round((float)this.w * this.sin);
    }

    public final int calculateX3() {
        return this.x + Math.round((float)this.w * this.cos - (float)this.h * this.sin);
    }

    public final int calculateY3() {
        return this.y + Math.round((float)this.w * this.sin + (float)this.h * this.cos);
    }

    public final int calculateX4() {
        return this.x - Math.round((float)this.h * this.sin);
    }

    public final int calculateY4() {
        return this.y + Math.round((float)this.h * this.cos);
    }

    public String toString() {
        return "GRectangle(" + this.x + "," + this.y + "," + this.w + "," + this.h + "," + this.sin + "," + this.cos + (this.getObject() != null ? "," + this.getObject() + ")" : ")");
    }
}

