/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.geometry;

import com.tssap.selena.layout.impl.geometry.Cell;
import com.tssap.selena.layout.impl.geometry.CellAction;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Lattice;

final class CheckAction
implements CellAction {
    private int currentMark;
    private Geometer myGeometer = null;
    private Lattice myLattice = null;
    private Element myElement = null;
    private Element myReason = null;

    public void setCurrentMark(int mark) {
        this.currentMark = mark;
    }

    public void setGeometer(Geometer geometer) {
        this.myGeometer = geometer;
    }

    public void setLattice(Lattice lattice) {
        this.myLattice = lattice;
    }

    public void setElement(Element element) {
        this.myElement = element;
    }

    public void start() {
        this.myReason = null;
    }

    public void process(int row, int col) {
        Cell cell = this.myLattice.getCell(row, col);
        if (cell != null) {
            Element elem = cell.getFirst();
            while (elem != null) {
                if (elem.mark != this.currentMark) {
                    if (!this.myGeometer.mayCombine(this.myElement, elem)) {
                        this.myReason = elem;
                        break;
                    }
                    elem.mark = this.currentMark;
                }
                elem = cell.getNext();
            }
        }
    }

    public boolean getContinueFlag() {
        return this.myReason == null;
    }

    public Lattice getLattice() {
        return this.myLattice;
    }

    public Element getReason() {
        return this.myReason;
    }
}

