/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Paging;
import com.tssap.selena.layout.impl.Vertex;

final class YCoordsAssigner {
    private Optioner myOptioner;
    private Paging myPaging = null;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vertex[][] myLevels = null;

    public YCoordsAssigner(Optioner optioner) {
        this.myOptioner = optioner;
        if (this.myOptioner.pagingFlag) {
            this.myPaging = new Paging(this.myOptioner);
        }
    }

    public void assignYCoords(Vertex[] vertices, Edge[] edges, Vertex[][] levels, int startY) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myLevels = levels;
        int lowestY = startY;
        int i_Level = 0;
        while (i_Level < this.myLevels.length) {
            this.assignYCoords(i_Level, lowestY);
            Vertex[] nodes = this.myLevels[i_Level];
            int bottom = Integer.MIN_VALUE;
            if (nodes.length == 0) {
                throw new RuntimeException();
            }
            int i = 0;
            while (i < nodes.length) {
                Vertex v = nodes[i];
                bottom = Math.max(bottom, v.getBottom() + v.bottomExt);
                ++i;
            }
            lowestY = bottom + this.myOptioner.nSpaceV;
            ++i_Level;
        }
    }

    public void assignYCoords(int level, int startY) {
        Vertex[] nodes = this.myLevels[level];
        if (level > 0) {
            int expand1 = this.calculateExpandForMediumIcons(level - 1, 1);
            int expand2 = this.calculateExpandForMediumIcons(level, -1);
            startY += Math.max(expand1, expand2);
        }
        int maxHeight = 0;
        int maxTopExt = 0;
        int maxBottomExt = 0;
        int i = 0;
        while (i < nodes.length) {
            Vertex v = nodes[i];
            maxHeight = Math.max(maxHeight, v.getHeight());
            maxTopExt = Math.max(maxTopExt, v.topExt);
            maxBottomExt = Math.max(maxBottomExt, v.bottomExt);
            ++i;
        }
        if (this.myOptioner.pagingFlag) {
            int fullH = maxHeight + maxTopExt + maxBottomExt;
            startY = this.myPaging.paginate(startY, fullH, startY, Integer.MAX_VALUE, true);
        }
        int i2 = 0;
        while (i2 < nodes.length) {
            int y;
            int justification;
            Vertex v = nodes[i2];
            int n = justification = v.isDummy ? 3 : this.myOptioner.levelsJustification;
            if (justification == 4) {
                int count = 0;
                Link[] links = v.myLinks;
                int i_Link = 0;
                while (i_Link < links.length) {
                    int level1 = links[i_Link].myVertex.level;
                    if (level1 < level) {
                        --count;
                    } else if (level1 > level) {
                        ++count;
                    }
                    ++i_Link;
                }
                justification = count < 0 ? 1 : (count > 0 ? 2 : 3);
            }
            int H = v.getHeight();
            switch (justification) {
                case 1: {
                    y = startY + maxTopExt;
                    break;
                }
                case 2: {
                    y = startY + maxTopExt + maxHeight - H;
                    break;
                }
                case 3: {
                    y = startY + maxTopExt + (maxHeight - H) / 2;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (this.myOptioner.pagingFlag && !v.isDummy) {
                int fullH = H + v.topExt + v.bottomExt;
                y = this.myPaging.paginate(y - v.topExt, fullH, startY, Integer.MAX_VALUE, true) + v.topExt;
            }
            v.setY(y);
            ++i2;
        }
    }

    private int calculateExpandForMediumIcons(int level, int direction) {
        Vertex[] nodes = this.myLevels[level];
        int expand = 0;
        int i = 0;
        while (i < nodes.length) {
            Vertex v = nodes[i];
            int i_Link = 0;
            while (i_Link < v.myLinks.length) {
                Link link = v.myLinks[i_Link];
                if (link.myVertex.level == level + direction) {
                    Edge edge = link.myEdge;
                    int i_Icon = 0;
                    while (i_Icon < edge.getIconCount()) {
                        Icon icon = edge.getIconAt(i_Icon);
                        int horPos = icon.getHorPos();
                        if (horPos == 3) {
                            boolean directed = icon.isDirected();
                            int size = directed ? icon.getWidth() + icon.getHeight() : icon.getHeight();
                            expand += size;
                        }
                        ++i_Icon;
                    }
                }
                ++i_Link;
            }
            ++i;
        }
        return expand;
    }
}

