/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Paging;
import com.tssap.selena.layout.impl.RightBound;
import com.tssap.selena.layout.impl.Vertex;

final class XCoordsAssigner {
    private Optioner myOptioner;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vertex[][] myLevels = null;
    private RightBound myStartX = null;
    private int[] myLevelsStart = null;
    private Paging myPaging = null;
    private int verticalComponentCount = 0;
    private int currentLevel = -1;
    private int direction;
    private int minIndex;
    private int maxIndex;
    private int bary;
    private int count;
    private static final boolean keepMostLeftStable = false;

    public XCoordsAssigner(Optioner optioner) {
        this.myOptioner = optioner;
        if (this.myOptioner.pagingFlag) {
            this.myPaging = new Paging(this.myOptioner);
        }
    }

    public void assignXCoords(Vertex[] vertices, Edge[] edges, Vertex[][] levels, RightBound startX) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myLevels = levels;
        this.myStartX = startX;
        this.calculateLevelsStart();
        this.selectVerticalComponents();
        this.assignInitialXCoords();
        this.optimizeXCoords();
    }

    public int getNodesHSpace(Vertex v1, Vertex v2) {
        if (v1.level != v2.level || v2.absPos != v1.absPos + 1) {
            throw new RuntimeException();
        }
        int space = v1.isDummy ? (v2.isDummy ? this.myOptioner.nDummiesSpaceH : this.myOptioner.nDummySpaceH) : (v2.isDummy ? this.myOptioner.nDummySpaceH : this.myOptioner.nSpaceH);
        return space + v1.rightExt + v1.rightMediumExt + v2.leftExt;
    }

    private void assignInitialXCoords() {
        Vertex v;
        int i_Level = 0;
        while (i_Level < this.myLevels.length) {
            Vertex[] nodes = this.myLevels[i_Level];
            if (nodes.length > 0) {
                nodes[0].setX(this.myLevelsStart[i_Level] + nodes[0].leftExt);
            }
            int i = 1;
            while (i < nodes.length) {
                v = nodes[i];
                Vertex prev = nodes[i - 1];
                v.setX(prev.getRight() + this.getNodesHSpace(prev, v));
                ++i;
            }
            ++i_Level;
        }
        this.adjustXCoords(-1);
        int i_Level2 = 0;
        while (i_Level2 < this.myLevels.length) {
            Vertex[] nodes = this.myLevels[i_Level2];
            if (nodes.length >= 1) {
                v = nodes[0];
                this.myLevelsStart[i_Level2] = v.getLeft() - v.leftExt;
            }
            ++i_Level2;
        }
    }

    private void optimizeXCoords() {
        int n1 = this.myOptioner.nXCoordsPhase1Iterations;
        int n2 = this.myOptioner.nXCoordsPhase2Iterations;
        int looper = 0;
        while (looper < n1 + n2) {
            int i_Level = 1;
            while (i_Level < this.myLevels.length) {
                this.applyMyMethod(i_Level, looper >= n1 ? 0 : -1);
                this.adjustXCoords(i_Level);
                ++i_Level;
            }
            this.adjustVerticalComponents();
            int i_Level2 = this.myLevels.length - 2;
            while (i_Level2 >= 0) {
                this.applyMyMethod(i_Level2, looper >= n1 ? 0 : 1);
                this.adjustXCoords(i_Level2);
                --i_Level2;
            }
            this.adjustVerticalComponents();
            ++looper;
        }
    }

    private void applyMyMethod(int i_Level, int d) {
        this.currentLevel = i_Level;
        this.direction = d;
        Vertex[] nodes = this.myLevels[i_Level];
        int index = nodes.length - 1;
        while (index >= 0) {
            this.bary = 0;
            this.count = 0;
            this.minIndex = 0;
            this.maxIndex = -1;
            this.optimizeNodes(nodes[index]);
            --index;
        }
    }

    private void optimizeNodes(Vertex v) {
        Vertex[] nodes = this.myLevels[this.currentLevel];
        int index = v.absPos;
        if (this.minIndex > this.maxIndex) {
            this.minIndex = this.maxIndex = index;
        } else {
            this.minIndex = Math.min(this.minIndex, index);
            this.maxIndex = Math.max(this.maxIndex, index);
        }
        Link[] links = v.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            Vertex v1 = links[i_Link].myVertex;
            if (this.direction >= 0 && v1.level == this.currentLevel + 1 || this.direction <= 0 && v1.level == this.currentLevel - 1) {
                this.bary += (v1.getLeft() + v1.getRight() - v.getLeft() - v.getRight()) / 2;
                ++this.count;
            }
            ++i_Link;
        }
        if (this.count == 0) {
            return;
        }
        int shift = this.bary / this.count;
        if (shift > 0) {
            if (this.maxIndex < nodes.length - 1) {
                Vertex last = nodes[this.maxIndex];
                Vertex next = nodes[this.maxIndex + 1];
                int space = next.getLeft() - last.getRight();
                if ((space -= this.getNodesHSpace(last, next)) < shift) {
                    this.shiftNodes(space);
                    this.optimizeNodes(next);
                    return;
                }
            }
        } else if (shift < 0 && this.minIndex > 0) {
            Vertex first = nodes[this.minIndex];
            Vertex prev = nodes[this.minIndex - 1];
            int space = first.getLeft() - prev.getRight();
            if ((space -= this.getNodesHSpace(prev, first)) < -shift) {
                this.shiftNodes(-space);
                this.optimizeNodes(prev);
                return;
            }
        }
        this.shiftNodes(shift);
    }

    private void shiftNodes(int shift) {
        if (shift == 0) {
            return;
        }
        Vertex[] nodes = this.myLevels[this.currentLevel];
        int i = this.minIndex;
        while (i <= this.maxIndex) {
            Vertex v = nodes[i];
            v.setX(v.getLeft() + shift);
            ++i;
        }
        this.bary -= shift * this.count;
    }

    private void adjustXCoords(int level) {
        block10: {
            block9: {
                int minSpace = Integer.MAX_VALUE;
                int i_Lev = 0;
                while (i_Lev < this.myLevels.length) {
                    Vertex[] nodes = this.myLevels[i_Lev];
                    if (nodes.length != 0) {
                        Vertex v = nodes[0];
                        int startX = this.myLevelsStart[i_Lev];
                        int space = v.getLeft() - v.leftExt - startX;
                        minSpace = Math.min(minSpace, space);
                    }
                    ++i_Lev;
                }
                if (minSpace == 0) break block9;
                int i_Lev2 = 0;
                while (i_Lev2 < this.myLevels.length) {
                    Vertex[] nodes = this.myLevels[i_Lev2];
                    int i = 0;
                    while (i < nodes.length) {
                        Vertex v = nodes[i];
                        v.setX(v.getLeft() - minSpace);
                        ++i;
                    }
                    ++i_Lev2;
                }
                if (!this.myOptioner.pagingFlag) break block10;
                int i_Lev3 = 0;
                while (i_Lev3 < this.myLevels.length) {
                    this.paginateNodes(i_Lev3);
                    ++i_Lev3;
                }
                break block10;
            }
            if (this.myOptioner.pagingFlag) {
                if (level >= 0) {
                    this.paginateNodes(level);
                } else {
                    int i_Lev = 0;
                    while (i_Lev < this.myLevels.length) {
                        this.paginateNodes(i_Lev);
                        ++i_Lev;
                    }
                }
            }
        }
    }

    private void paginateNodes(int i_Level) {
        Vertex[] nodes = this.myLevels[i_Level];
        int i_Pos = 0;
        while (i_Pos < nodes.length) {
            int minX;
            Vertex v = nodes[i_Pos];
            if (i_Pos == 0) {
                minX = Math.max(this.myOptioner.startX, this.myLevelsStart[i_Level] - this.myOptioner.nComponentsSpace + this.myOptioner.nMinComponentsSpace);
            } else {
                Vertex lv = nodes[i_Pos - 1];
                minX = lv.getRight() + this.getNodesHSpace(lv, v) - v.leftExt;
            }
            int left = v.getLeft() - v.leftExt;
            int w = v.getWidth() + v.leftExt + v.rightExt;
            left = this.myPaging.paginate(left, w, minX, Integer.MAX_VALUE, false);
            v.setX(left + v.leftExt);
            ++i_Pos;
        }
    }

    private void selectVerticalComponents() {
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            this.myVertices[i_Vertex].myVerticalComponent = 0;
            ++i_Vertex;
        }
        int i = 0;
        int i_Comps = 0;
        while (i < this.myVertices.length) {
            if (this.myVertices[i].myVerticalComponent == 0) {
                this.assignVerticalComponentLabel(++i_Comps, this.myVertices[i]);
            }
            ++i;
        }
        this.verticalComponentCount = i_Comps;
    }

    private void assignVerticalComponentLabel(int i_Component, Vertex v) {
        v.myVerticalComponent = i_Component;
        Link[] links = v.myLinks;
        int j = 0;
        while (j < links.length) {
            if (v.level != links[j].myVertex.level && links[j].myVertex.myVerticalComponent == 0) {
                this.assignVerticalComponentLabel(i_Component, links[j].myVertex);
            }
            ++j;
        }
    }

    private void adjustVerticalComponents() {
        if (this.verticalComponentCount == 1) {
            return;
        }
        boolean changes = true;
        while (changes) {
            changes = false;
            int i_Comp = 2;
            while (i_Comp <= this.verticalComponentCount) {
                changes = this.adjustVerticalComponent(i_Comp);
                ++i_Comp;
            }
        }
        this.adjustXCoords(-1);
    }

    private boolean adjustVerticalComponent(int i_Comp) {
        int minShift = Integer.MIN_VALUE;
        int maxShift = Integer.MAX_VALUE;
        int leftLinks = 0;
        int rightLinks = 0;
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            if (v.myVerticalComponent == i_Comp) {
                int level = v.level;
                Vertex[] nodes = this.myLevels[level];
                int absPos = v.absPos;
                if (absPos > 0) {
                    Vertex left = nodes[absPos - 1];
                    if (left.myVerticalComponent != i_Comp) {
                        minShift = Math.max(minShift, left.getRight() + this.getNodesHSpace(left, v) - v.getLeft());
                    }
                }
                if (absPos < nodes.length - 1) {
                    Vertex right = nodes[absPos + 1];
                    if (right.myVerticalComponent != i_Comp) {
                        maxShift = Math.min(maxShift, right.getLeft() - this.getNodesHSpace(v, right) - v.getRight());
                    }
                }
                Link[] links = v.myLinks;
                int i_Link = 0;
                while (i_Link < links.length) {
                    Vertex v1 = links[i_Link].myVertex;
                    if (v1.level == level && v1.myVerticalComponent != i_Comp) {
                        if (v1.absPos < absPos) {
                            ++leftLinks;
                        } else {
                            ++rightLinks;
                        }
                    }
                    ++i_Link;
                }
            }
            ++i_Vertex;
        }
        if (minShift > 0 || maxShift < 0) {
            throw new RuntimeException();
        }
        int shift = leftLinks > rightLinks ? minShift : (rightLinks > leftLinks ? maxShift : 0);
        if (shift == 0) {
            return false;
        }
        int i_Vertex2 = 0;
        while (i_Vertex2 < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex2];
            if (v.myVerticalComponent == i_Comp) {
                v.setX(v.getLeft() + shift);
            }
            ++i_Vertex2;
        }
        return true;
    }

    private void calculateLevelsStart() {
        this.myLevelsStart = new int[this.myLevels.length];
        this.myLevelsStart[0] = this.myStartX.getMaxX(0, Integer.MAX_VALUE);
        int i_Level = 1;
        while (i_Level < this.myLevels.length) {
            Vertex[] nodes = this.myLevels[i_Level - 1];
            int bottom = Integer.MIN_VALUE;
            int i = 0;
            while (i < nodes.length) {
                Vertex vertex = nodes[i];
                bottom = Math.max(bottom, vertex.getBottom() + vertex.bottomExt);
                ++i;
            }
            this.myLevelsStart[i_Level] = this.myStartX.getMaxX(bottom, Integer.MAX_VALUE);
            ++i_Level;
        }
    }
}

