/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.IconSpacing;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.EdgesCrossPermitter;
import com.tssap.selena.layout.impl.auto.ExpandHorizontalPipeException;
import com.tssap.selena.layout.impl.auto.LayoutingQueue;
import com.tssap.selena.layout.impl.auto.LineTracer;
import com.tssap.selena.layout.impl.auto.LinkRouter;
import com.tssap.selena.layout.impl.auto.RelayoutException;
import com.tssap.selena.layout.impl.geometry.CannotShiftException;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.geometry.Rectangle;

final class StraightVerticalLinkRouter
implements LinkRouter {
    private Optioner myOptioner;
    private LinesManager myLinesManager = null;
    private Geometer myGeometer;
    private LayoutingQueue myLayoutingQueue = null;
    private LineTracer myLineTracer = new LineTracer();
    private Vertex[][] myLevels = null;
    private int[] myLevelsTop = null;
    private int[] myLevelsBottom = null;
    private Edge edge = null;
    private Vertex v1 = null;
    private Vertex v2 = null;
    private int level1;
    private int level2;
    private Point p1;
    private Point p2;
    private Point p3;
    private Point p4;
    private int srcDirection;
    private int dstDirection;
    private int topBound;
    private int bottomBound;
    private int srcMinLength;
    private int dstMinLength;
    private Line myLine = new Line(0, 0, 0, 0, null);
    private Rectangle myRectangle = new Rectangle(0, 0, 0, 0, null);
    private Point myPoint1 = new Point(0, 0, null);
    private Point myPoint2 = new Point(0, 0, null);

    public StraightVerticalLinkRouter(Optioner optioner, LinesManager linesManager) {
        this.myOptioner = optioner;
        this.myLinesManager = linesManager;
        this.myGeometer = new Geometer(this.myOptioner);
    }

    public void setLayoutingQueue(LayoutingQueue layoutingQueue) {
        this.myLayoutingQueue = layoutingQueue;
    }

    public void setLevels(Vertex[][] levels) {
        this.myLevels = levels;
    }

    public void setLevelsTop(int[] levelsTop) {
        this.myLevelsTop = levelsTop;
    }

    public void setLevelsBottom(int[] levelsBottom) {
        this.myLevelsBottom = levelsBottom;
    }

    public void remove(Edge e) {
        this.edge = e;
        int n = this.edge.getPointCount();
        Point point1 = null;
        Point point2 = null;
        if (n < 2 || n > 4) {
            throw new RuntimeException();
        }
        if (n == 2) {
            point1 = this.edge.getPointAt(0);
            point2 = this.edge.getPointAt(1);
        } else {
            Point p1 = this.edge.getPointAt(0);
            Point p2 = this.edge.getPointAt(1);
            Point p3 = this.edge.getPointAt(2);
            if (p1.x == p2.x) {
                point1 = p2;
                point2 = p3;
                this.edge.srcFantom = point1;
                this.edge.dstFantom = n == 4 ? point2 : null;
            } else {
                if (n != 3) {
                    throw new RuntimeException();
                }
                point1 = p1;
                point2 = p2;
                this.edge.srcFantom = null;
                this.edge.dstFantom = point2;
            }
        }
        this.myLine.set(point1.x, point1.y, point2.x, point2.y, this.edge);
        this.myLinesManager.remove(this.myLine);
    }

    public void route(Edge e) throws RelayoutException, ExpandHorizontalPipeException {
        this.edge = e;
        this.p1 = this.edge.getSrcInjectionPoint();
        this.p2 = this.edge.getDstInjectionPoint();
        Point srcFantom = this.edge.srcFantom;
        if (srcFantom != null) {
            this.myLine.set(this.p1.x, this.p1.y, srcFantom.x, srcFantom.y, this.edge);
            this.myLinesManager.remove(this.myLine);
            this.myLinesManager.remove(srcFantom);
            this.edge.srcFantom = null;
            this.p3 = srcFantom;
        } else {
            this.p3 = new Point(this.p1.x, this.p1.y, this.edge);
        }
        Point dstFantom = this.edge.dstFantom;
        if (dstFantom != null) {
            this.myLine.set(this.p2.x, this.p2.y, dstFantom.x, dstFantom.y, this.edge);
            this.myLinesManager.remove(this.myLine);
            this.myLinesManager.remove(dstFantom);
            this.edge.dstFantom = null;
            this.p4 = dstFantom;
        } else {
            this.p4 = new Point(this.p2.x, this.p2.y, this.edge);
        }
        this.v1 = this.edge.vertex1;
        this.v2 = this.edge.vertex2;
        this.level1 = this.v1.level;
        this.level2 = this.v2.level;
        this.srcDirection = this.level1 < this.level2 ? 2 : 1;
        this.dstDirection = this.level2 < this.level1 ? 2 : 1;
        this.topBound = this.myLevelsBottom[Math.min(this.level1, this.level2)] + this.myOptioner.nRectanglesSpace;
        this.bottomBound = this.myLevelsTop[Math.max(this.level1, this.level2)] - this.myOptioner.nRectanglesSpace;
        this.srcMinLength = IconSpacing.calculateSrcIconHeight(this.edge) + this.myOptioner.minFirstSegLength;
        this.dstMinLength = IconSpacing.calculateDstIconHeight(this.edge) + this.myOptioner.minFirstSegLength;
        this.correctForMissingNeighbours(true);
        this.correctForMissingNeighbours(false);
        while (true) {
            if (!this.p1.equals(this.p3)) {
                int y1 = this.p1.y;
                int y3 = this.p3.y;
                if (Math.abs(y1 - y3) < this.srcMinLength) {
                    this.p3.y = y1 + (this.level1 < this.level2 ? this.srcMinLength : -this.srcMinLength);
                }
                if (this.level1 < this.level2) {
                    if (this.p3.y > this.bottomBound) {
                        throw new ExpandHorizontalPipeException(this.p3.y - this.bottomBound);
                    }
                    this.topBound = Math.max(this.topBound, this.p3.y);
                } else {
                    if (this.p3.y < this.topBound) {
                        throw new ExpandHorizontalPipeException(this.topBound - this.p3.y);
                    }
                    this.bottomBound = Math.min(this.bottomBound, this.p3.y);
                }
            }
            if (!this.p2.equals(this.p4)) {
                int y2 = this.p2.y;
                int y4 = this.p4.y;
                if (Math.abs(y2 - y4) < this.dstMinLength) {
                    this.p4.y = y2 + (this.level2 < this.level1 ? this.dstMinLength : -this.dstMinLength);
                }
                if (this.level2 < this.level1) {
                    if (this.p4.y > this.bottomBound) {
                        throw new ExpandHorizontalPipeException(this.p4.y - this.bottomBound);
                    }
                    this.topBound = Math.max(this.topBound, this.p4.y);
                } else {
                    if (this.p4.y < this.topBound) {
                        throw new ExpandHorizontalPipeException(this.topBound - this.p4.y);
                    }
                    this.bottomBound = Math.min(this.bottomBound, this.p4.y);
                }
            }
            this.myLine.set(this.p3.x, this.p3.y, this.p4.x, this.p4.y, this.edge);
            if (!this.myLinesManager.isCorrect(this.myLine)) {
                this.correctLine3_4();
                continue;
            }
            if (!this.p1.equals(this.p3)) {
                this.myLine.set(this.p1.x, this.p1.y, this.p3.x, this.p3.y, this.edge);
                if (!this.myLinesManager.isCorrect(this.myLine)) {
                    this.correctLine1_3();
                    continue;
                }
                if (!this.myLinesManager.isCorrect(this.p3)) {
                    this.correctPoint3();
                    continue;
                }
            }
            if (this.p2.equals(this.p4)) break;
            this.myLine.set(this.p2.x, this.p2.y, this.p4.x, this.p4.y, this.edge);
            if (!this.myLinesManager.isCorrect(this.myLine)) {
                this.correctLine2_4();
                continue;
            }
            if (this.myLinesManager.isCorrect(this.p4)) break;
            this.correctPoint4();
        }
        this.myLineTracer.start(this.myLinesManager, this.edge);
        this.myLineTracer.addPoint(this.p1);
        this.myLineTracer.addPoint(this.p3);
        this.myLineTracer.addPoint(this.p4);
        this.myLineTracer.addPoint(this.p2);
        this.myLineTracer.finish();
    }

    private void correctLine3_4() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Rectangle) {
            this.correctIfRectangle((Rectangle)reason);
        } else if (reason instanceof Line) {
            this.correctIfLine((Line)reason);
        } else if (reason instanceof Point) {
            this.correctIfPoint((Point)reason);
        } else {
            throw new RuntimeException();
        }
    }

    private void correctIfRectangle(Rectangle rect) throws RelayoutException {
        Vertex vertex = (Vertex)rect.getObject();
        int level = vertex.level;
        if (level != this.level1 && level != this.level2) {
            throw new RuntimeException();
        }
        try {
            if (level == this.level1) {
                this.myGeometer.shiftOnePointForOK(this.p3, this.p4, rect, this.srcDirection);
            } else {
                this.myGeometer.shiftOnePointForOK(this.p4, this.p3, rect, this.dstDirection);
            }
        }
        catch (CannotShiftException ex) {
            throw new RuntimeException();
        }
    }

    private void correctIfLine(Line line) throws RelayoutException {
        Edge e = (Edge)line.getObject();
        int pointToShift = this.whichPointToShift(e);
        try {
            if (pointToShift == 3) {
                this.myGeometer.shiftOnePointForNotCross(this.p3, this.p4, line, this.srcDirection);
                if (this.p1.y < this.p2.y && this.p3.y > this.bottomBound || this.p1.y > this.p2.y && this.p3.y < this.topBound) {
                    throw new RelayoutException(line, this.myLine);
                }
            } else {
                this.myGeometer.shiftOnePointForNotCross(this.p4, this.p3, line, this.dstDirection);
                if (this.p2.y < this.p1.y && this.p4.y > this.bottomBound || this.p2.y > this.p1.y && this.p4.y < this.topBound) {
                    throw new RelayoutException(line, this.myLine);
                }
            }
        }
        catch (CannotShiftException ex) {
            throw new RelayoutException(line, this.myLine);
        }
    }

    private void correctIfPoint(Point p) throws RelayoutException {
        Object obj = p.getObject();
        if (!(obj instanceof Edge) || !EdgesCrossPermitter.permitCrossing(this.edge, (Edge)obj)) {
            int pointToShift = this.whichPointToShift(obj);
            try {
                if (pointToShift == 3) {
                    this.myGeometer.shiftOnePointForOK(this.p3, this.p4, p, this.srcDirection);
                }
                this.myGeometer.shiftOnePointForOK(this.p4, this.p3, p, this.dstDirection);
            }
            catch (CannotShiftException ex) {
                throw new RelayoutException(p, this.myLine);
            }
        } else {
            this.myPoint1.set(this.p3.x, this.p3.y, this.edge);
            Point newP3 = this.myPoint1;
            try {
                this.myGeometer.shiftOnePointForOK(newP3, this.p4, p, this.srcDirection);
            }
            catch (CannotShiftException ex) {
                newP3 = null;
            }
            this.myPoint2.set(this.p4.x, this.p4.y, this.edge);
            Point newP4 = this.myPoint2;
            try {
                this.myGeometer.shiftOnePointForOK(newP4, this.p3, p, this.dstDirection);
            }
            catch (CannotShiftException ex) {
                newP4 = null;
            }
            if (newP3 == null && newP4 == null) {
                if (obj == null) {
                    throw new RuntimeException();
                }
                throw new RelayoutException(p, this.myLine);
            }
            if (newP3 == null) {
                this.p4.set(newP4.x, newP4.y);
            } else if (newP4 == null) {
                this.p3.set(newP3.x, newP3.y);
            } else if (Math.abs(this.p3.y - newP3.y) < Math.abs(this.p4.y - newP4.y)) {
                this.p3.set(newP3.x, newP3.y);
            } else {
                this.p4.set(newP4.x, newP4.y);
            }
        }
    }

    private void correctForMissingNeighbours(boolean srcFlag) {
        int direction;
        int d;
        Vertex v;
        int y2;
        int x2;
        int y1;
        int x1;
        if (this.p3.x == this.p4.x) {
            return;
        }
        if (srcFlag) {
            x1 = this.p3.x;
            y1 = this.p3.y;
            x2 = this.p4.x;
            y2 = this.p4.y;
            v = this.v1;
            d = this.p3.x < this.p4.x ? 1 : -1;
            direction = this.srcDirection;
        } else {
            x1 = this.p4.x;
            y1 = this.p4.y;
            x2 = this.p3.x;
            y2 = this.p3.y;
            v = this.v2;
            d = this.p4.x < this.p3.x ? 1 : -1;
            direction = this.dstDirection;
        }
        Vertex[] nodes = this.myLevels[v.level];
        int pos = v.absPos + d;
        while (0 <= pos && pos < nodes.length) {
            block11: {
                block13: {
                    int controlX;
                    Vertex nv;
                    block12: {
                        nv = nodes[pos];
                        if (direction == 2 ? nv.getTop() <= y1 : nv.getBottom() >= y1) break block11;
                        int controlY = nv.getTop();
                        controlX = Geometer.calculateIntersectionWithHorizontal(x1, y1, x2, y2, controlY);
                        if (d <= 0) break block12;
                        if (controlX < nv.getLeft()) break block11;
                        this.myRectangle.set(nv.getLeft(), nv.getTop(), x2 - nv.getLeft(), nv.getHeight(), null);
                        break block13;
                    }
                    if (controlX > nv.getRight()) break block11;
                    this.myRectangle.set(x2, nv.getTop(), nv.getRight() - x2, nv.getHeight(), null);
                }
                try {
                    if (srcFlag) {
                        this.myGeometer.shiftOnePointForOK(this.p3, this.p4, this.myRectangle, direction);
                        x1 = this.p3.x;
                        y1 = this.p3.y;
                    } else {
                        this.myGeometer.shiftOnePointForOK(this.p4, this.p3, this.myRectangle, direction);
                        x1 = this.p4.x;
                        y1 = this.p4.y;
                    }
                }
                catch (CannotShiftException ex) {
                    throw new RuntimeException();
                }
            }
            pos += d;
        }
    }

    private void correctLine1_3() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Line || reason instanceof Point) {
            throw new RelayoutException(reason, this.myLine);
        }
        throw new RuntimeException();
    }

    private void correctLine2_4() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Line || reason instanceof Point) {
            throw new RelayoutException(reason, this.myLine);
        }
        throw new RuntimeException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void correctPoint3() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Line) {
            this.myGeometer.shiftPointForOK(this.p3, (Line)reason, this.srcDirection);
            if (this.p3.y >= this.topBound && this.p3.y <= this.bottomBound) return;
            Edge e = (Edge)reason.getObject();
            int lev1 = e.vertex1.level;
            int lev2 = e.vertex2.level;
            if (lev1 == lev2) return;
            if (this.level1 == lev1) {
                if (Math.abs(e.getSrcInjectionX() - this.p3.x) > this.myOptioner.nLinesSpace) return;
                throw new RelayoutException(reason, this.p3);
            }
            if (this.level1 != lev2) throw new RuntimeException();
            if (Math.abs(e.getDstInjectionX() - this.p3.x) > this.myOptioner.nLinesSpace) return;
            throw new RelayoutException(reason, this.p3);
        }
        if (!(reason instanceof Point)) throw new RuntimeException();
        this.myGeometer.shiftPointForOK(this.p3, (Point)reason, this.srcDirection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void correctPoint4() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Line) {
            this.myGeometer.shiftPointForOK(this.p4, (Line)reason, this.dstDirection);
            if (this.p4.y >= this.topBound && this.p4.y <= this.bottomBound) return;
            Edge e = (Edge)reason.getObject();
            int lev1 = e.vertex1.level;
            int lev2 = e.vertex2.level;
            if (lev1 == lev2) return;
            if (this.level2 == lev1) {
                if (Math.abs(e.getSrcInjectionX() - this.p4.x) > this.myOptioner.nLinesSpace) return;
                throw new RelayoutException(reason, this.p4);
            }
            if (this.level2 != lev2) throw new RuntimeException();
            if (Math.abs(e.getDstInjectionX() - this.p4.x) > this.myOptioner.nLinesSpace) return;
            throw new RelayoutException(reason, this.p4);
        }
        if (!(reason instanceof Point)) throw new RuntimeException();
        this.myGeometer.shiftPointForOK(this.p4, (Point)reason, this.dstDirection);
    }

    private int whichPointToShift(Object obj) {
        if (obj instanceof Vertex) {
            Vertex v = (Vertex)obj;
            if (v.level == this.level1) {
                return 3;
            }
            return 4;
        }
        if (obj instanceof Edge) {
            Edge e = (Edge)obj;
            Vertex vert1 = e.vertex1;
            Vertex vert2 = e.vertex2;
            int i_Level1 = vert1.level;
            int i_Level2 = vert2.level;
            if (i_Level1 == i_Level2) {
                if (i_Level1 == this.level1) {
                    return 3;
                }
                if (i_Level1 == this.level2) {
                    return 4;
                }
                throw new RuntimeException();
            }
            int injx = e.getInjectionX(i_Level1 == this.level1);
            if (injx < this.p3.x) {
                return this.p3.x < this.p4.x ? 4 : 3;
            }
            return this.p3.x < this.p4.x ? 3 : 4;
        }
        throw new RuntimeException();
    }
}

