/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.IconSpacing;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Processible;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.ExpandHorizontalPipeException;
import com.tssap.selena.layout.impl.auto.LayoutingQueue;
import com.tssap.selena.layout.impl.auto.LineTracer;
import com.tssap.selena.layout.impl.auto.LinkRouter;
import com.tssap.selena.layout.impl.auto.RelayoutException;
import com.tssap.selena.layout.impl.geometry.CannotShiftException;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.geometry.Rectangle;
import java.util.Iterator;

final class StraightHorizontalLinkRouter
implements LinkRouter {
    private Optioner myOptioner;
    private LinesManager myLinesManager = null;
    private Geometer myGeometer;
    private LayoutingQueue myLayoutingQueue = null;
    private LineTracer myLineTracer = new LineTracer();
    private Vertex[][] myLevels = null;
    private int[] myLevelsTop = null;
    private int[] myLevelsBottom = null;
    private Edge edge = null;
    private Vertex v1 = null;
    private Vertex v2 = null;
    private int way;
    private int level;
    private Point p1;
    private Point p2;
    private Point p3;
    private Point p4;
    private Point p5;
    private Point p6;
    private int topBound;
    private int bottomBound;
    private int leftBound;
    private int rightBound;
    private int leftPos;
    private int rightPos;
    private int srcDirection;
    private int dstDirection;
    private int verticalDirection;
    private int mediumSpace;
    private int p3xStart;
    private int p4xStart;
    private Element lastChecked = null;
    private Line myLine = new Line(0, 0, 0, 0, null);

    public StraightHorizontalLinkRouter(Optioner optioner, LinesManager linesManager) {
        this.myOptioner = optioner;
        this.myLinesManager = linesManager;
        this.myGeometer = new Geometer(this.myOptioner);
    }

    public void setLayoutingQueue(LayoutingQueue layoutingQueue) {
        this.myLayoutingQueue = layoutingQueue;
    }

    public void setLevels(Vertex[][] levels) {
        this.myLevels = levels;
    }

    public void setLevelsTop(int[] levelsTop) {
        this.myLevelsTop = levelsTop;
    }

    public void setLevelsBottom(int[] levelsBottom) {
        this.myLevelsBottom = levelsBottom;
    }

    public void remove(Edge e) {
        e.removeFromLinesManager(this.myLinesManager);
    }

    public void route(Edge e) throws RelayoutException, ExpandHorizontalPipeException {
        int x;
        this.edge = e;
        this.p1 = this.edge.getSrcInjectionPoint();
        this.p2 = this.edge.getDstInjectionPoint();
        this.myLine.set(this.p1.x, this.p1.y, this.p2.x, this.p2.y, this.edge);
        if (this.myLinesManager.isCorrect(this.myLine)) {
            this.myLineTracer.start(this.myLinesManager, this.edge);
            this.myLineTracer.addPoint(this.p1);
            this.myLineTracer.addPoint(this.p2);
            this.myLineTracer.finish();
            return;
        }
        this.fillWorkVariables();
        Vertex[] nodes = this.myLevels[this.level];
        int y = this.way == 1 ? Math.min(this.p1.y, this.p2.y) : Math.max(this.p1.y, this.p2.y);
        int pos = -1;
        int i_Pos = this.leftPos + 1;
        while (i_Pos < this.rightPos) {
            Vertex v = nodes[i_Pos];
            if (!v.isDummy) {
                if (this.way == 1) {
                    int top = v.getTop() - v.topExt - this.myOptioner.nRectanglesSpace;
                    if (y > top) {
                        y = top;
                        pos = i_Pos;
                    }
                } else {
                    int bottom = v.getBottom() + v.bottomExt + this.myOptioner.nRectanglesSpace;
                    if (y < bottom) {
                        y = bottom;
                        pos = i_Pos;
                    }
                }
            }
            ++i_Pos;
        }
        if (pos >= 0) {
            Vertex v = nodes[pos];
            x = (v.getLeft() + v.getRight()) / 2;
        } else {
            x = (this.p1.x + this.p2.x) / 2;
        }
        this.p3 = new Point(x, y, this.edge);
        this.p4 = new Point(x, y, this.edge);
        this.p5 = new Point(this.p1.x, this.p1.y, this.edge);
        this.p6 = new Point(this.p2.x, this.p2.y, this.edge);
        this.shiftStartY();
        this.routing();
        this.trace();
    }

    private void fillWorkVariables() {
        this.way = this.edge.way;
        this.v1 = this.edge.vertex1;
        this.v2 = this.edge.vertex2;
        this.level = this.v1.level;
        this.srcDirection = this.p1.x < this.p2.x ? 4 : 3;
        this.dstDirection = this.p1.x > this.p2.x ? 4 : 3;
        this.verticalDirection = this.way == 1 ? 1 : 2;
        this.topBound = this.way == 1 && this.level > 0 ? this.myLevelsBottom[this.level - 1] + this.myOptioner.nRectanglesSpace : Integer.MIN_VALUE;
        this.bottomBound = this.way == 2 && this.level < this.myLevels.length - 1 ? this.myLevelsTop[this.level + 1] - this.myOptioner.nRectanglesSpace : Integer.MAX_VALUE;
        this.leftBound = (this.v1.absPos > this.v2.absPos ? this.v2 : this.v1).getRight() + this.myOptioner.nRectanglesSpace;
        this.rightBound = (this.v1.absPos > this.v2.absPos ? this.v1 : this.v2).getLeft() - this.myOptioner.nRectanglesSpace;
        this.leftPos = Math.min(this.v1.absPos, this.v2.absPos);
        this.rightPos = Math.max(this.v1.absPos, this.v2.absPos);
        this.mediumSpace = IconSpacing.calculateMediumIconsSpace(this.edge);
    }

    private void routing() throws RelayoutException, ExpandHorizontalPipeException {
        int center = (this.p3.x + this.p4.x) / 2;
        int leftStart = center - this.mediumSpace / 2;
        int rightStart = center + this.mediumSpace / 2;
        this.p3xStart = this.p1.x < this.p2.x ? leftStart : rightStart;
        this.p4xStart = this.p1.x < this.p2.x ? rightStart : leftStart;
        this.p3.x = this.p3xStart;
        this.p4.x = this.p4xStart;
        boolean firstTime = true;
        while (true) {
            if (this.p3.y < this.topBound) {
                throw new ExpandHorizontalPipeException(this.topBound - this.p3.y);
            }
            if (this.p3.y > this.bottomBound) {
                throw new ExpandHorizontalPipeException(this.p3.y - this.bottomBound);
            }
            this.leftBound = Math.max(this.leftBound, this.p1.x < this.p2.x ? this.p5.x : this.p6.x);
            this.rightBound = Math.min(this.rightBound, this.p1.x < this.p2.x ? this.p6.x : this.p5.x);
            if (Math.min(this.p3.x, this.p4.x) < this.leftBound || Math.max(this.p3.x, this.p4.x) > this.rightBound) {
                if (firstTime) {
                    throw new RuntimeException();
                }
                Element reason = this.myLinesManager.getReason();
                Object object = reason.getObject();
                if (object instanceof Edge) {
                    throw new RelayoutException(reason, this.lastChecked);
                }
                throw new RuntimeException();
            }
            firstTime = false;
            this.lastChecked = null;
            if (this.p3.equals(this.p4)) {
                if (!this.myLinesManager.isCorrect(this.p3)) {
                    this.lastChecked = this.p3;
                    this.correctPoint34();
                    continue;
                }
            } else {
                this.myLine.set(this.p3.x, this.p3.y, this.p4.x, this.p4.y, this.edge);
                if (!this.myLinesManager.isCorrect(this.myLine)) {
                    this.lastChecked = this.myLine;
                    this.correctLine3_4();
                    continue;
                }
                if (!this.myLinesManager.isCorrect(this.p3)) {
                    this.lastChecked = this.p3;
                    this.correctPoint3();
                    continue;
                }
                if (!this.myLinesManager.isCorrect(this.p4)) {
                    this.lastChecked = this.p4;
                    this.correctPoint4();
                    continue;
                }
            }
            this.myLine.set(this.p5.x, this.p5.y, this.p3.x, this.p3.y, this.edge);
            if (!this.myLinesManager.isCorrect(this.myLine)) {
                this.lastChecked = this.myLine;
                this.correctLine5_3();
                continue;
            }
            this.myLine.set(this.p6.x, this.p6.y, this.p4.x, this.p4.y, this.edge);
            if (this.myLinesManager.isCorrect(this.myLine)) break;
            this.lastChecked = this.myLine;
            this.correctLine6_4();
        }
    }

    private void correctPoint34() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Point) {
            Point point = (Point)reason;
            this.myGeometer.shiftPointForOK(this.p3, point, this.dstDirection);
            this.myGeometer.shiftPointForOK(this.p4, point, this.srcDirection);
        } else if (reason instanceof Line) {
            Line line = (Line)reason;
            this.myGeometer.shiftPointForOK(this.p3, line, this.dstDirection);
            this.myGeometer.shiftPointForOK(this.p4, line, this.srcDirection);
        } else {
            throw new RuntimeException();
        }
    }

    private void correctLine3_4() throws RelayoutException {
        int y;
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Point) {
            this.myGeometer.shiftLineForOK(this.myLine, (Point)reason, this.verticalDirection);
            y = this.myLine.getY1();
        } else if (reason instanceof Line) {
            Edge e = (Edge)reason.getObject();
            if (e.vertex1.level != this.level || e.vertex2.level != this.level) {
                throw new RelayoutException(reason, this.myLine);
            }
            this.myGeometer.shiftLineForNotCross(this.myLine, (Line)reason, this.verticalDirection);
            y = this.myLine.getY1();
        } else {
            throw new RuntimeException();
        }
        this.p3.y = this.p4.y = y;
        this.p3.x = this.p3xStart;
        this.p4.x = this.p4xStart;
        this.p5.x = this.p1.x;
        this.p6.x = this.p2.x;
    }

    private void correctLine5_3() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Point) {
            try {
                this.myGeometer.shiftOnePointForOK(this.p3, this.p5, (Point)reason, this.dstDirection);
            }
            catch (CannotShiftException ex) {
                throw new RuntimeException();
            }
        } else if (reason instanceof Line) {
            try {
                this.myGeometer.shiftOnePointForNotCross(this.p3, this.p5, (Line)reason, this.dstDirection);
            }
            catch (CannotShiftException ex) {
                throw new RelayoutException(reason, this.myLine);
            }
        } else if (reason instanceof Rectangle) {
            try {
                this.myGeometer.shiftOnePointForOK(this.p3, this.p5, (Rectangle)reason, this.dstDirection);
            }
            catch (CannotShiftException ex) {
                throw new RuntimeException();
            }
        } else {
            throw new RuntimeException();
        }
    }

    private void correctLine6_4() throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Point) {
            try {
                this.myGeometer.shiftOnePointForOK(this.p4, this.p6, (Point)reason, this.srcDirection);
            }
            catch (CannotShiftException ex) {
                throw new RuntimeException();
            }
        } else if (reason instanceof Line) {
            try {
                this.myGeometer.shiftOnePointForNotCross(this.p4, this.p6, (Line)reason, this.srcDirection);
            }
            catch (CannotShiftException ex) {
                throw new RelayoutException(reason, this.myLine);
            }
        } else if (reason instanceof Rectangle) {
            try {
                this.myGeometer.shiftOnePointForOK(this.p4, this.p6, (Rectangle)reason, this.srcDirection);
            }
            catch (CannotShiftException ex) {
                throw new RuntimeException();
            }
        } else {
            throw new RuntimeException();
        }
    }

    private void correctPoint3() {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Point) {
            this.myGeometer.shiftPointForOK(this.p3, (Point)reason, this.dstDirection);
        } else if (reason instanceof Line) {
            this.myGeometer.shiftPointForOK(this.p3, (Line)reason, this.dstDirection);
        } else {
            throw new RuntimeException();
        }
    }

    private void correctPoint4() {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Point) {
            this.myGeometer.shiftPointForOK(this.p4, (Point)reason, this.srcDirection);
        } else if (reason instanceof Line) {
            this.myGeometer.shiftPointForOK(this.p4, (Line)reason, this.srcDirection);
        } else {
            throw new RuntimeException();
        }
    }

    private void shiftStartY() {
        int y = this.p3.y;
        Iterator iter = this.myLayoutingQueue.beforeObjects(this.edge);
        if (iter != null) {
            while (iter.hasNext()) {
                int iconSpace;
                Processible obj = (Processible)iter.next();
                if (!obj.isProcessed() || !(obj instanceof Edge)) continue;
                Edge e = (Edge)obj;
                if (e.vertex1.level != this.level || e.vertex2.level != this.level || e.getPointCount() <= 3) continue;
                int newy = e.getPointAt((int)2).y;
                if (this.way == 1) {
                    y = Math.min(y, newy - this.myOptioner.nLinesSpace);
                    iconSpace = e.aboveSpace;
                    if (iconSpace <= 0) continue;
                    y = Math.min(y, newy - iconSpace - this.myOptioner.nIconsSpace);
                    continue;
                }
                y = Math.max(y, newy + this.myOptioner.nLinesSpace);
                iconSpace = e.underSpace;
                if (iconSpace <= 0) continue;
                y = Math.max(y, newy + iconSpace + this.myOptioner.nIconsSpace);
            }
        }
        if (this.way == 1) {
            int iconSpace = this.edge.underSpace;
            if (iconSpace > 0) {
                y -= iconSpace + this.myOptioner.nIconsSpace - this.myOptioner.nLinesSpace;
            }
        } else {
            int iconSpace = this.edge.aboveSpace;
            if (iconSpace > 0) {
                y += iconSpace + this.myOptioner.nIconsSpace - this.myOptioner.nLinesSpace;
            }
        }
        this.p3.y = this.p4.y = y;
    }

    private void trace() {
        this.myLineTracer.start(this.myLinesManager, this.edge);
        this.myLineTracer.addPoint(this.p1);
        this.myLineTracer.addPoint(this.p5);
        this.myLineTracer.addPoint(this.p3);
        this.myLineTracer.addPoint(this.p4);
        this.myLineTracer.addPoint(this.p6);
        this.myLineTracer.addPoint(this.p2);
        this.myLineTracer.finish();
    }
}

