/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.LayoutingQueue;
import com.tssap.selena.layout.impl.auto.LineTracer;
import com.tssap.selena.layout.impl.auto.LinkRouter;
import com.tssap.selena.layout.impl.auto.RelayoutException;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;

final class SelfConnectLinkRouter
implements LinkRouter {
    private Optioner myOptioner;
    private LinesManager myLinesManager = null;
    private LayoutingQueue myLayoutingQueue = null;
    private LineTracer myLineTracer = new LineTracer();
    private Edge edge = null;
    private Vertex[][] myLevels = null;
    private int[] myLevelsTop = null;
    private int[] myLevelsBottom = null;
    private Line myLine = new Line(0, 0, 0, 0, null);

    public SelfConnectLinkRouter(Optioner optioner, LinesManager linesManager) {
        this.myOptioner = optioner;
        this.myLinesManager = linesManager;
    }

    public void setLayoutingQueue(LayoutingQueue layoutingQueue) {
        this.myLayoutingQueue = layoutingQueue;
    }

    public void setLevels(Vertex[][] levels) {
        this.myLevels = levels;
    }

    public void setLevelsTop(int[] levelsTop) {
        this.myLevelsTop = levelsTop;
    }

    public void setLevelsBottom(int[] levelsBottom) {
        this.myLevelsBottom = levelsBottom;
    }

    public void remove(Edge e) {
        e.removeFromLinesManager(this.myLinesManager);
    }

    public void route(Edge e) throws RelayoutException {
        Point p4;
        Point p3;
        Point p;
        this.edge = e;
        boolean srcVertical = this.edge.srcInject == 3 || this.edge.srcInject == 4;
        int srcAdd = this.edge.srcInject == 3 || this.edge.srcInject == 1 ? -this.myOptioner.nRectanglesSpace : this.myOptioner.nRectanglesSpace;
        int dstAdd = this.edge.dstInject == 3 || this.edge.dstInject == 1 ? -this.myOptioner.nRectanglesSpace : this.myOptioner.nRectanglesSpace;
        Point p1 = this.edge.getSrcInjectionPoint();
        Point p2 = this.edge.getDstInjectionPoint();
        if (srcVertical) {
            int x = 2 * p2.x - p1.x + dstAdd;
            int y = 2 * p1.y - p2.y + srcAdd;
            p = new Point(x, y, this.edge);
            p3 = new Point(p1.x, y, this.edge);
            p4 = new Point(x, p2.y, this.edge);
        } else {
            int x = 2 * p1.x - p2.x + srcAdd;
            int y = 2 * p2.y - p1.y + dstAdd;
            p = new Point(x, y, this.edge);
            p4 = new Point(p2.x, y, this.edge);
            p3 = new Point(x, p1.y, this.edge);
        }
        if (!this.myLinesManager.isCorrect(p)) {
            this.solveProblem(p);
        }
        if (!this.myLinesManager.isCorrect(p3)) {
            this.solveProblem(p3);
        }
        if (!this.myLinesManager.isCorrect(p4)) {
            this.solveProblem(p4);
        }
        this.myLine.set(p1.x, p1.y, p3.x, p3.y, this.edge);
        if (!this.myLinesManager.isCorrect(this.myLine)) {
            this.solveProblem(this.myLine);
        }
        this.myLine.set(p3.x, p3.y, p.x, p.y, this.edge);
        if (!this.myLinesManager.isCorrect(this.myLine)) {
            this.solveProblem(this.myLine);
        }
        this.myLine.set(p.x, p.y, p4.x, p4.y, this.edge);
        if (!this.myLinesManager.isCorrect(this.myLine)) {
            this.solveProblem(this.myLine);
        }
        this.myLine.set(p4.x, p4.y, p2.x, p2.y, this.edge);
        if (!this.myLinesManager.isCorrect(this.myLine)) {
            this.solveProblem(this.myLine);
        }
        this.myLineTracer.start(this.myLinesManager, this.edge);
        this.myLineTracer.addPoint(p1);
        this.myLineTracer.addPoint(p3);
        this.myLineTracer.addPoint(p);
        this.myLineTracer.addPoint(p4);
        this.myLineTracer.addPoint(p2);
        this.myLineTracer.finish();
    }

    private void solveProblem(Element problem) throws RelayoutException {
        Element reason = this.myLinesManager.getReason();
        if (reason instanceof Point || reason instanceof Line) {
            throw new RelayoutException(reason, problem);
        }
        throw new RuntimeException();
    }
}

