/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Processible;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.LayoutingQueue;
import com.tssap.selena.layout.impl.auto.LineTracer;
import com.tssap.selena.layout.impl.auto.LinkRouter;
import com.tssap.selena.layout.impl.geometry.Point;
import java.util.Iterator;

final class OrthogonalHorizontalLinkRouter
implements LinkRouter {
    private Optioner myOptioner;
    private LayoutingQueue myLayoutingQueue = null;
    private LineTracer myLineTracer = new LineTracer();
    private Vertex[][] myLevels = null;
    private Edge edge = null;
    private Vertex v1 = null;
    private Vertex v2 = null;
    private int way;
    private int level;
    private Point p1;
    private Point p2;
    private Point p3;
    private Point p4;
    private Point p5;
    private Point p6;

    public OrthogonalHorizontalLinkRouter(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public void setLayoutingQueue(LayoutingQueue layoutingQueue) {
        this.myLayoutingQueue = layoutingQueue;
    }

    public void setLevels(Vertex[][] levels) {
    }

    public void setLevelsTop(int[] levelsTop) {
    }

    public void setLevelsBottom(int[] levelsBottom) {
    }

    public void remove(Edge e) {
        throw new RuntimeException();
    }

    public void route(Edge e) {
        this.edge = e;
        this.way = this.edge.way;
        this.v1 = this.edge.vertex1;
        this.v2 = this.edge.vertex2;
        this.level = this.v1.level;
        this.p1 = this.edge.getSrcInjectionPoint();
        this.p2 = this.edge.getDstInjectionPoint();
        int y1 = this.p1.y;
        int y2 = this.p2.y;
        int y = this.way == 1 ? this.edge.y : this.edge.y;
        if (y1 == y2 && y == y1) {
            this.edge.resetPoints();
            this.edge.addPoint(this.p1);
            this.edge.addPoint(this.p2);
            return;
        }
        this.routeLine1_5();
        this.routeLine2_6();
        this.p3 = new Point(this.p5.x, y, this.edge);
        this.p4 = new Point(this.p6.x, y, this.edge);
        this.myLineTracer.start(null, this.edge);
        this.myLineTracer.addPoint(this.p1);
        this.myLineTracer.addPoint(this.p5);
        this.myLineTracer.addPoint(this.p3);
        this.myLineTracer.addPoint(this.p4);
        this.myLineTracer.addPoint(this.p6);
        this.myLineTracer.addPoint(this.p2);
        this.myLineTracer.finish();
    }

    private void routeLine1_5() {
        this.p5 = new Point(this.p1.x + (this.p1.x < this.p2.x ? this.v1.rightExt : -this.v1.leftExt), this.p1.y, this.edge);
        this.routeLineFromSide(this.p1, this.p5);
    }

    private void routeLine2_6() {
        this.p6 = new Point(this.p2.x + (this.p2.x < this.p1.x ? this.v2.rightExt : -this.v2.leftExt), this.p2.y, this.edge);
        this.routeLineFromSide(this.p2, this.p6);
    }

    private void routeLineFromSide(Point inj, Point p) {
        int x = p.x;
        Iterator iter = this.myLayoutingQueue.allBeforeObjects(this.edge);
        if (iter != null) {
            while (iter.hasNext()) {
                boolean srcFlag;
                Processible obj = (Processible)iter.next();
                if (!obj.isProcessed() || !(obj instanceof Edge)) continue;
                Edge e = (Edge)obj;
                if (e.vertex1.level != this.level || e.vertex2.level != this.level || e.vertex1 == e.vertex2) continue;
                if (e.getSrcInjectionX() == inj.x) {
                    srcFlag = true;
                } else {
                    if (e.getDstInjectionX() != inj.x) continue;
                    srcFlag = false;
                }
                int n = e.getPointCount();
                if (n <= 3) continue;
                int newx = e.getPointAt((int)(srcFlag ? 1 : n - 2)).x;
                if (!(x < inj.x ? (x = Math.max(x, newx + this.myOptioner.nLinesSpace)) > inj.x - this.myOptioner.nRectanglesSpace : (x = Math.min(x, newx - this.myOptioner.nLinesSpace)) < inj.x + this.myOptioner.nRectanglesSpace)) continue;
                throw new RuntimeException();
            }
        }
        p.x = x;
    }
}

