/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.CountCrossPermitter;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.StandardIgnorer;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.BendsOptimizer;
import com.tssap.selena.layout.impl.geometry.ConflictIgnorer;
import com.tssap.selena.layout.impl.geometry.CrossPermitter;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;

final class OrthogonalBendsOptimizer
implements BendsOptimizer {
    private Optioner myOptioner;
    private LinesManager myLinesManager;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private CountCrossPermitter myCountCrossPermitter = new CountCrossPermitter();
    private ConflictIgnorer myStandardIgnorer = new StandardIgnorer();
    private Point myPoint = new Point(0, 0, null);
    private Line myLine = new Line(0, 0, 0, 0, null);

    public OrthogonalBendsOptimizer(Optioner optioner, LinesManager linesManager) {
        this.myOptioner = optioner;
        this.myLinesManager = linesManager;
    }

    public void removeUselessPoints(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            if (this.myEdges[i_Edge].getPointCount() > 2) {
                this.removeUselessPoints(this.myEdges[i_Edge]);
            }
            ++i_Edge;
        }
    }

    public void optimizeBends(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        CrossPermitter oldCrossPermitter = this.myLinesManager.getCrossPermitter();
        ConflictIgnorer oldConflictIgnorerBefore = this.myLinesManager.getConflictIgnorerBefore();
        ConflictIgnorer oldConflictIgnorerAfter = this.myLinesManager.getConflictIgnorerAfter();
        int oldFlags = this.myLinesManager.getFlags();
        this.myLinesManager.setCrossPermitter(this.myCountCrossPermitter);
        this.myLinesManager.setConflictIgnorerBefore(this.myStandardIgnorer);
        this.myLinesManager.setConflictIgnorerAfter(null);
        this.myLinesManager.assignFlags(0);
        int[] crossings = null;
        Edge lastEdge = null;
        boolean changeFlag = true;
        while (changeFlag) {
            changeFlag = false;
            int i_Edge = 0;
            while (i_Edge < this.myEdges.length) {
                if (this.myEdges[i_Edge].getPointCount() >= 5 && this.myEdges[i_Edge].vertex1.level != this.myEdges[i_Edge].vertex2.level) {
                    Edge edge = this.myEdges[i_Edge];
                    int n = edge.getPointCount();
                    if (edge != lastEdge) {
                        if (crossings == null || crossings.length < n - 1) {
                            crossings = new int[n - 1];
                        }
                        int i = 0;
                        while (i < n - 1) {
                            crossings[i] = -1;
                            ++i;
                        }
                        lastEdge = edge;
                    }
                    int d = (n - 2) / 2 * 2;
                    block3: while (d >= 2) {
                        int i = 1;
                        while (i < n - d - 1) {
                            Point p1 = edge.getPointAt(i);
                            Point p2 = edge.getPointAt(i + d);
                            Point prev = edge.getPointAt(i - 1);
                            Point next = edge.getPointAt(i + d + 1);
                            if (prev.x == p1.x && next.y == p2.y) {
                                this.myPoint.set(p1.x, p2.y, edge);
                            } else if (prev.y == p1.y && next.x == p2.x) {
                                this.myPoint.set(p2.x, p1.y, edge);
                            } else {
                                throw new RuntimeException();
                            }
                            this.myLinesManager.assignFlags(0);
                            if (this.myLinesManager.isCorrect(this.myPoint)) {
                                this.myLinesManager.assignFlags(240);
                                this.myLine.set(p1.x, p1.y, this.myPoint.x, this.myPoint.y, edge);
                                if (this.myLinesManager.isCorrect(this.myLine)) {
                                    this.myLine.set(this.myPoint.x, this.myPoint.y, p2.x, p2.y, edge);
                                    if (this.myLinesManager.isCorrect(this.myLine)) {
                                        this.myCountCrossPermitter.maxCrossings = Integer.MAX_VALUE;
                                        this.myCountCrossPermitter.crossCounter = 0;
                                        this.myLinesManager.assignFlags(65295);
                                        int j = i;
                                        while (j < i + d) {
                                            Point point1 = edge.getPointAt(j);
                                            Point point2 = edge.getPointAt(j + 1);
                                            if (crossings[j] < 0) {
                                                int old = this.myCountCrossPermitter.crossCounter;
                                                this.myLine.set(point1.x, point1.y, point2.x, point2.y, edge);
                                                if (!this.myLinesManager.isCorrect(this.myLine)) {
                                                    throw new RuntimeException();
                                                }
                                                crossings[j] = this.myCountCrossPermitter.crossCounter - old;
                                            } else {
                                                this.myCountCrossPermitter.crossCounter += crossings[j];
                                            }
                                            ++j;
                                        }
                                        this.myCountCrossPermitter.maxCrossings = this.myCountCrossPermitter.crossCounter;
                                        this.myCountCrossPermitter.crossCounter = 0;
                                        this.myLine.set(p1.x, p1.y, this.myPoint.x, this.myPoint.y, edge);
                                        if (this.myLinesManager.isCorrect(this.myLine)) {
                                            int count1 = this.myCountCrossPermitter.crossCounter;
                                            this.myLine.set(this.myPoint.x, this.myPoint.y, p2.x, p2.y, edge);
                                            if (this.myLinesManager.isCorrect(this.myLine)) {
                                                int count2 = this.myCountCrossPermitter.crossCounter - count1;
                                                this.myLinesManager.assignFlags(0);
                                                int j2 = i - 1;
                                                while (j2 <= i + d) {
                                                    Point point1 = edge.getPointAt(j2);
                                                    Point point2 = edge.getPointAt(j2 + 1);
                                                    this.myLine.set(point1.x, point1.y, point2.x, point2.y, edge);
                                                    this.myLinesManager.remove(this.myLine);
                                                    if (j2 != i - 1) {
                                                        this.myLinesManager.remove(point1);
                                                    }
                                                    ++j2;
                                                }
                                                int j3 = 0;
                                                while (j3 <= d) {
                                                    edge.deletePointAt(i);
                                                    ++j3;
                                                }
                                                Point p = (Point)this.myPoint.clone();
                                                this.myLinesManager.add(p);
                                                this.myLinesManager.add(new Line(prev.x, prev.y, p.x, p.y, edge));
                                                this.myLinesManager.add(new Line(p.x, p.y, next.x, next.y, edge));
                                                edge.insertPointAt(i, p);
                                                crossings[i] = count1;
                                                crossings[i + 1] = count2;
                                                int j4 = i + 2;
                                                while (j4 < n - d + 1) {
                                                    crossings[j4] = crossings[j4 + d - 2];
                                                    ++j4;
                                                }
                                                int i_Icon = 0;
                                                while (i_Icon < edge.getIconCount()) {
                                                    Icon icon = edge.getIconAt(i_Icon);
                                                    int seg = icon.getSegment();
                                                    if (seg >= i - 1) {
                                                        if (seg > i + d) {
                                                            icon.setSegment(seg - d);
                                                        } else {
                                                            icon.setSegment(-1);
                                                        }
                                                    }
                                                    ++i_Icon;
                                                }
                                                changeFlag = true;
                                                --i_Edge;
                                                break block3;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        d -= 2;
                    }
                }
                ++i_Edge;
            }
        }
        this.myLinesManager.setCrossPermitter(oldCrossPermitter);
        this.myLinesManager.setConflictIgnorerBefore(oldConflictIgnorerBefore);
        this.myLinesManager.setConflictIgnorerAfter(oldConflictIgnorerAfter);
        this.myLinesManager.assignFlags(oldFlags);
    }

    private void removeUselessPoints(Edge edge) {
        int i = 1;
        while (i < edge.getPointCount() - 1) {
            block5: {
                block4: {
                    block6: {
                        Point next;
                        Point prev;
                        Point p;
                        block3: {
                            p = edge.getPointAt(i);
                            prev = edge.getPointAt(i - 1);
                            next = edge.getPointAt(i + 1);
                            if (prev.x != p.x) break block3;
                            if (p.x == next.x) break block4;
                            break block5;
                        }
                        if (prev.y != p.y) break block6;
                        if (p.y == next.y) break block4;
                        break block5;
                    }
                    throw new RuntimeException();
                }
                edge.deletePointAt(i);
                int i_Icon = 0;
                while (i_Icon < edge.getIconCount()) {
                    Icon icon = edge.getIconAt(i_Icon);
                    int seg = icon.getSegment();
                    if (seg >= i) {
                        icon.setSegment(seg - 1);
                    }
                    ++i_Icon;
                }
                --i;
            }
            ++i;
        }
    }
}

