/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.EdgeBase;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.HashSetIgnorer;
import com.tssap.selena.layout.impl.IconSpacing;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Processible;
import com.tssap.selena.layout.impl.StandardIgnorer;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.EdgesCrossPermitter;
import com.tssap.selena.layout.impl.auto.ExpandHorizontalPipeException;
import com.tssap.selena.layout.impl.auto.LayoutingQueue;
import com.tssap.selena.layout.impl.auto.LinkRouter;
import com.tssap.selena.layout.impl.auto.OrthogonalHorizontalLinkRouter;
import com.tssap.selena.layout.impl.auto.OrthogonalVerticalLinkRouter;
import com.tssap.selena.layout.impl.auto.RelayoutException;
import com.tssap.selena.layout.impl.auto.SelfConnectLinkRouter;
import com.tssap.selena.layout.impl.auto.StraightHorizontalLinkRouter;
import com.tssap.selena.layout.impl.auto.StraightVerticalLinkRouter;
import com.tssap.selena.layout.impl.auto.YCoordsAssigner;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import java.util.Iterator;
import java.util.Vector;

class LinksRouter {
    private Optioner myOptioner;
    private LinesManager myLinesManager;
    private int fromLevel;
    private int toLevel;
    private LayoutingQueue myLayoutingQueue = null;
    private LayoutingQueue myLayoutingQueue1 = null;
    private LayoutingQueue myLayoutingQueue2 = null;
    private LayoutingQueue myLayoutingQueue3 = null;
    private HashSetIgnorer myHashSetIgnorer = new HashSetIgnorer();
    private LinkRouter myVerticalLinkRouter;
    private LinkRouter myHorizontalLinkRouter;
    private LinkRouter mySelfConnectLinkRouter;
    private YCoordsAssigner myYCoordsAssigner;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vertex[][] myLevels = null;
    private int myStartY;
    private int[] myLevelsTop = null;
    private int[] myLevelsBottom = null;

    public LinksRouter(Optioner optioner, YCoordsAssigner yCoordsAssigner) {
        this.myOptioner = optioner;
        this.myYCoordsAssigner = yCoordsAssigner;
        this.myLinesManager = new LinesManager(this.myOptioner);
        this.myLinesManager.setCrossPermitter(new EdgesCrossPermitter());
        this.myLinesManager.setConflictIgnorerBefore(new StandardIgnorer());
        this.myLinesManager.setConflictIgnorerAfter(this.myHashSetIgnorer);
        this.myLinesManager.setFlags(this.myOptioner.routingFlags);
        if (this.myOptioner.bOrthogonalMode) {
            this.myVerticalLinkRouter = new OrthogonalVerticalLinkRouter(this.myOptioner);
            this.myHorizontalLinkRouter = new OrthogonalHorizontalLinkRouter(this.myOptioner);
            this.mySelfConnectLinkRouter = new SelfConnectLinkRouter(this.myOptioner, this.myLinesManager);
        } else {
            this.myVerticalLinkRouter = new StraightVerticalLinkRouter(this.myOptioner, this.myLinesManager);
            this.myHorizontalLinkRouter = new StraightHorizontalLinkRouter(this.myOptioner, this.myLinesManager);
            this.mySelfConnectLinkRouter = new SelfConnectLinkRouter(this.myOptioner, this.myLinesManager);
        }
    }

    public final void routeLinks(Vertex[] vertices, Edge[] edges, Vertex[][] levels, int startY) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myLevels = levels;
        this.myStartY = startY;
        this.myVerticalLinkRouter.setLevels(this.myLevels);
        this.myHorizontalLinkRouter.setLevels(this.myLevels);
        this.mySelfConnectLinkRouter.setLevels(this.myLevels);
        this.myLevelsTop = new int[this.myLevels.length];
        this.myLevelsBottom = new int[this.myLevels.length];
        int i_Level = 0;
        while (i_Level < this.myLevels.length) {
            this.myLevelsTop[i_Level] = 1000;
            this.myLevelsBottom[i_Level] = -1000;
            ++i_Level;
        }
        this.myVerticalLinkRouter.setLevelsTop(this.myLevelsTop);
        this.myHorizontalLinkRouter.setLevelsTop(this.myLevelsTop);
        this.mySelfConnectLinkRouter.setLevelsTop(this.myLevelsTop);
        this.myVerticalLinkRouter.setLevelsBottom(this.myLevelsBottom);
        this.myHorizontalLinkRouter.setLevelsBottom(this.myLevelsBottom);
        this.mySelfConnectLinkRouter.setLevelsBottom(this.myLevelsBottom);
        int i_Level2 = -1;
        while (i_Level2 < this.myLevels.length) {
            this.routeBetween(i_Level2);
            ++i_Level2;
        }
    }

    private final void routeBetween(int level) {
        this.fromLevel = level;
        this.toLevel = this.fromLevel + 1;
        if (this.fromLevel != -1 && this.toLevel != this.myLevels.length) {
            this.myYCoordsAssigner.assignYCoords(this.toLevel, this.myLevelsBottom[this.fromLevel] + this.myOptioner.nSpaceV);
        }
        if (this.toLevel != this.myLevels.length) {
            this.calculateLevelTopAndBottom(this.toLevel);
        }
        this.createLayoutingQueues();
        this.assignIconsSpaces();
        this.initialPipeExpanding();
        if (this.myOptioner.bOrthogonalMode) {
            this.arrangeLinksY();
        }
        this.createTotalLayoutingQueue();
        if (this.myLayoutingQueue.size() == 0) {
            return;
        }
        this.myVerticalLinkRouter.setLayoutingQueue(this.myLayoutingQueue);
        this.myHorizontalLinkRouter.setLayoutingQueue(this.myLayoutingQueue);
        this.mySelfConnectLinkRouter.setLayoutingQueue(this.myLayoutingQueue);
        this.myHashSetIgnorer.clear();
        if (!this.myOptioner.bOrthogonalMode) {
            this.addInitialIgnorings();
        }
        block3: while (true) {
            Processible current;
            Iterator iter;
            if (!this.myOptioner.bOrthogonalMode) {
                iter = this.myLayoutingQueue.begin();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof Edge)) continue;
                    Edge e = (Edge)obj;
                    e.srcFantom = null;
                    e.dstFantom = null;
                }
                this.myLinesManager.clear();
                int i_Level = this.fromLevel;
                while (i_Level <= this.toLevel) {
                    if (i_Level != -1 && i_Level != this.myLevels.length) {
                        Vertex[] nodes = this.myLevels[i_Level];
                        int i = 0;
                        while (i < nodes.length) {
                            Vertex v = nodes[i];
                            if (!v.isDummy) {
                                this.myLinesManager.add(v);
                            } else {
                                Point p = new Point(v.getLeft() + v.getWidth() / 2, v.getTop(), v);
                                this.myLinesManager.add(p);
                            }
                            ++i;
                        }
                    }
                    ++i_Level;
                }
            }
            while ((current = this.myLayoutingQueue.current()) != null) {
                block27: {
                    try {
                        if (iter instanceof Edge) {
                            Edge edge = (Edge)((Object)iter);
                            Vertex vertex1 = edge.vertex1;
                            Vertex vertex2 = edge.vertex2;
                            int level1 = vertex1.level;
                            int level2 = vertex2.level;
                            if (level1 != level2) {
                                this.myVerticalLinkRouter.route(edge);
                            } else if (vertex1 != vertex2) {
                                this.myHorizontalLinkRouter.route(edge);
                            } else {
                                this.mySelfConnectLinkRouter.route(edge);
                            }
                            break block27;
                        }
                        if (iter instanceof EdgesGroup) {
                            EdgesGroup group = (EdgesGroup)((Object)iter);
                            Edge[] edges = group.myEdges;
                            int i = 0;
                            while (i < edges.length) {
                                Edge edge = edges[i];
                                edge.y = group.y;
                                this.myVerticalLinkRouter.route(edge);
                                edge.process();
                                ++i;
                            }
                            break block27;
                        }
                        throw new RuntimeException();
                    }
                    catch (RelayoutException ex) {
                        Edge edge = (Edge)ex.obj;
                        if (!edge.isProcessed() || this.myLayoutingQueue.getOrder(edge, (Processible)((Object)iter)) > 0) {
                            this.myHashSetIgnorer.addConflict(ex.myConflict);
                            continue;
                        }
                        this.myLayoutingQueue.setOrder((Processible)((Object)iter), edge);
                        this.myLayoutingQueue.unprocess(edge);
                        Vertex vertex1 = edge.vertex1;
                        Vertex vertex2 = edge.vertex2;
                        int level1 = vertex1.level;
                        int level2 = vertex2.level;
                        if (level1 != level2) {
                            this.myVerticalLinkRouter.remove(edge);
                            continue;
                        }
                        if (vertex1 != vertex2) {
                            this.myHorizontalLinkRouter.remove(edge);
                            continue;
                        }
                        this.mySelfConnectLinkRouter.remove(edge);
                        continue;
                    }
                    catch (ExpandHorizontalPipeException ex) {
                        int howMuch = Math.max(ex.howMuch, this.myOptioner.minExpandPipe);
                        this.expandPipe(this.fromLevel, howMuch);
                        this.myLayoutingQueue.unprocessAll();
                        continue block3;
                    }
                }
                this.myLayoutingQueue.process();
            }
            break;
        }
    }

    private final void createLayoutingQueues() {
        if (this.myOptioner.bOrthogonalMode) {
            int i_Edge = 0;
            while (i_Edge < this.myEdges.length) {
                Edge edge = this.myEdges[i_Edge];
                if (edge.myGroup != null) {
                    edge.myGroup.tempFlag = false;
                }
                ++i_Edge;
            }
        }
        this.myLayoutingQueue1 = new LayoutingQueue();
        if (this.fromLevel != -1) {
            this.addEdges(this.myLayoutingQueue1, this.fromLevel, this.fromLevel, 5);
            this.addEdges(this.myLayoutingQueue1, this.fromLevel, this.fromLevel, 6);
            this.addEdges(this.myLayoutingQueue1, this.fromLevel, this.fromLevel, 2);
        }
        this.myLayoutingQueue2 = new LayoutingQueue();
        if (this.fromLevel != this.myLevels.length - 1) {
            this.addEdges(this.myLayoutingQueue2, this.fromLevel + 1, this.fromLevel + 1, 3);
            this.addEdges(this.myLayoutingQueue2, this.fromLevel + 1, this.fromLevel + 1, 4);
            this.addEdges(this.myLayoutingQueue2, this.fromLevel + 1, this.fromLevel + 1, 1);
        }
        this.myLayoutingQueue3 = new LayoutingQueue();
        if (this.fromLevel != -1 && this.fromLevel != this.myLevels.length - 1) {
            this.addEdges(this.myLayoutingQueue3, this.fromLevel, this.fromLevel + 1, -1);
        }
        Iterator iter = this.myLayoutingQueue3.begin();
        while (iter.hasNext()) {
            int mostLeft;
            Object obj = iter.next();
            if (!(obj instanceof EdgesGroup)) continue;
            EdgesGroup group = (EdgesGroup)obj;
            Edge[] edges = group.myEdges;
            int mostRight = mostLeft = group.vertex2.getLeft() + group.dstOffset;
            int i = 0;
            while (i < edges.length) {
                Edge edge = edges[i];
                int x = edge.getSrcInjectionX();
                mostLeft = Math.min(mostLeft, x);
                mostRight = Math.max(mostRight, x);
                ++i;
            }
            group.mostLeft = mostLeft;
            group.mostRight = mostRight;
        }
        this.addOrders(this.myLayoutingQueue1);
        this.addOrders(this.myLayoutingQueue2);
        this.addOrders(this.myLayoutingQueue3);
    }

    private final void createTotalLayoutingQueue() {
        this.myLayoutingQueue1.add(this.myLayoutingQueue2);
        this.myLayoutingQueue1.add(this.myLayoutingQueue3);
        this.myLayoutingQueue = this.myLayoutingQueue1;
        this.myLayoutingQueue1 = null;
        this.myLayoutingQueue2 = null;
        this.myLayoutingQueue3 = null;
    }

    private final void addEdges(LayoutingQueue queue, int level1, int level2, int way) {
        Vertex[] nodes = this.myLevels[level1];
        int i = 0;
        while (i < nodes.length) {
            Vertex v = nodes[i];
            Link[] links = v.myLinks;
            int i_Link = 0;
            while (i_Link < links.length) {
                Link link = links[i_Link];
                Vertex vertex = link.myVertex;
                Edge edge = link.myEdge;
                if (vertex.level == level2 && (level1 != level2 || link.iDirected >= 0 && edge.way == way)) {
                    EdgesGroup group = edge.myGroup;
                    if (group == null) {
                        queue.add(edge);
                    } else if (!group.tempFlag) {
                        queue.add(group);
                        group.tempFlag = true;
                    }
                }
                ++i_Link;
            }
            ++i;
        }
    }

    private final void addOrders(LayoutingQueue queue) {
        Processible obj2;
        Processible obj1;
        int j;
        int i;
        if (this.myOptioner.addStrongOrders && (this.myOptioner.bOrthogonalMode || queue != this.myLayoutingQueue3)) {
            queue.freeze();
            i = 1;
            while (i < queue.getNotProcessedList().size()) {
                j = 0;
                int k = i;
                while (k < queue.getNotProcessedList().size()) {
                    obj1 = (Processible)queue.getNotProcessedList().get(j);
                    int order = this.calculateStrongOrder(obj1, obj2 = (Processible)queue.getNotProcessedList().get(k));
                    if (order > 0) {
                        queue.setOrder(obj1, obj2);
                    } else if (order < 0) {
                        queue.setOrder(obj2, obj1);
                    }
                    ++j;
                    ++k;
                }
                ++i;
            }
            queue.melt();
        }
        if (this.myOptioner.addNearInjectionsOrders && this.myOptioner.bOrthogonalMode && queue == this.myLayoutingQueue3) {
            queue.freeze();
            i = 0;
            while (i < queue.getNotProcessedList().size()) {
                Processible obj12 = (Processible)queue.getNotProcessedList().get(i);
                j = i + 1;
                while (j < queue.getNotProcessedList().size()) {
                    Processible obj22 = (Processible)queue.getNotProcessedList().get(j);
                    if (obj12 instanceof Edge && obj22 instanceof Edge) {
                        this.processForNearInjections((Edge)obj12, (Edge)obj22);
                    } else if (obj12 instanceof Edge && obj22 instanceof EdgesGroup) {
                        this.processForNearInjections((Edge)obj12, (EdgesGroup)obj22);
                    } else if (obj12 instanceof EdgesGroup && obj22 instanceof Edge) {
                        this.processForNearInjections((Edge)obj22, (EdgesGroup)obj12);
                    } else if (obj12 instanceof EdgesGroup && obj22 instanceof EdgesGroup) {
                        this.processForNearInjections((EdgesGroup)obj12, (EdgesGroup)obj22);
                    } else {
                        throw new RuntimeException();
                    }
                    ++j;
                }
                ++i;
            }
            queue.melt();
        }
        if (this.myOptioner.bOrthogonalMode || queue != this.myLayoutingQueue3) {
            queue.freeze();
            i = 1;
            while (i < queue.getNotProcessedList().size()) {
                j = 0;
                int k = i;
                while (k < queue.getNotProcessedList().size()) {
                    obj1 = (Processible)queue.getNotProcessedList().get(j);
                    if (this.needToOrder(obj1, obj2 = (Processible)queue.getNotProcessedList().get(k)) && !queue.setOrder(obj1, obj2)) {
                        throw new RuntimeException();
                    }
                    ++j;
                    ++k;
                }
                ++i;
            }
            queue.melt();
        }
    }

    private final int calculateStrongOrder(Object obj1, Object obj2) {
        if (obj1 instanceof Edge && obj2 instanceof Edge) {
            return this.calculateStrongOrder((Edge)obj1, (Edge)obj2);
        }
        if (obj1 instanceof Edge && obj2 instanceof EdgesGroup) {
            return this.calculateStrongOrder((Edge)obj1, (EdgesGroup)obj2);
        }
        if (obj1 instanceof EdgesGroup && obj2 instanceof Edge) {
            return -this.calculateStrongOrder((Edge)obj2, (EdgesGroup)obj1);
        }
        if (obj1 instanceof EdgesGroup && obj2 instanceof EdgesGroup) {
            return this.calculateStrongOrder((EdgesGroup)obj1, (EdgesGroup)obj2);
        }
        throw new RuntimeException();
    }

    private final int calculateStrongOrder(Edge edge1, Edge edge2) {
        Vertex v11 = edge1.vertex1;
        Vertex v12 = edge1.vertex2;
        Vertex v21 = edge2.vertex1;
        Vertex v22 = edge2.vertex2;
        if (v11 == v12 || v21 == v22) {
            return 0;
        }
        int level11 = v11.level;
        int level12 = v12.level;
        if (level11 == level12) {
            if (!EdgesCrossPermitter.permitCrossing(edge1, edge2)) {
                int inj11x = edge1.getSrcInjectionX();
                int inj12x = edge1.getDstInjectionX();
                int inj21x = edge2.getSrcInjectionX();
                int inj22x = edge2.getDstInjectionX();
                if (inj11x == inj21x) {
                    return this.calculateOrderByY(edge1.getSrcInjectionY(), edge2.getSrcInjectionY(), edge1.way);
                }
                if (inj11x == inj22x) {
                    return this.calculateOrderByY(edge1.getSrcInjectionY(), edge2.getDstInjectionY(), edge1.way);
                }
                if (inj12x == inj21x) {
                    return this.calculateOrderByY(edge1.getDstInjectionY(), edge2.getSrcInjectionY(), edge1.way);
                }
                if (inj12x == inj22x) {
                    return this.calculateOrderByY(edge1.getDstInjectionY(), edge2.getDstInjectionY(), edge1.way);
                }
                int left1 = Math.min(inj11x, inj12x);
                int right1 = Math.max(inj11x, inj12x);
                int left2 = Math.min(inj21x, inj22x);
                int right2 = Math.max(inj21x, inj22x);
                if (left1 < left2 && right2 < right1) {
                    return -1;
                }
                if (left2 < left1 && right1 < right2) {
                    return 1;
                }
            }
        } else if (this.myOptioner.bOrthogonalMode) {
            boolean srcFlag1 = level11 > level12;
            int level21 = v21.level;
            int level22 = v22.level;
            boolean srcFlag2 = level21 > level22;
            int inj11x = edge1.getInjectionX(srcFlag1);
            int inj12x = edge1.getInjectionX(!srcFlag1);
            int inj21x = edge2.getInjectionX(srcFlag2);
            int inj22x = edge2.getInjectionX(!srcFlag2);
            boolean inverse = false;
            if (inj11x > inj21x) {
                int temp = inj11x;
                inj11x = inj21x;
                inj21x = temp;
                temp = inj12x;
                inj12x = inj22x;
                inj22x = temp;
                inverse = true;
            }
            if (inj12x >= inj22x) {
                return 0;
            }
            if (inj11x < inj12x && inj21x < inj22x) {
                if (inj21x - inj12x < this.myOptioner.nLinesSpace) {
                    return inverse ? -1 : 1;
                }
            } else if (inj11x > inj12x && inj21x > inj22x && inj22x - inj11x < this.myOptioner.nLinesSpace) {
                return inverse ? 1 : -1;
            }
        }
        return 0;
    }

    private final int calculateOrderByY(int y1, int y2, int way) {
        if (way == 1) {
            return y1 > y2 ? 1 : -1;
        }
        return y1 < y2 ? 1 : -1;
    }

    private final int calculateStrongOrder(Edge edge, EdgesGroup group) {
        int inj1x = edge.getSrcInjectionX();
        int inj2x = edge.getDstInjectionX();
        int left1 = Math.min(inj1x, inj2x);
        int right1 = Math.max(inj1x, inj2x);
        int left2 = group.mostLeft;
        int right2 = group.mostRight;
        int left = Math.max(left1, left2);
        int right = Math.min(right1, right2);
        if (right - left < 0) {
            return 0;
        }
        int level1 = edge.vertex1.level;
        int level = group.vertex2.level;
        int level2 = edge.vertex2.level;
        if (level != level2) {
            int temp = inj1x;
            inj1x = inj2x;
            inj2x = temp;
        }
        int injx = group.vertex2.getLeft() + group.dstOffset;
        int s1 = 0;
        if (left1 <= injx && injx <= right1) {
            ++s1;
        }
        if (left2 <= inj1x && inj1x <= right2) {
            ++s1;
        }
        int s2 = 0;
        if (left2 <= inj2x && inj2x <= right2) {
            ++s2;
        }
        if (s2 <= s1) {
            Edge[] edges = group.myEdges;
            int i = 0;
            while (i < edges.length) {
                Edge e = edges[i];
                int x = e.getSrcInjectionX();
                if (left1 <= x && x <= right1 && ++s2 > s1) break;
                ++i;
            }
        }
        if (s1 == s2) {
            return 0;
        }
        if (level == Math.min(level1, level2)) {
            return s1 < s2 ? 1 : -1;
        }
        return s1 < s2 ? -1 : 1;
    }

    private final int calculateStrongOrder(EdgesGroup group1, EdgesGroup group2) {
        int s2;
        int left1 = group1.mostLeft;
        int right1 = group1.mostRight;
        int left2 = group2.mostLeft;
        int right2 = group2.mostRight;
        int left = Math.max(left1, left2);
        int right = Math.min(right1, right2);
        if (right - left < 0) {
            return 0;
        }
        int s1 = this.calculateCrossingsWith(group1, left2, right2, false) + this.calculateCrossingsWith(group2, left1, right1, true);
        if (s1 == (s2 = this.calculateCrossingsWith(group1, left2, right2, true) + this.calculateCrossingsWith(group2, left1, right1, false))) {
            return 0;
        }
        return s1 < s2 ? 1 : -1;
    }

    private final int calculateCrossingsWith(EdgesGroup group, int left, int right, boolean above) {
        boolean upward;
        Edge e = group.myEdges[0];
        boolean bl = upward = e.vertex1.level > e.vertex2.level;
        if (upward && above || !upward && !above) {
            int injx = group.vertex2.getLeft() + group.dstOffset;
            return left <= injx && injx <= right ? 1 : 0;
        }
        int s = 0;
        Edge[] edges = group.myEdges;
        int i = 0;
        while (i < edges.length) {
            e = edges[i];
            int x = e.getSrcInjectionX();
            if (left <= x && x <= right) {
                ++s;
            }
            ++i;
        }
        return s;
    }

    private final boolean needToOrder(Object obj1, Object obj2) {
        int right2;
        int left2;
        int right1;
        int left1;
        if (obj1 instanceof Edge && obj2 instanceof Edge) {
            return this.needToOrder((Edge)obj1, (Edge)obj2);
        }
        if (obj1 instanceof Edge) {
            Edge edge1 = (Edge)obj1;
            int inj11x = edge1.getSrcInjectionX();
            int inj12x = edge1.getDstInjectionX();
            left1 = Math.min(inj11x, inj12x);
            right1 = Math.max(inj11x, inj12x);
        } else {
            EdgesGroup group1 = (EdgesGroup)obj1;
            left1 = group1.mostLeft;
            right1 = group1.mostRight;
        }
        if (obj2 instanceof Edge) {
            Edge edge2 = (Edge)obj2;
            int inj21x = edge2.getSrcInjectionX();
            int inj22x = edge2.getDstInjectionX();
            left2 = Math.min(inj21x, inj22x);
            right2 = Math.max(inj21x, inj22x);
        } else {
            EdgesGroup group2 = (EdgesGroup)obj2;
            left2 = group2.mostLeft;
            right2 = group2.mostRight;
        }
        int left = Math.max(left1, left2);
        int right = Math.min(right1, right2);
        return right - left > -this.myOptioner.nLinesSpace;
    }

    private final boolean needToOrder(Edge edge1, Edge edge2) {
        Vertex v11 = edge1.vertex1;
        Vertex v12 = edge1.vertex2;
        Vertex v21 = edge2.vertex1;
        Vertex v22 = edge2.vertex2;
        if (v11 == v12 || v21 == v22) {
            return false;
        }
        int level11 = v11.level;
        int level12 = v12.level;
        if (level11 != level12) {
            if (!this.myOptioner.bOrthogonalMode) {
                return false;
            }
            int inj11x = edge1.getSrcInjectionX();
            int inj12x = edge1.getDstInjectionX();
            int inj21x = edge2.getSrcInjectionX();
            int inj22x = edge2.getDstInjectionX();
            int left1 = Math.min(inj11x, inj12x);
            int right1 = Math.max(inj11x, inj12x);
            int left2 = Math.min(inj21x, inj22x);
            int right2 = Math.max(inj21x, inj22x);
            int left = Math.max(left1, left2);
            int right = Math.min(right1, right2);
            return right - left > -this.myOptioner.nLinesSpace;
        }
        int pos11 = v11.absPos;
        int pos12 = v12.absPos;
        int pos21 = v21.absPos;
        int pos22 = v22.absPos;
        int leftPos1 = Math.min(pos11, pos12);
        int leftPos2 = Math.min(pos21, pos22);
        int rightPos1 = Math.max(pos11, pos12);
        int rightPos2 = Math.max(pos21, pos22);
        int left = Math.max(leftPos1, leftPos2);
        int right = Math.min(rightPos1, rightPos2);
        return right - left > (this.myOptioner.bOrthogonalMode ? 0 : 1);
    }

    private final void processForNearInjections(EdgesGroup group1, EdgesGroup group2) {
        Edge[] edges1 = group1.myEdges;
        Edge[] edges2 = group2.myEdges;
        int i = 0;
        while (i < edges1.length) {
            int j = 0;
            while (j < edges2.length) {
                this.processForNearInjections(edges1[i], edges2[j]);
                ++j;
            }
            ++i;
        }
    }

    private final void processForNearInjections(Edge edge, EdgesGroup group) {
        Edge[] edges = group.myEdges;
        int i = 0;
        while (i < edges.length) {
            this.processForNearInjections(edge, edges[i]);
            ++i;
        }
    }

    private final void processForNearInjections(Edge edge1, Edge edge2) {
        boolean ok;
        int order2;
        boolean ok2;
        EdgeBase obj1 = edge1.myGroup == null ? edge1 : edge1.myGroup;
        EdgeBase obj2 = edge2.myGroup == null ? edge2 : edge2.myGroup;
        boolean inverse = edge1.vertex1.level != edge2.vertex1.level;
        int order1 = this.calculateNearInjectionsOrder(edge1, true, edge2, inverse);
        if (order1 != 0 && !(ok2 = order1 > 0 ? this.myLayoutingQueue3.setOrder(obj1, obj2) : this.myLayoutingQueue3.setOrder(obj2, obj1)) && this.myOptioner.separateNearInjections) {
            this.separateInjections(edge1, true, edge2, inverse);
        }
        if ((order2 = this.calculateNearInjectionsOrder(edge1, false, edge2, !inverse)) != 0 && !(ok = order2 > 0 ? this.myLayoutingQueue3.setOrder(obj1, obj2) : this.myLayoutingQueue3.setOrder(obj2, obj1)) && this.myOptioner.separateNearInjections) {
            this.separateInjections(edge1, false, edge2, !inverse);
        }
    }

    private final int calculateNearInjectionsOrder(Edge edge1, boolean srcFlag1, Edge edge2, boolean srcFlag2) {
        if (Math.abs(edge1.getInjectionX(srcFlag1) - edge2.getInjectionX(srcFlag2)) < this.myOptioner.nLinesSpace) {
            return edge1.getInjectionY(srcFlag1) > edge2.getInjectionY(srcFlag2) ? -1 : 1;
        }
        return 0;
    }

    private final void separateInjections(Edge edge1, boolean srcFlag1, Edge edge2, boolean srcFlag2) {
        if (!this.shiftInjection(edge1, srcFlag1, edge2.getInjectionX(srcFlag2))) {
            this.shiftInjection(edge2, srcFlag2, edge1.getInjectionX(srcFlag1));
        }
    }

    private final boolean shiftInjection(Edge edge, boolean srcFlag, int fromX) {
        block25: {
            int x;
            int right;
            int inj2;
            Vertex v;
            block21: {
                int dist;
                int offset;
                EdgesGroup group = edge.myGroup;
                Vertex v1 = edge.vertex1;
                Vertex v2 = edge.vertex2;
                v = srcFlag ? v1 : v2;
                int inj1 = edge.getInjectionX(srcFlag);
                inj2 = edge.getInjectionX(!srcFlag);
                if (Math.abs(fromX - inj1) >= this.myOptioner.nLinesSpace) {
                    throw new RuntimeException();
                }
                if (v.isDummy) break block21;
                int fromOffset = fromX - v.getLeft();
                int inject = srcFlag ? edge.srcInject : edge.dstInject;
                Link[] links = v.myLinks;
                int left = -this.myOptioner.nLinesSpace;
                int right2 = v.getWidth() + this.myOptioner.nLinesSpace;
                int i_Link = 0;
                while (i_Link < links.length) {
                    block22: {
                        block24: {
                            Edge e;
                            block23: {
                                e = links[i_Link].myEdge;
                                if (e == edge || !srcFlag && group != null && e.myGroup == group) break block22;
                                if (e.vertex1 != v || e.srcInject != inject) break block23;
                                offset = e.srcOffset;
                                break block24;
                            }
                            if (e.vertex2 != v || e.dstInject != inject) break block22;
                            offset = e.dstOffset;
                        }
                        if (left < offset && offset < fromOffset) {
                            left = offset;
                        } else if (fromOffset < offset && offset < right2) {
                            right2 = offset;
                        }
                    }
                    ++i_Link;
                }
                int inj1Offset = inj1 - v.getLeft();
                if (inj1Offset < left || inj1Offset > right2) {
                    return false;
                }
                offset = inj2 < fromX ? ((dist = fromOffset - left) >= 2 * this.myOptioner.nLinesSpace ? fromOffset - this.myOptioner.nLinesSpace : fromOffset - dist / 2) : ((dist = right2 - fromOffset) >= 2 * this.myOptioner.nLinesSpace ? fromOffset + this.myOptioner.nLinesSpace : fromOffset + dist / 2);
                offset = Math.max(0, offset);
                offset = Math.min(v.getWidth(), offset);
                if (srcFlag) {
                    edge.srcOffset = offset;
                } else {
                    edge.dstOffset = offset;
                    if (group != null) {
                        group.dstOffset = offset;
                        Edge[] edges = group.myEdges;
                        int i = 0;
                        while (i < edges.length) {
                            edges[i].dstOffset = offset;
                            ++i;
                        }
                    }
                }
                if (group != null) {
                    int mostLeft;
                    Edge[] edges = group.myEdges;
                    int mostRight = mostLeft = group.vertex2.getLeft() + group.dstOffset;
                    int i = 0;
                    while (i < edges.length) {
                        Edge e = edges[i];
                        int x2 = e.getSrcInjectionX();
                        mostLeft = Math.min(mostLeft, x2);
                        mostRight = Math.max(mostRight, x2);
                        ++i;
                    }
                    group.mostLeft = mostLeft;
                    group.mostRight = mostRight;
                }
                if (offset - left < this.myOptioner.nLinesSpace || right2 - offset < this.myOptioner.nLinesSpace) {
                    return false;
                }
                break block25;
            }
            Vertex[] nodes = this.myLevels[v.level];
            int absPos = v.absPos;
            int left = absPos > 0 ? nodes[absPos - 1].getRight() + this.myOptioner.nSpaceH / 2 : Integer.MIN_VALUE;
            int n = right = absPos < nodes.length - 1 ? nodes[absPos + 1].getLeft() - this.myOptioner.nSpaceH / 2 : Integer.MAX_VALUE;
            if (inj2 < fromX) {
                x = fromX - this.myOptioner.nLinesSpace;
                if (x < left) {
                    x = left;
                }
            } else {
                x = fromX + this.myOptioner.nLinesSpace;
                if (x > right) {
                    x = right;
                }
            }
            v.setX(x);
        }
        return true;
    }

    private final void addInitialIgnorings() {
    }

    private final void calculateLevelTopAndBottom(int level) {
        Vertex[] nodes = this.myLevels[level];
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        int i = 0;
        while (i < nodes.length) {
            Vertex vertex = nodes[i];
            top = Math.min(top, vertex.getTop() - vertex.topExt);
            bottom = Math.max(bottom, vertex.getBottom() + vertex.bottomExt);
            ++i;
        }
        this.myLevelsTop[level] = top;
        this.myLevelsBottom[level] = bottom;
    }

    private final void assignIconsSpaces() {
        this.assignIconsSpaces(this.myLayoutingQueue1);
        this.assignIconsSpaces(this.myLayoutingQueue2);
        this.assignIconsSpaces(this.myLayoutingQueue3);
    }

    private final void assignIconsSpaces(LayoutingQueue layoutingQueue) {
        Iterator iter = layoutingQueue.begin();
        while (iter.hasNext()) {
            EdgeBase e = (EdgeBase)iter.next();
            e.aboveSpace = IconSpacing.calculateMediumIconsHeight(e, 1);
            e.underSpace = IconSpacing.calculateMediumIconsHeight(e, -1);
            if (!(e instanceof EdgesGroup)) continue;
            EdgesGroup group = (EdgesGroup)e;
            Edge[] edges = group.myEdges;
            int i = 0;
            while (i < edges.length) {
                Edge edge = edges[i];
                edge.aboveSpace = e.aboveSpace;
                edge.underSpace = e.underSpace;
                ++i;
            }
        }
    }

    private final void initialPipeExpanding() {
        if (this.toLevel == this.myLevels.length) {
            return;
        }
        int height1 = this.calculateQueueHeight(this.myLayoutingQueue1);
        int height2 = this.calculateQueueHeight(this.myLayoutingQueue2);
        int height3 = this.myOptioner.bOrthogonalMode ? this.calculateQueueHeight(this.myLayoutingQueue3) : 0;
        int expand = 0;
        if (this.fromLevel >= 0) {
            expand += height1;
            expand += height3;
        }
        this.expandPipe(this.fromLevel, expand += height2);
    }

    private final int calculateQueueHeight(LayoutingQueue layoutingQueue) {
        int height = 0;
        Iterator iter = layoutingQueue.begin();
        while (iter.hasNext()) {
            EdgeBase e = (EdgeBase)iter.next();
            int way = e instanceof Edge ? ((Edge)e).way : -1;
            int fullSpace = e.aboveSpace + e.underSpace;
            int h = fullSpace + this.myOptioner.nRectanglesSpace;
            Iterator before = layoutingQueue.beforeObjects(e);
            if (before != null) {
                int s = way == 1 ? e.underSpace : e.aboveSpace;
                while (before.hasNext()) {
                    EdgeBase e1 = (EdgeBase)before.next();
                    int s1 = way == 1 ? e1.aboveSpace : e1.underSpace;
                    int space = s > 0 || s1 > 0 ? Math.max(this.myOptioner.nIconsSpace, this.myOptioner.nLinesSpace - s - s1) : this.myOptioner.nLinesSpace;
                    h = Math.max(h, e1.tempInt + space + fullSpace);
                }
            }
            e.tempInt = h;
            height = Math.max(height, h);
        }
        return height;
    }

    private final void arrangeLinksY() {
        this.calculateLinksBounds(this.myLayoutingQueue1);
        this.calculateLinksBounds(this.myLayoutingQueue2);
        this.assignLinksY(this.myLayoutingQueue1);
        this.assignLinksY(this.myLayoutingQueue2);
        this.calculateLinksBounds(this.myLayoutingQueue3);
        this.arrangeQueue3();
    }

    private final void calculateLinksBounds(LayoutingQueue layoutingQueue) {
        Iterator iter = layoutingQueue.begin();
        while (iter.hasNext()) {
            EdgeBase e = (EdgeBase)iter.next();
            if (e instanceof Edge) {
                this.calculateLinkBounds((Edge)e);
                continue;
            }
            if (e instanceof EdgesGroup) {
                EdgesGroup group = (EdgesGroup)e;
                Edge[] edges = group.myEdges;
                group.minY = Integer.MIN_VALUE;
                group.maxY = Integer.MAX_VALUE;
                int i = 0;
                while (i < edges.length) {
                    Edge edge = edges[i];
                    this.calculateLinkBounds(edge);
                    group.minY = Math.max(group.minY, edge.minY);
                    group.maxY = Math.min(group.maxY, edge.maxY);
                    ++i;
                }
                continue;
            }
            throw new RuntimeException();
        }
    }

    private final void calculateLinkBounds(Edge e) {
        Vertex v1 = e.vertex1;
        Vertex v2 = e.vertex2;
        if (v1.level == v2.level) {
            int rightPos;
            Vertex[] nodes = this.myLevels[v1.level];
            int way = e.way;
            int leftPos = Math.min(v1.absPos, v2.absPos);
            if (leftPos == (rightPos = Math.max(v1.absPos, v2.absPos))) {
                --leftPos;
                ++rightPos;
            }
            if (way == 1) {
                int y = Math.min(e.getSrcInjectionY(), e.getDstInjectionY());
                int i_Pos = leftPos + 1;
                while (i_Pos < rightPos) {
                    Vertex v = nodes[i_Pos];
                    if (!v.isDummy) {
                        y = Math.min(y, v.getTop() - v.topExt - this.myOptioner.nRectanglesSpace - e.underSpace);
                    }
                    ++i_Pos;
                }
                e.minY = Integer.MIN_VALUE;
                e.maxY = y;
            } else {
                int y = Math.max(e.getSrcInjectionY(), e.getDstInjectionY());
                int i_Pos = leftPos + 1;
                while (i_Pos < rightPos) {
                    Vertex v = nodes[i_Pos];
                    if (!v.isDummy) {
                        y = Math.max(y, v.getBottom() + v.bottomExt + this.myOptioner.nRectanglesSpace + e.aboveSpace);
                    }
                    ++i_Pos;
                }
                e.minY = y;
                e.maxY = Integer.MAX_VALUE;
            }
        } else {
            Vertex v;
            int i_Pos;
            int i_Pos2;
            Vertex[] nodes;
            int inj2x;
            int inj1x;
            if (v1.level > v2.level) {
                Vertex tempV = v1;
                v1 = v2;
                v2 = tempV;
                inj1x = e.getDstInjectionX();
                inj2x = e.getSrcInjectionX();
            } else {
                inj1x = e.getSrcInjectionX();
                inj2x = e.getDstInjectionX();
            }
            int left = Math.min(inj1x, inj2x);
            int right = Math.max(inj1x, inj2x);
            int minY = v1.getBottom() + v1.bottomExt;
            int maxY = v2.getTop() - v2.topExt;
            if (inj1x < inj2x) {
                nodes = this.myLevels[this.fromLevel];
                i_Pos2 = v1.absPos + 1;
                while (i_Pos2 < nodes.length) {
                    Vertex v3 = nodes[i_Pos2];
                    if (!v3.isDummy) {
                        if (v3.getLeft() - this.myOptioner.nRectanglesSpace > right) break;
                        minY = Math.max(minY, v3.getBottom() + v3.bottomExt);
                    }
                    ++i_Pos2;
                }
                nodes = this.myLevels[this.toLevel];
                i_Pos = v2.absPos - 1;
                while (i_Pos >= 0) {
                    v = nodes[i_Pos];
                    if (!v.isDummy) {
                        if (v.getRight() + this.myOptioner.nRectanglesSpace < left) break;
                        maxY = Math.min(maxY, v.getTop() - v.topExt);
                    }
                    --i_Pos;
                }
            } else if (inj1x > inj2x) {
                nodes = this.myLevels[this.fromLevel];
                i_Pos2 = v1.absPos - 1;
                while (i_Pos2 >= 0) {
                    Vertex v4 = nodes[i_Pos2];
                    if (!v4.isDummy) {
                        if (v4.getRight() + this.myOptioner.nRectanglesSpace < left) break;
                        minY = Math.max(minY, v4.getBottom() + v4.bottomExt);
                    }
                    --i_Pos2;
                }
                nodes = this.myLevels[this.toLevel];
                i_Pos = v2.absPos + 1;
                while (i_Pos < nodes.length) {
                    v = nodes[i_Pos];
                    if (!v.isDummy) {
                        if (v.getLeft() - this.myOptioner.nRectanglesSpace > right) break;
                        maxY = Math.min(maxY, v.getTop() - v.topExt);
                    }
                    ++i_Pos;
                }
            }
            left -= this.myOptioner.nLinesSpace;
            right += this.myOptioner.nLinesSpace;
            Iterator iter1 = this.myLayoutingQueue1.begin();
            while (iter1.hasNext()) {
                Edge e1 = (Edge)iter1.next();
                int x1 = e1.getSrcInjectionX();
                int x2 = e1.getDstInjectionX();
                if (x1 <= left && x2 <= left || x1 >= right && x2 >= right) continue;
                minY = Math.max(minY, e1.y);
            }
            Iterator iter12 = this.myLayoutingQueue2.begin();
            while (iter12.hasNext()) {
                Edge e1 = (Edge)iter12.next();
                int x1 = e1.getSrcInjectionX();
                int x2 = e1.getDstInjectionX();
                if (x1 <= left && x2 <= left || x1 >= right && x2 >= right) continue;
                maxY = Math.min(maxY, e1.y);
            }
            e.minY = minY + this.myOptioner.nRectanglesSpace + e.aboveSpace;
            e.maxY = maxY - this.myOptioner.nRectanglesSpace - e.underSpace;
        }
    }

    private final void assignLinksY(LayoutingQueue layoutingQueue) {
        Iterator iter = layoutingQueue.begin();
        while (iter.hasNext()) {
            EdgeBase e = (EdgeBase)iter.next();
            int way = e instanceof Edge ? ((Edge)e).way : -1;
            int y = way == 1 ? e.maxY : e.minY;
            Iterator before = layoutingQueue.beforeObjects(e);
            if (before != null) {
                int s = way == 1 ? e.underSpace : e.aboveSpace;
                while (before.hasNext()) {
                    EdgeBase e1 = (EdgeBase)before.next();
                    int s1 = way == 1 ? e1.aboveSpace : e1.underSpace;
                    int space = this.myOptioner.nLinesSpace;
                    if (s > 0 || s1 > 0) {
                        space = Math.max(space, s + s1 + this.myOptioner.nIconsSpace);
                    }
                    y = way == 1 ? Math.min(y, e1.y - space) : Math.max(y, e1.y + space);
                }
            }
            e.y = y;
        }
    }

    private final void arrangeQueue3() {
        Iterator iter = this.myLayoutingQueue3.begin();
        while (iter.hasNext()) {
            EdgeBase e = (EdgeBase)iter.next();
            e.tempFlag = false;
            e.tempInt = -1;
            e.y = e.minY;
        }
        int fixed = 0;
        Vector<EdgeBase> buffer = new Vector<EdgeBase>();
        int[] minSpaces = new int[this.myLayoutingQueue3.size() + 1];
        while (fixed < this.myLayoutingQueue3.size()) {
            EdgeBase e;
            int start;
            int maxSpace;
            int totalSpace;
            block31: {
                EdgeBase e1;
                int space;
                int minMargin = Integer.MAX_VALUE;
                EdgeBase minMarginEdge = null;
                Iterator iter2 = this.myLayoutingQueue3.begin();
                while (iter2.hasNext()) {
                    EdgeBase e2 = (EdgeBase)iter2.next();
                    if (e2.tempInt < 0) {
                        Iterator before;
                        int margin = e2.maxY - e2.y;
                        Iterator after = this.myLayoutingQueue3.afterObjects(e2);
                        if (after != null) {
                            while (after.hasNext()) {
                                EdgeBase e12 = (EdgeBase)after.next();
                                space = Math.max(e2.underSpace + e12.aboveSpace + this.myOptioner.nIconsSpace, this.myOptioner.nLinesSpace);
                                if (e12.tempFlag) {
                                    margin = Math.min(margin, e12.y - e2.y - space);
                                    continue;
                                }
                                int newy = e2.y + space;
                                if (e12.y >= newy) continue;
                                e12.y = newy;
                                e12.tempInt = -1;
                            }
                        }
                        if (margin < 0) {
                            throw new RuntimeException();
                        }
                        e2.tempInt = margin;
                        if (e2.tempFlag && (before = this.myLayoutingQueue3.allBeforeObjects(e2)) != null) {
                            while (before.hasNext()) {
                                EdgeBase e13 = (EdgeBase)before.next();
                                if (e13.tempFlag) continue;
                                int space2 = Math.max(e2.aboveSpace + e13.underSpace + this.myOptioner.nIconsSpace, this.myOptioner.nLinesSpace);
                                margin = e2.y - e13.y - space2;
                                if (margin < 0) {
                                    throw new RuntimeException();
                                }
                                if (e13.tempInt <= margin) continue;
                                e13.tempInt = margin;
                                if (minMargin <= margin) continue;
                                minMargin = margin;
                                minMarginEdge = e13;
                            }
                        }
                    }
                    if (e2.tempFlag || minMargin <= e2.tempInt) continue;
                    minMargin = e2.tempInt;
                    minMarginEdge = e2;
                }
                buffer.clear();
                totalSpace = minMargin;
                maxSpace = 0;
                start = 0;
                e = minMarginEdge;
                space = 0;
                if (e.maxY == e.y + minMargin) {
                    space = e.underSpace + this.myOptioner.nRectanglesSpace;
                } else {
                    Iterator after = this.myLayoutingQueue3.afterObjects(e);
                    while (after.hasNext()) {
                        e1 = (EdgeBase)after.next();
                        if (e1.tempFlag && e1.y - e.y - (space = Math.max(e.underSpace + e1.aboveSpace + this.myOptioner.nIconsSpace, this.myOptioner.nLinesSpace)) == minMargin) break;
                    }
                    if (!after.hasNext()) {
                        throw new RuntimeException();
                    }
                }
                minSpaces[0] = space;
                totalSpace += space;
                maxSpace = Math.max(maxSpace, space);
                block6: while (true) {
                    buffer.add(e);
                    if (e.y == e.minY) {
                        minSpaces[buffer.size()] = space = e.aboveSpace + this.myOptioner.nRectanglesSpace;
                        totalSpace += space;
                        maxSpace = Math.max(maxSpace, space);
                        start = e.minY - space;
                        break block31;
                    }
                    Iterator iter3 = this.myLayoutingQueue3.beforeObjects(e);
                    while (iter3.hasNext()) {
                        e1 = (EdgeBase)iter3.next();
                        space = Math.max(e.aboveSpace + e1.underSpace + this.myOptioner.nIconsSpace, this.myOptioner.nLinesSpace);
                        if (e.y - e1.y != space) continue;
                        minSpaces[buffer.size()] = space;
                        totalSpace += space;
                        maxSpace = Math.max(maxSpace, space);
                        if (e1.tempFlag) {
                            start = e1.y;
                            break block31;
                        }
                        e = e1;
                        continue block6;
                    }
                    break;
                }
                throw new RuntimeException();
            }
            int size = buffer.size();
            if (maxSpace * (size + 1) > totalSpace) {
                int[] spaces = new int[size + 1];
                int i = 0;
                while (i < spaces.length) {
                    spaces[i] = -1;
                    ++i;
                }
                int newSize = size;
                do {
                    int i2 = 0;
                    while (i2 < spaces.length) {
                        if (spaces[i2] < 0 && minSpaces[i2] == maxSpace) {
                            spaces[i2] = maxSpace;
                            --newSize;
                            totalSpace -= maxSpace;
                        }
                        ++i2;
                    }
                    if (newSize == 0) break;
                    maxSpace = Integer.MIN_VALUE;
                    int i3 = 0;
                    while (i3 < spaces.length) {
                        if (spaces[i3] < 0) {
                            maxSpace = Math.max(maxSpace, minSpaces[i3]);
                        }
                        ++i3;
                    }
                } while (maxSpace * (newSize + 1) > totalSpace);
                int index = 0;
                int y = start;
                int i4 = 0;
                while (i4 < size) {
                    int s = spaces[size - i4];
                    if (s >= 0) {
                        y += s;
                    } else {
                        ++index;
                    }
                    int last = buffer.size() - 1;
                    e = (EdgeBase)buffer.elementAt(last);
                    buffer.remove(last);
                    e.y = y + index * totalSpace / (newSize + 1);
                    e.tempFlag = true;
                    e.tempInt = -1;
                    ++i4;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    int y = start + i * totalSpace / (size + 1);
                    int last = buffer.size() - 1;
                    e = (EdgeBase)buffer.elementAt(last);
                    buffer.remove(last);
                    e.y = y;
                    e.tempFlag = true;
                    e.tempInt = -1;
                    ++i;
                }
            }
            fixed += size;
        }
    }

    private final void expandPipe(int i_Level, int howMuch) {
        if (i_Level >= this.myLevels.length - 1) {
            throw new RuntimeException();
        }
        if (howMuch == 0) {
            return;
        }
        this.myYCoordsAssigner.assignYCoords(i_Level + 1, this.myLevelsTop[i_Level + 1] + howMuch);
        this.calculateLevelTopAndBottom(i_Level + 1);
    }
}

