/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;

final class LineTracer {
    private LinesManager myLinesManager = null;
    private Edge myEdge = null;
    private Point lastPoint = null;
    private Point prelastPoint = null;

    public void start(LinesManager linesManager, Edge edge) {
        this.myLinesManager = linesManager;
        this.myEdge = edge;
        this.myEdge.resetPoints();
        this.lastPoint = null;
        this.prelastPoint = null;
    }

    public void addPoint(Point p) {
        if (this.lastPoint == null) {
            this.lastPoint = p;
        } else if (p.x != this.lastPoint.x || p.y != this.lastPoint.y) {
            if (this.prelastPoint == null) {
                this.prelastPoint = this.lastPoint;
                this.lastPoint = p;
            } else if (this.prelastPoint.x == this.lastPoint.x && p.x == this.lastPoint.x || this.prelastPoint.y == this.lastPoint.y && p.y == this.lastPoint.y) {
                this.lastPoint = p;
            } else {
                this.myEdge.addPoint(this.prelastPoint);
                if (this.myLinesManager != null) {
                    if (this.myEdge.getPointCount() > 1) {
                        this.myLinesManager.add(this.prelastPoint);
                    }
                    Line l = new Line(this.prelastPoint.x, this.prelastPoint.y, this.lastPoint.x, this.lastPoint.y, this.myEdge);
                    this.myLinesManager.add(l);
                }
                this.prelastPoint = this.lastPoint;
                this.lastPoint = p;
            }
        }
    }

    public void finish() {
        this.myEdge.addPoint(this.prelastPoint);
        this.myEdge.addPoint(this.lastPoint);
        if (this.myLinesManager != null) {
            if (this.myEdge.getPointCount() > 2) {
                this.myLinesManager.add(this.prelastPoint);
            }
            Line l = new Line(this.prelastPoint.x, this.prelastPoint.y, this.lastPoint.x, this.lastPoint.y, this.myEdge);
            this.myLinesManager.add(l);
        }
    }
}

