/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Service;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.VerticalCyclesManager;

public class LevelsAssigner {
    protected Optioner myOptioner;
    protected Vertex[] myVertices = null;
    protected Edge[] myEdges = null;
    private VerticalCyclesManager myVerticalCyclesManager;
    private int nLevels = -1;
    protected boolean inverseInheritances = false;
    protected int minLevel;
    protected int maxLevel;
    protected int oneSpanComponentCount = -1;
    protected int minShift;
    protected int maxShift;
    protected int[] linkCounts = null;
    protected int[] penalties = null;

    public LevelsAssigner(Optioner optioner) {
        this.myOptioner = optioner;
        int orientation = this.myOptioner.orientation;
        this.inverseInheritances = orientation == 2 || orientation == 4;
        this.myVerticalCyclesManager = new VerticalCyclesManager(this.myOptioner);
    }

    public void assignLevels(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myVerticalCyclesManager.removeVerticalCycles(this.myVertices, this.myEdges);
        this.assignInitialLevels();
        this.selectOneSpanComponents();
        this.optimizeOneSpanComponents();
        if (this.myOptioner.fineTuneLevels) {
            this.fineTuneLevels();
        }
        this.adjustLevels();
        this.myVerticalCyclesManager.restoreVerticalCycles();
    }

    public final int getLevelCount() {
        return this.nLevels;
    }

    private final void assignInitialLevels() {
        int i = 0;
        while (i < this.myVertices.length) {
            Link[] links = this.myVertices[i].myLinks;
            int j = 0;
            while (j < links.length) {
                if (links[j].myEdge.isVertical()) {
                    if (this.inverseInheritances ? links[j].iDirected < 0 : links[j].iDirected > 0) break;
                }
                ++j;
            }
            this.myVertices[i].level = j == links.length ? 0 : -1;
            ++i;
        }
        int assigned = 1;
        int level = 0;
        while (assigned > 0) {
            assigned = 0;
            int i2 = 0;
            while (i2 < this.myVertices.length) {
                if (this.myVertices[i2].level == level) {
                    Link[] links = this.myVertices[i2].myLinks;
                    int j = 0;
                    while (j < links.length) {
                        if (links[j].myEdge.isVertical()) {
                            boolean bl = this.inverseInheritances ? links[j].iDirected > 0 : links[j].iDirected < 0;
                            if (bl) {
                                links[j].myVertex.level = level + 1;
                                ++assigned;
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            ++level;
        }
        this.minLevel = 0;
        this.maxLevel = level - 1;
    }

    protected final void adjustLevels() {
        int curLevel = 0;
        int i_Level = this.minLevel;
        while (i_Level <= this.maxLevel) {
            int count = 0;
            int i = 0;
            while (i < this.myVertices.length) {
                Vertex v = this.myVertices[i];
                if (v.level == i_Level) {
                    v.level = this.maxLevel + 1 + curLevel;
                    ++count;
                }
                ++i;
            }
            if (count > 0) {
                ++curLevel;
            }
            ++i_Level;
        }
        int i = 0;
        while (i < this.myVertices.length) {
            this.myVertices[i].level -= this.maxLevel + 1;
            ++i;
        }
        this.nLevels = curLevel;
    }

    private final void selectOneSpanComponents() {
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            this.myVertices[i_Vertex].myOneSpanComponent = 0;
            ++i_Vertex;
        }
        int i = 0;
        int i_Comps = 0;
        while (i < this.myVertices.length) {
            if (this.myVertices[i].myOneSpanComponent == 0) {
                this.assignOneSpanComponentLabel(++i_Comps, this.myVertices[i]);
            }
            ++i;
        }
        this.oneSpanComponentCount = i_Comps;
    }

    private final void assignOneSpanComponentLabel(int i_Component, Vertex v) {
        v.myOneSpanComponent = i_Component;
        Link[] links = v.myLinks;
        int j = 0;
        while (j < links.length) {
            if (links[j].myEdge.isVertical() && Math.abs(v.level - links[j].myVertex.level) == 1 && links[j].myVertex.myOneSpanComponent == 0) {
                this.assignOneSpanComponentLabel(i_Component, links[j].myVertex);
            }
            ++j;
        }
    }

    private final void optimizeOneSpanComponents() {
        int[] compCards = new int[this.oneSpanComponentCount];
        int[] order = new int[this.oneSpanComponentCount];
        int i_Comp = 1;
        while (i_Comp <= this.oneSpanComponentCount) {
            compCards[i_Comp - 1] = 0;
            order[i_Comp - 1] = i_Comp;
            ++i_Comp;
        }
        int i = 0;
        while (i < this.myVertices.length) {
            int n = this.myVertices[i].myOneSpanComponent - 1;
            compCards[n] = compCards[n] + 1;
            ++i;
        }
        Service.sortBiIntArray(compCards, order);
        int index = 0;
        while (index < this.oneSpanComponentCount - 1) {
            int i_Component = order[index];
            this.calculateOneSpanComponentShiftBounds(i_Component);
            int shift = this.getOptimumOneSpanComponentShift(i_Component);
            this.shiftOneSpanComponent(i_Component, shift);
            ++index;
        }
    }

    private final void fineTuneLevels() {
        int level;
        int shift;
        Vertex v;
        int i_Vertex;
        int limit = this.maxLevel;
        int i_Level = this.minLevel;
        while (i_Level <= limit) {
            int i_Vertex2 = 0;
            while (i_Vertex2 < this.myVertices.length) {
                Vertex v2 = this.myVertices[i_Vertex2];
                if (v2.level == i_Level) {
                    v2.level = Integer.MIN_VALUE;
                }
                ++i_Vertex2;
            }
            i_Vertex = 0;
            while (i_Vertex < this.myVertices.length) {
                v = this.myVertices[i_Vertex];
                if (v.level == Integer.MIN_VALUE) {
                    v.level = i_Level;
                    this.calculateNodeLevelShiftBounds(v);
                    shift = this.getOptimumNodeLevelShift(v);
                    if (shift != 0) {
                        level = v.level;
                        v.level = level += shift;
                        this.minLevel = Math.min(this.minLevel, level);
                        this.maxLevel = Math.max(this.maxLevel, level);
                    }
                }
                ++i_Vertex;
            }
            ++i_Level;
        }
        boolean bChanges = true;
        while (bChanges) {
            bChanges = false;
            i_Vertex = 0;
            while (i_Vertex < this.myVertices.length) {
                v = this.myVertices[i_Vertex];
                this.calculateNodeLevelShiftBounds(v);
                shift = this.getOptimumNodeLevelShift(v);
                if (shift != 0) {
                    level = v.level;
                    v.level = level += shift;
                    this.minLevel = Math.min(this.minLevel, level);
                    this.maxLevel = Math.max(this.maxLevel, level);
                }
                ++i_Vertex;
            }
        }
    }

    private final int getOptimumOneSpanComponentShift(int i_Component) {
        if (this.minShift > this.maxShift) {
            return 0;
        }
        if (this.minShift == this.maxShift) {
            return this.minShift;
        }
        this.prepareArrays();
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            if (this.myVertices[i_Vertex].myOneSpanComponent == i_Component) {
                Vertex v = this.myVertices[i_Vertex];
                Link[] links = this.myVertices[i_Vertex].myLinks;
                int i_Link = 0;
                while (i_Link < links.length) {
                    Link link = links[i_Link];
                    if (link.myVertex.myOneSpanComponent != i_Component) {
                        this.advanceArrays(v, link);
                    }
                    ++i_Link;
                }
            }
            ++i_Vertex;
        }
        int bestShift = this.calculateBestLevelShift();
        return bestShift;
    }

    protected final int getOptimumNodeLevelShift(Vertex vertex) {
        if (this.minShift > this.maxShift) {
            return 0;
        }
        if (this.minShift == this.maxShift) {
            return this.minShift;
        }
        this.prepareArrays();
        Link[] links = vertex.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            Link link = links[i_Link];
            Vertex v = link.myVertex;
            if (v != vertex && v.level != Integer.MIN_VALUE) {
                this.advanceArrays(vertex, link);
            }
            ++i_Link;
        }
        int bestShift = this.calculateBestLevelShift();
        return bestShift;
    }

    private final void prepareArrays() {
        this.linkCounts = new int[this.maxShift - this.minShift + 1];
        int i = 0;
        while (i < this.linkCounts.length) {
            this.linkCounts[i] = 0;
            ++i;
        }
        this.penalties = new int[this.maxShift - this.minShift + 1];
        int i2 = 0;
        while (i2 < this.penalties.length) {
            this.penalties[i2] = 0;
            ++i2;
        }
    }

    private final void advanceArrays(Vertex v, Link link) {
        Vertex v1 = link.myVertex;
        int distance = v1.level - v.level;
        if (distance < this.minShift) {
            distance = this.minShift;
        } else if (distance > this.maxShift) {
            distance = this.maxShift;
        } else if (this.myOptioner.smartLevels) {
            int count1 = 0;
            Link[] links = v.myLinks;
            int i = 0;
            while (i < links.length) {
                Vertex vertex = links[i].myVertex;
                if (vertex.level == v1.level && vertex != v1 && vertex != v) {
                    ++count1;
                }
                ++i;
            }
            int count2 = 0;
            links = v1.myLinks;
            int i2 = 0;
            while (i2 < links.length) {
                Vertex vertex = links[i2].myVertex;
                if (vertex.level == v1.level && vertex != v1 && vertex != v) {
                    ++count2;
                }
                ++i2;
            }
            int n = distance - this.minShift;
            this.penalties[n] = this.penalties[n] + (count1 + count2 + 1);
        }
        int n = distance - this.minShift;
        this.linkCounts[n] = this.linkCounts[n] + 1;
    }

    private final int calculateBestLevelShift() {
        int bestShift = this.maxShift + 1;
        int bestSum = Integer.MAX_VALUE;
        int i_Shift = this.minShift;
        while (i_Shift <= this.maxShift) {
            int sum = this.penalties[i_Shift - this.minShift];
            int index = this.minShift;
            while (index <= this.maxShift) {
                if ((sum += 2 * this.linkCounts[index - this.minShift] * Math.abs(index - i_Shift)) > bestSum) break;
                ++index;
            }
            if (sum < bestSum) {
                bestSum = sum;
                bestShift = i_Shift;
            } else if (sum == bestSum && Math.abs(i_Shift) >= Math.abs(bestShift)) {
                bestShift = i_Shift;
            }
            ++i_Shift;
        }
        return bestShift;
    }

    private final void calculateOneSpanComponentShiftBounds(int i_Component) {
        int minLev = this.minLevel;
        int maxLev = this.maxLevel;
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            if (this.myVertices[i_Vertex].myOneSpanComponent == i_Component) {
                int level = this.myVertices[i_Vertex].level;
                this.minLevel = Math.min(minLev, level);
                this.maxLevel = Math.max(maxLev, level);
            }
            ++i_Vertex;
        }
        this.minShift = this.minLevel - maxLev - 1;
        this.maxShift = this.maxLevel - minLev + 1;
        int i_Vertex2 = 0;
        while (i_Vertex2 < this.myVertices.length) {
            if (this.myVertices[i_Vertex2].myOneSpanComponent == i_Component) {
                int level = this.myVertices[i_Vertex2].level;
                Link[] links = this.myVertices[i_Vertex2].myLinks;
                int i_Link = 0;
                while (i_Link < links.length) {
                    Link link = links[i_Link];
                    if (link.myEdge.isVertical()) {
                        Vertex vert = link.myVertex;
                        if (vert.myOneSpanComponent != i_Component) {
                            if (link.iDirected < 0 && !this.inverseInheritances || link.iDirected > 0 && this.inverseInheritances) {
                                this.maxShift = Math.min(this.maxShift, vert.level - level - 1);
                            } else {
                                this.minShift = Math.max(this.minShift, vert.level - level + 1);
                            }
                        }
                    }
                    ++i_Link;
                }
            }
            ++i_Vertex2;
        }
    }

    protected final void calculateNodeLevelShiftBounds(Vertex vertex) {
        int level = vertex.level;
        this.minShift = this.minLevel - level - 1;
        this.maxShift = this.maxLevel - level + 1;
        Link[] links = vertex.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            Link link = links[i_Link];
            if (link.myEdge.isVertical()) {
                Vertex v = link.myVertex;
                if (v.level != Integer.MIN_VALUE) {
                    if (link.iDirected < 0 && !this.inverseInheritances || link.iDirected > 0 && this.inverseInheritances) {
                        this.maxShift = Math.min(this.maxShift, v.level - level - 1);
                    } else {
                        this.minShift = Math.max(this.minShift, v.level - level + 1);
                    }
                }
            }
            ++i_Link;
        }
    }

    private final void shiftOneSpanComponent(int i_Component, int shift) {
        if (shift == 0) {
            return;
        }
        int i = 0;
        while (i < this.myVertices.length) {
            if (this.myVertices[i].myOneSpanComponent == i_Component) {
                int level = this.myVertices[i].level;
                this.myVertices[i].level = level += shift;
                this.minLevel = Math.min(this.minLevel, level);
                this.maxLevel = Math.max(this.maxLevel, level);
            }
            ++i;
        }
    }
}

