/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Processible;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

final class LayoutingQueue {
    private LinkedList myNotProcessedList = new LinkedList();
    private LinkedList myProcessedList = new LinkedList();
    private HashMap myFromMap = new HashMap();
    private HashMap myToMap = new HashMap();
    private HashMap myAllFromMap = new HashMap();
    private HashMap myAllToMap = new HashMap();
    private static final int HashSetInitCapacity = 47;
    private static final float HashSetLoadRatio = 0.75f;
    private boolean isFrozen = false;

    LayoutingQueue() {
    }

    public void add(Processible obj) {
        obj.unprocess();
        this.myNotProcessedList.addFirst(obj);
    }

    public void add(LayoutingQueue queue) {
        if (this.isFrozen != queue.isFrozen) {
            throw new RuntimeException();
        }
        this.myFromMap.putAll(queue.myFromMap);
        this.myToMap.putAll(queue.myToMap);
        this.myAllFromMap.putAll(queue.myAllFromMap);
        this.myAllToMap.putAll(queue.myAllToMap);
        Iterator iter = queue.myNotProcessedList.iterator();
        while (iter.hasNext()) {
            this.myNotProcessedList.addLast(iter.next());
        }
        Iterator iter2 = queue.myProcessedList.iterator();
        while (iter2.hasNext()) {
            this.myProcessedList.addLast(iter2.next());
        }
    }

    LinkedList getNotProcessedList() {
        return this.myNotProcessedList;
    }

    public Iterator begin() {
        return this.myNotProcessedList.iterator();
    }

    public void freeze() {
        if (this.isFrozen) {
            throw new RuntimeException();
        }
        this.isFrozen = true;
    }

    public void melt() {
        if (!this.isFrozen) {
            throw new RuntimeException();
        }
        LinkedList tempList = this.myNotProcessedList;
        this.myNotProcessedList = new LinkedList();
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            this.insertIntoNotProcessedList(iter.next());
        }
        this.isFrozen = false;
    }

    public boolean setOrder(Processible first, Processible second) {
        HashSet toFirstSet;
        int order = this.getOrder(first, second);
        if (order < 0) {
            return false;
        }
        if (order > 0) {
            return true;
        }
        this.getFromSet(first).add(second);
        this.getToSet(second).add(first);
        HashSet fromFirstSet = this.getAllFromSet(first);
        HashSet toSecondSet = this.getAllToSet(second);
        fromFirstSet.add(second);
        toSecondSet.add(first);
        HashSet fromSecondSet = (HashSet)this.myAllFromMap.get(second);
        if (fromSecondSet != null) {
            Iterator iter = fromSecondSet.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (fromFirstSet.contains(obj)) continue;
                fromFirstSet.add(obj);
                HashSet toObjSet = this.getAllToSet(obj);
                toObjSet.add(first);
            }
        }
        if ((toFirstSet = (HashSet)this.myAllToMap.get(first)) != null) {
            Iterator iter = toFirstSet.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (toSecondSet.contains(obj)) continue;
                toSecondSet.add(obj);
                HashSet fromObjSet = this.getAllFromSet(obj);
                fromObjSet.add(second);
            }
        }
        if (fromSecondSet != null && toFirstSet != null) {
            Iterator from = toFirstSet.iterator();
            while (from.hasNext()) {
                Object obj1 = from.next();
                HashSet fromObj1Set = this.getAllFromSet(obj1);
                Iterator to = fromSecondSet.iterator();
                while (to.hasNext()) {
                    Object obj2 = to.next();
                    if (fromObj1Set.contains(obj2)) continue;
                    fromObj1Set.add(obj2);
                    HashSet toObj2Set = this.getAllToSet(obj2);
                    toObj2Set.add(obj1);
                }
            }
        }
        if (!this.isFrozen) {
            if (!first.isProcessed()) {
                this.myNotProcessedList.remove(first);
            }
            if (!second.isProcessed()) {
                this.myNotProcessedList.remove(second);
            }
            if (!first.isProcessed()) {
                this.insertIntoNotProcessedList(first);
            }
            if (!second.isProcessed()) {
                this.insertIntoNotProcessedList(second);
            }
        }
        return true;
    }

    public int getOrder(Processible obj1, Processible obj2) {
        if (obj1.equals(obj2)) {
            throw new RuntimeException();
        }
        HashSet fromObj1Set = (HashSet)this.myAllFromMap.get(obj1);
        if (fromObj1Set != null && fromObj1Set.contains(obj2)) {
            return 1;
        }
        HashSet toObj1Set = (HashSet)this.myAllToMap.get(obj1);
        if (toObj1Set != null && toObj1Set.contains(obj2)) {
            return -1;
        }
        return 0;
    }

    public Iterator beforeObjects(Processible obj) {
        Vector toSet = (Vector)this.myToMap.get(obj);
        if (toSet != null) {
            return ((AbstractList)toSet).iterator();
        }
        return null;
    }

    public Iterator afterObjects(Processible obj) {
        Vector fromSet = (Vector)this.myFromMap.get(obj);
        if (fromSet != null) {
            return ((AbstractList)fromSet).iterator();
        }
        return null;
    }

    public Iterator allBeforeObjects(Processible obj) {
        HashSet toSet = (HashSet)this.myAllToMap.get(obj);
        if (toSet != null) {
            return toSet.iterator();
        }
        return null;
    }

    public Iterator allAfterObjects(Processible obj) {
        HashSet fromSet = (HashSet)this.myAllFromMap.get(obj);
        if (fromSet != null) {
            return fromSet.iterator();
        }
        return null;
    }

    public Processible current() {
        if (this.isFrozen) {
            throw new RuntimeException();
        }
        if (!this.myNotProcessedList.isEmpty()) {
            return (Processible)this.myNotProcessedList.getFirst();
        }
        return null;
    }

    public void process() {
        if (this.isFrozen) {
            throw new RuntimeException();
        }
        Processible obj = (Processible)this.myNotProcessedList.getFirst();
        this.myNotProcessedList.removeFirst();
        obj.process();
        this.myProcessedList.add(obj);
    }

    public void unprocess(Processible obj) {
        if (this.isFrozen) {
            throw new RuntimeException();
        }
        this.myProcessedList.remove(obj);
        obj.unprocess();
        this.insertIntoNotProcessedList(obj);
    }

    /*
     * Unable to fully structure code
     */
    public void unprocessAll() {
        if (!this.isFrozen) ** GOTO lbl8
        throw new RuntimeException();
lbl-1000:
        // 1 sources

        {
            obj = (Processible)this.myProcessedList.getLast();
            this.myProcessedList.removeLast();
            obj.unprocess();
            this.insertIntoNotProcessedList(obj);
lbl8:
            // 2 sources

            ** while (this.myProcessedList.size() != 0)
        }
lbl9:
        // 1 sources

    }

    public int processedObjectCount() {
        return this.myProcessedList.size();
    }

    public int size() {
        return this.myNotProcessedList.size();
    }

    private void insertIntoNotProcessedList(Object obj) {
        HashSet toObjSet = (HashSet)this.myAllToMap.get(obj);
        if (toObjSet == null) {
            this.myNotProcessedList.addFirst(obj);
            return;
        }
        int beforeIndex = 0;
        int index = 0;
        Iterator iter = this.myNotProcessedList.iterator();
        while (iter.hasNext()) {
            if (toObjSet.contains(iter.next())) {
                beforeIndex = index + 1;
            }
            ++index;
        }
        this.myNotProcessedList.add(beforeIndex, obj);
    }

    private Vector getFromSet(Object obj) {
        Vector fromSet = (Vector)this.myFromMap.get(obj);
        if (fromSet == null) {
            fromSet = new Vector();
            this.myFromMap.put(obj, fromSet);
        }
        return fromSet;
    }

    private Vector getToSet(Object obj) {
        Vector toSet = (Vector)this.myToMap.get(obj);
        if (toSet == null) {
            toSet = new Vector();
            this.myToMap.put(obj, toSet);
        }
        return toSet;
    }

    private HashSet getAllFromSet(Object obj) {
        HashSet fromSet = (HashSet)this.myAllFromMap.get(obj);
        if (fromSet == null) {
            fromSet = new HashSet(47, 0.75f);
            this.myAllFromMap.put(obj, fromSet);
        }
        return fromSet;
    }

    private HashSet getAllToSet(Object obj) {
        HashSet toSet = (HashSet)this.myAllToMap.get(obj);
        if (toSet == null) {
            toSet = new HashSet(47, 0.75f);
            this.myAllToMap.put(obj, toSet);
        }
        return toSet;
    }

    public String toString() {
        return "LayoutingQueue ( myNotProcessedList = " + this.myNotProcessedList + ", " + "myProcessedList = " + this.myProcessedList + ", " + "myFromMap = " + this.myFromMap + ", " + "myToMap = " + this.myToMap + ", " + "myAllFromMap = " + this.myAllFromMap + ", " + "myAllToMap = " + this.myAllToMap + " )";
    }
}

