/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.AbstractLayouter;
import com.tssap.selena.layout.impl.ComponentsManager;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.LonelyVerticesLayouter;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.RightBound;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.ComponentLayouter;
import java.util.Vector;

public final class Layouter
extends AbstractLayouter {
    private Optioner myOptioner;
    private ComponentsManager myComponentsManager;
    private ComponentLayouter myComponentLayouter;
    private LonelyVerticesLayouter myLonelyVerticesLayouter;
    private Vector myVerticesArray = null;
    private Vector myEdgesArray = null;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;

    public Layouter(Optioner optioner) {
        this.myOptioner = optioner;
        this.myComponentsManager = new ComponentsManager(this.myOptioner);
        this.myComponentLayouter = new ComponentLayouter(this.myOptioner);
        this.myLonelyVerticesLayouter = new LonelyVerticesLayouter(this.myOptioner);
    }

    public void doLayout(Vector verticesArray, Vector edgesArray) {
        this.myVerticesArray = verticesArray;
        this.myEdgesArray = edgesArray;
        this.myComponentsManager.start(this.myVerticesArray, this.myEdgesArray);
        this.myComponentsManager.countAdjacentLinks();
        this.myComponentsManager.selectComponents();
        int orientation = this.myOptioner.orientation;
        boolean transponate = orientation != 2 && orientation != 1;
        RightBound startX = new RightBound(this.myOptioner, this.myOptioner.startX);
        int startY = this.myOptioner.startY;
        int i_Comp = 0;
        while (i_Comp < this.myComponentsManager.getComponentCount()) {
            this.myComponentsManager.chooseComponent(i_Comp);
            this.myComponentsManager.buildLinksList();
            this.myVertices = this.myComponentsManager.getVertices();
            this.myEdges = this.myComponentsManager.getEdges();
            if (transponate) {
                this.myComponentsManager.transponateComponent();
            }
            if (!transponate) {
                this.myComponentLayouter.doLayout(this.myVertices, this.myEdges, startX, startY);
            } else {
                this.myComponentLayouter.doLayout(this.myVertices, this.myEdges, new RightBound(this.myOptioner, startY), startX.getMaxX(0, Integer.MAX_VALUE));
            }
            if (transponate) {
                this.myComponentsManager.transponateComponent();
            }
            if (this.myOptioner.adjustComponents) {
                this.myComponentsManager.adjustComponent(startX, 0);
            }
            this.myComponentsManager.calculateNewRightBound(startX);
            ++i_Comp;
        }
        this.myLonelyVerticesLayouter.layoutLonelyVertices(this.myVerticesArray, startX);
    }
}

