/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.EdgeBase;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.IconSpacing;
import com.tssap.selena.layout.impl.Injection;
import com.tssap.selena.layout.impl.InjectionsSolver;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;

final class InjectionsAssigner {
    private Optioner myOptioner;
    private InjectionsSolver myInjectionsSolver;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vertex[][] myLevels = null;
    private int pass = 0;
    private int selfConnCounter = 0;

    public InjectionsAssigner(Optioner optioner) {
        this.myOptioner = optioner;
        this.myInjectionsSolver = new InjectionsSolver(this.myOptioner);
    }

    public void assignInjectionsSides(Vertex[] vertices, Edge[] edges, Vertex[][] levels) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myLevels = levels;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            edge.way = this.getBestWayForEdge(edge);
            this.setInjectionsSides(edge);
            edge.dstOffset = -1;
            edge.srcOffset = -1;
            ++i_Edge;
        }
    }

    public void assignInjections(Vertex[] vertices, Edge[] edges, Vertex[][] levels) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myLevels = levels;
        this.pass = 1;
        while (this.pass <= this.myOptioner.nInjectionsAssignerPasses) {
            int i_Vertex = 0;
            while (i_Vertex < this.myVertices.length) {
                Vertex v = this.myVertices[i_Vertex];
                this.assignVerticalInjections(v, 3);
                this.assignVerticalInjections(v, 4);
                this.assignHorizontalInjections(v, 1);
                this.assignHorizontalInjections(v, 2);
                ++i_Vertex;
            }
            ++this.pass;
        }
    }

    private void assignVerticalInjections(Vertex v, int inject) {
        this.myInjectionsSolver.setSize(v.getWidth());
        int space = Math.min(v.getWidth(), v.getHeight()) * this.myOptioner.nOutermostSpacePercents / 100;
        this.myInjectionsSolver.setMaxOutermostSpace(space);
        this.myInjectionsSolver.resetInjections();
        this.selfConnCounter = 0;
        Link[] links = v.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            Edge edge = links[i_Link].myEdge;
            if (edge.vertex1 == v && edge.srcInject == inject) {
                this.addVerticalInjection(edge, true);
            }
            if (edge.vertex2 == v && edge.dstInject == inject) {
                EdgesGroup group = edge.myGroup;
                if (group == null) {
                    this.addVerticalInjection(edge, false);
                } else {
                    int i_Link1 = 0;
                    while (i_Link1 < i_Link) {
                        if (links[i_Link1].myEdge.myGroup == group) break;
                        ++i_Link1;
                    }
                    if (i_Link1 == i_Link) {
                        this.addVerticalInjection(group);
                    }
                }
            }
            ++i_Link;
        }
        this.myInjectionsSolver.solve();
        this.setInjections();
    }

    private void assignHorizontalInjections(Vertex v, int inject) {
        if (v.isDummy) {
            return;
        }
        this.myInjectionsSolver.setSize(v.getHeight());
        int space = Math.min(v.getWidth(), v.getHeight()) * this.myOptioner.nOutermostSpacePercents / 100;
        this.myInjectionsSolver.setMaxOutermostSpace(space);
        this.myInjectionsSolver.resetInjections();
        this.selfConnCounter = 0;
        Link[] links = v.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            Edge edge = links[i_Link].myEdge;
            if (edge.vertex1 == v && edge.srcInject == inject) {
                this.addHorizontalInjection(edge, true);
            }
            if (edge.vertex2 == v && edge.dstInject == inject) {
                this.addHorizontalInjection(edge, false);
            }
            ++i_Link;
        }
        this.myInjectionsSolver.solve();
        this.setInjections();
    }

    private void addVerticalInjection(Edge edge, boolean srcFlag) {
        Vertex v = srcFlag ? edge.vertex1 : edge.vertex2;
        Vertex vertex = srcFlag ? edge.vertex2 : edge.vertex1;
        MyInjection inj = new MyInjection(edge, srcFlag);
        if (vertex != v) {
            int left = v.getLeft();
            int right = v.getRight();
            int left1 = vertex.getLeft();
            int right1 = vertex.getRight();
            if (this.pass == 1 && edge.myGroup == null) {
                inj.minBound = Math.max(left1 - left, 0);
                inj.maxBound = Math.min(right1 - left, right - left);
                if (inj.maxBound < inj.minBound) {
                    inj.minBound = Integer.MIN_VALUE;
                    inj.maxBound = Integer.MAX_VALUE;
                }
            }
            inj.bary1 = left1 - left;
            if (srcFlag) {
                if (edge.dstOffset != -1) {
                    inj.bary1 += edge.dstOffset;
                    if (edge.myGroup == null) {
                        inj.bestOffset = inj.bary1;
                    }
                }
            } else if (edge.srcOffset != -1) {
                inj.bary1 += edge.srcOffset;
                if (edge.myGroup == null) {
                    inj.bestOffset = inj.bary1;
                }
            }
        } else {
            inj.attractorFlag = true;
            inj.bary1 = edge.way == 3 || edge.way == 5 ? (inj.attractorOffset = Integer.MIN_VALUE + this.selfConnCounter) : (inj.attractorOffset = Integer.MAX_VALUE - this.selfConnCounter);
            ++this.selfConnCounter;
        }
        inj.leftIconSpace = IconSpacing.calculateInjectionIconsSpace(edge, srcFlag, 3);
        inj.rightIconSpace = IconSpacing.calculateInjectionIconsSpace(edge, srcFlag, 4);
        this.myInjectionsSolver.addInjection(inj);
    }

    private void addVerticalInjection(EdgesGroup group) {
        Vertex v = group.vertex2;
        MyInjection inj = new MyInjection(group);
        int left = v.getLeft();
        int right = v.getRight();
        Edge[] edges = group.myEdges;
        int bary = 0;
        int left1 = Integer.MAX_VALUE;
        int right1 = Integer.MIN_VALUE;
        int i = 0;
        while (i < edges.length) {
            Edge edge = edges[i];
            Vertex vertex = edge.vertex1;
            int x = vertex.getLeft();
            if (edge.srcOffset != -1) {
                x += edge.srcOffset;
            }
            bary += x;
            left1 = Math.min(left1, x);
            right1 = Math.max(right1, x);
            ++i;
        }
        inj.bary1 = (bary /= edges.length) - left;
        inj.minBound = Math.max(left1 - left, 0);
        inj.maxBound = Math.min(right1 - left, right - left);
        if (inj.maxBound < inj.minBound) {
            inj.minBound = Integer.MIN_VALUE;
            inj.maxBound = Integer.MAX_VALUE;
        }
        inj.leftIconSpace = IconSpacing.calculateInjectionIconsSpace(group, 3);
        inj.rightIconSpace = IconSpacing.calculateInjectionIconsSpace(group, 4);
        this.myInjectionsSolver.addInjection(inj);
    }

    private void addHorizontalInjection(Edge edge, boolean srcFlag) {
        Vertex v = srcFlag ? edge.vertex1 : edge.vertex2;
        Vertex vertex = srcFlag ? edge.vertex2 : edge.vertex1;
        MyInjection inj = new MyInjection(edge, srcFlag);
        int way = edge.way;
        int top = v.getTop();
        if (v != vertex) {
            inj.bary1 = Math.abs(vertex.absPos - v.absPos);
            if (way == 1) {
                inj.bary1 = -inj.bary1;
            }
            inj.bary2 = vertex.getTop() - top;
            boolean injectionFlag = false;
            if (srcFlag) {
                if (edge.dstOffset != -1) {
                    inj.bary2 += edge.dstOffset;
                    injectionFlag = true;
                }
            } else if (edge.srcOffset != -1) {
                inj.bary2 += edge.srcOffset;
                injectionFlag = true;
            }
            int bound = this.calculateVerticesBound(v, vertex, way);
            if (way == 2 && bound >= v.getHeight() || way == 1 && bound <= 0) {
                inj.attractorFlag = true;
                inj.attractorOffset = bound;
            } else {
                int maxBound;
                int minBound;
                if (way == 2) {
                    inj.minBound = bound;
                    inj.maxBound = v.getHeight();
                } else {
                    inj.minBound = 0;
                    inj.maxBound = bound;
                }
                if (injectionFlag) {
                    inj.attractorFlag = true;
                    inj.attractorOffset = inj.bary2;
                    if (inj.minBound <= inj.bary2 && inj.bary2 <= inj.maxBound) {
                        inj.bestOffset = inj.bary2;
                    }
                } else if (this.pass == 1 && (minBound = Math.max(inj.minBound, vertex.getTop() - top)) <= (maxBound = Math.min(inj.maxBound, vertex.getBottom() - top))) {
                    inj.minBound = minBound;
                    inj.maxBound = maxBound;
                }
            }
        } else {
            inj.attractorFlag = true;
            inj.bary1 = way == 3 || way == 4 ? (inj.attractorOffset = Integer.MIN_VALUE + this.selfConnCounter) : (inj.attractorOffset = Integer.MAX_VALUE - this.selfConnCounter);
            ++this.selfConnCounter;
        }
        inj.leftIconSpace = IconSpacing.calculateInjectionIconsSpace(edge, srcFlag, 1);
        inj.rightIconSpace = IconSpacing.calculateInjectionIconsSpace(edge, srcFlag, 2);
        this.myInjectionsSolver.addInjection(inj);
    }

    private void setInjections() {
        int i = 0;
        while (i < this.myInjectionsSolver.getInjectionCount()) {
            MyInjection inj = (MyInjection)this.myInjectionsSolver.getInjection(i);
            if (inj.edgeBase instanceof Edge) {
                Edge edge = (Edge)inj.edgeBase;
                if (inj.srcFlag) {
                    edge.srcOffset = inj.offset;
                } else {
                    edge.dstOffset = inj.offset;
                }
            } else if (inj.edgeBase instanceof EdgesGroup) {
                EdgesGroup group = (EdgesGroup)inj.edgeBase;
                group.dstOffset = inj.offset;
                Edge[] edges = group.myEdges;
                int j = 0;
                while (j < edges.length) {
                    edges[j].dstOffset = inj.offset;
                    ++j;
                }
            } else {
                throw new RuntimeException();
            }
            ++i;
        }
    }

    private int calculateVerticesBound(Vertex v1, Vertex v2, int way) {
        if (way != 1 && way != 2) {
            throw new RuntimeException();
        }
        int level = v1.level;
        int absPos1 = v1.absPos;
        int absPos2 = v2.absPos;
        int absPosMin = Math.min(absPos1, absPos2);
        int absPosMax = Math.max(absPos1, absPos2);
        int start = v1.getTop();
        int h = v1.getHeight();
        int bound = way == 2 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        Vertex[] nodes = this.myLevels[level];
        int i_Pos = absPosMin + 1;
        while (i_Pos < absPosMax) {
            Vertex v = nodes[i_Pos];
            if (!v.isDummy && (way == 2 ? (bound = Math.max(bound, v.getBottom() + v.bottomExt + this.myOptioner.nRectanglesSpace - start)) >= h : (bound = Math.min(bound, v.getTop() - v.topExt - this.myOptioner.nRectanglesSpace - start)) <= 0)) {
                return bound;
            }
            ++i_Pos;
        }
        return bound;
    }

    private int getBestWayForEdge(Edge edge) {
        Vertex v1 = edge.vertex1;
        Vertex v2 = edge.vertex2;
        if (v1.level != v2.level) {
            return -1;
        }
        if (v1 == v2) {
            return 6;
        }
        int level = v1.level;
        Vertex[] nodes = this.myLevels[level];
        int absPos1 = v1.absPos;
        int absPos2 = v2.absPos;
        int absPosMin = Math.min(absPos1, absPos2);
        int absPosMax = Math.max(absPos1, absPos2);
        int upCounter = 0;
        int downCounter = 0;
        int i_Pos = absPosMin + 1;
        while (i_Pos < absPosMax) {
            Vertex v = nodes[i_Pos];
            Link[] links = v.myLinks;
            int i_Link = 0;
            while (i_Link < links.length) {
                Vertex vertex = links[i_Link].myVertex;
                if (vertex.level == level) {
                    int absPos = vertex.absPos;
                    if (absPos < absPosMin || absPos > absPosMax) {
                        int way = links[i_Link].myEdge.way;
                        if (way == 1) {
                            ++upCounter;
                        } else if (way == 2) {
                            ++downCounter;
                        }
                    }
                } else if (vertex.level > level) {
                    ++downCounter;
                } else {
                    ++upCounter;
                }
                ++i_Link;
            }
            ++i_Pos;
        }
        if (upCounter < downCounter) {
            return 1;
        }
        if (downCounter < upCounter) {
            return 2;
        }
        return 2;
    }

    private void setInjectionsSides(Edge e) {
        Vertex v1 = e.vertex1;
        Vertex v2 = e.vertex2;
        int i_Level1 = v1.level;
        int i_Level2 = v2.level;
        if (i_Level1 < i_Level2) {
            e.srcInject = 4;
            e.dstInject = 3;
        } else if (i_Level2 < i_Level1) {
            e.srcInject = 3;
            e.dstInject = 4;
        } else {
            int absPos1 = v1.absPos;
            int absPos2 = v2.absPos;
            if (absPos1 < absPos2) {
                e.srcInject = 2;
                e.dstInject = 1;
            } else if (absPos2 < absPos1) {
                e.srcInject = 1;
                e.dstInject = 2;
            } else {
                switch (e.way) {
                    case 3: {
                        e.srcInject = 3;
                        e.dstInject = 1;
                        break;
                    }
                    case 5: {
                        e.srcInject = 4;
                        e.dstInject = 1;
                        break;
                    }
                    case 4: {
                        e.srcInject = 3;
                        e.dstInject = 2;
                        break;
                    }
                    case 6: {
                        e.srcInject = 4;
                        e.dstInject = 2;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        }
    }

    private static final class MyInjection
    extends Injection {
        EdgeBase edgeBase;
        boolean srcFlag;

        MyInjection(Edge edge, boolean srcFlag) {
            this.edgeBase = edge;
            this.srcFlag = srcFlag;
        }

        MyInjection(EdgesGroup edgesGroup) {
            this.edgeBase = edgesGroup;
            this.srcFlag = false;
        }
    }
}

