/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.CrossPermitter;
import com.tssap.selena.layout.impl.geometry.Line;

final class EdgesCrossPermitter
implements CrossPermitter {
    EdgesCrossPermitter() {
    }

    public boolean permitCrossing(Line l1, Line l2) {
        Edge edge1 = (Edge)l1.getObject();
        Edge edge2 = (Edge)l2.getObject();
        return EdgesCrossPermitter.permitCrossing(edge1, edge2);
    }

    public static boolean permitCrossing(Edge edge1, Edge edge2) {
        Vertex v1 = edge1.vertex1;
        Vertex v2 = edge1.vertex2;
        Vertex v3 = edge2.vertex1;
        Vertex v4 = edge2.vertex2;
        int level1 = v1.level;
        int level2 = v2.level;
        int level3 = v3.level;
        int level4 = v4.level;
        if (v1 == v2) {
            return EdgesCrossPermitter.checkWithSelfConnect(edge1, edge2);
        }
        if (v3 == v4) {
            return EdgesCrossPermitter.checkWithSelfConnect(edge2, edge1);
        }
        if (level1 == level2) {
            if (level3 == level4) {
                if (level1 == level3) {
                    return EdgesCrossPermitter.checkHorizontalWithHorizontal(edge1, edge2);
                }
                return false;
            }
            if (level3 == level1) {
                return EdgesCrossPermitter.checkHorizontalWithVertical(edge1, edge2, true);
            }
            if (level4 == level1) {
                return EdgesCrossPermitter.checkHorizontalWithVertical(edge1, edge2, false);
            }
            return false;
        }
        if (level3 == level4) {
            if (level1 == level3) {
                return EdgesCrossPermitter.checkHorizontalWithVertical(edge2, edge1, true);
            }
            if (level2 == level3) {
                return EdgesCrossPermitter.checkHorizontalWithVertical(edge2, edge1, false);
            }
            return false;
        }
        if (level1 == level3 && level2 == level4) {
            return EdgesCrossPermitter.checkVerticalWithVertical(edge1, edge2, true);
        }
        if (level1 == level4 && level2 == level3) {
            return EdgesCrossPermitter.checkVerticalWithVertical(edge1, edge2, false);
        }
        return false;
    }

    private static boolean checkWithSelfConnect(Edge self, Edge another) {
        int self1x = self.getSrcInjectionX();
        int self1y = self.getSrcInjectionY();
        int self2x = self.getDstInjectionX();
        int self2y = self.getDstInjectionY();
        int another1x = another.getSrcInjectionX();
        int another1y = another.getSrcInjectionY();
        int another2x = another.getDstInjectionX();
        int another2y = another.getDstInjectionY();
        boolean inConner1 = EdgesCrossPermitter.isInConner(another1x, another1y, self1x, self1y, self2x, self2y);
        boolean inConner2 = EdgesCrossPermitter.isInConner(another2x, another2y, self1x, self1y, self2x, self2y);
        return inConner1 ? !inConner2 : inConner2;
    }

    private static boolean isInConner(int x, int y, int self1x, int self1y, int self2x, int self2y) {
        return Math.min(self1x, self2x) <= x && x <= Math.max(self1x, self2x) && Math.min(self1y, self2y) <= y && y <= Math.max(self1y, self2y);
    }

    private static boolean checkVerticalWithVertical(Edge edge1, Edge edge2, boolean srcFlag) {
        int inj1x = edge1.getSrcInjectionX();
        int inj2x = edge1.getDstInjectionX();
        int inj3x = edge2.getInjectionX(srcFlag);
        int inj4x = edge2.getInjectionX(!srcFlag);
        if (inj1x < inj3x) {
            return inj2x >= inj4x;
        }
        return inj2x <= inj4x;
    }

    private static boolean checkHorizontalWithVertical(Edge hor, Edge vert, boolean srcFlag) {
        int vert1y = vert.getInjectionY(srcFlag);
        int vert2y = vert.getInjectionY(!srcFlag);
        if (vert2y > vert1y && hor.way == 2 || vert2y < vert1y && hor.way == 1) {
            int hor1x = hor.getSrcInjectionX();
            int hor2x = hor.getDstInjectionX();
            int left = Math.min(hor1x, hor2x);
            int right = Math.max(hor1x, hor2x);
            int vert1x = vert.getInjectionX(srcFlag);
            if (left < vert1x && vert1x < right) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkHorizontalWithHorizontal(Edge edge1, Edge edge2) {
        int inj1x = edge1.getSrcInjectionX();
        int inj2x = edge1.getDstInjectionX();
        int inj3x = edge2.getSrcInjectionX();
        int inj4x = edge2.getDstInjectionX();
        if (inj1x == inj3x) {
            if (inj2x == inj4x) {
                return EdgesCrossPermitter.checkHorizontalsWithTwoCommonSides(edge1, edge2, true);
            }
            return EdgesCrossPermitter.checkHorizontalsWithOneCommonSide(edge1, true, edge2, true);
        }
        if (inj1x == inj4x) {
            if (inj2x == inj3x) {
                return EdgesCrossPermitter.checkHorizontalsWithTwoCommonSides(edge1, edge2, false);
            }
            return EdgesCrossPermitter.checkHorizontalsWithOneCommonSide(edge1, true, edge2, false);
        }
        if (inj2x == inj3x) {
            return EdgesCrossPermitter.checkHorizontalsWithOneCommonSide(edge1, false, edge2, true);
        }
        if (inj2x == inj4x) {
            return EdgesCrossPermitter.checkHorizontalsWithOneCommonSide(edge1, false, edge2, false);
        }
        return EdgesCrossPermitter.checkHorizontalsWithNoCommonSides(edge1, edge2);
    }

    private static boolean checkHorizontalsWithTwoCommonSides(Edge edge1, Edge edge2, boolean srcFlag) {
        int inj1y = edge1.getSrcInjectionY();
        int inj2y = edge1.getDstInjectionY();
        int inj3y = edge2.getInjectionY(srcFlag);
        int inj4y = edge2.getInjectionY(!srcFlag);
        if (inj1y < inj3y) {
            return inj2y >= inj4y;
        }
        return inj2y <= inj4y;
    }

    private static boolean checkHorizontalsWithOneCommonSide(Edge edge1, boolean srcFlag1, Edge edge2, boolean srcFlag2) {
        int way1 = edge1.way;
        int way2 = edge2.way;
        if (way1 != way2) {
            return false;
        }
        int inj1y = edge1.getInjectionY(srcFlag1);
        int inj3y = edge2.getInjectionY(srcFlag2);
        int inj1x = edge1.getInjectionX(srcFlag1);
        int inj2x = edge1.getInjectionX(!srcFlag1);
        int inj3x = edge2.getInjectionX(srcFlag2);
        int inj4x = edge2.getInjectionX(!srcFlag2);
        if (way1 == 1 && inj1y < inj3y || way1 == 2 && inj1y > inj3y) {
            return Math.abs(inj1x - inj2x) < Math.abs(inj3x - inj4x);
        }
        return Math.abs(inj1x - inj2x) > Math.abs(inj3x - inj4x);
    }

    private static boolean checkHorizontalsWithNoCommonSides(Edge edge1, Edge edge2) {
        if (edge1.way != edge2.way) {
            return false;
        }
        int inj1x = edge1.getSrcInjectionX();
        int inj2x = edge1.getDstInjectionX();
        int inj3x = edge2.getSrcInjectionX();
        int inj4x = edge2.getDstInjectionX();
        int leftx1 = Math.min(inj1x, inj2x);
        int rightx1 = Math.max(inj1x, inj2x);
        int leftx2 = Math.min(inj3x, inj4x);
        int rightx2 = Math.max(inj3x, inj4x);
        if (leftx1 < leftx2 && leftx2 < rightx1) {
            return rightx2 > rightx1;
        }
        if (leftx1 < rightx2 && rightx2 < rightx1) {
            return leftx2 < leftx1;
        }
        return false;
    }
}

