/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Point;

public final class DummyVerticesManager {
    private Optioner myOptioner;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vertex[] myOldVertices = null;
    private Edge[] myOldEdges = null;
    private int dummyVerticeCount = 0;

    public DummyVerticesManager(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public void start(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.dummyVerticeCount = 0;
    }

    public void createDummyVertices() {
        int i_DummyVerticesNeed = this.countDummyVerticesNeed();
        if (i_DummyVerticesNeed == 0) {
            return;
        }
        Vertex[] newVertices = new Vertex[this.myVertices.length + i_DummyVerticesNeed];
        int i = 0;
        while (i < this.myVertices.length) {
            newVertices[i] = this.myVertices[i];
            ++i;
        }
        this.myOldVertices = this.myVertices;
        this.myVertices = newVertices;
        Edge[] newEdges = new Edge[this.myEdges.length + i_DummyVerticesNeed];
        int i2 = 0;
        while (i2 < this.myEdges.length) {
            newEdges[i2] = this.myEdges[i2];
            ++i2;
        }
        this.myOldEdges = this.myEdges;
        this.myEdges = newEdges;
        int i_DummyEdgeCount = 0;
        int i_DummyVerticeCount = 0;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length - i_DummyVerticesNeed) {
            int dist;
            Edge edge = this.myEdges[i_Edge];
            Vertex vertex1 = edge.vertex1;
            Vertex vertex2 = edge.vertex2;
            int level1 = vertex1.level;
            int level2 = vertex2.level;
            if (level1 != -1 && level2 != -1 && (dist = Math.abs(level1 - level2)) > 1) {
                int delta = level2 > level1 ? 1 : -1;
                int i_Level = level1 + delta;
                while (i_Level != level2) {
                    Vertex newVertex = new Vertex();
                    newVertex.setWidth(0);
                    newVertex.setHeight(0);
                    newVertex.isDummy = true;
                    newVertex.level = i_Level;
                    newVertex.myLinks = new Link[2];
                    newVertex.setSelected(vertex1.isSelected() || vertex2.isSelected());
                    this.myVertices[this.myVertices.length - i_DummyVerticesNeed + i_DummyVerticeCount] = newVertex;
                    ++i_DummyVerticeCount;
                    i_Level += delta;
                }
                int mediumIconsLevel = edge.isGroupable() ? level2 - delta : level1 + delta * ((dist - 1) / 2);
                int nearDstIconsLevel = level2 - delta;
                int curIndex = this.myVertices.length - i_DummyVerticesNeed + i_DummyVerticeCount - dist;
                int i_Level2 = level1;
                while (i_Level2 != level2) {
                    Edge newEdge;
                    Vertex v2;
                    Vertex v1 = i_Level2 == level1 ? vertex1 : this.myVertices[curIndex];
                    Vertex vertex = v2 = i_Level2 == level2 - delta ? vertex2 : this.myVertices[curIndex + 1];
                    if (i_Level2 == level1) {
                        newEdge = edge;
                    } else {
                        newEdge = new Edge();
                        newEdge.setVertical(edge.isVertical());
                        newEdge.setGroupId(edge.getGroupId());
                        this.myEdges[this.myEdges.length - i_DummyVerticesNeed + i_DummyEdgeCount] = newEdge;
                        ++i_DummyEdgeCount;
                    }
                    newEdge.vertex1 = v1;
                    newEdge.vertex2 = v2;
                    Link link = null;
                    if (v1 == vertex1) {
                        link = DummyVerticesManager.findLink(vertex1, edge);
                    } else {
                        v1.myLinks[0] = link = new Link();
                    }
                    link.myVertex = v2;
                    link.myEdge = newEdge;
                    link.iDirected = 1;
                    if (v2 == vertex2) {
                        link = DummyVerticesManager.findLink(vertex2, edge);
                    } else {
                        v2.myLinks[1] = link = new Link();
                    }
                    link.myVertex = v1;
                    link.myEdge = newEdge;
                    link.iDirected = -1;
                    if (edge != newEdge && (i_Level2 == mediumIconsLevel || i_Level2 == nearDstIconsLevel)) {
                        int i_Icon = 0;
                        while (i_Icon < edge.getIconCount()) {
                            Icon icon = edge.getIconAt(i_Icon);
                            int horPos = icon.getHorPos();
                            if (horPos == 3 && i_Level2 == mediumIconsLevel || horPos == 2 && i_Level2 == nearDstIconsLevel) {
                                edge.deleteIconAt(i_Icon);
                                --i_Icon;
                                newEdge.addIcon(icon);
                            }
                            ++i_Icon;
                        }
                    }
                    i_Level2 += delta;
                    ++curIndex;
                }
            }
            ++i_Edge;
        }
        if (i_DummyVerticeCount != i_DummyVerticesNeed || i_DummyEdgeCount != i_DummyVerticesNeed) {
            throw new RuntimeException();
        }
        this.dummyVerticeCount += i_DummyVerticeCount;
    }

    public void removeDummyVertices() {
        if (this.dummyVerticeCount == 0) {
            return;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            if (this.myEdges[i_Edge].vertex2.isDummy && !this.myEdges[i_Edge].vertex1.isDummy) {
                Edge edge = this.myEdges[i_Edge];
                Vertex v1 = edge.vertex1;
                Vertex v2 = edge.vertex2;
                Vertex lastVertex = null;
                Vertex prevVertex = null;
                lastVertex = v2;
                while (lastVertex.isDummy) {
                    Edge lastEdge = lastVertex.myLinks[0].myEdge;
                    Point p = lastEdge.getPointAt(0);
                    Point prev = edge.getPointAt(edge.getPointCount() - 1);
                    if (p.x != prev.x || p.y != prev.y) {
                        edge.addPoint(p);
                    }
                    int i_Point = 1;
                    while (i_Point < lastEdge.getPointCount()) {
                        edge.addPoint(lastEdge.getPointAt(i_Point));
                        ++i_Point;
                    }
                    int i_Icon = 0;
                    while (i_Icon < lastEdge.getIconCount()) {
                        Icon icon = lastEdge.getIconAt(i_Icon);
                        edge.addIcon(icon);
                        if (icon.getSegment() != -1) {
                            icon.setSegment(edge.getPointCount() - lastEdge.getPointCount() + icon.getSegment());
                        }
                        ++i_Icon;
                    }
                    EdgesGroup group = lastEdge.myGroup;
                    if (group != null) {
                        if (edge.myGroup != null) {
                            throw new RuntimeException();
                        }
                        edge.myGroup = group;
                        Edge[] edges = group.myEdges;
                        int i = 0;
                        while (i < edges.length) {
                            if (edges[i] == lastEdge) {
                                edges[i] = edge;
                                break;
                            }
                            ++i;
                        }
                        if (i == edges.length) {
                            throw new RuntimeException();
                        }
                    }
                    prevVertex = lastVertex;
                    lastVertex = lastVertex.myLinks[0].myVertex;
                }
                edge.vertex2 = lastVertex;
                Link link = DummyVerticesManager.findLink(v1, edge);
                link.myVertex = lastVertex;
                link.myEdge = edge;
                link = DummyVerticesManager.findLink(lastVertex, prevVertex.myLinks[0].myEdge);
                link.myVertex = v1;
                link.myEdge = edge;
            }
            ++i_Edge;
        }
        this.myVertices = this.myOldVertices;
        this.myEdges = this.myOldEdges;
        this.dummyVerticeCount = 0;
    }

    public Vertex[] getVertices() {
        return this.myVertices;
    }

    public Edge[] getEdges() {
        return this.myEdges;
    }

    public int getDummyVerticeCount() {
        return this.dummyVerticeCount;
    }

    public static Edge getOrigin(Vertex v) {
        if (!v.isDummy) {
            throw new RuntimeException();
        }
        Link link = null;
        Vertex firstV = v;
        while (firstV.isDummy) {
            link = firstV.myLinks[1];
            firstV = link.myVertex;
        }
        return link.myEdge;
    }

    private int countDummyVerticesNeed() {
        int count = 0;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            int dist;
            Vertex vertex1 = this.myEdges[i_Edge].vertex1;
            Vertex vertex2 = this.myEdges[i_Edge].vertex2;
            int level1 = vertex1.level;
            int level2 = vertex2.level;
            if (level1 != -1 && level2 != -1 && (dist = Math.abs(level1 - level2)) > 1) {
                count += dist - 1;
            }
            ++i_Edge;
        }
        return count;
    }

    private static Link findLink(Vertex vertex, Edge edge) {
        Link[] links = vertex.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            if (links[i_Link].myEdge == edge) break;
            ++i_Link;
        }
        return links[i_Link];
    }
}

