/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.AbstractComponentLayouter;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.IconSpacing;
import com.tssap.selena.layout.impl.IconsPlacer;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.RightBound;
import com.tssap.selena.layout.impl.Service;
import com.tssap.selena.layout.impl.StandardIgnorer;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.auto.AbsPosAssigner;
import com.tssap.selena.layout.impl.auto.BendsOptimizer;
import com.tssap.selena.layout.impl.auto.DummyVerticesManager;
import com.tssap.selena.layout.impl.auto.InjectionsAssigner;
import com.tssap.selena.layout.impl.auto.LevelsAssigner;
import com.tssap.selena.layout.impl.auto.LinksRouter;
import com.tssap.selena.layout.impl.auto.OrthogonalBendsOptimizer;
import com.tssap.selena.layout.impl.auto.StraightBendsOptimizer;
import com.tssap.selena.layout.impl.auto.XCoordsAssigner;
import com.tssap.selena.layout.impl.auto.YCoordsAssigner;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;

public final class ComponentLayouter
implements AbstractComponentLayouter {
    private Optioner myOptioner;
    private LevelsAssigner myLevelsAssigner;
    private DummyVerticesManager myDummyVerticesManager;
    private AbsPosAssigner myAbsPosAssigner;
    private XCoordsAssigner myXCoordsAssigner;
    private YCoordsAssigner myYCoordsAssigner;
    private InjectionsAssigner myInjectionsAssigner;
    private LinksRouter myLinksRouter;
    private IconsPlacer myIconsPlacer;
    private BendsOptimizer myBendsOptimizer;
    private LinesManager myLinesManager;
    private com.tssap.selena.layout.impl.increment.ComponentLayouter myIncrementComponentLayouter = null;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vertex[][] myLevels = null;
    private RightBound myStartX = null;
    private int myStartY;
    private int currentXShift;
    private int currentYShift;

    public ComponentLayouter(Optioner optioner) {
        this.myOptioner = optioner;
        this.myDummyVerticesManager = new DummyVerticesManager(this.myOptioner);
        if (this.myOptioner.incrementAfterAuto) {
            this.myIncrementComponentLayouter = new com.tssap.selena.layout.impl.increment.ComponentLayouter(this.myOptioner);
        }
        this.init();
    }

    public ComponentLayouter(Optioner optioner, DummyVerticesManager dummyVerticesManager) {
        this.myOptioner = optioner;
        this.myDummyVerticesManager = dummyVerticesManager;
        this.init();
    }

    private void init() {
        this.myLevelsAssigner = new LevelsAssigner(this.myOptioner);
        this.myAbsPosAssigner = new AbsPosAssigner(this.myOptioner);
        this.myXCoordsAssigner = new XCoordsAssigner(this.myOptioner);
        this.myYCoordsAssigner = new YCoordsAssigner(this.myOptioner);
        this.myInjectionsAssigner = new InjectionsAssigner(this.myOptioner);
        this.myLinksRouter = new LinksRouter(this.myOptioner, this.myYCoordsAssigner);
        this.myLinesManager = new LinesManager(this.myOptioner);
        this.myLinesManager.setConflictIgnorerBefore(new StandardIgnorer());
        this.myLinesManager.setFlags(0);
        this.myBendsOptimizer = this.myOptioner.bOrthogonalMode ? new OrthogonalBendsOptimizer(this.myOptioner, this.myLinesManager) : new StraightBendsOptimizer(this.myOptioner, this.myLinesManager);
        this.myIconsPlacer = new IconsPlacer(this.myOptioner, this.myLinesManager, this.myOptioner.orientation != 2 && this.myOptioner.orientation != 1);
    }

    public void doLayout(Vertex[] vertices, Edge[] edges, RightBound startX, int startY) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myStartX = startX;
        this.myStartY = startY;
        this.myLevelsAssigner.assignLevels(this.myVertices, this.myEdges);
        this.myDummyVerticesManager.start(this.myVertices, this.myEdges);
        this.myDummyVerticesManager.createDummyVertices();
        this.myVertices = this.myDummyVerticesManager.getVertices();
        this.myEdges = this.myDummyVerticesManager.getEdges();
        this.myAbsPosAssigner.assignAbsPos(this.myVertices, this.myEdges, this.myLevelsAssigner.getLevelCount());
        this.myLevels = this.myAbsPosAssigner.getLevels();
        this.doSecondPart();
        if (this.myIncrementComponentLayouter != null) {
            this.myIncrementComponentLayouter.doLayout(this.myVertices, this.myEdges, this.myStartX, this.myStartY);
        }
    }

    public void doLayoutForIncrement(Vertex[] vertices, Edge[] edges, Vertex[][] levels, RightBound startX, int startY) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myLevels = levels;
        this.myStartX = startX;
        this.myStartY = startY;
        this.doSecondPart();
    }

    private void doSecondPart() {
        this.myInjectionsAssigner.assignInjectionsSides(this.myVertices, this.myEdges, this.myLevels);
        if (this.myOptioner.bOrthogonalMode) {
            this.createEdgesGroups();
        }
        this.calculateExtensions();
        this.currentXShift = 0;
        this.currentYShift = 0;
        this.doThirdPart();
        if (this.currentXShift != 0 || this.currentYShift != 0) {
            throw new RuntimeException();
        }
    }

    private void doThirdPart() {
        do {
            this.myYCoordsAssigner.assignYCoords(this.myVertices, this.myEdges, this.myLevels, this.myStartY);
            this.myXCoordsAssigner.assignXCoords(this.myVertices, this.myEdges, this.myLevels, this.myStartX);
            this.myInjectionsAssigner.assignInjections(this.myVertices, this.myEdges, this.myLevels);
        } while (this.calculateAdditionalExtensions());
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            this.myVertices[i_Vertex].process();
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            edge.unprocess();
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                edge.getIconAt(i_Icon).unprocess();
                ++i_Icon;
            }
            ++i_Edge;
        }
        this.myLinksRouter.routeLinks(this.myVertices, this.myEdges, this.myLevels, this.myStartY);
        this.chooseIconsSegments();
        this.myDummyVerticesManager.removeDummyVertices();
        this.myVertices = this.myDummyVerticesManager.getVertices();
        this.myEdges = this.myDummyVerticesManager.getEdges();
        this.myBendsOptimizer.removeUselessPoints(this.myVertices, this.myEdges);
        this.myLinesManager.clear();
        if (this.myOptioner.optimizeBends || !this.myOptioner.stupidIcons) {
            Service.addToLinesManager(this.myLinesManager, this.myVertices, this.myEdges, false);
        }
        if (this.myOptioner.optimizeBends) {
            this.myBendsOptimizer.optimizeBends(this.myVertices, this.myEdges);
        }
        this.myIconsPlacer.placeIcons(this.myEdges);
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int i_Edge2 = 0;
        while (i_Edge2 < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge2];
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                Icon icon = edge.getIconAt(i_Icon);
                left = Math.min(left, icon.getLeft());
                top = Math.min(top, icon.getTop());
                ++i_Icon;
            }
            ++i_Edge2;
        }
        if (left < 0 || top < 0) {
            int xshift = this.myStartX.getLeft() - this.currentXShift - left;
            int yshift = this.myStartY - this.currentYShift - top;
            if (!this.myOptioner.pagingFlag) {
                Service.shift(this.myVertices, this.myEdges, xshift, yshift);
            } else {
                this.myStartX.shift(xshift);
                this.currentXShift += xshift;
                this.myStartY += yshift;
                this.currentYShift += yshift;
                this.doThirdPart();
                this.myStartX.shift(-xshift);
                this.currentXShift -= xshift;
                this.myStartY -= yshift;
                this.currentYShift -= yshift;
            }
        }
    }

    private void createEdgesGroups() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            this.myEdges[i_Edge].myGroup = null;
            ++i_Edge;
        }
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            Service.createEdgesGroups(v, 3);
            Service.createEdgesGroups(v, 4);
            ++i_Vertex;
        }
    }

    private void calculateExtensions() {
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            v.topExt = this.calculateExtension(v, 3);
            v.bottomExt = this.calculateExtension(v, 4);
            v.leftExt = this.calculateExtension(v, 1);
            v.rightExt = this.calculateExtension(v, 2);
            v.rightMediumExt = 0;
            ++i_Vertex;
        }
        this.calculateMediumExtensions();
    }

    private int calculateExtension(Vertex v, int inject) {
        boolean vertical = inject == 3 || inject == 4;
        Link[] links = v.myLinks;
        int ext = 0;
        int i_Link = 0;
        while (i_Link < links.length) {
            Link link = links[i_Link];
            Edge edge = link.myEdge;
            if (link.iDirected >= 0 && edge.srcInject == inject || link.iDirected <= 0 && edge.dstInject == inject) {
                Vertex vertex = link.myVertex;
                if (v != vertex) {
                    ext = Math.max(ext, this.myOptioner.noIconsExt);
                    int i_Icon = 0;
                    while (i_Icon < edge.getIconCount()) {
                        Icon icon = edge.getIconAt(i_Icon);
                        int horPos = icon.getHorPos();
                        if (link.iDirected > 0 && horPos == 1 || link.iDirected < 0 && horPos == 2) {
                            int size = icon.isDirected() ? (this.myOptioner.bOrthogonalMode ? icon.getWidth() : icon.getWidth() + icon.getHeight()) : (vertical ? icon.getHeight() : icon.getWidth());
                            ext = Math.max(ext, size + this.myOptioner.nIconsSpace);
                        }
                        ++i_Icon;
                    }
                } else {
                    ext += Math.min(v.getHeight(), v.getWidth()) * this.myOptioner.nOutermostSpacePercents / 100 + this.myOptioner.nRectanglesSpace;
                }
            }
            ++i_Link;
        }
        if (!vertical) {
            int i_Link2 = 0;
            while (i_Link2 < links.length) {
                Link link = links[i_Link2];
                Edge edge = link.myEdge;
                if (link.iDirected >= 0 && edge.srcInject == inject || link.iDirected <= 0 && edge.dstInject == inject) {
                    ext += this.myOptioner.nLinesSpace * 2;
                }
                ++i_Link2;
            }
        }
        return ext;
    }

    private void calculateMediumExtensions() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            int space;
            Edge edge = this.myEdges[i_Edge];
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            if (v1.level == v2.level && v1 != v2 && (space = IconSpacing.calculateMediumIconsSpace(edge)) != 0) {
                space += this.myOptioner.mediumIconAdd;
                int pos1 = v1.absPos;
                int pos2 = v2.absPos;
                if (pos1 > pos2) {
                    int temp = pos1;
                    pos1 = pos2;
                    pos2 = temp;
                    Vertex tempV = v1;
                    v1 = v2;
                    v2 = tempV;
                }
                int d = pos2 - pos1;
                Vertex[] nodes = this.myLevels[v1.level];
                int S = -v1.getWidth() - v1.rightExt - v2.leftExt;
                int i_Pos = pos1;
                while (i_Pos < pos2) {
                    Vertex v = nodes[i_Pos];
                    if ((S += v.getWidth() + this.myXCoordsAssigner.getNodesHSpace(v, nodes[i_Pos + 1])) >= space) break;
                    ++i_Pos;
                }
                if (S < space) {
                    int add = (space - S + d - 1) / d;
                    int i_Pos2 = pos1;
                    while (i_Pos2 < pos2) {
                        nodes[i_Pos2].rightMediumExt += add;
                        ++i_Pos2;
                    }
                }
            }
            ++i_Edge;
        }
    }

    private boolean calculateAdditionalExtensions() {
        boolean changes = false;
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.vertex1.level != edge.vertex2.level) {
                int i_Icon = 0;
                while (i_Icon < edge.getIconCount()) {
                    int size;
                    Icon icon = edge.getIconAt(i_Icon);
                    int horPos = icon.getHorPos();
                    int vertPos = icon.getVertPos();
                    boolean directed = icon.isDirected();
                    int n = size = directed ? icon.getWidth() + icon.getHeight() : icon.getWidth();
                    if ((horPos == 3 || vertPos == 10 || vertPos == 11) && this.setIfAdditionalExtension(edge, true, size, -1)) {
                        changes = true;
                    }
                    if ((horPos == 3 || vertPos == 12 || vertPos == 13) && this.setIfAdditionalExtension(edge, true, size, 1)) {
                        changes = true;
                    }
                    if ((horPos == 3 || vertPos == 10 || vertPos == 11) && this.setIfAdditionalExtension(edge, false, size, -1)) {
                        changes = true;
                    }
                    if ((horPos == 3 || vertPos == 12 || vertPos == 13) && this.setIfAdditionalExtension(edge, false, size, 1)) {
                        changes = true;
                    }
                    if ((horPos == 3 || vertPos == 14 || vertPos == 14) && this.setIfAdditionalExtension(edge, true, size, 0)) {
                        changes = true;
                    }
                    if ((horPos == 3 || vertPos == 14 || vertPos == 14) && this.setIfAdditionalExtension(edge, false, size, 0)) {
                        changes = true;
                    }
                    ++i_Icon;
                }
            }
            ++i_Edge;
        }
        return changes;
    }

    private boolean setIfAdditionalExtension(Edge edge, boolean srcFlag, int size, int direction) {
        Vertex v;
        int offset = srcFlag ? edge.srcOffset : edge.dstOffset;
        Vertex vertex = v = srcFlag ? edge.vertex1 : edge.vertex2;
        if (direction <= 0) {
            if ((size -= offset) > v.leftExt) {
                v.leftExt = size;
                return true;
            }
        } else if (direction >= 0 && (size -= v.getWidth() - offset) > v.rightExt) {
            v.rightExt = size;
            return true;
        }
        return false;
    }

    private void chooseIconsSegments() {
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                Icon icon = edge.getIconAt(i_Icon);
                icon.setSegment(this.chooseSegment(icon));
                ++i_Icon;
            }
            ++i_Edge;
        }
    }

    private int chooseSegment(Icon icon) {
        Edge edge = icon.getParent();
        int n = edge.getPointCount();
        if (icon.getHorPos() == 3) {
            Vertex v1 = edge.vertex1;
            Vertex v2 = edge.vertex2;
            if (v1 == v2) {
                return -1;
            }
            if (!this.myOptioner.bOrthogonalMode && v1.level != v2.level) {
                return -1;
            }
            if (n < 2) {
                throw new RuntimeException();
            }
            if (n == 2) {
                return 0;
            }
            if (v1.level != v2.level) {
                int seg = 0;
                while (seg < n - 1) {
                    if (edge.getPointAt((int)seg).x != edge.getPointAt((int)(seg + 1)).x) break;
                    ++seg;
                }
                if (seg == n - 1) {
                    throw new RuntimeException();
                }
                return seg;
            }
            if (n == 3) {
                Point p1 = edge.getPointAt(0);
                Point p2 = edge.getPointAt(1);
                Point p3 = edge.getPointAt(2);
                if (p1.y == p2.y) {
                    return 0;
                }
                if (p2.y == p3.y) {
                    return 1;
                }
            } else if (n == 4) {
                if (edge.getPointAt((int)1).y == edge.getPointAt((int)2).y) {
                    return 1;
                }
            } else if (n == 5) {
                Point p1 = edge.getPointAt(1);
                Point p2 = edge.getPointAt(2);
                Point p3 = edge.getPointAt(3);
                if (p1.y == p2.y) {
                    return 1;
                }
                if (p2.y == p3.y) {
                    return 2;
                }
            } else if (n == 6) {
                if (edge.getPointAt((int)2).y == edge.getPointAt((int)3).y) {
                    return 2;
                }
            } else {
                throw new RuntimeException();
            }
        }
        return -1;
    }
}

