/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl.auto;

import com.tssap.selena.layout.impl.Bary;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import java.util.Random;

final class AbsPosAssigner {
    private Optioner myOptioner;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vertex[][] myLevels = null;
    private boolean[] hasHorLinks = null;

    public AbsPosAssigner(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public void assignAbsPos(Vertex[] vertices, Edge[] edges, int n_Levels) {
        this.myVertices = vertices;
        this.myEdges = edges;
        this.myLevels = new Vertex[n_Levels][];
        this.assignInitialPositions();
        this.applyBCMethod();
    }

    public Vertex[][] getLevels() {
        return this.myLevels;
    }

    private void assignInitialPositions() {
        int i_Level = 0;
        while (i_Level < this.myLevels.length) {
            int count = 0;
            int i_Vertex = 0;
            while (i_Vertex < this.myVertices.length) {
                if (this.myVertices[i_Vertex].level == i_Level) {
                    ++count;
                }
                ++i_Vertex;
            }
            Vertex[] level = new Vertex[count];
            int i_Pos = 0;
            int i_Vertex2 = 0;
            while (i_Vertex2 < this.myVertices.length) {
                if (this.myVertices[i_Vertex2].level == i_Level) {
                    this.myVertices[i_Vertex2].absPos = i_Pos;
                    level[i_Pos] = this.myVertices[i_Vertex2];
                    ++i_Pos;
                }
                ++i_Vertex2;
            }
            this.myLevels[i_Level] = level;
            ++i_Level;
        }
    }

    private void applyBCMethod() {
        this.hasHorLinks = new boolean[this.myLevels.length];
        int i = 0;
        while (i < this.hasHorLinks.length) {
            this.hasHorLinks[i] = false;
            ++i;
        }
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            v.myBary = new Bary();
            Link[] links = v.myLinks;
            int level = v.level;
            int i_Link = 0;
            while (i_Link < links.length) {
                Vertex v1 = links[i_Link].myVertex;
                if (v1.level == level && v1 != v) break;
                ++i_Link;
            }
            if (i_Link == links.length) {
                v.tempInt = -1;
            } else {
                v.tempInt = i_Link;
                this.hasHorLinks[v.level] = true;
            }
            ++i_Vertex;
        }
        if (this.myLevels.length != 1) {
            int looper = 0;
            while (looper < this.myOptioner.BCMethodPhasesDirected.length) {
                boolean directed = this.myOptioner.BCMethodPhasesDirected[looper];
                boolean hOrdering = this.myOptioner.BCMethodPhasesHOrdering[looper];
                boolean mixing = this.myOptioner.BCMethodPhasesMixing[looper];
                int level = 0;
                while (level < this.myLevels.length) {
                    this.performPermutations(level, directed ? -1 : 0, hOrdering, mixing, 2 * looper);
                    ++level;
                }
                int level2 = this.myLevels.length - 1;
                while (level2 >= 0) {
                    this.performPermutations(level2, directed ? 1 : 0, hOrdering, mixing, 2 * looper + 1);
                    --level2;
                }
                ++looper;
            }
        } else {
            this.performPermutations(0, 0, true, false, 0);
        }
    }

    private boolean performPermutations(int i_Level, int d, boolean horizontalOrdering, boolean mixing, int counter) {
        Vertex[] nodes = this.myLevels[i_Level];
        if (nodes.length <= 1) {
            return false;
        }
        boolean b_Changes = false;
        int i = 0;
        while (i < nodes.length) {
            nodes[i].myBary.calculateFor(nodes[i], d);
            ++i;
        }
        int i2 = 0;
        while (i2 < nodes.length - 1) {
            int pos;
            Vertex min = nodes[i2];
            int j = i2 + 1;
            while (j < nodes.length) {
                Vertex v = nodes[j];
                if (v.myBary.lessThan(min.myBary)) {
                    min = v;
                    b_Changes = true;
                }
                ++j;
            }
            int k = pos = min.absPos;
            while (k > i2) {
                Vertex v;
                nodes[k] = v = nodes[k - 1];
                v.absPos = k--;
            }
            nodes[i2] = min;
            min.absPos = i2++;
        }
        if (!horizontalOrdering && !mixing) {
            return b_Changes;
        }
        Vertex[] nodes1 = new Vertex[nodes.length];
        int i3 = 0;
        while (i3 < nodes.length) {
            nodes1[i3] = nodes[i3];
            ++i3;
        }
        int[] forces = new int[nodes.length];
        Random random = new Random(counter);
        random.nextInt();
        int index = 0;
        while (index < nodes1.length) {
            int i_Pos = nodes1[index].absPos;
            Bary b = nodes[i_Pos].myBary;
            int leftBound = i_Pos - 1;
            while (leftBound >= 0) {
                if (!b.equalTo(nodes[leftBound].myBary)) break;
                --leftBound;
            }
            ++leftBound;
            int rightBound = i_Pos + 1;
            while (rightBound < nodes.length) {
                if (!b.equalTo(nodes[rightBound].myBary)) break;
                ++rightBound;
            }
            if (leftBound != --rightBound) {
                int i_NewPos;
                int maxForceCount;
                int maxForce;
                if (horizontalOrdering) {
                    int i_NewPos2 = leftBound;
                    while (i_NewPos2 < i_Pos) {
                        forces[i_NewPos2] = this.calculateForceToExchange(i_Level, i_NewPos2, i_Pos - 1, i_Pos, i_Pos);
                        ++i_NewPos2;
                    }
                    forces[i_Pos] = 0;
                    int i_NewPos3 = i_Pos + 1;
                    while (i_NewPos3 <= rightBound) {
                        forces[i_NewPos3] = this.calculateForceToExchange(i_Level, i_Pos, i_Pos, i_Pos + 1, i_NewPos3);
                        ++i_NewPos3;
                    }
                    maxForce = Integer.MIN_VALUE;
                    maxForceCount = 0;
                    i_NewPos = leftBound;
                    while (i_NewPos <= rightBound) {
                        int force = forces[i_NewPos];
                        if (force > maxForce) {
                            maxForce = force;
                            maxForceCount = 1;
                        } else if (force == maxForce) {
                            ++maxForceCount;
                        }
                        ++i_NewPos;
                    }
                } else {
                    maxForce = 0;
                    maxForceCount = rightBound - leftBound + 1;
                }
                int rand = random.nextInt();
                if (maxForce > 0 || maxForce == 0 && mixing && rand < 0) {
                    Vertex t;
                    int i4;
                    int n = Math.abs(rand) % maxForceCount;
                    if (horizontalOrdering) {
                        int count = 0;
                        i_NewPos = leftBound;
                        while (i_NewPos <= rightBound) {
                            if (forces[i_NewPos] != maxForce || count++ != n) {
                                ++i_NewPos;
                                continue;
                            }
                            break;
                        }
                    } else {
                        i_NewPos = leftBound + n;
                    }
                    if (i_NewPos < i_Pos) {
                        Vertex v = nodes[i_Pos];
                        i4 = i_Pos;
                        while (i4 > i_NewPos) {
                            nodes[i4] = t = nodes[i4 - 1];
                            t.absPos = i4--;
                        }
                        nodes[i_NewPos] = v;
                        v.absPos = i_NewPos;
                        b_Changes = true;
                    } else if (i_NewPos < i_Pos) {
                        Vertex v = nodes[i_Pos];
                        i4 = i_Pos;
                        while (i4 < i_NewPos) {
                            nodes[i4] = t = nodes[i4 + 1];
                            t.absPos = i4++;
                        }
                        nodes[i_NewPos] = v;
                        v.absPos = i_NewPos;
                        b_Changes = true;
                    }
                }
            }
            ++index;
        }
        return b_Changes;
    }

    private int calculateForceToExchange(int level, int left1, int right1, int left2, int right2) {
        if (right1 >= left2) {
            throw new RuntimeException();
        }
        if (!this.hasHorLinks[level]) {
            return 0;
        }
        Vertex[] nodes = this.myLevels[level];
        int force = 0;
        int i_Pos = left1;
        while (i_Pos <= right1) {
            Vertex v = nodes[i_Pos];
            int i_Link = v.tempInt;
            if (i_Link >= 0) {
                Link[] links = v.myLinks;
                while (i_Link < links.length) {
                    Vertex v1 = links[i_Link].myVertex;
                    if (v1.level == level) {
                        int pos = v1.absPos;
                        if (pos < left1) {
                            force -= right2 - right1;
                        } else if (pos > right1) {
                            force = pos < left2 ? (force -= left2 - left1 + 2 * (i_Pos - pos)) : (pos <= right2 ? (force -= left2 - left1 + right2 - right1 + 2 * (i_Pos - pos)) : (force += right2 - right1));
                        }
                    }
                    ++i_Link;
                }
            }
            ++i_Pos;
        }
        int i_Pos2 = left2;
        while (i_Pos2 <= right2) {
            Vertex v = nodes[i_Pos2];
            int i_Link = v.tempInt;
            if (i_Link >= 0) {
                Link[] links = v.myLinks;
                while (i_Link < links.length) {
                    Vertex v1 = links[i_Link].myVertex;
                    if (v1.level == level) {
                        int pos = v1.absPos;
                        if (pos < left1) {
                            force += left2 - left1;
                        } else if (pos > right1) {
                            if (pos < left2) {
                                force -= right2 - right1 + 2 * (pos - i_Pos2);
                            } else if (pos > right2) {
                                force -= left2 - left1;
                            }
                        }
                    }
                    ++i_Link;
                }
            }
            ++i_Pos2;
        }
        return force;
    }
}

