/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import java.util.Vector;

public class VerticalCyclesManager {
    private Optioner myOptioner;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private Vector myReversed;

    public VerticalCyclesManager(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public void removeVerticalCycles(Vertex[] vertices, Edge[] edges) {
        this.myVertices = vertices;
        this.myEdges = edges;
        Vertex[] sequence = new Vertex[this.myVertices.length];
        int left = 0;
        int right = sequence.length;
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            this.myVertices[i_Vertex].tempFlag = false;
            ++i_Vertex;
        }
        boolean changes = true;
        while (changes) {
            changes = false;
            int i_Vertex2 = 0;
            while (i_Vertex2 < this.myVertices.length) {
                if (left == right) {
                    return;
                }
                Vertex v = this.myVertices[i_Vertex2];
                if (!v.tempFlag) {
                    boolean incoming = false;
                    boolean outcoming = false;
                    int i_Link = 0;
                    while (i_Link < v.myLinks.length) {
                        Link link = v.myLinks[i_Link];
                        if (link.myEdge.isVertical() && !link.myVertex.tempFlag && link.myVertex != v) {
                            if (link.iDirected > 0) {
                                outcoming = true;
                            } else {
                                incoming = true;
                            }
                            if (incoming && outcoming) break;
                        }
                        ++i_Link;
                    }
                    if (!incoming) {
                        sequence[left] = v;
                        v.tempFlag = true;
                        v.tempInt = left++;
                        changes = true;
                    } else if (!outcoming) {
                        sequence[--right] = v;
                        v.tempFlag = true;
                        v.tempInt = right;
                        changes = true;
                    }
                }
                ++i_Vertex2;
            }
        }
        if (left == right) {
            return;
        }
        int count = 0;
        int i_Vertex3 = 0;
        while (i_Vertex3 < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex3];
            if (!v.tempFlag) {
                if (count == 0) {
                    sequence[left] = v;
                    v.tempFlag = true;
                    v.tempInt = left;
                    ++count;
                } else {
                    int minReversed = Integer.MAX_VALUE;
                    int bestPosition = -1;
                    int i_Pos = left;
                    while (i_Pos <= left + count) {
                        block25: {
                            int reversed = 0;
                            int i_Link = 0;
                            while (i_Link < v.myLinks.length) {
                                int index;
                                Link link = v.myLinks[i_Link];
                                if (!link.myEdge.isVertical() || link.myVertex == v || left > (index = link.myVertex.tempInt) || index >= right || link.iDirected > 0 != index < i_Pos || ++reversed < minReversed) {
                                    ++i_Link;
                                    continue;
                                }
                                break block25;
                            }
                            if (reversed < minReversed) {
                                minReversed = reversed;
                                bestPosition = i_Pos;
                            }
                        }
                        ++i_Pos;
                    }
                    int i = left + count - 1;
                    while (i >= bestPosition) {
                        sequence[i + 1] = sequence[i];
                        sequence[i + 1].tempInt = i + 1;
                        --i;
                    }
                    sequence[bestPosition] = v;
                    v.tempFlag = true;
                    v.tempInt = bestPosition;
                    ++count;
                }
            }
            ++i_Vertex3;
        }
        if (count != right - left) {
            throw new RuntimeException("VCMG001");
        }
        this.myReversed = new Vector();
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            if (edge.isVertical() && edge.vertex1 != edge.vertex2 && edge.vertex1.tempInt > edge.vertex2.tempInt) {
                edge.setVertical(false);
                this.myReversed.add(edge);
            }
            ++i_Edge;
        }
    }

    public void restoreVerticalCycles() {
        if (this.myReversed == null) {
            return;
        }
        int i = 0;
        while (i < this.myReversed.size()) {
            ((Edge)this.myReversed.get(i)).setVertical(true);
            ++i;
        }
        this.myReversed = null;
    }
}

