/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.ConflictIgnorer;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.Geometer;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.Point;

public final class StandardIgnorer
implements ConflictIgnorer {
    public boolean ignoreConflict(Element e1, Element e2) {
        Edge edge;
        Vertex v;
        Object obj1 = e1.getObject();
        Object obj2 = e2.getObject();
        if (obj1 instanceof Edge && obj2 instanceof Edge) {
            return obj1 == obj2;
        }
        if (obj2 instanceof Icon) {
            Object obj = obj1;
            obj1 = obj2;
            obj2 = obj;
        }
        if (obj1 instanceof Icon) {
            Icon icon = (Icon)obj1;
            if (obj2 instanceof Edge) {
                Element e;
                if (icon.getParent() != obj2) {
                    return false;
                }
                Edge edge2 = (Edge)obj2;
                int seg = icon.getSegment();
                Point p1 = edge2.getPointAt(seg);
                Point p2 = edge2.getPointAt(seg + 1);
                Element element = e = e1.getObject() == obj2 ? e1 : e2;
                if (e instanceof Line) {
                    boolean eq21;
                    boolean eq22;
                    Line l = (Line)e;
                    boolean eq11 = l.getX1() == p1.x && l.getY1() == p1.y;
                    boolean bl = eq22 = l.getX2() == p2.x && l.getY2() == p2.y;
                    if (eq11 && eq22) {
                        return true;
                    }
                    boolean eq12 = l.getX1() == p2.x && l.getY1() == p2.y;
                    boolean bl2 = eq21 = l.getX2() == p1.x && l.getY2() == p1.y;
                    if (eq12 && eq21) {
                        return true;
                    }
                    if (eq11 || eq12 || eq21 || eq22) {
                        return !Geometer.lineCrossGRectangle(l, icon);
                    }
                    return false;
                }
                if (e instanceof Point) {
                    return e.equals(p1) || e.equals(p2);
                }
                throw new RuntimeException("STDI001");
            }
            if (obj2 instanceof Vertex) {
                int horPos = icon.getHorPos();
                if (horPos == 1) {
                    return icon.getParent().vertex1 == obj2;
                }
                if (horPos == 2) {
                    return icon.getParent().vertex2 == obj2;
                }
            } else {
                return false;
            }
        }
        if (obj1 instanceof Vertex && obj2 instanceof Edge) {
            v = (Vertex)obj1;
            edge = (Edge)obj2;
        } else if (obj1 instanceof Edge && obj2 instanceof Vertex) {
            v = (Vertex)obj2;
            edge = (Edge)obj1;
        } else {
            return false;
        }
        return v == edge.vertex1 || v == edge.vertex2;
    }
}

