/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Reporter;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import java.util.Vector;

public class Service {
    static final int OutputCoords = 1;
    public static final int OutputSelected = 2;
    public static final int OutputReshaped = 4;
    public static final int SkipIcons = 8;

    public static void shift(Vertex[] vertices, Edge[] edges, int shiftx, int shifty) {
        int i_Vertex = 0;
        while (i_Vertex < vertices.length) {
            vertices[i_Vertex].shift(shiftx, shifty);
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < edges.length) {
            Edge edge = edges[i_Edge];
            int i_Point = 0;
            while (i_Point < edge.getPointCount()) {
                edge.getPointAt(i_Point).shift(shiftx, shifty);
                ++i_Point;
            }
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                edge.getIconAt(i_Icon).shift(shiftx, shifty);
                ++i_Icon;
            }
            ++i_Edge;
        }
    }

    public static void transponate(Vertex[] vertices, Edge[] edges) {
        int i_Vertex = 0;
        while (i_Vertex < vertices.length) {
            vertices[i_Vertex].transponate();
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < edges.length) {
            Edge e = edges[i_Edge];
            int i_Point = 0;
            while (i_Point < e.getPointCount()) {
                e.getPointAt(i_Point).transponate();
                ++i_Point;
            }
            int i_Icon = 0;
            while (i_Icon < e.getIconCount()) {
                e.getIconAt(i_Icon).transponate();
                ++i_Icon;
            }
            ++i_Edge;
        }
    }

    public static void createEdgesGroups(Vertex v, int inject) {
        int lastIndex = -1;
        Vector<Edge> edgesArray = null;
        do {
            int groupId = 0;
            edgesArray = null;
            Link[] links = v.myLinks;
            int i_Link = lastIndex + 1;
            while (i_Link < links.length) {
                Edge edge;
                Link link = links[i_Link];
                if (link.iDirected < 0 && (edge = link.myEdge).isGroupable() && edge.myGroup == null && (edge.dstInject == inject || inject == -1)) {
                    if (groupId == 0) {
                        groupId = edge.getGroupId();
                        lastIndex = i_Link;
                        edgesArray = new Vector<Edge>();
                    }
                    if (edge.getGroupId() == groupId) {
                        edgesArray.add(edge);
                    }
                }
                ++i_Link;
            }
            if (edgesArray == null || edgesArray.size() <= 1) continue;
            EdgesGroup group = new EdgesGroup();
            Edge[] edges = new Edge[edgesArray.size()];
            int i = 0;
            while (i < edgesArray.size()) {
                Edge edge;
                edges[i] = edge = (Edge)edgesArray.get(i);
                edge.myGroup = group;
                ++i;
            }
            group.dstInject = inject;
            group.myEdges = edges;
            group.id = groupId;
            group.vertex2 = edges[0].vertex2;
        } while (edgesArray != null);
    }

    public static void addToLinesManager(LinesManager linesManager, Vertex[] vertices, Edge[] edges, boolean addIcons) {
        if (vertices != null) {
            int i_Vertex = 0;
            while (i_Vertex < vertices.length) {
                Vertex v = vertices[i_Vertex];
                linesManager.add(v);
                ++i_Vertex;
            }
        }
        if (edges != null) {
            int i_Edge = 0;
            while (i_Edge < edges.length) {
                Edge e = edges[i_Edge];
                int n = e.getPointCount();
                int i_Point = 0;
                while (i_Point < n - 1) {
                    Point p1 = e.getPointAt(i_Point);
                    Point p2 = e.getPointAt(i_Point + 1);
                    if (i_Point != 0) {
                        linesManager.add(p1);
                    }
                    Line l = new Line(p1.x, p1.y, p2.x, p2.y, e);
                    linesManager.add(l);
                    ++i_Point;
                }
                if (addIcons) {
                    int i_Icon = 0;
                    while (i_Icon < e.getIconCount()) {
                        Icon i = e.getIconAt(i_Icon);
                        linesManager.add(i);
                        ++i_Icon;
                    }
                }
                ++i_Edge;
            }
        }
    }

    public static void sortBiIntArray(int[] keyArray, int[] followArray) {
        int i = keyArray.length - 1;
        while (i >= 1) {
            int j = 0;
            while (j < i) {
                if (keyArray[j] > keyArray[j + 1]) {
                    int temp = keyArray[j];
                    keyArray[j] = keyArray[j + 1];
                    keyArray[j + 1] = temp;
                    temp = followArray[j];
                    followArray[j] = followArray[j + 1];
                    followArray[j + 1] = temp;
                }
                ++j;
            }
            --i;
        }
    }

    public static int dist2(int x1, int y1, int x2, int y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public static void outputDump(Vector verticesArray, Vector edgesArray, String fileName, int flags) {
        Reporter reporter = new Reporter();
        if (!reporter.open(fileName)) {
            return;
        }
        if (verticesArray != null) {
            int i_Vertex = 0;
            while (i_Vertex < verticesArray.size()) {
                Vertex v = (Vertex)verticesArray.get(i_Vertex);
                String s = "node " + i_Vertex + " : w = " + v.getWidth() + " h = " + v.getHeight();
                if ((flags & 2) != 0) {
                    s = s + " selected = " + v.isSelected();
                }
                if ((flags & 4) != 0) {
                    s = s + " reshaped = " + v.isReshaped();
                }
                if ((flags & 1) != 0) {
                    s = s + " x = " + v.getLeft() + " y = " + v.getTop();
                }
                if (v.getContainingNode() != null) {
                    s = s + " (inner)";
                }
                reporter.outputString(s);
                v.tempInt = i_Vertex++;
            }
        }
        if (edgesArray != null) {
            int i_Edge = 0;
            while (i_Edge < edgesArray.size()) {
                Edge edge = (Edge)edgesArray.get(i_Edge);
                int from = edge.vertex1.tempInt;
                int to = edge.vertex2.tempInt;
                String s = "link " + i_Edge + " : from " + from + " to " + to + " vertical = " + edge.isVertical();
                if ((flags & 2) != 0) {
                    s = s + " selected = " + edge.isSelected();
                }
                if ((flags & 1) != 0) {
                    int i_Point = 0;
                    while (i_Point < edge.getPointCount()) {
                        Point p = edge.getPointAt(i_Point);
                        s = s + " " + p.x + " " + p.y;
                        ++i_Point;
                    }
                }
                reporter.outputString(s);
                if ((flags & 8) == 0) {
                    int i_Icon = 0;
                    while (i_Icon < edge.getIconCount()) {
                        String vertPos;
                        String horPos;
                        Icon icon = edge.getIconAt(i_Icon);
                        switch (icon.getHorPos()) {
                            case 1: {
                                horPos = "NearSrcPos";
                                break;
                            }
                            case 2: {
                                horPos = "NearDstPos";
                                break;
                            }
                            case 3: {
                                horPos = "MediumPos";
                                break;
                            }
                            default: {
                                throw new RuntimeException("SERV001");
                            }
                        }
                        switch (icon.getVertPos()) {
                            case 10: {
                                vertPos = "AboveLeftPos";
                                break;
                            }
                            case 12: {
                                vertPos = "AboveRightPos";
                                break;
                            }
                            case 11: {
                                vertPos = "UnderLeftPos";
                                break;
                            }
                            case 13: {
                                vertPos = "UnderRightPos";
                                break;
                            }
                            case 14: {
                                vertPos = "Aside";
                                break;
                            }
                            case 15: {
                                vertPos = "OnPos";
                                break;
                            }
                            default: {
                                throw new RuntimeException("SERV002");
                            }
                        }
                        s = "         icon " + i_Icon + " : w = " + icon.getWidth() + " h = " + icon.getHeight() + " directed = " + icon.isDirected() + " horPos = " + horPos + " vertPos = " + vertPos;
                        if ((flags & 2) != 0) {
                            s = s + " selected = " + icon.isSelected();
                        }
                        if ((flags & 1) != 0) {
                            s = s + " x = " + icon.getX() + " y = " + icon.getY() + " sin = " + icon.getSin() + " cos = " + icon.getCos();
                        }
                        reporter.outputString(s);
                        ++i_Icon;
                    }
                }
                ++i_Edge;
            }
        }
        reporter.close();
    }
}

