/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.MyInteger;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Point;
import java.util.Vector;

public final class RightBound {
    private Optioner myOptioner;
    private int myStartX;
    private int step;
    private Vector myElements = new Vector();
    private int myMaxX;
    private int lastIndex1;
    private int lastIndex2;
    private int lastResult;

    public RightBound(Optioner optioner, int startX) {
        this.myOptioner = optioner;
        this.myStartX = startX;
        this.step = this.myOptioner.rightBoundStep;
        this.myMaxX = this.myStartX;
        this.lastIndex1 = -1;
    }

    public void shift(int shiftx) {
        int i = 0;
        while (i < this.myElements.size()) {
            ((MyInteger)this.myElements.get((int)i)).value += shiftx;
            ++i;
        }
        this.myStartX += shiftx;
        this.myMaxX += shiftx;
        if (this.lastIndex1 >= 0) {
            this.lastResult += shiftx;
        }
    }

    public void add(Vertex v) {
        int x = v.getRight() + v.rightExt;
        int y1 = v.getTop() - v.topExt;
        int y2 = v.getBottom() + v.bottomExt;
        this.addLine(x, y1, x, y2);
    }

    public void add(Edge e) {
        int i_Point = 0;
        while (i_Point < e.getPointCount() - 1) {
            Point p1 = e.getPointAt(i_Point);
            Point p2 = e.getPointAt(i_Point + 1);
            this.addLine(p1.x, p1.y, p2.x, p2.y);
            ++i_Point;
        }
    }

    public void add(Icon i) {
        int x = i.getRight();
        int y1 = i.getTop();
        int y2 = i.getBottom();
        this.addLine(x, y1, x, y2);
    }

    public int getMaxX(int y1, int y2) {
        y1 = Math.max(y1, 0);
        y2 = Math.max(y2, 0);
        int ymin = Math.min(y1, y2);
        int ymax = Math.max(y1, y2);
        int index1 = ymin / this.step;
        int index2 = ymax / this.step;
        if (index1 == 0 && index2 >= this.myElements.size() - 1) {
            return this.myMaxX;
        }
        if (index1 >= this.myElements.size()) {
            return this.myStartX;
        }
        index2 = Math.min(index2, this.myElements.size() - 1);
        if (this.lastIndex1 == index1 && this.lastIndex2 == index2) {
            return this.lastResult;
        }
        if (index2 - index1 > 4 && this.lastIndex1 >= 0) {
            int i1 = Math.max(index1, this.lastIndex1);
            int i2 = Math.min(index2, this.lastIndex2);
            if (2 * (i2 - i1) > index1 - index2) {
                int x = this.myStartX;
                int i = index1;
                while (i < this.lastIndex1) {
                    MyInteger X = (MyInteger)this.myElements.get(i);
                    x = Math.max(x, X.value);
                    ++i;
                }
                int i3 = this.lastIndex2 + 1;
                while (i3 <= index2) {
                    MyInteger X = (MyInteger)this.myElements.get(i3);
                    x = Math.max(x, X.value);
                    ++i3;
                }
                if (x < this.lastResult) {
                    int i4 = i1;
                    while (i4 <= i2) {
                        MyInteger X = (MyInteger)this.myElements.get(i4);
                        if ((x = Math.max(X.value, x)) == this.lastResult) break;
                        ++i4;
                    }
                }
                this.lastIndex1 = index1;
                this.lastIndex2 = index2;
                this.lastResult = x;
                return x;
            }
        }
        int x = this.myStartX;
        int i = index1;
        while (i <= index2) {
            MyInteger X = (MyInteger)this.myElements.get(i);
            x = Math.max(x, X.value);
            ++i;
        }
        this.lastIndex1 = index1;
        this.lastIndex2 = index2;
        this.lastResult = x;
        return x;
    }

    public int calculateShift(Vertex v) {
        int y1 = v.getTop();
        int y2 = v.getBottom();
        return this.getMaxX(y1, y2) - v.getLeft();
    }

    public int calculateShift(Edge e) {
        int shift = Integer.MIN_VALUE;
        int i_Point = 0;
        while (i_Point < e.getPointCount() - 1) {
            Point p1 = e.getPointAt(i_Point);
            Point p2 = e.getPointAt(i_Point + 1);
            shift = Math.max(shift, this.calculateShift(p1.x, p1.y, p2.x, p2.y));
            ++i_Point;
        }
        return shift;
    }

    public int calculateShift(Icon i) {
        int y1 = i.getTop();
        int y2 = i.getBottom();
        return this.getMaxX(y1, y2) - i.getLeft();
    }

    public int getBottom() {
        return this.myElements.size() * this.step;
    }

    public int getLeft() {
        return this.myStartX;
    }

    private int calculateShift(int x1, int y1, int x2, int y2) {
        y1 = Math.max(y1, 0);
        y2 = Math.max(y2, 0);
        int minx = Math.min(x1, x2);
        if (y1 == y2) {
            int index = y1 / this.step;
            int X = this.getConst(index);
            return X - minx;
        }
        if (y1 > y2) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        int index1 = y1 / this.step;
        int index2 = y2 / this.step;
        int shift = Integer.MIN_VALUE;
        int i = index1;
        while (i <= index2) {
            int y = x2 < x1 ? (i + 1) * this.step : i * this.step;
            int x = ((y - y1) * x2 + (y2 - y) * x1) / (y2 - y1);
            x = Math.max(x, minx);
            int X = this.getConst(i);
            shift = Math.max(shift, X - x);
            ++i;
        }
        return shift;
    }

    private void addLine(int x1, int y1, int x2, int y2) {
        y1 = Math.max(y1, 0);
        y2 = Math.max(y2, 0);
        this.lastIndex1 = -1;
        int maxx = Math.max(x1 += this.myOptioner.nComponentsSpace, x2 += this.myOptioner.nComponentsSpace);
        if (y1 == y2) {
            y1 = Math.max(0, y1 - this.myOptioner.nComponentsSpace);
            y2 += this.myOptioner.nComponentsSpace;
            x1 = x2 = Math.max(x1, x2);
        } else {
            if (y2 < y1) {
                int temp = y1;
                y1 = y2;
                y2 = temp;
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            int newy1 = Math.max(0, y1 - this.myOptioner.nComponentsSpace);
            int newy2 = y2 + this.myOptioner.nComponentsSpace;
            int newx1 = ((newy1 - y1) * x2 + (y2 - newy1) * x1) / (y2 - y1);
            int newx2 = ((newy2 - y1) * x2 + (y2 - newy2) * x1) / (y2 - y1);
            x1 = newx1;
            x2 = newx2;
            y1 = newy1;
            y2 = newy2;
        }
        int index1 = y1 / this.step;
        int index2 = y2 / this.step;
        int i = index1;
        while (i <= index2) {
            int x;
            if (x1 != x2) {
                int y = x2 > x1 ? (i + 1) * this.step : i * this.step;
                x = ((y - y1) * x2 + (y2 - y) * x1) / (y2 - y1);
                x = Math.min(x, maxx);
            } else {
                x = x1;
            }
            MyInteger X = this.get(i);
            if (x > X.value) {
                X.value = x;
                this.myMaxX = Math.max(this.myMaxX, x);
            }
            ++i;
        }
    }

    private MyInteger get(int index) {
        while (index >= this.myElements.size()) {
            this.myElements.add(new MyInteger(this.myStartX));
        }
        return (MyInteger)this.myElements.get(index);
    }

    private int getConst(int index) {
        return index < this.myElements.size() ? ((MyInteger)this.myElements.get((int)index)).value : this.myStartX;
    }
}

