/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Injection;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Reporter {
    private DataOutputStream myStream = null;

    public boolean open(String fileName) {
        try {
            this.myStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName), 128));
            return true;
        }
        catch (IOException e) {
            this.myStream = null;
            return false;
        }
    }

    public void close() {
        try {
            if (this.myStream != null) {
                this.myStream.flush();
            }
            this.myStream = null;
        }
        catch (IOException e) {
            this.myStream = null;
        }
    }

    public void flush() {
        try {
            if (this.myStream != null) {
                this.myStream.flush();
            }
        }
        catch (IOException e) {
            this.myStream = null;
        }
    }

    public void outputInjection(Injection inj) {
        this.outputString("offset = " + inj.offset);
        this.outputString("bary1 = " + inj.bary1 + " bary2 = " + inj.bary2);
        this.outputString("bestOffset = " + inj.bestOffset);
        if (inj.attractorFlag) {
            this.outputString("attractorOffset = " + inj.attractorOffset);
        }
        this.outputString("minBound = " + inj.minBound + " maxBound = " + inj.maxBound);
        this.outputString("leftIconSpace = " + inj.leftIconSpace + " rightIconSpace = " + inj.rightIconSpace);
    }

    public void outputIcon(Icon icon) {
        this.outputString("x = " + icon.getX() + ", y = " + icon.getY());
        this.outputString("w = " + icon.getWidth() + ", h = " + icon.getHeight());
        if (icon.isDirected()) {
            this.outputString("Is directed.");
        }
        this.outputString("sin = " + icon.getSin() + ", cos = " + icon.getCos());
    }

    public void outputString(String s) {
        if (this.myStream == null) {
            return;
        }
        try {
            this.myStream.writeBytes(s + "\n");
            this.myStream.flush();
        }
        catch (IOException e) {
            this.myStream = null;
        }
    }

    public void outputString_(String s) {
        if (this.myStream == null) {
            return;
        }
        try {
            this.myStream.writeBytes(s);
        }
        catch (IOException e) {
            this.myStream = null;
        }
    }
}

