/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Optioner;

public final class Paging {
    private Optioner myOptioner;

    public Paging(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public int paginate(int pos, int size, int minBound, int maxBound, boolean vertical) {
        int nPages;
        int page1;
        if (!this.myOptioner.pagingFlag) {
            throw new RuntimeException("PAGN001");
        }
        int pageSize = vertical ? this.myOptioner.pageHeight : this.myOptioner.pageWidth;
        int margin = this.myOptioner.pageMargin;
        if ((maxBound -= size) < (minBound = Math.max(minBound, margin))) {
            throw new RuntimeException("PAGN002");
        }
        int newPos = Math.min(Math.max(pos, minBound), maxBound);
        int page2 = (newPos + size + margin) / pageSize;
        if (page2 - (page1 = (newPos - margin) / pageSize) != (nPages = (size + 2 * margin) / pageSize)) {
            int pos1 = page2 * pageSize - size - margin;
            int pos2 = (page1 + 1) * pageSize + margin;
            newPos = pos1 < minBound ? pos2 : (pos2 > maxBound ? pos1 : (Math.abs(pos2 - pos) < Math.abs(pos1 - pos) ? pos2 : pos1));
        }
        return newPos;
    }
}

