/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Paging;
import com.tssap.selena.layout.impl.RightBound;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import java.util.Vector;

public final class LonelyVerticesLayouter {
    private Optioner myOptioner;
    private Vector myVerticesArray = null;
    private RightBound myStartX = null;
    private LinesManager myLinesManager = null;
    private Paging myPaging = null;
    private int right;
    private int bottom;
    private int step;

    public LonelyVerticesLayouter(Optioner optioner) {
        this.myOptioner = optioner;
        this.step = this.myOptioner.rightBoundStep;
        if (this.myOptioner.pagingFlag) {
            this.myPaging = new Paging(this.myOptioner);
        }
    }

    public void layoutLonelyVertices(Vector verticesArray, RightBound startX) {
        this.myVerticesArray = verticesArray;
        this.myStartX = startX;
        this.myLinesManager = null;
        this.doLayout(false);
    }

    public void layoutLonelyVerticesForIncremental(Vector verticesArray, RightBound startX, LinesManager linesManager) {
        this.myVerticesArray = verticesArray;
        this.myStartX = startX;
        this.myLinesManager = linesManager;
        this.doLayout(true);
    }

    private void doLayout(boolean forIncremental) {
        int i_Vertex = 0;
        while (i_Vertex < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i_Vertex);
            if (v.myNumberOfLinks == 0) {
                if (forIncremental && !v.isSelected()) {
                    int shift;
                    if (!this.myLinesManager.isCorrect(v) && (shift = this.myStartX.calculateShift(v)) > 0) {
                        int x = v.getLeft() + shift;
                        if (this.myOptioner.pagingFlag) {
                            int minX = Math.max(this.myOptioner.startX, x - this.myOptioner.nComponentsSpace + this.myOptioner.nMinComponentsSpace);
                            x = this.myPaging.paginate(x, v.getWidth(), minX, Integer.MAX_VALUE, false);
                        }
                        v.setX(x);
                    }
                } else {
                    this.right = this.myStartX.getMaxX(0, Integer.MAX_VALUE);
                    this.bottom = Math.max(this.myStartX.getBottom(), this.myOptioner.startY);
                    this.place(v);
                }
                this.myStartX.add(v);
                if (this.myLinesManager != null) {
                    this.myLinesManager.add(v);
                }
            }
            ++i_Vertex;
        }
    }

    private void place(Vertex v) {
        int h = v.getHeight();
        int w = v.getWidth();
        int bestX = Integer.MIN_VALUE;
        int bestY = Integer.MIN_VALUE;
        int bestValue = Integer.MAX_VALUE;
        int y = this.myOptioner.startY;
        while (y < this.bottom + this.step) {
            if (this.myOptioner.pagingFlag) {
                y = this.myPaging.paginate(y, h, y, Integer.MAX_VALUE, true);
            }
            v.setY(y);
            v.setX(0);
            int x = this.myStartX.calculateShift(v);
            if (this.myOptioner.pagingFlag) {
                int minX = Math.max(this.myOptioner.startX, x - this.myOptioner.nComponentsSpace + this.myOptioner.nMinComponentsSpace);
                x = this.myPaging.paginate(x, w, minX, Integer.MAX_VALUE, false);
            }
            int r = x + w + this.myOptioner.nComponentsSpace - this.right;
            int b = y + h + this.myOptioner.nComponentsSpace - this.bottom;
            if (r < 0 && b < 0) {
                v.setX(x);
                return;
            }
            if (this.right > this.bottom) {
                if (bestValue > r) {
                    bestValue = r;
                    bestX = x;
                    bestY = y;
                }
            } else if (bestValue > b) {
                bestValue = b;
                bestX = x;
                bestY = y;
            }
            y += this.step;
        }
        v.setX(bestX);
        v.setY(bestY);
    }
}

