/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.Item;
import com.tssap.selena.layout.LayoutNode;
import com.tssap.selena.layout.impl.AbstractLayouter;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.model.elements.Element;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;

public final class Layouter
extends AbstractLayouter {
    private AbstractLayouter myLayouter;
    private Optioner myOptioner;
    private Vector myVerticesArray = null;
    private Vector myEdgesArray = null;
    private Vector mySavedVerticesArray = null;
    private Vector mySavedEdgesArray = null;
    private Vector myInnerVerticesArray = null;
    private Vector myInnerEdgesArray = null;
    private Vector myReroutedEdgesArray = null;
    private HashMap myReroutedEdgeToSrcMap = null;
    private HashMap myReroutedEdgeToDstMap = null;
    static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;

    public Layouter(Optioner optioner) {
        this.myOptioner = optioner;
        switch (optioner.layoutType) {
            case 1: {
                this.myLayouter = new com.tssap.selena.layout.impl.auto.Layouter(optioner);
                break;
            }
            case 2: {
                this.myLayouter = new com.tssap.selena.layout.impl.increment.Layouter(optioner);
                break;
            }
            case 3: {
                this.myLayouter = new com.tssap.selena.layout.impl.semiauto.Layouter(optioner);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void doLayout(Vector verticesArray, Vector edgesArray) {
        this.myVerticesArray = verticesArray;
        this.myEdgesArray = edgesArray;
        if (!this.myOptioner.bOrthogonalMode) {
            int i = 0;
            while (i < this.myEdgesArray.size()) {
                Edge edge = (Edge)this.myEdgesArray.get(i);
                edge.setGroupId(0);
                ++i;
            }
        }
        if (this.myOptioner.layoutType == 1 || this.myOptioner.layoutType == 2) {
            this.extractInnerNodes();
            this.SyncBarsControl(this.myVerticesArray, this.myOptioner.orientation == 1 || this.myOptioner.orientation == 2, true);
        } else {
            this.SyncBarsControl(this.myVerticesArray, this.myOptioner.orientation == 1 || this.myOptioner.orientation == 2, false);
        }
        this.processReversedLinks();
        try {
            this.myLayouter.doLayout(this.myVerticesArray, this.myEdgesArray);
        }
        catch (Exception ex) {
            String msg = "Internal error in layouter: " + ex.getMessage();
            System.out.println(msg);
        }
        this.processReversedLinks();
        if ((this.myOptioner.layoutType == 1 || this.myOptioner.layoutType == 2) && this.restoreInnerNodes()) {
            int i = 0;
            while (i < this.myVerticesArray.size()) {
                Vertex v = (Vertex)this.myVerticesArray.get(i);
                v.setSelected(false);
                ++i;
            }
            if (this.myOptioner.layoutType == 2) {
                int i2 = 0;
                while (i2 < this.myEdgesArray.size()) {
                    Edge edge = (Edge)this.myEdgesArray.get(i2);
                    int j = 0;
                    while (j < edge.getIconCount()) {
                        edge.getIconAt(j).setSelected(true);
                        ++j;
                    }
                    ++i2;
                }
            }
            try {
                new com.tssap.selena.layout.impl.semiauto.Layouter(this.myOptioner).doLayout(this.myVerticesArray, this.myEdgesArray);
            }
            catch (Exception ex) {
                String msg = "Internal Error in Layouter: " + ex.getMessage();
                System.out.println(msg);
            }
        }
    }

    private void processReversedLinks() {
        int i_Edge = 0;
        while (i_Edge < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i_Edge);
            if (edge.getDirected() == 2) {
                Vertex v = edge.vertex1;
                edge.vertex1 = edge.vertex2;
                edge.vertex2 = v;
                Point[] points = new Point[edge.getPointCount()];
                int i = 0;
                while (i < points.length) {
                    points[i] = edge.getPointAt(i);
                    ++i;
                }
                edge.resetPoints();
                int i2 = points.length - 1;
                while (i2 >= 0) {
                    edge.addPoint(points[i2]);
                    --i2;
                }
                int i3 = 0;
                while (i3 < edge.getIconCount()) {
                    Icon icon = edge.getIconAt(i3);
                    if (icon.getHorPos() == 1) {
                        icon.setHorPos(2);
                    } else if (icon.getHorPos() == 2) {
                        icon.setHorPos(1);
                    }
                    ++i3;
                }
            }
            ++i_Edge;
        }
    }

    private void extractInnerNodes() {
        Vector<Vertex> newVerticesArray = null;
        Vector<Edge> newEdgesArray = null;
        int i = 0;
        while (i < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i);
            if (v.myContainingVertex != null) {
                newVerticesArray = new Vector<Vertex>();
                newEdgesArray = new Vector<Edge>();
                this.myInnerVerticesArray = new Vector();
                this.myInnerEdgesArray = new Vector();
                this.myReroutedEdgesArray = new Vector();
                this.myReroutedEdgeToSrcMap = new HashMap();
                this.myReroutedEdgeToDstMap = new HashMap();
                break;
            }
            ++i;
        }
        if (newVerticesArray == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i2);
            Vertex container = Layouter.getTopContainingVertex(v);
            if (container != null) {
                this.myInnerVerticesArray.add(v);
                v.setX(v.getX() - container.getX());
                v.setY(v.getY() - container.getY());
            } else {
                newVerticesArray.add(v);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.myEdgesArray.size()) {
            Edge e = (Edge)this.myEdgesArray.get(i3);
            Vertex v1 = e.vertex1;
            Vertex v2 = e.vertex2;
            Vertex container1 = Layouter.getTopContainingVertex(v1);
            Vertex container2 = Layouter.getTopContainingVertex(v2);
            if (container1 == null && container2 == null) {
                newEdgesArray.add(e);
            } else if (container1 != container2) {
                this.myReroutedEdgesArray.add(e);
                if (container1 != null) {
                    this.myReroutedEdgeToSrcMap.put(e, v1);
                    e.vertex1 = container1;
                }
                if (container2 != null) {
                    this.myReroutedEdgeToDstMap.put(e, v2);
                    e.vertex2 = container2;
                }
                newEdgesArray.add(e);
            } else {
                this.myInnerEdgesArray.add(e);
                int j = 0;
                while (j < e.getPointCount()) {
                    Point p = e.getPointAt(j);
                    p.setX(p.getX() - container1.getX());
                    p.setY(p.getY() - container1.getY());
                    ++j;
                }
                int j2 = 0;
                while (j2 < e.getIconCount()) {
                    Icon icon = e.getIconAt(j2);
                    icon.setX(icon.getX() - container1.getX());
                    icon.setY(icon.getY() - container1.getY());
                    ++j2;
                }
            }
            ++i3;
        }
        this.mySavedVerticesArray = this.myVerticesArray;
        this.mySavedEdgesArray = this.myEdgesArray;
        this.myVerticesArray = newVerticesArray;
        this.myEdgesArray = newEdgesArray;
    }

    private boolean restoreInnerNodes() {
        if (this.mySavedVerticesArray == null) {
            return false;
        }
        int i = 0;
        while (i < this.myReroutedEdgesArray.size()) {
            Vertex v2;
            Edge e = (Edge)this.myReroutedEdgesArray.get(i);
            Vertex v1 = (Vertex)this.myReroutedEdgeToSrcMap.get(e);
            if (v1 != null) {
                e.vertex1 = v1;
            }
            if ((v2 = (Vertex)this.myReroutedEdgeToDstMap.get(e)) != null) {
                e.vertex2 = v2;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.myInnerVerticesArray.size()) {
            Vertex v = (Vertex)this.myInnerVerticesArray.get(i2);
            Vertex container = Layouter.getTopContainingVertex(v);
            v.setX(v.getX() + container.getX());
            v.setY(v.getY() + container.getY());
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.myInnerEdgesArray.size()) {
            Edge e = (Edge)this.myInnerEdgesArray.get(i3);
            Vertex container = Layouter.getTopContainingVertex(e.vertex1);
            int j = 0;
            while (j < e.getPointCount()) {
                Point p = e.getPointAt(j);
                p.setX(p.getX() + container.getX());
                p.setY(p.getY() + container.getY());
                ++j;
            }
            int j2 = 0;
            while (j2 < e.getIconCount()) {
                Icon icon = e.getIconAt(j2);
                icon.setX(icon.getX() + container.getX());
                icon.setY(icon.getY() + container.getY());
                ++j2;
            }
            ++i3;
        }
        this.myVerticesArray = this.mySavedVerticesArray;
        this.myEdgesArray = this.mySavedEdgesArray;
        this.mySavedVerticesArray = null;
        this.mySavedEdgesArray = null;
        this.myInnerVerticesArray = null;
        this.myInnerEdgesArray = null;
        this.myReroutedEdgesArray = null;
        this.myReroutedEdgeToSrcMap = null;
        this.myReroutedEdgeToDstMap = null;
        return true;
    }

    private static Vertex getTopContainingVertex(Vertex v) {
        if (v.myContainingVertex == null) {
            return null;
        }
        do {
            v = v.myContainingVertex;
        } while (v.myContainingVertex != null);
        return v;
    }

    private void SyncBarsControl(Vector ar, boolean bVertical, boolean bResize) {
        int i = 0;
        while (i < ar.size()) {
            Vertex v = (Vertex)ar.get(i);
            Vertex lNode = v;
            if (!(lNode.getUserObject() instanceof Item)) {
                return;
            }
            Item item = (Item)lNode.getUserObject();
            if (Layouter.isSyncBar(lNode)) {
                if (bResize) {
                    int lastW = item.w();
                    int lastH = item.h();
                    if (lastH < lastW != bVertical) {
                        item.justResize(lastH, lastW);
                        lNode.setWidth(lastH);
                        lNode.setHeight(lastW);
                    }
                }
                v.myLongSideOnly = true;
            }
            ++i;
        }
    }

    private static boolean isSyncBar(LayoutNode lNode) {
        Element modelElement = Layouter.getModelElement(lNode);
        if (modelElement == null) {
            return false;
        }
        return modelElement.hasPropertyValue("$metaclass", "Synchronization Bar");
    }

    private static Element getModelElement(LayoutNode lNode) {
        if (lNode == null) {
            return null;
        }
        Object item = lNode.getUserObject();
        if (item instanceof IAdaptable) {
            return (Element)((IAdaptable)item).getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = Layouter.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

