/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Injection;
import com.tssap.selena.layout.impl.Optioner;
import java.util.Vector;

public final class InjectionsSolver {
    private Optioner myOptioner;
    private Vector myInjectionsArray = new Vector();
    private int size = -1;
    private int maxOutermostSpace = -1;
    private int[] minSpaces = null;
    private int[] minOffsets = null;
    private int[] maxOffsets = null;

    public InjectionsSolver(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public void resetInjections() {
        this.myInjectionsArray.clear();
    }

    public void setSize(int size) {
        this.size = size;
        this.maxOutermostSpace = size * this.myOptioner.nOutermostSpacePercents / 100;
    }

    public void setMaxOutermostSpace(int space) {
        this.maxOutermostSpace = space;
    }

    public void addInjection(Injection inj) {
        this.myInjectionsArray.add(inj);
    }

    public int getInjectionCount() {
        return this.myInjectionsArray.size();
    }

    public Injection getInjection(int i) {
        return (Injection)this.myInjectionsArray.get(i);
    }

    public void solve() {
        if (this.myInjectionsArray.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.myInjectionsArray.size()) {
            Injection inj = (Injection)this.myInjectionsArray.get(i);
            inj.minBound = Math.max(0, inj.minBound);
            inj.maxBound = Math.min(this.size, inj.maxBound);
            ++i;
        }
        this.orderInjections();
        this.calculateMinSpaces();
        this.validateMinSpaces();
        this.calculateMinAndMaxOffsets();
        this.useBestOffsets();
        this.useAttractors();
        this.useBounds();
    }

    private void orderInjections() {
        int i = 0;
        while (i < this.myInjectionsArray.size() - 1) {
            int j = i + 1;
            while (j < this.myInjectionsArray.size()) {
                Injection inj1 = (Injection)this.myInjectionsArray.get(i);
                Injection inj2 = (Injection)this.myInjectionsArray.get(j);
                if (!(inj1.offset != -1 && inj2.offset != -1 ? inj1.offset <= inj2.offset : inj1.bary1 < inj2.bary1 || inj1.bary1 == inj2.bary1 && inj1.bary2 <= inj2.bary2)) {
                    this.myInjectionsArray.set(i, inj2);
                    this.myInjectionsArray.set(j, inj1);
                }
                ++j;
            }
            ++i;
        }
    }

    private void calculateMinSpaces() {
        this.minSpaces = new int[this.myInjectionsArray.size() + 1];
        int i = 0;
        while (i < this.minSpaces.length) {
            int iconSpace;
            int space = 0;
            if (i == 0) {
                iconSpace = ((Injection)this.myInjectionsArray.get((int)0)).leftIconSpace;
                if (iconSpace >= 0) {
                    space = this.myOptioner.nIconsSpace + iconSpace;
                }
            } else if (i == this.minSpaces.length - 1) {
                iconSpace = ((Injection)this.myInjectionsArray.get((int)(i - 1))).rightIconSpace;
                if (iconSpace >= 0) {
                    space = this.myOptioner.nIconsSpace + iconSpace;
                }
            } else {
                int iconSpace1 = ((Injection)this.myInjectionsArray.get((int)(i - 1))).rightIconSpace;
                int iconSpace2 = ((Injection)this.myInjectionsArray.get((int)i)).leftIconSpace;
                if (iconSpace1 >= 0 || iconSpace2 >= 0) {
                    space = this.myOptioner.nIconsSpace;
                    if (iconSpace1 > 0) {
                        space += iconSpace1;
                    }
                    if (iconSpace2 > 0) {
                        space += iconSpace2;
                    }
                }
            }
            this.minSpaces[i] = space = Math.max(space, this.myOptioner.nLinesSpace);
            ++i;
        }
    }

    private void validateMinSpaces() {
        int lastFixed = -1;
        int i = 0;
        while (i < this.myInjectionsArray.size()) {
            Injection inj = (Injection)this.myInjectionsArray.get(i);
            if (inj.offset != -1) {
                this.validateMinSpaces(lastFixed, i);
                lastFixed = i;
            }
            ++i;
        }
        this.validateMinSpaces(lastFixed, this.myInjectionsArray.size());
    }

    /*
     * Unable to fully structure code
     */
    private void validateMinSpaces(int from, int to) {
        S = 0;
        i = from + 1;
        while (i < to + 1) {
            S += this.minSpaces[i];
            ++i;
        }
        left = from != -1 ? ((Injection)this.myInjectionsArray.get((int)from)).offset : 0;
        right = to != this.myInjectionsArray.size() ? ((Injection)this.myInjectionsArray.get((int)to)).offset : this.size;
        w = right - left;
        if (to - from != 1) ** GOTO lbl32
        this.minSpaces[from + 1] = w;
        return;
lbl-1000:
        // 1 sources

        {
            maxSpace = -2147483648;
            maxSpaceIndex = -1;
            prevMaxSpace = -2147483648;
            i = from + 1;
            while (i < to + 1) {
                space = this.minSpaces[i];
                if (space > prevMaxSpace) {
                    if (space >= maxSpace) {
                        prevMaxSpace = maxSpace;
                        maxSpace = space;
                        maxSpaceIndex = i;
                    } else {
                        prevMaxSpace = space;
                    }
                }
                ++i;
            }
            decrement = Math.min(S - w, maxSpace - prevMaxSpace + 1);
            v0 = maxSpaceIndex;
            this.minSpaces[v0] = this.minSpaces[v0] - decrement;
            S -= decrement;
lbl32:
            // 2 sources

            ** while (S > w)
        }
lbl33:
        // 1 sources

    }

    private void calculateMinAndMaxOffsets() {
        this.minOffsets = new int[this.myInjectionsArray.size()];
        int offset = 0;
        int i = 0;
        while (i < this.minOffsets.length) {
            this.minOffsets[i] = offset += this.minSpaces[i];
            ++i;
        }
        this.maxOffsets = new int[this.myInjectionsArray.size()];
        offset = this.size;
        int i2 = this.maxOffsets.length - 1;
        while (i2 >= 0) {
            this.maxOffsets[i2] = offset -= this.minSpaces[i2 + 1];
            --i2;
        }
        int i3 = 0;
        while (i3 < this.myInjectionsArray.size()) {
            Injection inj = (Injection)this.myInjectionsArray.get(i3);
            if (inj.offset != -1) {
                offset = inj.offset;
                inj.offset = -1;
                this.setInjection(i3, offset);
                if (inj.offset != offset) {
                    throw new RuntimeException("IJSL001");
                }
            }
            ++i3;
        }
    }

    private void useBestOffsets() {
        int i = 0;
        while (i < this.myInjectionsArray.size()) {
            Injection inj = (Injection)this.myInjectionsArray.get(i);
            int bestOffset = inj.bestOffset;
            if (this.isValidInjection(i, bestOffset)) {
                this.setInjection(i, bestOffset);
            }
            ++i;
        }
    }

    private void useAttractors() {
        this.useLeftAttractors();
        this.useRightAttractors();
        this.useAllAttractors();
    }

    private void useLeftAttractors() {
        int i = 0;
        while (i < this.myInjectionsArray.size()) {
            Injection inj = (Injection)this.myInjectionsArray.get(i);
            if (inj.offset == -1 && inj.attractorFlag && inj.attractorOffset < inj.minBound) {
                int left = inj.minBound;
                if (i != 0) {
                    int offset = ((Injection)this.myInjectionsArray.get((int)(i - 1))).offset;
                    left = Math.max(left, offset != -1 ? offset : this.minOffsets[i - 1]);
                }
                this.setInjection(i, left + this.calculateOutermostSpace(inj.maxBound - inj.minBound));
            }
            ++i;
        }
    }

    private void useRightAttractors() {
        int i = this.myInjectionsArray.size() - 1;
        while (i >= 0) {
            Injection inj = (Injection)this.myInjectionsArray.get(i);
            if (inj.offset == -1 && inj.attractorFlag && inj.attractorOffset >= inj.maxBound) {
                int right = inj.maxBound;
                if (i != this.myInjectionsArray.size() - 1) {
                    int offset = ((Injection)this.myInjectionsArray.get((int)(i + 1))).offset;
                    right = Math.min(right, offset != -1 ? offset : this.maxOffsets[i + 1]);
                }
                this.setInjection(i, right - this.calculateOutermostSpace(inj.maxBound - inj.minBound));
            }
            --i;
        }
    }

    private void useAllAttractors() {
        int i = 0;
        while (i < this.myInjectionsArray.size()) {
            Injection inj = (Injection)this.myInjectionsArray.get(i);
            if (inj.offset == -1 && inj.attractorFlag) {
                this.setInjection(i, inj.attractorOffset);
            }
            ++i;
        }
    }

    private void useBounds() {
        int i = 0;
        while (i < this.myInjectionsArray.size()) {
            Injection inj = (Injection)this.myInjectionsArray.get(i);
            if (inj.offset == -1) {
                this.useBounds(i, inj.minBound, inj.maxBound);
            }
            ++i;
        }
    }

    private void useBounds(int i, int minBound, int maxBound) {
        int left = i != 0 ? ((Injection)this.myInjectionsArray.get((int)(i - 1))).offset : 0;
        left = Math.max(left, minBound);
        int j = i + 1;
        while (j < this.myInjectionsArray.size()) {
            if (((Injection)this.myInjectionsArray.get((int)j)).offset != -1) break;
            ++j;
        }
        int right = j != this.myInjectionsArray.size() ? ((Injection)this.myInjectionsArray.get((int)j)).offset : this.size;
        right = Math.min(right, maxBound);
        int offset = left + (right - left) / (j - i + 1);
        offset = Math.max(offset, this.minOffsets[i]);
        offset = Math.min(offset, this.maxOffsets[i]);
        if (left <= offset && offset <= right) {
            this.setInjection(i, offset);
        } else {
            this.useBounds(i, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    private boolean isValidInjection(int i, int offset) {
        return this.minOffsets[i] <= offset && offset <= this.maxOffsets[i];
    }

    private void setInjection(int i, int offset) {
        int dec;
        offset = Math.max(offset, this.minOffsets[i]);
        int inc = (offset = Math.min(offset, this.maxOffsets[i])) - this.minOffsets[i];
        if (inc > 0) {
            int j = i;
            while (j < this.minOffsets.length) {
                if (((Injection)this.myInjectionsArray.get((int)j)).offset != -1) break;
                int n = j++;
                this.minOffsets[n] = this.minOffsets[n] + inc;
            }
        }
        if ((dec = this.maxOffsets[i] - offset) > 0) {
            int j = i;
            while (j >= 0) {
                if (((Injection)this.myInjectionsArray.get((int)j)).offset != -1) break;
                int n = j--;
                this.maxOffsets[n] = this.maxOffsets[n] - dec;
            }
        }
        ((Injection)this.myInjectionsArray.get((int)i)).offset = offset;
    }

    private int calculateOutermostSpace(int s) {
        int space = s * this.myOptioner.nOutermostSpacePercents / 100;
        space = Math.min(space, this.maxOutermostSpace);
        return space;
    }
}

