/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.ElementGroup;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import java.util.Vector;

public final class IconsPlacer {
    private Optioner myOptioner;
    private LinesManager myLinesManager;
    private boolean myTransponateFlag;
    private Edge edge;
    private int horPos;
    private int vertPos;
    private int n;
    private int[] distances = null;
    private int total;
    private int start;
    private int end;
    private int best;
    private static final int OK = 0;
    private static final int PAGING_CONFLICT = 1;
    private static final int CONFLICT = 2;
    private static final int STRONG_CONFLICT = 3;
    private static final int TOO_SHORT = 4;
    private Point myPoint = new Point(0, 0, null);
    private ElementGroup myGroup = new ElementGroup();

    public IconsPlacer(Optioner optioner, LinesManager linesManager, boolean transponate) {
        this.myOptioner = optioner;
        this.myLinesManager = linesManager;
        this.myTransponateFlag = transponate;
    }

    public void placeIcons(Edge[] edges) {
        this.placeIcons(edges, 1, 15);
        this.placeIcons(edges, 1, 10);
        this.placeIcons(edges, 1, 12);
        this.placeIcons(edges, 1, 11);
        this.placeIcons(edges, 1, 13);
        this.placeIcons(edges, 1, 14);
        this.placeIcons(edges, 2, 15);
        this.placeIcons(edges, 2, 10);
        this.placeIcons(edges, 2, 12);
        this.placeIcons(edges, 2, 11);
        this.placeIcons(edges, 2, 13);
        this.placeIcons(edges, 2, 14);
        this.placeIcons(edges, 3, 15);
        this.placeIcons(edges, 3, 10);
        this.placeIcons(edges, 3, 12);
        this.placeIcons(edges, 3, 11);
        this.placeIcons(edges, 3, 13);
        this.placeIcons(edges, 3, 14);
    }

    public void placeIcons(Vector edgesArray) {
        this.placeIcons(edgesArray, 1, 15);
        this.placeIcons(edgesArray, 1, 10);
        this.placeIcons(edgesArray, 1, 12);
        this.placeIcons(edgesArray, 1, 11);
        this.placeIcons(edgesArray, 1, 13);
        this.placeIcons(edgesArray, 1, 14);
        this.placeIcons(edgesArray, 2, 15);
        this.placeIcons(edgesArray, 2, 10);
        this.placeIcons(edgesArray, 2, 12);
        this.placeIcons(edgesArray, 2, 11);
        this.placeIcons(edgesArray, 2, 13);
        this.placeIcons(edgesArray, 2, 14);
        this.placeIcons(edgesArray, 3, 15);
        this.placeIcons(edgesArray, 3, 10);
        this.placeIcons(edgesArray, 3, 12);
        this.placeIcons(edgesArray, 3, 11);
        this.placeIcons(edgesArray, 3, 13);
        this.placeIcons(edgesArray, 3, 14);
    }

    private void placeIcons(Edge[] edges, int horPos, int vertPos) {
        int i_Edge = 0;
        while (i_Edge < edges.length) {
            this.edge = edges[i_Edge];
            this.horPos = horPos;
            this.vertPos = vertPos;
            this.placeIcons();
            ++i_Edge;
        }
    }

    private void placeIcons(Vector edgesArray, int horPos, int vertPos) {
        int i_Edge = 0;
        while (i_Edge < edgesArray.size()) {
            this.edge = (Edge)edgesArray.get(i_Edge);
            this.horPos = horPos;
            this.vertPos = vertPos;
            this.placeIcons();
            ++i_Edge;
        }
    }

    private void placeIcons() {
        Icon icon;
        int i_Icon;
        int nIcons = this.edge.getIconCount();
        if (nIcons == 0) {
            return;
        }
        if (this.horPos == 3 && this.vertPos != 15 && this.edge.getIconCount() > 1) {
            this.myGroup.resetElements();
            i_Icon = 0;
            while (i_Icon < this.edge.getIconCount()) {
                icon = this.edge.getIconAt(i_Icon);
                if (!icon.isProcessed() && icon.getHorPos() == this.horPos && icon.getVertPos() == this.vertPos && icon.isGrouped()) {
                    this.myGroup.addElement(icon);
                }
                ++i_Icon;
            }
            if (this.myGroup.getElementCount() > 1) {
                this.place(this.myGroup);
                int i = 0;
                while (i < this.myGroup.getElementCount()) {
                    Icon icon2 = (Icon)this.myGroup.getElement(i);
                    icon2.process();
                    if (!this.myOptioner.stupidIcons) {
                        this.myLinesManager.add(icon2);
                    }
                    ++i;
                }
                return;
            }
        }
        i_Icon = 0;
        while (i_Icon < this.edge.getIconCount()) {
            icon = this.edge.getIconAt(i_Icon);
            if (!icon.isProcessed() && icon.getHorPos() == this.horPos && icon.getVertPos() == this.vertPos) {
                this.place(icon);
                icon.process();
                if (!this.myOptioner.stupidIcons) {
                    this.myLinesManager.add(icon);
                }
            }
            ++i_Icon;
        }
    }

    private void place(Element elem) {
        this.n = this.edge.getPointCount();
        if (this.horPos != 3) {
            this.placeNotMediumPos(elem);
        } else if (!this.edge.isGroupable()) {
            this.placeMediumPos(elem);
        } else {
            this.placeSpecialPos(elem);
        }
    }

    private void placeNotMediumPos(Element elem) {
        Icon lastIcon2;
        Icon lastIcon1;
        Vertex v;
        Point p2;
        Point p1;
        Icon icon;
        block90: {
            int where;
            icon = (Icon)elem;
            int segment = icon.getSegment();
            if (this.horPos == 1) {
                if (segment != -1 && segment != 0) {
                    throw new RuntimeException("ICPL001");
                }
                p1 = this.edge.getPointAt(0);
                p2 = this.edge.getPointAt(1);
                v = this.edge.vertex1;
                icon.setSegment(0);
            } else {
                if (segment != -1 && segment != this.n - 2) {
                    throw new RuntimeException("ICPL002");
                }
                p1 = this.edge.getPointAt(this.n - 1);
                p2 = this.edge.getPointAt(this.n - 2);
                v = this.edge.vertex2;
                icon.setSegment(this.n - 2);
            }
            lastIcon1 = null;
            int i_Icon = this.edge.getIconCount() - 1;
            while (i_Icon >= 0) {
                Icon icon1 = this.edge.getIconAt(i_Icon);
                if (icon1.isProcessed() && icon1.getHorPos() == this.horPos && icon1.getVertPos() == this.vertPos) {
                    lastIcon1 = icon1;
                    break;
                }
                --i_Icon;
            }
            lastIcon2 = null;
            if (this.vertPos != 15) {
                int i_Icon2 = this.edge.getIconCount() - 1;
                while (i_Icon2 >= 0) {
                    Icon icon1 = this.edge.getIconAt(i_Icon2);
                    if (icon1.isProcessed() && icon1.getHorPos() == this.horPos && icon1.getVertPos() == 15) {
                        lastIcon2 = icon1;
                        break;
                    }
                    --i_Icon2;
                }
            }
            if (this.myTransponateFlag && (lastIcon1 != null || lastIcon2 != null)) {
                icon.transponate();
                if (lastIcon1 != null) {
                    lastIcon1.transponate();
                }
                if (lastIcon2 != null) {
                    lastIcon2.transponate();
                }
                p1.transponate();
                p2.transponate();
                v.transponate();
            }
            icon.setSinCosForLine(p1, p2);
            int x = p1.x;
            int y = p1.y;
            int x1 = p2.x;
            int y1 = p2.y;
            int inject = -1;
            if (x == v.getLeft() || x == v.getRight()) {
                inject = x1 < x ? 1 : 2;
            } else if (y == v.getTop() || y == v.getBottom()) {
                inject = y1 < y ? 3 : 4;
            } else {
                icon.setX((p1.x + p2.x) / 2);
                icon.setY((p1.y + p2.y) / 2);
                return;
            }
            boolean On = false;
            boolean Left = true;
            int Right = 2;
            int Above = 3;
            int Under = 4;
            switch (this.vertPos) {
                case 15: {
                    where = 0;
                    break;
                }
                case 10: {
                    if (inject == 1 || inject == 2) {
                        where = 3;
                        break;
                    }
                    where = 1;
                    break;
                }
                case 12: {
                    if (inject == 1 || inject == 2) {
                        where = 3;
                        break;
                    }
                    where = 2;
                    break;
                }
                case 11: {
                    if (inject == 1 || inject == 2) {
                        where = 4;
                        break;
                    }
                    where = 1;
                    break;
                }
                case 13: {
                    if (inject == 1 || inject == 2) {
                        where = 4;
                        break;
                    }
                    where = 2;
                    break;
                }
                default: {
                    throw new RuntimeException("ICPL003");
                }
            }
            block7 : switch (where) {
                case 0: {
                    if (icon.isDirected()) {
                        icon.setLeftCenterAt(x, y);
                        break;
                    }
                    switch (inject) {
                        case 1: {
                            icon.setRightCenterAt(x, y);
                            break;
                        }
                        case 2: {
                            icon.setLeftCenterAt(x, y);
                            break;
                        }
                        case 3: {
                            icon.setCenterBottomAt(x, y);
                            break;
                        }
                        case 4: {
                            icon.setCenterTopAt(x, y);
                        }
                    }
                    break;
                }
                case 3: {
                    if (icon.isDirected()) {
                        this.placeOrientedLabel(icon, x, y, 3, lastIcon1, lastIcon2);
                        break;
                    }
                    int yy = y;
                    if (y1 < y && x != x1) {
                        yy += icon.getWidth() * (y1 - y) / Math.abs(x - x1);
                        yy = Math.max(yy, v.getTop() - this.myOptioner.nRectanglesSpace);
                    }
                    if (lastIcon1 != null) {
                        yy = Math.min(yy, lastIcon1.getTop() + lastIcon1.getIconsDistCorrection() + icon.getIconsDistCorrection());
                    }
                    if (lastIcon2 != null) {
                        yy = Math.min(yy, lastIcon2.getTop() + lastIcon2.getIconsDistCorrection() + icon.getIconsDistCorrection());
                    }
                    if (inject == 1) {
                        icon.setRightBottomAt(x, yy);
                    } else {
                        icon.setLeftBottomAt(x, yy);
                    }
                    if (y == y1 || yy > v.getTop() - this.myOptioner.nRectanglesSpace) break;
                    int oldx = icon.getX();
                    if (inject == 1) {
                        icon.setLeftAt(x, y, x1, y1);
                        if (icon.getX() >= oldx) break;
                        icon.setX(oldx);
                        break;
                    }
                    icon.setRightAt(x, y, x1, y1);
                    if (icon.getX() <= oldx) break;
                    icon.setX(oldx);
                    break;
                }
                case 4: {
                    if (icon.isDirected()) {
                        this.placeOrientedLabel(icon, x, y, 4, lastIcon1, lastIcon2);
                        break;
                    }
                    int yy = y;
                    if (y1 > y && x != x1) {
                        yy += icon.getWidth() * (y1 - y) / Math.abs(x - x1);
                        yy = Math.min(yy, v.getBottom() + this.myOptioner.nRectanglesSpace);
                    }
                    if (lastIcon1 != null) {
                        yy = Math.max(yy, lastIcon1.getBottom() - lastIcon1.getIconsDistCorrection() - icon.getIconsDistCorrection());
                    }
                    if (lastIcon2 != null) {
                        yy = Math.max(yy, lastIcon2.getBottom() - lastIcon2.getIconsDistCorrection() - icon.getIconsDistCorrection());
                    }
                    if (inject == 1) {
                        icon.setRightTopAt(x, yy);
                    } else {
                        icon.setLeftTopAt(x, yy);
                    }
                    if (y == y1 || yy < v.getBottom() + this.myOptioner.nRectanglesSpace) break;
                    int oldx = icon.getX();
                    if (inject == 1) {
                        icon.setLeftAt(x, y, x1, y1);
                        if (icon.getX() >= oldx) break;
                        icon.setX(oldx);
                        break;
                    }
                    icon.setRightAt(x, y, x1, y1);
                    if (icon.getX() < oldx) break;
                    icon.setX(oldx);
                    break;
                }
                case 1: {
                    if (icon.isDirected()) {
                        this.placeOrientedLabel(icon, x, y, 1, lastIcon1, lastIcon2);
                        break;
                    }
                    switch (inject) {
                        case 3: {
                            int yy = y;
                            if (lastIcon1 != null) {
                                yy = Math.min(yy, lastIcon1.getTop() + lastIcon1.getIconsDistCorrection() + icon.getIconsDistCorrection());
                            }
                            int xx = x;
                            if (lastIcon2 != null) {
                                xx = Math.min(xx, lastIcon2.getLeft() + lastIcon2.getIconsDistCorrection() + icon.getIconsDistCorrection());
                            }
                            icon.setRightBottomAt(xx, yy);
                            if (x != x1 && y != y1) {
                                int d;
                                int oldx = icon.getX();
                                icon.setRightAt(x, y, x1, y1);
                                if (icon.getX() > oldx) {
                                    icon.setX(oldx);
                                }
                                int bound = v.getLeft() - this.myOptioner.nRectanglesSpace;
                                if (lastIcon1 != null) {
                                    bound = lastIcon1.getLeft() + lastIcon1.getIconsDistCorrection() + icon.getIconsDistCorrection() - this.myOptioner.nIconsSpace;
                                }
                                if ((d = bound - icon.getRight()) <= 0) break block7;
                                icon.shift(d, 0);
                                icon.setTopAt(x, y, x1, y1);
                                break;
                            }
                            break block90;
                        }
                        case 4: {
                            int yy = y;
                            if (lastIcon1 != null) {
                                yy = Math.max(yy, lastIcon1.getBottom() - lastIcon1.getIconsDistCorrection() - icon.getIconsDistCorrection());
                            }
                            int xx = x;
                            if (lastIcon2 != null) {
                                xx = Math.min(xx, lastIcon2.getLeft() + lastIcon2.getIconsDistCorrection() + icon.getIconsDistCorrection());
                            }
                            icon.setRightTopAt(xx, yy);
                            if (x != x1 && y != y1) {
                                int d;
                                int oldx = icon.getX();
                                icon.setRightAt(x, y, x1, y1);
                                if (icon.getX() > oldx) {
                                    icon.setX(oldx);
                                }
                                int bound = v.getLeft() - this.myOptioner.nRectanglesSpace;
                                if (lastIcon1 != null) {
                                    bound = lastIcon1.getLeft() + lastIcon1.getIconsDistCorrection() + icon.getIconsDistCorrection() - this.myOptioner.nIconsSpace;
                                }
                                if ((d = bound - icon.getRight()) > 0) {
                                    icon.shift(d, 0);
                                    icon.setBottomAt(x, y, x1, y1);
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    if (icon.isDirected()) {
                        this.placeOrientedLabel(icon, x, y, 2, lastIcon1, lastIcon2);
                        break;
                    }
                    switch (inject) {
                        case 3: {
                            int yy = y;
                            if (lastIcon1 != null) {
                                yy = Math.min(yy, lastIcon1.getTop() + lastIcon1.getIconsDistCorrection() + icon.getIconsDistCorrection());
                            }
                            int xx = x;
                            if (lastIcon2 != null) {
                                xx = Math.max(xx, lastIcon2.getRight() - lastIcon2.getIconsDistCorrection() - icon.getIconsDistCorrection());
                            }
                            icon.setLeftBottomAt(xx, yy);
                            if (x != x1 && y != y1) {
                                int d;
                                int oldx = icon.getX();
                                icon.setLeftAt(x, y, x1, y1);
                                if (icon.getX() < oldx) {
                                    icon.setX(oldx);
                                }
                                int bound = v.getRight() + this.myOptioner.nRectanglesSpace;
                                if (lastIcon1 != null) {
                                    bound = lastIcon1.getRight() - lastIcon1.getIconsDistCorrection() - icon.getIconsDistCorrection() + this.myOptioner.nIconsSpace;
                                }
                                if ((d = bound - icon.getLeft()) >= 0) break block7;
                                icon.shift(d, 0);
                                icon.setTopAt(x, y, x1, y1);
                                break;
                            }
                            break block90;
                        }
                        case 4: {
                            int yy = y;
                            if (lastIcon1 != null) {
                                yy = Math.max(yy, lastIcon1.getBottom() - lastIcon1.getIconsDistCorrection() - icon.getIconsDistCorrection());
                            }
                            int xx = x;
                            if (lastIcon2 != null) {
                                xx = Math.max(xx, lastIcon2.getRight() - lastIcon2.getIconsDistCorrection() - icon.getIconsDistCorrection());
                            }
                            icon.setLeftTopAt(xx, yy);
                            if (x != x1 && y != y1) {
                                int d;
                                int oldx = icon.getX();
                                icon.setLeftAt(x, y, x1, y1);
                                if (icon.getX() < oldx) {
                                    icon.setX(oldx);
                                }
                                int bound = v.getRight() + this.myOptioner.nRectanglesSpace;
                                if (lastIcon1 != null) {
                                    bound = lastIcon1.getRight() - lastIcon1.getIconsDistCorrection() - icon.getIconsDistCorrection() + this.myOptioner.nIconsSpace;
                                }
                                if ((d = bound - icon.getLeft()) < 0) {
                                    icon.shift(d, 0);
                                    icon.setBottomAt(x, y, x1, y1);
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("ICPL004");
                }
            }
        }
        if (this.myTransponateFlag && (lastIcon1 != null || lastIcon2 != null)) {
            icon.transponate();
            if (lastIcon1 != null) {
                lastIcon1.transponate();
            }
            if (lastIcon2 != null) {
                lastIcon2.transponate();
            }
            p1.transponate();
            p2.transponate();
            v.transponate();
        }
    }

    private void placeMediumPos(Element elem) {
        if (elem instanceof Icon) {
            this.placeMediumPos(elem, false);
            return;
        }
        int state1 = this.placeMediumPos(elem, true);
        if (state1 == 0) {
            return;
        }
        int state2 = this.placeMediumPos(elem, false);
        if (state2 < state1) {
            return;
        }
        this.placeMediumPos(elem, true);
    }

    private int placeMediumPos(Element elem, boolean adjust) {
        this.distances = new int[this.n];
        this.distances[0] = 0;
        int i_Point = 0;
        while (i_Point < this.n - 1) {
            Point p1 = this.edge.getPointAt(i_Point);
            Point p2 = this.edge.getPointAt(i_Point + 1);
            int dx = p2.x - p1.x;
            int dy = p2.y - p1.y;
            int d = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
            this.distances[i_Point + 1] = this.distances[i_Point] + d;
            ++i_Point;
        }
        this.total = this.distances[this.n - 1];
        this.start = Math.min(Math.max(this.total / 10, 10), this.total / 3);
        this.end = this.total - this.start;
        this.best = this.total / 2;
        boolean[] checked = new boolean[this.n - 1];
        int i = 0;
        while (i < this.n - 1) {
            checked[i] = false;
            ++i;
        }
        int counter = this.n - 1;
        int bestState = Integer.MAX_VALUE;
        int bestStateSeg = -1;
        int bestStateVariant = 0;
        while (counter > 0) {
            int bestSeg = -1;
            int bestVal = Integer.MAX_VALUE;
            int i2 = 0;
            while (i2 < this.n - 1) {
                if (!checked[i2]) {
                    int val = 0;
                    if (this.best < this.distances[i2]) {
                        val = this.distances[i2] - this.best;
                    } else if (this.best > this.distances[i2 + 1]) {
                        val = this.best - this.distances[i2 + 1];
                    }
                    if (val < bestVal) {
                        bestVal = val;
                        bestSeg = i2;
                    }
                }
                ++i2;
            }
            if (bestSeg == -1) {
                throw new RuntimeException("ICPL005");
            }
            int variant = 0;
            while (variant < (this.vertPos == 14 ? 2 : 1)) {
                int state = this.placeMediumOnSeg(elem, bestSeg, adjust, variant);
                if (state == 0) {
                    return 0;
                }
                if (state < bestState) {
                    bestState = state;
                    bestStateSeg = bestSeg;
                    bestStateVariant = variant;
                }
                ++variant;
            }
            checked[bestSeg] = true;
            --counter;
        }
        return this.placeMediumOnSeg(elem, bestStateSeg, adjust, bestStateVariant);
    }

    /*
     * Unable to fully structure code
     */
    private int placeMediumOnSeg(Element elem, int seg, boolean adjust, int variant) {
        block7: {
            block8: {
                block6: {
                    if (!(elem instanceof Icon)) break block6;
                    this.placeMediumOnSegStupid((Icon)elem, seg, variant);
                    break block7;
                }
                p1 = this.edge.getPointAt(seg + 1);
                p2 = this.edge.getPointAt(seg);
                dx = p2.x - p1.x;
                dy = p2.y - p1.y;
                if (dx == 0) {
                    adjust = true;
                }
                if (dy == 0) {
                    adjust = false;
                }
                group = (ElementGroup)elem;
                if (!adjust) break block8;
                h = 0;
                i = 0;
                while (i < group.getElementCount()) {
                    icon = (Icon)group.getElement(i);
                    this.placeMediumOnSegStupid(icon, seg, variant);
                    shifty = h;
                    shiftx = shifty * dx / dy;
                    icon.shift(shiftx, shifty);
                    h += icon.getHeight() - icon.getIconsDistCorrection();
                    ++i;
                }
                break block7;
            }
            inverse = this.vertPos == 10 || this.vertPos == 12 || this.vertPos == 14 && variant == 0;
            i = inverse != false ? group.getElementCount() - 1 : 0;
            icon0 = (Icon)group.getElement(i);
            this.placeMediumOnSegStupid(icon0, seg, variant);
            prev = icon0;
            if (true) ** GOTO lbl46
            do {
                i = inverse ? --i : ++i;
                icon = (Icon)group.getElement(i);
                shifty = inverse != false ? -icon.getHeight() + icon.getIconsDistCorrection() : prev.getHeight() - icon.getIconsDistCorrection();
                icon.setX(prev.getX());
                icon.setY(prev.getY() + shifty);
                icon.setSin(prev.getSin());
                icon.setCos(prev.getCos());
                icon.setInnerVector((Point)((Point)prev.getInnerVector()).clone());
                icon.setBasePoint(null);
                icon.setSegment(seg);
                prev = icon;
lbl46:
                // 2 sources

                if (inverse) {
                    if (i > 0) {
                        v0 = true;
                        continue;
                    }
                    v0 = false;
                    continue;
                }
                v0 = i < group.getElementCount() - 1;
            } while (v0);
        }
        return this.tryMoveAlongSegment(elem, seg);
    }

    private void placeMediumOnSegStupid(Icon icon, int seg, int variant) {
        boolean above;
        Point p1 = this.edge.getPointAt(seg + 1);
        Point p2 = this.edge.getPointAt(seg);
        icon.setSinCosForLine(p1, p2);
        this.myPoint.set((p1.x + p2.x) / 2, (p1.y + p2.y) / 2, null);
        icon.setBasePoint((Point)this.myPoint.clone());
        icon.setSegment(seg);
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        boolean left = this.vertPos == 10 || this.vertPos == 11 || this.vertPos == 14 && variant == 1;
        boolean bl = above = this.vertPos == 10 || this.vertPos == 12 || this.vertPos == 14 && variant == 0;
        if (this.vertPos == 15) {
            icon.setCenterAt(this.myPoint.x, this.myPoint.y);
            icon.setInnerVector(0, 0);
        } else if (!icon.isDirected()) {
            if (dy == 0) {
                if (above) {
                    icon.setCenterBottomAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(0, -1);
                } else {
                    icon.setCenterTopAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(0, 1);
                }
            } else if (dx == 0) {
                if (left) {
                    icon.setRightCenterAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(-1, 0);
                } else {
                    icon.setLeftCenterAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(1, 0);
                }
            } else if (dx * dy > 0) {
                boolean f;
                boolean bl2 = Math.abs(dx) > Math.abs(dy) ? above : (f = !left);
                if (f) {
                    icon.setLeftBottomAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(1, -1);
                } else {
                    icon.setRightTopAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(-1, 1);
                }
            } else {
                boolean f;
                boolean bl3 = f = Math.abs(dx) > Math.abs(dy) ? above : left;
                if (f) {
                    icon.setRightBottomAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(-1, -1);
                } else {
                    icon.setLeftTopAt(this.myPoint.x, this.myPoint.y);
                    icon.setInnerVector(1, 1);
                }
            }
        } else {
            switch (this.vertPos) {
                case 10: 
                case 12: {
                    if (icon.isDirected()) {
                        if (icon.getCos() >= icon.getSin()) {
                            icon.setCenterBottomAt(this.myPoint.x, this.myPoint.y);
                            break;
                        }
                        icon.setCenterTopAt(this.myPoint.x, this.myPoint.y);
                        break;
                    }
                }
                case 13: {
                    if (icon.isDirected()) {
                        if (icon.getCos() >= icon.getSin()) {
                            icon.setCenterTopAt(this.myPoint.x, this.myPoint.y);
                            break;
                        }
                        icon.setCenterBottomAt(this.myPoint.x, this.myPoint.y);
                        break;
                    }
                }
                default: {
                    if (!icon.isDirected()) break;
                    if (icon.getCos() >= icon.getSin()) {
                        icon.setCenterBottomAt(this.myPoint.x, this.myPoint.y);
                        break;
                    }
                    icon.setCenterTopAt(this.myPoint.x, this.myPoint.y);
                }
            }
        }
    }

    private int tryMoveAlongSegment(Element elem, int seg) {
        if (this.myOptioner.stupidIcons) {
            return 0;
        }
        Point p1 = this.edge.getPointAt(seg + 1);
        Point p2 = this.edge.getPointAt(seg);
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        int shiftX1 = 0;
        int shiftY1 = 0;
        int shiftX2 = 0;
        int shiftY2 = 0;
        int shiftX = 0;
        int shiftY = 0;
        if (elem instanceof Icon) {
            Point p = (Point)((Icon)elem).getBasePoint();
            shiftX1 = p1.x - p.x;
            shiftY1 = p1.y - p.y;
            shiftX2 = p2.x - p.x;
            shiftY2 = p2.y - p.y;
            shiftX = (shiftX1 + shiftX2) / 2;
            shiftY = (shiftY1 + shiftY2) / 2;
        } else if (elem instanceof ElementGroup) {
            ElementGroup group = (ElementGroup)elem;
            if (dx > 0) {
                shiftX1 = Integer.MIN_VALUE;
                shiftX2 = Integer.MAX_VALUE;
            } else if (dx < 0) {
                shiftX1 = Integer.MAX_VALUE;
                shiftX2 = Integer.MIN_VALUE;
            }
            if (dy > 0) {
                shiftY1 = Integer.MIN_VALUE;
                shiftY2 = Integer.MAX_VALUE;
            } else if (dy < 0) {
                shiftY1 = Integer.MAX_VALUE;
                shiftY2 = Integer.MIN_VALUE;
            }
            int i = 0;
            while (i < group.getElementCount()) {
                Icon icon = (Icon)group.getElement(i);
                Point p = (Point)icon.getBasePoint();
                if (p != null) {
                    int dx1 = p1.x - p.x;
                    int dy1 = p1.y - p.y;
                    int dx2 = p2.x - p.x;
                    int dy2 = p2.y - p.y;
                    if (dx > 0) {
                        shiftX1 = Math.max(shiftX1, dx1);
                        shiftX2 = Math.min(shiftX2, dx2);
                    } else if (dx < 0) {
                        shiftX1 = Math.min(shiftX1, dx1);
                        shiftX2 = Math.max(shiftX2, dx2);
                    }
                    if (dy > 0) {
                        shiftY1 = Math.max(shiftY1, dy1);
                        shiftY2 = Math.min(shiftY2, dy2);
                    } else if (dy < 0) {
                        shiftY1 = Math.min(shiftY1, dy1);
                        shiftY2 = Math.max(shiftY2, dy2);
                    }
                }
                ++i;
            }
            shiftX = (shiftX1 + shiftX2) / 2;
            shiftY = (shiftY1 + shiftY2) / 2;
        }
        if ((shiftX2 - shiftX1) * dx < 0 || (shiftY2 - shiftY1) * dy < 0) {
            return 4;
        }
        elem.shift(shiftX, shiftY);
        shiftX1 -= shiftX;
        shiftY1 -= shiftY;
        shiftX2 -= shiftX;
        shiftY2 -= shiftY;
        boolean edgesIgnored = false;
        boolean pagingIgnored = false;
        if (!this.myLinesManager.isCorrect(elem) || this.isTherePagingConflict(elem)) {
            double t1 = this.tryToShift(elem, shiftX1, shiftY1, edgesIgnored, pagingIgnored);
            double t2 = this.tryToShift(elem, shiftX2, shiftY2, edgesIgnored, pagingIgnored);
            if (t1 > 1.0 && t2 > 1.0) {
                if (this.myOptioner.pagingFlag) {
                    pagingIgnored = true;
                    t1 = this.tryToShift(elem, shiftX1, shiftY1, edgesIgnored, pagingIgnored);
                    t2 = this.tryToShift(elem, shiftX2, shiftY2, edgesIgnored, pagingIgnored);
                }
                if (t1 > 1.0 && t2 > 1.0) {
                    edgesIgnored = true;
                    t1 = this.tryToShift(elem, shiftX1, shiftY1, edgesIgnored, pagingIgnored);
                    t2 = this.tryToShift(elem, shiftX2, shiftY2, edgesIgnored, pagingIgnored);
                    if (t1 > 1.0 && t2 > 1.0) {
                        return 3;
                    }
                }
            }
            int c = 0;
            if (t1 > 1.0) {
                c = 2;
            } else if (t2 > 1.0) {
                c = 1;
            } else {
                int dy2;
                int dx2;
                int d2;
                int dy1;
                int dx1 = (int)Math.round((double)shiftX1 * t1);
                int d1 = dx1 * dx1 + (dy1 = (int)Math.round((double)shiftY1 * t1)) * dy1;
                int n = c = d1 > (d2 = (dx2 = (int)Math.round((double)shiftX2 * t2)) * dx2 + (dy2 = (int)Math.round((double)shiftY2 * t2)) * dy2) ? 2 : 1;
            }
            if (c == 1) {
                dx = (int)Math.round((double)shiftX1 * t1);
                dy = (int)Math.round((double)shiftY1 * t1);
            } else {
                dx = (int)Math.round((double)shiftX2 * t2);
                dy = (int)Math.round((double)shiftY2 * t2);
            }
            elem.shift(dx, dy);
        }
        if (edgesIgnored) {
            return 2;
        }
        if (pagingIgnored) {
            return 1;
        }
        return 0;
    }

    private double tryToShift(Element elem, int maxShiftX, int maxShiftY, boolean ignoreEdges, boolean ignorePaging) {
        if (maxShiftX == 0 && maxShiftY == 0) {
            return 2.0;
        }
        int flags = this.myLinesManager.getFlags();
        if (ignoreEdges) {
            this.myLinesManager.setFlags(flags | 0x80 | 8);
        }
        double d = Math.sqrt(maxShiftX * maxShiftX + maxShiftY * maxShiftY);
        double step = (double)this.myOptioner.nIconsShiftStep / d;
        int dx = 0;
        int dy = 0;
        int oldDx = 0;
        int oldDy = 0;
        double t = step;
        while (t <= 1.0) {
            dx = (int)Math.round((double)maxShiftX * t);
            dy = (int)Math.round((double)maxShiftY * t);
            elem.shift(dx - oldDx, dy - oldDy);
            oldDx = dx;
            oldDy = dy;
            if (this.myLinesManager.isCorrect(elem) && (!this.myOptioner.pagingFlag || ignorePaging || !this.isTherePagingConflict(elem))) break;
            t += step;
        }
        elem.shift(-dx, -dy);
        this.myLinesManager.setFlags(flags);
        return t;
    }

    private boolean isTherePagingConflict(Element elem) {
        if (this.myOptioner.pagingFlag) {
            int bottom;
            int right;
            int left = elem.getLeft();
            if (left / this.myOptioner.pageWidth != (right = elem.getRight()) / this.myOptioner.pageWidth) {
                return true;
            }
            int top = elem.getTop();
            if (top / this.myOptioner.pageHeight != (bottom = elem.getBottom()) / this.myOptioner.pageHeight) {
                return true;
            }
        }
        return false;
    }

    private void placeSpecialPos(Element elem) {
        Icon icon = (Icon)elem;
        int seg = this.n - 2;
        icon.setSegment(seg);
        Point p1 = this.edge.getPointAt(seg + 1);
        Point p2 = this.edge.getPointAt(seg);
        icon.setSinCosForLine(p1, p2);
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        this.myPoint.set(p2.x, p2.y, null);
        EdgesGroup group = this.edge.myGroup;
        int count = 0;
        if (group != null) {
            Edge[] edges = group.myEdges;
            int i = 0;
            while (i < edges.length) {
                Edge e = edges[i];
                Point point1 = e.getPointAt(e.getPointCount() - 1);
                Point point2 = e.getPointAt(e.getPointCount() - 2);
                if (point1.x == p1.x && point1.y == p1.y) {
                    int dx1 = point2.x - point1.x;
                    int dy1 = point2.y - point1.y;
                    if (dx == 0) {
                        if (dy > 0) {
                            if (dx1 == 0 && dy1 > 0) {
                                this.myPoint.y = Math.min(this.myPoint.y, point2.y);
                                ++count;
                            }
                        } else if (dx1 == 0 && dy1 < 0) {
                            this.myPoint.y = Math.max(this.myPoint.y, point2.y);
                            ++count;
                        }
                    } else if (dy == 0) {
                        if (dx > 0) {
                            if (dy1 == 0 && dx1 > 0) {
                                this.myPoint.x = Math.min(this.myPoint.x, point2.x);
                                ++count;
                            }
                        } else if (dy1 == 0 && dx1 < 0) {
                            this.myPoint.x = Math.max(this.myPoint.x, point2.x);
                            ++count;
                        }
                    } else {
                        throw new RuntimeException("ICPL006");
                    }
                }
                ++i;
            }
        }
        if (this.n == 2 && count <= 1) {
            this.placeMediumPos(icon);
            return;
        }
        switch (this.vertPos) {
            case 15: {
                icon.setRightCenterAt(this.myPoint.x, this.myPoint.y);
                break;
            }
            case 10: {
                if (icon.isDirected()) {
                    if (icon.getCos() >= icon.getSin()) {
                        icon.setCenterBottomAt(this.myPoint.x, this.myPoint.y);
                        break;
                    }
                    icon.setCenterTopAt(this.myPoint.x, this.myPoint.y);
                    break;
                }
                if (dy == 0) {
                    icon.setCenterBottomAt(this.myPoint.x, this.myPoint.y);
                    break;
                }
                if (dx == 0) {
                    icon.setRightCenterAt(this.myPoint.x, this.myPoint.y);
                    break;
                }
                throw new RuntimeException("ICPL007");
            }
            case 13: {
                if (icon.isDirected()) {
                    if (icon.getCos() >= icon.getSin()) {
                        icon.setCenterTopAt(this.myPoint.x, this.myPoint.y);
                        break;
                    }
                    icon.setCenterBottomAt(this.myPoint.x, this.myPoint.y);
                    break;
                }
                if (dy == 0) {
                    icon.setCenterTopAt(this.myPoint.x, this.myPoint.y);
                    break;
                }
                if (dx == 0) {
                    icon.setLeftCenterAt(this.myPoint.x, this.myPoint.y);
                    break;
                }
                throw new RuntimeException("ICPL008");
            }
            default: {
                throw new RuntimeException("ICPL009");
            }
        }
    }

    private void placeOrientedLabel(Icon icon, int x, int y, int position, Icon sameIcon, Icon onposIcon) {
        int AUXMARGIN = 5;
        int dX = 0;
        int dY = 0;
        switch (position) {
            case 1: {
                if (icon.getSin() != 0.0f) {
                    dX -= Math.round((float)(icon.getHeight() + 5) / Math.abs(icon.getSin()) / 2.0f);
                }
                if (sameIcon != null && sameIcon.getSin() != 0.0f) {
                    dX -= Math.round((float)sameIcon.getHeight() / Math.abs(sameIcon.getSin()) / 2.0f);
                }
                icon.setLeftCenterAt(x + (dX -= Math.round(5.0f * icon.getCos())), y + (dY += Math.round(5.0f * icon.getSin())));
                break;
            }
            case 2: {
                if (icon.getSin() != 0.0f) {
                    dX += Math.round((float)(icon.getHeight() + 5) / Math.abs(icon.getSin()) / 2.0f);
                }
                if (sameIcon != null && sameIcon.getSin() != 0.0f) {
                    dX += Math.round((float)sameIcon.getHeight() / Math.abs(sameIcon.getSin()) / 2.0f);
                }
                icon.setLeftCenterAt(x + (dX += Math.round(5.0f * icon.getCos())), y + (dY += Math.round(5.0f * icon.getSin())));
                break;
            }
            case 3: {
                if (icon.getCos() != 0.0f) {
                    dY -= Math.round((float)icon.getHeight() / Math.abs(icon.getCos()));
                }
                if (sameIcon != null && sameIcon.getCos() != 0.0f) {
                    dY -= Math.round((float)(sameIcon.getHeight() + 5) / Math.abs(sameIcon.getCos()));
                }
                icon.setLeftCenterAt(x + (dX += Math.round(5.0f * icon.getCos())), y + (dY -= Math.round(5.0f * icon.getSin())));
            }
            case 4: {
                if (icon.getCos() != 0.0f) {
                    dY += Math.round((float)icon.getHeight() / Math.abs(icon.getCos()) / 2.0f);
                }
                if (sameIcon != null && sameIcon.getCos() != 0.0f) {
                    dY += Math.round((float)(sameIcon.getHeight() + 5) / Math.abs(sameIcon.getCos()) / 2.0f);
                }
                icon.setLeftCenterAt(x + (dX += Math.round(5.0f * icon.getCos())), y + (dY += Math.round(5.0f * icon.getSin())));
            }
        }
    }
}

