/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.EdgeBase;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.Icon;

public class IconSpacing {
    public static final int Above = 1;
    public static final int Under = 2;
    public static final int Left = 3;
    public static final int Right = 4;

    /*
     * Enabled aggressive block sorting
     */
    public static int calculateInjectionIconsSpace(Edge edge, boolean srcFlag, int where) {
        int space = -1;
        int i_Icon = 0;
        while (i_Icon < edge.getIconCount()) {
            block9: {
                Icon icon = edge.getIconAt(i_Icon);
                int horPos = icon.getHorPos();
                if (srcFlag ? horPos != 1 : horPos != 2) break block9;
                int vertPos = icon.getVertPos();
                switch (where) {
                    case 3: {
                        if (vertPos != 12 && vertPos != 13) break;
                        break block9;
                    }
                    case 4: {
                        if (vertPos != 10 && vertPos != 11) break;
                        break block9;
                    }
                    case 1: {
                        if (vertPos != 11 && vertPos != 13) break;
                        break block9;
                    }
                    case 2: {
                        if (vertPos == 10 || vertPos == 12) break block9;
                    }
                }
                int size = icon.isDirected() ? icon.getHeight() : (where == 1 || where == 2 ? icon.getHeight() : icon.getWidth());
                if (vertPos == 15) {
                    size = (size + 1) / 2 + 1;
                }
                if (space == -1) {
                    space = 0;
                }
                space += size;
            }
            ++i_Icon;
        }
        return space;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int calculateInjectionIconsSpace(EdgesGroup group, int where) {
        int space = -1;
        Edge[] edges = group.myEdges;
        int i = 0;
        while (i < edges.length) {
            Edge edge = edges[i];
            space = Math.max(space, IconSpacing.calculateInjectionIconsSpace(edge, false, where));
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                block9: {
                    Icon icon = edge.getIconAt(i_Icon);
                    if (icon.getHorPos() != 3) break block9;
                    int vertPos = icon.getVertPos();
                    switch (where) {
                        case 3: {
                            if (vertPos != 12 && vertPos != 13) break;
                            break block9;
                        }
                        case 4: {
                            if (vertPos != 10 && vertPos != 11) break;
                            break block9;
                        }
                        case 1: {
                            if (vertPos != 11 && vertPos != 13) break;
                            break block9;
                        }
                        case 2: {
                            if (vertPos == 10 || vertPos == 12) break block9;
                        }
                    }
                    int size = icon.isDirected() ? icon.getHeight() : (where == 1 || where == 2 ? icon.getHeight() : icon.getWidth());
                    if (vertPos == 15) {
                        size = (size + 1) / 2 + 1;
                    }
                    space = Math.max(space, size);
                }
                ++i_Icon;
            }
            ++i;
        }
        return space;
    }

    public static int calculateMediumIconsSpace(Edge edge) {
        int space = 0;
        int i_Icon = 0;
        while (i_Icon < edge.getIconCount()) {
            Icon icon = edge.getIconAt(i_Icon);
            if (icon.getHorPos() == 3) {
                space += icon.getWidth();
            }
            ++i_Icon;
        }
        return space;
    }

    public static int calculateMediumIconsHeight(EdgeBase edgeBase, int where) {
        if (edgeBase instanceof Edge) {
            return IconSpacing.calculateMediumIconsHeight((Edge)edgeBase, where);
        }
        if (edgeBase instanceof EdgesGroup) {
            return IconSpacing.calculateMediumIconsHeight((EdgesGroup)edgeBase, where);
        }
        throw new RuntimeException("ICSP001");
    }

    public static int calculateMediumIconsHeight(EdgesGroup group, int where) {
        Edge[] edges = group.myEdges;
        int space = 0;
        int i = 0;
        while (i < edges.length) {
            space = Math.max(space, IconSpacing.calculateMediumIconsHeight(edges[i], where));
            ++i;
        }
        return space;
    }

    public static int calculateMediumIconsHeight(Edge edge, int where) {
        int maxAbove = 0;
        int maxUnder = 0;
        int maxOn = 0;
        int i_Icon = 0;
        while (i_Icon < edge.getIconCount()) {
            Icon icon = edge.getIconAt(i_Icon);
            if (icon.getHorPos() == 3) {
                int h = icon.getHeight();
                if (icon.isDirected()) {
                    h = Math.max(h, icon.getWidth());
                }
                switch (icon.getVertPos()) {
                    case 10: 
                    case 12: {
                        maxAbove = Math.max(maxAbove, h);
                        break;
                    }
                    case 11: 
                    case 13: {
                        maxUnder = Math.max(maxUnder, h);
                        break;
                    }
                    case 14: {
                        maxAbove = Math.max(maxAbove, h);
                        maxUnder = Math.max(maxUnder, h);
                        break;
                    }
                    case 15: {
                        maxOn = Math.max(maxOn, h);
                        break;
                    }
                    default: {
                        throw new RuntimeException("ICSP002");
                    }
                }
            }
            ++i_Icon;
        }
        int space = 0;
        if (where >= 0) {
            space += Math.max(maxAbove, maxOn / 2);
        }
        if (where <= 0) {
            space += Math.max(maxUnder, maxOn / 2);
        }
        return space;
    }

    public static int calculateSrcIconHeight(Edge edge) {
        int maxH = 0;
        int i_Icon = 0;
        while (i_Icon < edge.getIconCount()) {
            Icon icon = edge.getIconAt(i_Icon);
            if (icon.getHorPos() == 1) {
                int h = icon.isDirected() ? icon.getWidth() : icon.getHeight();
                maxH = Math.max(maxH, h);
            }
            ++i_Icon;
        }
        return maxH;
    }

    public static int calculateDstIconHeight(Edge edge) {
        int maxH = 0;
        int i_Icon = 0;
        while (i_Icon < edge.getIconCount()) {
            Icon icon = edge.getIconAt(i_Icon);
            if (icon.getHorPos() == 2) {
                int h = icon.isDirected() ? icon.getWidth() : icon.getHeight();
                maxH = Math.max(maxH, h);
            }
            ++i_Icon;
        }
        return maxH;
    }
}

