/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.LayoutIcon;
import com.tssap.selena.layout.LayoutPoint;
import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Processible;
import com.tssap.selena.layout.impl.geometry.GRectangle;
import com.tssap.selena.layout.impl.geometry.Point;

public class Icon
extends GRectangle
implements LayoutIcon,
Processible {
    public static final int NearSrcPos = 1;
    public static final int NearDstPos = 2;
    public static final int MediumPos = 3;
    public static final int AboveLeftPos = 10;
    public static final int UnderLeftPos = 11;
    public static final int AboveRightPos = 12;
    public static final int UnderRightPos = 13;
    public static final int AsidePos = 14;
    public static final int OnPos = 15;
    public static final int AbovePos = 10;
    public static final int UnderPos = 13;
    private Object myUserObject;
    private boolean myProcessedFlag;
    private boolean directedFlag = false;
    private int horPos;
    private int vertPos;
    private int myIconsDistCorrection = 0;
    private boolean myGroupedFlag = false;
    private boolean mySelectionFlag = false;
    private Point myBasePoint = null;
    private Point myInnerVector = null;
    private Edge myParent;
    private int mySegment;
    public String myDebugName = "";

    public Icon() {
        super(0, 0, 0, 0, 0.0f, 0.0f, null);
        this.setObject(this);
    }

    public final void setDirected(boolean f) {
        this.directedFlag = f;
    }

    public final void setGrouped(boolean f) {
        this.myGroupedFlag = f;
    }

    public final void setHorPos(int pos) {
        this.horPos = pos;
    }

    public final void setVertPos(int pos) {
        this.vertPos = pos;
    }

    public final void setIconsDistCorrection(int correction) {
        this.myIconsDistCorrection = correction;
    }

    public final boolean isDirected() {
        return this.directedFlag;
    }

    public final boolean isGrouped() {
        return this.myGroupedFlag;
    }

    public final int getHorPos() {
        return this.horPos;
    }

    public final int getVertPos() {
        return this.vertPos;
    }

    public final int getIconsDistCorrection() {
        return this.myIconsDistCorrection;
    }

    public final void setSelected(boolean f) {
        this.mySelectionFlag = f;
    }

    public final boolean isSelected() {
        return this.mySelectionFlag;
    }

    public final LayoutPoint getBasePoint() {
        return this.myBasePoint;
    }

    public final LayoutPoint getInnerVector() {
        return this.myInnerVector;
    }

    public final float getDirectedSin() {
        Point p1 = this.myParent.getPointAt(this.mySegment + 1);
        Point p2 = this.myParent.getPointAt(this.mySegment);
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        if (dx == 0 && dy == 0) {
            return 0.0f;
        }
        float d = (float)Math.sqrt(dx * dx + dy * dy);
        return (float)dy / d;
    }

    public final float getDirectedCos() {
        Point p1 = this.myParent.getPointAt(this.mySegment + 1);
        Point p2 = this.myParent.getPointAt(this.mySegment);
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        if (dx == 0 && dy == 0) {
            return 1.0f;
        }
        float d = (float)Math.sqrt(dx * dx + dy * dy);
        return (float)dx / d;
    }

    public void setUserObject(Object obj) {
        this.myUserObject = obj;
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    public final void process() {
        this.myProcessedFlag = true;
    }

    public final void unprocess() {
        this.myProcessedFlag = false;
    }

    public final boolean isProcessed() {
        return this.myProcessedFlag;
    }

    public final Edge getParent() {
        return this.myParent;
    }

    public final void setParent(Edge edge) {
        this.myParent = edge;
    }

    public final int getSegment() {
        return this.mySegment;
    }

    public final void setSegment(int segment) {
        this.mySegment = segment;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public final void setBasePoint(Point p) {
        this.myBasePoint = p;
    }

    public final void setInnerVector(Point v) {
        this.myInnerVector = v;
    }

    public final void setInnerVector(int x, int y) {
        this.myInnerVector = new Point(x, y);
    }

    public final void setSinCosForLine(Point p1, Point p2) {
        if (this.isDirected()) {
            int dx = p2.x - p1.x;
            int dy = p2.y - p1.y;
            if (dx == 0 && dy == 0) {
                this.setSin(0.0f);
                this.setCos(1.0f);
                return;
            }
            float d = (float)Math.sqrt(dx * dx + dy * dy);
            this.setSin((float)dy / d);
            this.setCos((float)dx / d);
        } else {
            this.setSin(0.0f);
            this.setCos(1.0f);
        }
    }

    public final void shift(int dx, int dy) {
        super.shift(dx, dy);
        if (this.myBasePoint != null) {
            this.myBasePoint.shift(dx, dy);
        }
    }

    public final void transponate() {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (!this.isDirected()) {
            this.setX(y);
            this.setY(x);
            this.setWidth(h);
            this.setHeight(w);
        } else {
            float sin = this.getSin();
            float cos = this.getCos();
            this.setX(Math.round((float)y + (float)h * cos));
            this.setY(Math.round((float)x - (float)h * sin));
            this.setSin(cos);
            this.setCos(sin);
        }
        if (this.myBasePoint != null) {
            this.myBasePoint.transponate();
        }
        if (this.myInnerVector != null) {
            this.myInnerVector.transponate();
        }
    }

    public String toString() {
        return "icon " + this.myDebugName;
    }
}

