/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.LayoutIcon;
import com.tssap.selena.layout.LayoutLink;
import com.tssap.selena.layout.LayoutNode;
import com.tssap.selena.layout.LayoutPoint;
import com.tssap.selena.layout.impl.EdgeBase;
import com.tssap.selena.layout.impl.EdgesGroup;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import java.util.Vector;

public class Edge
extends EdgeBase
implements LayoutLink {
    private Object myUserObject;
    public Vertex vertex1;
    public int srcOffset;
    public int srcInject;
    public int way;
    public static final int WayUnknown = -1;
    public static final int WayUp = 1;
    public static final int WayDown = 2;
    public static final int WayLeftUpConner = 3;
    public static final int WayRightUpConner = 4;
    public static final int WayLeftDownConner = 5;
    public static final int WayRightDownConner = 6;
    public EdgesGroup myGroup;
    public Point srcFantom;
    public Point dstFantom;
    public boolean srcChange;
    public boolean dstChange;
    public int srcWas;
    public int dstWas;
    public static final int Unknown = 0;
    public static final int Vertical = 1;
    public static final int Horizontal = 2;
    private boolean myIsVertical = false;
    private boolean myIsReversed = false;
    private int myGroupId = 0;
    private boolean myIsYLink = false;
    private Vector myPointsArray = new Vector();
    private Vector myIconsArray = new Vector();
    private boolean mySelectionFlag = false;
    private Point mySelectedPoint = null;
    public String myDebugName = "";

    public final void setFromNode(LayoutNode from) {
        this.vertex1 = (Vertex)from;
    }

    public final void setToNode(LayoutNode to) {
        this.vertex2 = (Vertex)to;
    }

    public final void setVertical(boolean isInh) {
        this.myIsVertical = isInh;
    }

    public final void setDirected(int directed) {
        switch (directed) {
            case 0: {
                this.myIsVertical = false;
                break;
            }
            case 1: {
                this.myIsVertical = true;
                this.myIsReversed = false;
                break;
            }
            case 2: {
                this.myIsVertical = true;
                this.myIsReversed = true;
            }
        }
    }

    public final void setYLink(boolean isYLink) {
        this.myIsYLink = isYLink;
    }

    public final void setGroupId(int groupId) {
        this.myGroupId = groupId;
    }

    public final void addPoint(LayoutPoint p) {
        this.myPointsArray.add(p);
        if (p != null) {
            ((Point)p).setObject(this);
        }
    }

    public final void addIcon(LayoutIcon i) {
        this.myIconsArray.add(i);
        ((Icon)i).setParent(this);
    }

    public final LayoutNode getFromNode() {
        return this.vertex1;
    }

    public final LayoutNode getToNode() {
        return this.vertex2;
    }

    public final boolean isVertical() {
        return this.myIsVertical;
    }

    public final int getDirected() {
        if (!this.myIsVertical) {
            return 0;
        }
        return this.myIsReversed ? 2 : 1;
    }

    public final boolean isYLink() {
        return this.myIsYLink;
    }

    public final boolean isGroupable() {
        return this.myGroupId != 0;
    }

    public final int getGroupId() {
        return this.myGroupId;
    }

    public final int getPointCount() {
        return this.myPointsArray.size();
    }

    public final LayoutPoint getPoint(int i) {
        return (LayoutPoint)this.myPointsArray.get(i);
    }

    public final int getIconCount() {
        return this.myIconsArray.size();
    }

    public final LayoutIcon getIcon(int i) {
        return (LayoutIcon)this.myIconsArray.get(i);
    }

    public final void setSelected(boolean f) {
        this.mySelectionFlag = f;
    }

    public final boolean isSelected() {
        return this.mySelectionFlag;
    }

    public final void setSelectedPoint(LayoutPoint p) {
        this.mySelectedPoint = (Point)p;
    }

    public final LayoutPoint getSelectedPoint() {
        return this.mySelectedPoint;
    }

    public void setUserObject(Object obj) {
        this.myUserObject = obj;
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    public final Vertex getFrom() {
        return this.vertex1;
    }

    public final Vertex getTo() {
        return this.vertex2;
    }

    public final void setFrom(Vertex from) {
        this.vertex1 = from;
    }

    public final void setTo(Vertex to) {
        this.vertex2 = to;
    }

    public final Point getPointAt(int i) {
        return (Point)this.myPointsArray.get(i);
    }

    public final Icon getIconAt(int i) {
        return (Icon)this.myIconsArray.get(i);
    }

    public final void resetPoints() {
        this.myPointsArray.clear();
    }

    public final void insertPointAt(int i, Point p) {
        this.myPointsArray.add(i, p);
        if (p != null) {
            p.setObject(this);
        }
    }

    public final void deletePointAt(int i) {
        this.myPointsArray.remove(i);
    }

    public final void setPointAt(int i, Point p) {
        this.myPointsArray.set(i, p);
        if (p != null) {
            p.setObject(this);
        }
    }

    public final void resetIcons() {
        this.myIconsArray.clear();
    }

    public final void deleteIconAt(int i) {
        this.myIconsArray.remove(i);
    }

    public final Point getSrcInjectionPoint() {
        int y;
        int x;
        switch (this.srcInject) {
            case 3: {
                x = this.vertex1.getLeft() + this.srcOffset;
                y = this.vertex1.getTop();
                break;
            }
            case 4: {
                x = this.vertex1.getLeft() + this.srcOffset;
                y = this.vertex1.getBottom();
                break;
            }
            case 1: {
                x = this.vertex1.getLeft();
                y = this.vertex1.getTop() + this.srcOffset;
                break;
            }
            case 2: {
                x = this.vertex1.getRight();
                y = this.vertex1.getTop() + this.srcOffset;
                break;
            }
            default: {
                throw new RuntimeException("EDG001");
            }
        }
        return new Point(x, y, this);
    }

    public final Point getInjectionPoint(boolean srcFlag) {
        int y;
        int x;
        Vertex v = srcFlag ? this.vertex1 : this.vertex2;
        int offset = srcFlag ? this.srcOffset : this.dstOffset;
        switch (srcFlag ? this.srcInject : this.dstInject) {
            case 3: {
                x = v.getLeft() + offset;
                y = v.getTop();
                break;
            }
            case 4: {
                x = v.getLeft() + offset;
                y = v.getBottom();
                break;
            }
            case 1: {
                x = v.getLeft();
                y = v.getTop() + offset;
                break;
            }
            case 2: {
                x = v.getRight();
                y = v.getTop() + offset;
                break;
            }
            default: {
                throw new RuntimeException("EDG002");
            }
        }
        return new Point(x, y, this);
    }

    public final int getSrcInjectionX() {
        switch (this.srcInject) {
            case 3: 
            case 4: {
                return this.vertex1.getLeft() + this.srcOffset;
            }
            case 1: {
                return this.vertex1.getLeft();
            }
            case 2: {
                return this.vertex1.getRight();
            }
        }
        throw new RuntimeException("EDG003");
    }

    public final int getSrcInjectionY() {
        switch (this.srcInject) {
            case 3: {
                return this.vertex1.getTop();
            }
            case 4: {
                return this.vertex1.getBottom();
            }
            case 1: 
            case 2: {
                return this.vertex1.getTop() + this.srcOffset;
            }
        }
        throw new RuntimeException("EDG004");
    }

    public final int getInjectionX(boolean srcFlag) {
        Vertex v = srcFlag ? this.vertex1 : this.vertex2;
        switch (srcFlag ? this.srcInject : this.dstInject) {
            case 3: 
            case 4: {
                return v.getLeft() + (srcFlag ? this.srcOffset : this.dstOffset);
            }
            case 1: {
                return v.getLeft();
            }
            case 2: {
                return v.getRight();
            }
        }
        throw new RuntimeException("EDG005");
    }

    public final int getInjectionY(boolean srcFlag) {
        Vertex v = srcFlag ? this.vertex1 : this.vertex2;
        switch (srcFlag ? this.srcInject : this.dstInject) {
            case 3: {
                return v.getTop();
            }
            case 4: {
                return v.getBottom();
            }
            case 1: 
            case 2: {
                return v.getTop() + (srcFlag ? this.srcOffset : this.dstOffset);
            }
        }
        throw new RuntimeException("EDG006");
    }

    public final void addToLinesManager(LinesManager linesManager) {
        int n = this.getPointCount();
        int i_Point = 0;
        while (i_Point < n - 1) {
            Point p1 = this.getPointAt(i_Point);
            Point p2 = this.getPointAt(i_Point + 1);
            if (i_Point != 0) {
                linesManager.add(p1);
            }
            Line l = new Line(p1.x, p1.y, p2.x, p2.y, this);
            linesManager.add(l);
            ++i_Point;
        }
    }

    public final void removeFromLinesManager(LinesManager linesManager) {
        int n = this.getPointCount();
        int i_Point = 0;
        while (i_Point < n - 1) {
            Point p1 = this.getPointAt(i_Point);
            Point p2 = this.getPointAt(i_Point + 1);
            if (i_Point != 0) {
                linesManager.remove(p1);
            }
            Line l = new Line(p1.x, p1.y, p2.x, p2.y, this);
            linesManager.remove(l);
            ++i_Point;
        }
    }

    public String toString() {
        return "edge " + this.myDebugName;
    }
}

